/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;

public class LogHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(LogHandler.class.getName());
    long start = 0L;

    public void invoke(MessageContext msgContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: LogHandler::invoke");
        }
        if (!msgContext.getPastPivot()) {
            this.start = System.currentTimeMillis();
        } else {
            try {
                FileWriter fw = new FileWriter("webservices.handler.log", true);
                PrintWriter pw = new PrintWriter(fw);
                Message inMsg = msgContext.getRequestMessage();
                Message outMsg = msgContext.getResponseMessage();
                pw.println("=======================================================");
                pw.println("= " + Messages.getMessage("elapsed00", "" + (System.currentTimeMillis() - this.start)));
                pw.println("= " + Messages.getMessage("inMsg00", inMsg == null ? "null" : inMsg.getSOAPPartAsString()));
                pw.println("= " + Messages.getMessage("outMsg00", outMsg == null ? "null" : outMsg.getSOAPPartAsString()));
                pw.println("=======================================================");
                pw.close();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.handlers.LogHandler.invoke", "103", this);
                log.error(Messages.getMessage("exception00"), e);
                throw WebServicesFault.makeFault(e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: LogHandler::invoke");
        }
    }

    public void onFault(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: LogHandler::onFault");
        }
        try {
            FileWriter fw = new FileWriter("webservices.handler.log", true);
            PrintWriter pw = new PrintWriter(fw);
            pw.println("=====================");
            pw.println("= " + Messages.getMessage("fault00"));
            pw.println("=====================");
            pw.close();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.handlers.LogHandler.onFault", "121", this);
            log.error(Messages.getMessage("exception00"), e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: LogHandler::onFault");
        }
    }
}

