/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class VectorSerializer
implements Serializer {
    protected static Log log = LogFactory.getLog(VectorSerializer.class.getName());
    protected QName xmlType;
    protected Class javaType;

    public VectorSerializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    public void serialize(QName name2, Attributes attributes, Object value2, SerializationContext context) throws IOException {
        if (!(value2 instanceof Vector)) {
            throw new IOException(Messages.getMessage("noVector00", "VectorSerializer", value2.getClass().getName()));
        }
        Vector vector = (Vector)value2;
        context.getSerializationWriter().startElement(name2, attributes);
        Iterator i = vector.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            context.serialize(Constants.QNAME_LITERAL_ITEM, null, item, null, true, new Boolean(true));
        }
        context.getSerializationWriter().endElement();
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }
}

