/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SimpleType;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleValueSerializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleSerializer
implements SimpleValueSerializer {
    public QName xmlType;
    public Class javaType;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;
    protected BeanDesc beanDesc = null;
    private static boolean hasToPlainStringMethodCache = false;
    private static Method toPlainStringMethodCache = null;
    protected static Log log = LogFactory.getLog(SimpleSerializer.class.getName());

    public SimpleSerializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.init();
    }

    public SimpleSerializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    public SimpleSerializer(Class javaType, QName xmlType, BeanDesc beanDesc) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.beanDesc = beanDesc;
        this.init();
    }

    protected void init() {
        if (SimpleType.class.isAssignableFrom(this.javaType)) {
            if (this.beanDesc == null) {
                this.beanDesc = BeanDesc.getBeanDescForClass(this.javaType);
            }
            this.propertyDescriptor = this.beanDesc != null ? this.beanDesc.getPropertyDescriptors() : BeanUtils.getPd(this.javaType, null);
        }
    }

    void setup(BeanDesc beanDesc, BeanPropertyDescriptor[] propertyDescriptor) {
        this.beanDesc = beanDesc;
        this.propertyDescriptor = propertyDescriptor;
    }

    public void serialize(QName name2, Attributes attributes, Object value2, SerializationContext context) throws IOException {
        if (value2 != null && value2.getClass() == Object.class) {
            throw new IOException(Messages.getMessage("cantSerialize02"));
        }
        if (value2 instanceof SimpleType) {
            attributes = this.getObjectAttributes(value2, attributes, context);
        }
        String strValue = null;
        if (value2 != null) {
            strValue = this.getValueAsString(value2, context);
        }
        context.getSerializationWriter().simpleElement(name2, attributes, strValue);
    }

    public String getValueAsString(Object value2, SerializationContext context) {
        if (value2 instanceof Float || value2 instanceof Double) {
            double data = 0.0;
            data = value2 instanceof Float ? ((Float)value2).doubleValue() : ((Double)value2).doubleValue();
            if (Double.isNaN(data)) {
                return "NaN";
            }
            if (data == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (data == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
        } else {
            if (value2 instanceof Boolean) {
                boolean isOne = (Boolean)value2;
                return isOne ? "1" : "0";
            }
            if (value2 instanceof Character) {
                char ch = ((Character)value2).charValue();
                if (ch == '\u0000') {
                    return "";
                }
                return value2.toString();
            }
            if (value2 instanceof BigDecimal) {
                return this.getNonScientificValue((BigDecimal)value2);
            }
        }
        return value2.toString();
    }

    protected Attributes getObjectAttributes(Object value2, Attributes attributes, SerializationContext context) {
        if (this.beanDesc == null || !this.beanDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attrs = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                Object propValue;
                FieldDesc field;
                String propName = this.propertyDescriptor[i].getName();
                if (propName.equals("class") || (field = this.beanDesc.getFieldByName(propName)) == null || field.isElement()) continue;
                QName qname = field.getXmlName();
                if (qname == null) {
                    qname = QNameTable.createQName("", propName);
                }
                if (!this.propertyDescriptor[i].isReadable() || this.propertyDescriptor[i].isIndexed() || (propValue = this.propertyDescriptor[i].get(value2)) == null) continue;
                String propString = this.getValueAsString(propValue, context);
                String namespace = qname.getNamespaceURI();
                String localName = qname.getLocalPart();
                attrs.addAttribute(namespace, localName, context.getSerializationWriter().qName2String(qname), "CDATA", propString);
            }
        }
        catch (Exception e) {
            return attrs;
        }
        return attrs;
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return this.beanDesc == null ? null : this.beanDesc.getBuildNumber();
    }

    private String getNonScientificValue(BigDecimal value2) {
        if (!hasToPlainStringMethodCache) {
            toPlainStringMethodCache = (Method)AccessController.doPrivileged(new getMethodPRIV(value2.getClass(), "toPlainString"));
            hasToPlainStringMethodCache = true;
        }
        if (toPlainStringMethodCache != null) {
            if (log.isDebugEnabled()) {
                log.debug("Invoking toPlainString() method to convert BigDecimal to string.");
            }
            final BigDecimal finalValue = value2;
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return toPlainStringMethodCache.invoke((Object)finalValue, null);
                    }
                    catch (Throwable e) {
                        if (log.isDebugEnabled()) {
                            log.debug("The following exception encountered when trying to invoke method [" + toPlainStringMethodCache.getName() + "] on class [" + finalValue.getClass().getName() + "].");
                            log.debug(e.toString());
                        }
                        return null;
                    }
                }
            });
        }
        if (log.isDebugEnabled()) {
            log.debug("Invoking toString() method to convert BigDecimal to string.");
        }
        return value2.toString();
    }

    private class getMethodPRIV
    implements PrivilegedAction {
        private Class clazz;
        private String methodName;

        getMethodPRIV(Class clazz, String methodName) {
            this.clazz = clazz;
            this.methodName = methodName;
        }

        public Object run() {
            try {
                return this.clazz.getMethod(this.methodName, null);
            }
            catch (Throwable e) {
                if (log.isDebugEnabled()) {
                    log.debug("The following exception encountered when trying to get method [" + this.methodName + "] from class [" + this.clazz.getName() + "].");
                    log.debug(e.toString());
                }
                return null;
            }
        }
    }
}

