/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPElementDeserializer
extends SimpleDeserializer {
    protected SOAPElement myElement = null;
    protected SOAPElement myChildElement = null;

    public SOAPElementDeserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public void setMyElement(SOAPElement element) {
        this.myElement = element;
    }

    public void onStartElement(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        try {
            InputStream is;
            SOAPFactory sf = null;
            if (this.myElement == null) {
                sf = new SOAPFactory(context.getMessageContext().getSOAPConstants());
                mappingScope = mappingScope.flatten();
                this.myElement = sf.createSOAPElement(namespace, localPart, prefixedName, attributes, mappingScope, context, this.myElement);
            }
            if (!context.isSimpleEventEnabled() && (is = context.getLazyParse()) != null) {
                this.myElement.setAlternateContent(is);
            }
        }
        catch (SOAPException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializer.onStartElement", "80", this);
            throw new SAXException((Exception)((Object)e));
        }
    }

    public DEventProcessor onStartChild(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        try {
            SOAPElementDeserializer deser = new SOAPElementDeserializer(SOAPElement.class, Constants.WEBSERVICES_SOAPELEMENT);
            SOAPFactory sf = this.myElement.getSOAPFactory();
            this.myChildElement = sf.createSOAPElement(namespace, localPart, prefixedName, attributes, mappingScope, context, this.myElement);
            deser.setMyElement(this.myChildElement);
            return deser;
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializer.onStartChild", "107", this);
            throw new SAXException((Exception)((Object)se));
        }
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        this.value = this.myElement;
        super.onEndElement(namespace, localName, context);
    }

    public void characters(String value2) throws SAXException {
        if (this.myElement != null) {
            try {
                this.myElement.addTextNode(value2);
            }
            catch (SOAPException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializer.characters", "122", this);
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    public void comment(char[] chars, int offset, int length) throws SAXException {
        String value2 = new String(chars, offset, length);
        if (this.myElement != null) {
            try {
                this.myElement.addComment(value2);
            }
            catch (SOAPException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializer.comment", "166", this);
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    protected Object makeValue(String source) throws Exception {
        return this.myElement;
    }

    public boolean recycle() {
        boolean rc = super.recycle();
        if (rc) {
            this.myElement = null;
            this.myChildElement = null;
        }
        return rc;
    }
}

