/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class QNameDeserializer
extends SimpleDeserializer {
    private MappingScope mappingScope = null;

    public QNameDeserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public Object makeValue(String source) {
        int colon = source.lastIndexOf(":");
        String namespace = null;
        String localPart = null;
        if (colon < 0) {
            localPart = source;
            namespace = "";
        } else {
            localPart = source.substring(colon + 1);
            String prefix = source.substring(0, colon);
            Mapping mapping = this.mappingScope.getMappingForPrefix(prefix, false);
            if (mapping == null) {
                throw new InternalException(Messages.getMessage("unmappedPrefix00", prefix));
            }
            namespace = mapping.getNamespaceURI();
        }
        return QNameTable.createQName(namespace, localPart);
    }

    public void onStartElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        this.mappingScope = mappingScope;
    }
}

