/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class MapSerializer
implements Serializer {
    protected static Log log = LogFactory.getLog(MapSerializer.class.getName());
    private static final QName QNAME_KEY = QNameTable.createQName("", "key");
    private static final QName QNAME_ITEM = QNameTable.createQName("", "item");
    private static final QName QNAME_VALUE = QNameTable.createQName("", "value");
    protected QName xmlType;
    protected Class javaType;

    public MapSerializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    public void serialize(QName name2, Attributes attributes, Object value2, SerializationContext context) throws IOException {
        if (!(value2 instanceof Map)) {
            throw new IOException(Messages.getMessage("noMap00", "MapSerializer", value2.getClass().getName()));
        }
        Map map = (Map)value2;
        context.getSerializationWriter().startElement(name2, attributes);
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            Object val = entry.getValue();
            context.getSerializationWriter().startElement(QNAME_ITEM, null);
            context.serialize(QNAME_KEY, null, key, null, true, new Boolean(true));
            context.serialize(QNAME_VALUE, null, val, null, true, new Boolean(true));
            context.getSerializationWriter().endElement();
        }
        context.getSerializationWriter().endElement();
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }
}

