/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;

public final class ListSerializer
extends SimpleSerializer {
    QName componentTypeQName = null;

    public ListSerializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public ListSerializer(Class javaType, QName xmlType, QName compQName, QName componentTypeQName) {
        super(javaType, xmlType);
        this.componentTypeQName = componentTypeQName;
    }

    public void serialize(QName name2, Attributes attributes, Object value2, SerializationContext context) throws IOException {
        context.getSerializationWriter().simpleElement(name2, attributes, this.getValueAsString(value2, context));
    }

    public String getValueAsString(Object value2, SerializationContext context) {
        if (value2.getClass().isArray()) {
            return this.getArrayValueAsString(value2, context);
        }
        if (value2 instanceof Collection) {
            return this.getListValueAsString(value2, context);
        }
        try {
            return context.getValueAsString(value2, this.componentTypeQName).trim();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.ListSerializer.getValueAsString", "133", this);
            return super.getValueAsString(value2, context).trim();
        }
    }

    private String getArrayValueAsString(Object value2, SerializationContext context) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < Array.getLength(value2); ++i) {
            if (Array.get(value2, i) == null) continue;
            buf.append(" " + this.getValueAsString(Array.get(value2, i), context));
        }
        return buf.toString().trim();
    }

    private String getListValueAsString(Object value2, SerializationContext context) {
        StringBuffer buf = new StringBuffer();
        List objList = (List)value2;
        int size = objList.size();
        for (int i = 0; i < size; ++i) {
            if (objList.get(i) == null) continue;
            buf.append(" " + this.getValueAsString(objList.get(i), context));
        }
        return buf.toString();
    }

    public String getBuildNumber() {
        return null;
    }
}

