/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.ImageDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.MimeMultipartDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.PlainTextDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.SourceDataHandlerDeserializer;
import java.awt.Image;
import javax.mail.internet.MimeMultipart;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;

public class JAFDataHandlerDeserializerFactory
extends BaseDeserializerFactory {
    protected static Log log = LogFactory.getLog(JAFDataHandlerDeserializerFactory.class.getName());

    public JAFDataHandlerDeserializerFactory(Class javaType, QName xmlType) {
        super(JAFDataHandlerDeserializerFactory.getDeserializerClass(javaType, xmlType), xmlType, javaType);
        if (log.isDebugEnabled()) {
            log.debug("Enter/Exit: JAFDataHandlerDeserializerFactory(" + javaType + ", " + xmlType + ")");
        }
    }

    public static JAFDataHandlerDeserializerFactory create(Class javaType, QName xmlType, QName compQName, QName compTypeQName) {
        return new JAFDataHandlerDeserializerFactory(javaType, xmlType);
    }

    private static Class getDeserializerClass(Class javaType, QName xmlType) {
        Class deser = Image.class.isAssignableFrom(javaType) ? ImageDataHandlerDeserializer.class : (String.class.isAssignableFrom(javaType) ? PlainTextDataHandlerDeserializer.class : (Source.class.isAssignableFrom(javaType) ? SourceDataHandlerDeserializer.class : (MimeMultipart.class.isAssignableFrom(javaType) ? MimeMultipartDataHandlerDeserializer.class : JAFDataHandlerDeserializer.class)));
        return deser;
    }
}

