/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.configurable.ConfigurableImpl;
import com.ibm.ws.webservices.engine.configurable.Configured;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.CustomSerializerFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.apache.commons.logging.Log;

public abstract class BaseSerializerFactory
implements SerializerFactory {
    private static Log log = LogFactory.getLog(BaseSerializerFactory.class.getName());
    static Vector mechanisms = null;
    protected Class serClass = null;
    protected Serializer ser = null;
    protected QName xmlType = null;
    protected Class javaType = null;
    protected boolean initialized = false;
    protected Constructor serClassConstructor = null;
    protected Method getSerializer = null;
    private Configurable _configurable = null;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$java$lang$String;

    public BaseSerializerFactory(Class serClass, QName xmlType, Class javaType) {
        this.serClass = serClass;
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.xml.rpc.encoding.Serializer getSerializerAs(String mechanismType) throws JAXRPCException {
        BaseSerializerFactory baseSerializerFactory = this;
        synchronized (baseSerializerFactory) {
            if (this.ser == null) {
                this.ser = this.getSerializerAsInternal(mechanismType);
            }
            return this.ser;
        }
    }

    protected void lazyInitialization() {
        this.serClassConstructor = this.getConstructor(this.serClass);
        this.getSerializer = this.getSerializerMethod(this.javaType);
        this.initialized = true;
    }

    protected Serializer getSerializerAsInternal(String mechanismType) throws JAXRPCException {
        Serializer serializer;
        if (!this.initialized) {
            this.lazyInitialization();
        }
        if ((serializer = this.getSpecialized(mechanismType)) == null) {
            serializer = this.getGeneralPurpose(mechanismType);
        }
        return serializer;
    }

    protected Serializer getGeneralPurpose(String mechanismType) {
        if (this.serClassConstructor != null) {
            try {
                return (Serializer)this.serClassConstructor.newInstance(this.javaType, this.xmlType);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private Constructor getConstructor(Class clazz) {
        return (Constructor)AccessController.doPrivileged(new getConstructorPRIV(clazz));
    }

    protected Serializer getSpecialized(String mechanismType) {
        if (this.getSerializer != null) {
            try {
                return (Serializer)this.getSerializer.invoke(null, mechanismType, this.javaType, this.xmlType);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Method getSerializerMethod(Class clazz) {
        return (Method)AccessController.doPrivileged(new getSerializerMethodPRIV(clazz));
    }

    public Iterator getSupportedMechanismTypes() {
        if (mechanisms == null) {
            mechanisms = new Vector();
            mechanisms.add("WebServices SAX Mechanism");
        }
        return mechanisms.iterator();
    }

    public QName getXMLType() {
        return this.xmlType;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public static SerializerFactory createFactory(Class factory, Class javaType, QName xmlType) {
        return BaseSerializerFactory.createFactory(factory, javaType, xmlType, null, null, null);
    }

    public static SerializerFactory createFactory(Class factory, Class javaType, QName xmlType, String binderName) {
        return BaseSerializerFactory.createFactory(factory, javaType, xmlType, binderName, null, null);
    }

    public static SerializerFactory createFactory(Class factory, Class javaType, QName xmlType, QName compQName, QName compTypeQName) {
        return BaseSerializerFactory.createFactory(factory, javaType, xmlType, null, compQName, compTypeQName);
    }

    public static SerializerFactory createFactory(Class factory, Class javaType, QName xmlType, String binderName, QName compQName, QName compTypeQName) {
        return (SerializerFactory)AccessController.doPrivileged(new CreateFactoryPRIV(factory, javaType, xmlType, binderName, compQName, compTypeQName));
    }

    private void makeConfigurable() {
        if (this._configurable == null) {
            this._configurable = new ConfigurableImpl();
        }
    }

    private String toStringConfigurable(String indent) {
        String text = "";
        if (this._configurable != null) {
            Set entrySet;
            Iterator it = null;
            Map options = this.getOptions();
            if (options != null && (entrySet = options.entrySet()) != null) {
                it = options.entrySet().iterator();
            }
            if (it != null) {
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    text = text + indent + "KEY(" + entry.getKey() + ")\n";
                    text = text + indent + " VALUE(" + entry.getValue() + ")\n";
                }
            }
        }
        return text;
    }

    public final void setOptionsDefault(Configured dephault) {
        this.makeConfigurable();
        this._configurable.setOptionsDefault(dephault);
    }

    public final void setOption(String name2, Object value2) {
        this.makeConfigurable();
        this._configurable.setOption(name2, value2);
    }

    public final void setOption(String name2, Object value2, boolean lock) {
        this.makeConfigurable();
        this._configurable.setOption(name2, value2, lock);
    }

    public final boolean setOptionDefault(String name2, Object value2) {
        this.makeConfigurable();
        return this._configurable.setOptionDefault(name2, value2);
    }

    public final boolean setOptionDefault(String name2, Object value2, boolean lock) {
        this.makeConfigurable();
        return this._configurable.setOptionDefault(name2, value2, lock);
    }

    public final void setOptions(Map opts) {
        this.makeConfigurable();
        this._configurable.setOptions(opts);
    }

    public final Object getOption(String name2) {
        this.makeConfigurable();
        return this._configurable.getOption(name2);
    }

    public final void removeOption(String name2) {
        if (this._configurable != null) {
            this._configurable.removeOption(name2);
        }
    }

    public final Map getOptions() {
        this.makeConfigurable();
        return this._configurable.getOptions();
    }

    public Set getOptionsBooleanNames() {
        this.makeConfigurable();
        return this._configurable.getOptionsBooleanNames();
    }

    public String toString() {
        return "BaseSerializerFactory: SerClass=" + (this.serClass != null ? this.serClass.toString() : "<null>") + ", XmlType=" + (this.xmlType != null ? this.xmlType.toString() : "<null>") + ", JavaType=" + (this.javaType != null ? this.javaType.toString() : "<null>");
    }

    private static class CreateFactoryPRIV
    implements PrivilegedAction {
        private Class factory;
        private Class javaType;
        private QName xmlType;
        private String binderName;
        private QName compQName;
        private QName compTypeQName;

        CreateFactoryPRIV(Class factory, Class javaType, QName xmlType, String binderName, QName compQName, QName compTypeQName) {
            this.factory = factory;
            this.javaType = javaType;
            this.xmlType = xmlType;
            this.binderName = binderName;
            this.compQName = compQName;
            this.compTypeQName = compTypeQName;
        }

        public Object run() {
            SerializerFactory sf;
            block44: {
                block43: {
                    Constructor constructor;
                    block42: {
                        Method method;
                        block41: {
                            block40: {
                                sf = null;
                                try {
                                    if (this.binderName != null) {
                                        Class<?> binderClass = Class.forName(this.binderName, true, Thread.currentThread().getContextClassLoader());
                                        sf = new CustomSerializerFactory(this.javaType, this.xmlType, binderClass);
                                    }
                                }
                                catch (ClassNotFoundException e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "410", this);
                                    log.error(Messages.getMessage("noBinderFound00", this.binderName), e);
                                }
                                if (sf == null) {
                                    try {
                                        method = this.factory.getMethod("create", class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                                        sf = (SerializerFactory)method.invoke(null, this.javaType, this.xmlType, this.compQName, this.compTypeQName);
                                    }
                                    catch (NoSuchMethodException e) {
                                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "454", this);
                                        if (log.isDebugEnabled()) {
                                            log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught NoSuchMethodException: " + e);
                                        }
                                    }
                                    catch (IllegalAccessException e) {
                                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "457", this);
                                        if (log.isDebugEnabled()) {
                                            log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + e);
                                        }
                                    }
                                    catch (InvocationTargetException e) {
                                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "457", this);
                                        if (!log.isDebugEnabled()) break block40;
                                        log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught InvocationTargetException: " + e);
                                    }
                                }
                            }
                            if (sf == null) {
                                try {
                                    constructor = this.factory.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                                    sf = (SerializerFactory)constructor.newInstance(this.javaType, this.xmlType, this.compQName, this.compTypeQName);
                                }
                                catch (NoSuchMethodException e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "476", this);
                                    if (log.isDebugEnabled()) {
                                        log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught NoSuchMethodException: " + e);
                                    }
                                }
                                catch (InstantiationException e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "480", this);
                                    if (log.isDebugEnabled()) {
                                        log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught InstantiationException: " + e);
                                    }
                                }
                                catch (IllegalAccessException e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "480", this);
                                    if (log.isDebugEnabled()) {
                                        log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + e);
                                    }
                                }
                                catch (InvocationTargetException e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "480", this);
                                    if (!log.isDebugEnabled()) break block41;
                                    log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught InvocationTargetException: " + e);
                                }
                            }
                        }
                        if (sf == null) {
                            try {
                                method = this.factory.getMethod("create", class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                                sf = (SerializerFactory)method.invoke(null, this.javaType, this.xmlType);
                            }
                            catch (NoSuchMethodException e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "504", this);
                                if (log.isDebugEnabled()) {
                                    log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught NoSuchMethodException: " + e);
                                }
                            }
                            catch (IllegalAccessException e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "507", this);
                                if (log.isDebugEnabled()) {
                                    log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + e);
                                }
                            }
                            catch (InvocationTargetException e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "507", this);
                                if (!log.isDebugEnabled()) break block42;
                                log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught InvocationTargetException: " + e);
                            }
                        }
                    }
                    if (sf == null) {
                        try {
                            constructor = this.factory.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                            sf = (SerializerFactory)constructor.newInstance(this.javaType, this.xmlType);
                        }
                        catch (NoSuchMethodException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "527", this);
                            if (log.isDebugEnabled()) {
                                log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught NoSuchMethodException: " + e);
                            }
                        }
                        catch (InstantiationException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "529", this);
                            if (log.isDebugEnabled()) {
                                log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught InstantiationException: " + e);
                            }
                        }
                        catch (IllegalAccessException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "529", this);
                            if (log.isDebugEnabled()) {
                                log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + e);
                            }
                        }
                        catch (InvocationTargetException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "529", this);
                            if (!log.isDebugEnabled()) break block43;
                            log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught InvocationTargetException: " + e);
                        }
                    }
                }
                if (sf == null) {
                    try {
                        sf = (SerializerFactory)this.factory.newInstance();
                    }
                    catch (InstantiationException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "551", this);
                        if (log.isDebugEnabled()) {
                            log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught InstantiationException: " + e);
                        }
                    }
                    catch (IllegalAccessException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory", "551", this);
                        if (!log.isDebugEnabled()) break block44;
                        log.debug("BaseSerializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + e);
                    }
                }
            }
            return sf;
        }
    }

    private class getSerializerMethodPRIV
    implements PrivilegedAction {
        private Class clazz;

        getSerializerMethodPRIV(Class clazz) {
            this.clazz = clazz;
        }

        public Object run() {
            Method method = null;
            Class helper = null;
            try {
                if (this.clazz.getClassLoader() == null) {
                    helper = ClassUtils.forName(this.clazz.getName() + "_Helper");
                } else {
                    try {
                        helper = ClassUtils.forName(this.clazz.getName() + "_Helper", true, this.clazz.getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        helper = ClassUtils.forName(this.clazz.getName() + "_Helper");
                    }
                }
                method = helper.getMethod("getSerializer", class$java$lang$String == null ? (class$java$lang$String = BaseSerializerFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
            }
            catch (NoSuchMethodException e) {
                if (log.isDebugEnabled()) {
                    log.debug("getSerializerMethodPRIV - processing continues " + JavaUtils.stackToDebugString(e));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return method;
        }
    }

    private class getConstructorPRIV
    implements PrivilegedAction {
        private Class clazz;

        getConstructorPRIV(Class clazz) {
            this.clazz = clazz;
        }

        public Object run() {
            try {
                return this.clazz.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
    }
}

