/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.schema.SchemaVersion;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class ArraySerializer
implements Serializer {
    protected static Log log = LogFactory.getLog(ArraySerializer.class.getName());
    protected QName xmlType;
    protected Class javaType;
    QName compTypeQName = null;
    QName compQName = null;

    public ArraySerializer(Class javaType, QName xmlType) {
        this(javaType, xmlType, null, null);
    }

    public ArraySerializer(Class javaType, QName xmlType, QName componentQName, QName componentTypeQName) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.compQName = componentQName;
        this.compTypeQName = componentTypeQName;
    }

    public void serialize(QName name2, Attributes attributes, Object value2, SerializationContext context) throws IOException {
        boolean caseSOAPArray;
        if (value2 == null) {
            throw new IOException(Messages.getMessage("cantDoNullArray00"));
        }
        MessageContext msgContext = context.getMessageContext();
        SchemaVersion schema = msgContext.getSchemaVersion();
        SOAPConstants soap2 = msgContext.getSOAPConstants();
        Class<?> cls = value2.getClass();
        Collection list = null;
        if (!cls.isArray()) {
            if (!(value2 instanceof Collection)) {
                throw new IOException(Messages.getMessage("cantSerialize00", cls.getName()));
            }
            list = (Collection)value2;
        }
        QName componentTypeQName = this.compTypeQName != null ? this.compTypeQName : this.getComponentTypeQName(cls, context);
        int len = list == null ? Array.getLength(value2) : list.size();
        int dim2Len = -1;
        boolean caseWrappedArray = this.compQName != null;
        boolean caseMaxOccurs = !caseWrappedArray && componentTypeQName.equals(context.getCurrentXMLType());
        boolean bl = caseSOAPArray = !caseWrappedArray && !caseMaxOccurs;
        if (caseSOAPArray && value2 instanceof SOAPElement[]) {
            caseMaxOccurs = true;
            caseSOAPArray = false;
        }
        if (caseSOAPArray) {
            int typeI;
            AttributesImpl attrs;
            String dims = this.getExtraDims(cls, componentTypeQName, context);
            String prefix = context.getSerializationWriter().getOrCreatePrefix(componentTypeQName.getNamespaceURI(), null, true);
            String compType = prefix.length() > 0 ? prefix + ':' + componentTypeQName.getLocalPart() : componentTypeQName.getLocalPart();
            String arrayType = compType + dims + "[" + len + "]";
            boolean enable2Dim = true;
            if (enable2Dim && !dims.equals("") && cls.isArray() && len > 0) {
                boolean okay = true;
                for (int i = 0; i < len && okay; ++i) {
                    Object elementValue = Array.get(value2, i);
                    if (elementValue == null) {
                        okay = false;
                        continue;
                    }
                    if (dim2Len < 0) {
                        dim2Len = Array.getLength(elementValue);
                        if (dim2Len > 0) continue;
                        okay = false;
                        continue;
                    }
                    if (dim2Len == Array.getLength(elementValue)) continue;
                    okay = false;
                }
                if (okay) {
                    dims = dims.substring(0, dims.length() - 2);
                    arrayType = compType + dims + "[" + len + "," + dim2Len + "]";
                } else {
                    dim2Len = -1;
                }
            }
            if ((attrs = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes))).getIndex(soap2.getEncodingURI(), "arrayType") == -1) {
                String encprefix = context.getSerializationWriter().getOrCreatePrefix(soap2.getEncodingURI(), null, true);
                attrs.addAttribute(soap2.getEncodingURI(), "arrayType", encprefix + ":arrayType", "CDATA", arrayType);
            }
            if ((typeI = attrs.getIndex(schema.getXsiURI(), "type")) != -1) {
                String qname = context.getSerializationWriter().getOrCreatePrefix(schema.getXsiURI(), "xsi", true) + ":type";
                attrs.setAttribute(typeI, schema.getXsiURI(), "type", qname, "CDATA", context.getSerializationWriter().qName2String(Constants.SOAP_ARRAY));
            }
            attributes = attrs;
        }
        QName elementName = name2;
        if (caseSOAPArray || caseWrappedArray) {
            context.getSerializationWriter().startElement(name2, attributes);
            elementName = this.compQName == null ? Constants.QNAME_LITERAL_ITEM : this.compQName;
        }
        if (dim2Len < 0) {
            Object aValue;
            if (list == null) {
                for (int index = 0; index < len; ++index) {
                    aValue = Array.get(value2, index);
                    context.serialize(elementName, NullAttributes.singleton, aValue, componentTypeQName, true, Boolean.FALSE);
                }
            } else {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    aValue = iterator.next();
                    context.serialize(elementName, NullAttributes.singleton, aValue, componentTypeQName, true, Boolean.FALSE);
                }
            }
        } else {
            for (int index = 0; index < len; ++index) {
                for (int index2 = 0; index2 < dim2Len; ++index2) {
                    Object aValue = Array.get(Array.get(value2, index), index2);
                    context.serialize(elementName, null, aValue);
                }
            }
        }
        if (caseSOAPArray || caseWrappedArray) {
            context.getSerializationWriter().endElement();
        }
    }

    private final QName getComponentTypeQName(Class cls, SerializationContext context) throws IOException {
        Class componentType;
        if (cls.isArray()) {
            componentType = cls.getComponentType();
        } else {
            Class clazz = componentType = Object.class;
        }
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        QName componentTypeQName = context.getTypeMapping().getTypeQName(componentType);
        if (componentTypeQName == null) {
            Class searchCls;
            for (searchCls = componentType; searchCls != null && componentTypeQName == null; searchCls = searchCls.getSuperclass()) {
                componentTypeQName = context.getTypeMapping().getTypeQName(searchCls);
            }
            if (componentTypeQName != null) {
                componentType = searchCls;
            }
        }
        if (componentTypeQName == null) {
            throw new IOException(Messages.getMessage("noType00", componentType.getName()));
        }
        return componentTypeQName;
    }

    private final String getExtraDims(Class cls, QName componentTypeQName, SerializationContext context) {
        String dims = "";
        Class componentType = cls.isArray() ? cls.getComponentType() : Object.class;
        boolean found = false;
        while (componentType.isArray() && !context.getTypeMapping().isRegistered(componentType, componentTypeQName)) {
            componentType = componentType.getComponentType();
            dims = dims + "[]";
        }
        return dims;
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }
}

