/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import [Ljava.lang.Object;;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.ser.ComponentDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.DeserializerTarget;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ArrayDeserializer
extends ComponentDeserializer {
    protected static Log log = LogFactory.getLog(ArrayDeserializer.class.getName());
    public QName arrayType = null;
    public int curIndex = 0;
    QName defaultItemType;
    int length;
    Class arrayClass = null;
    ArrayList mDimLength = null;
    ArrayList mDimFactor = null;
    QName componentTypeQName = null;
    QName componentQName = null;

    public ArrayDeserializer(Class javaType, QName xmlType) {
        this(javaType, xmlType, null, null);
    }

    public ArrayDeserializer(Class javaType, QName xmlType, QName componentQName, QName componentTypeQName) {
        super(javaType, xmlType);
        this.componentQName = componentQName;
        this.componentTypeQName = componentTypeQName;
    }

    public void onStartElement(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        QName typeQName;
        if (log.isDebugEnabled()) {
            log.debug("Enter: ArrayDeserializer::startElement()");
        }
        if ((typeQName = AttributeUtils.getTypeFromAttributes(namespace, localPart, attributes, mappingScope)) == null) {
            typeQName = this.getDefaultType();
        }
        if (typeQName != null && Constants.equals(Constants.SOAP_ARRAY, typeQName)) {
            typeQName = null;
        }
        String arrayTypeString = Constants.getValue(attributes, Constants.URIS_SOAP_ENC, "arrayType");
        QName arrayTypeValue = null;
        if (arrayTypeString != null) {
            arrayTypeValue = QNameTable.createQName(arrayTypeString, mappingScope);
        }
        String dimString = null;
        QName innerQName = null;
        String innerDimString = "";
        if (arrayTypeValue != null) {
            String arrayTypeValueNamespaceURI = arrayTypeValue.getNamespaceURI();
            String arrayTypeValueLocalPart = arrayTypeValue.getLocalPart();
            int leftBracketIndex = arrayTypeValueLocalPart.lastIndexOf(91);
            int rightBracketIndex = arrayTypeValueLocalPart.lastIndexOf(93);
            if (leftBracketIndex == -1 || rightBracketIndex == -1 || rightBracketIndex < leftBracketIndex) {
                throw new IllegalArgumentException(Messages.getMessage("badArrayType00", "" + arrayTypeValue));
            }
            dimString = arrayTypeValueLocalPart.substring(leftBracketIndex + 1, rightBracketIndex);
            if ((arrayTypeValueLocalPart = arrayTypeValueLocalPart.substring(0, leftBracketIndex)).endsWith("]")) {
                this.defaultItemType = Constants.SOAP_ARRAY;
                innerQName = QNameTable.createQName(arrayTypeValueNamespaceURI, arrayTypeValueLocalPart.substring(0, arrayTypeValueLocalPart.indexOf("[")));
                innerDimString = arrayTypeValueLocalPart.substring(arrayTypeValueLocalPart.indexOf("["));
            } else {
                this.defaultItemType = QNameTable.createQName(arrayTypeValueNamespaceURI, arrayTypeValueLocalPart);
            }
        }
        if (this.defaultItemType == null) {
            this.defaultItemType = this.componentTypeQName;
        }
        if (this.defaultItemType == null && typeQName == null) {
            this.defaultItemType = Constants.XSD_ANYTYPE;
        }
        this.arrayClass = null;
        if (typeQName != null) {
            this.arrayClass = context.getTypeMapping().getClassForQName(typeQName);
        } else if (this.javaType != null && !this.javaType.equals(Object;.class) && this.javaType.isArray()) {
            this.arrayClass = this.javaType;
        } else {
            Class arrayItemClass;
            QName compQName = this.defaultItemType;
            String dims = "[]";
            if (innerQName != null) {
                compQName = innerQName;
                dims = dims + innerDimString;
            }
            if ((arrayItemClass = context.getTypeMapping().getClassForQName(compQName)) != null) {
                try {
                    Object ret = AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                return arrayItemClass.getClassLoader();
                            }
                            catch (Throwable e) {
                                return e;
                            }
                        }
                    });
                    ClassLoader clsLoader = null;
                    if (ret instanceof ClassLoader) {
                        clsLoader = (ClassLoader)ret;
                    }
                    if (clsLoader == null) {
                        this.arrayClass = ClassUtils.forName(JavaUtils.getLoadableClassName(JavaUtils.getTextClassName(arrayItemClass.getName()) + dims));
                    } else {
                        try {
                            this.arrayClass = ClassUtils.forName(JavaUtils.getLoadableClassName(JavaUtils.getTextClassName(arrayItemClass.getName()) + dims), true, clsLoader);
                        }
                        catch (ClassNotFoundException e) {
                            this.arrayClass = ClassUtils.forName(JavaUtils.getLoadableClassName(JavaUtils.getTextClassName(arrayItemClass.getName()) + dims));
                        }
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializer.onStartElement", "276", this);
                    throw new SAXException(Messages.getMessage("noComponent00", "" + this.defaultItemType));
                }
            }
        }
        if (this.arrayClass == null) {
            throw new SAXException(Messages.getMessage("noComponent00", "" + this.defaultItemType));
        }
        if (dimString == null || dimString.length() == 0) {
            this.value = new ArrayListExtension(this.arrayClass);
        } else {
            try {
                StringTokenizer tokenizer = new StringTokenizer(dimString, "[],");
                this.length = Integer.parseInt(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    this.mDimLength = new ArrayList();
                    this.mDimLength.add(new Integer(this.length));
                    while (tokenizer.hasMoreTokens()) {
                        this.mDimLength.add(new Integer(Integer.parseInt(tokenizer.nextToken())));
                    }
                }
                ArrayListExtension list = new ArrayListExtension(this.arrayClass, this.length);
                for (int i = 0; i < this.length; ++i) {
                    list.add(null);
                }
                this.value = list;
            }
            catch (NumberFormatException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializer.onStartElement", "330", this);
                throw new IllegalArgumentException(Messages.getMessage("badInteger00", dimString));
            }
        }
        String offset = Constants.getValue(attributes, Constants.URIS_SOAP_ENC, "offset");
        if (offset != null) {
            int leftBracketIndex = offset.lastIndexOf(91);
            int rightBracketIndex = offset.lastIndexOf(93);
            if (leftBracketIndex == -1 || rightBracketIndex == -1 || rightBracketIndex < leftBracketIndex) {
                throw new SAXException(Messages.getMessage("badOffset00", offset));
            }
            this.curIndex = this.convertToIndex(offset.substring(leftBracketIndex + 1, rightBracketIndex), "badOffset00");
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: ArrayDeserializer::startElement()");
        }
    }

    public DEventProcessor onStartChild(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        String href;
        Deserializer dSer;
        QName itemType;
        if (log.isDebugEnabled()) {
            log.debug("Enter: ArrayDeserializer.onStartChild()");
        }
        if (attributes != null) {
            String pos = Constants.getValue(attributes, Constants.URIS_SOAP_ENC, "position");
            if (pos != null) {
                int leftBracketIndex = pos.lastIndexOf(91);
                int rightBracketIndex = pos.lastIndexOf(93);
                if (leftBracketIndex == -1 || rightBracketIndex == -1 || rightBracketIndex < leftBracketIndex) {
                    throw new SAXException(Messages.getMessage("badPosition00", pos));
                }
                this.curIndex = this.convertToIndex(pos.substring(leftBracketIndex + 1, rightBracketIndex), "badPosition00");
            }
            if (AttributeUtils.isNil(attributes)) {
                this.setChildValue(null, this.curIndex++);
                return new NOOPProcessor();
            }
        }
        if ((itemType = AttributeUtils.getTypeFromAttributes(namespace, localPart, attributes, mappingScope)) == null) {
            itemType = this.defaultItemType;
        }
        Class<?> itemClass = null;
        if (this.arrayClass != null && !this.arrayClass.equals(Object;.class) && this.arrayClass.isArray()) {
            itemClass = this.arrayClass.getComponentType();
            if (this.defaultType == null) {
                this.defaultType = context.getTypeMapping().getTypeQName(itemClass);
            }
        }
        if ((dSer = this.getDeserializer(itemType, itemClass, href = attributes.getValue("href"), context)) == null) {
            dSer = this.getDeserializer(itemType, null, href, context);
        }
        dSer.registerValueTarget(new DeserializerTarget(this, new Integer(this.curIndex)));
        this.addChildDeserializer(dSer, href);
        ++this.curIndex;
        if (log.isDebugEnabled()) {
            log.debug("Exit: ArrayDeserializer.onStartChild()");
        }
        return dSer;
    }

    public void onSimpleChild(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context, String strValue) throws SAXException {
        Object childValue;
        Class<?> itemClass = null;
        if (this.arrayClass != null && this.arrayClass.isArray()) {
            itemClass = this.arrayClass.getComponentType();
        }
        if (itemClass == null || itemClass != String.class && !itemClass.isPrimitive()) {
            super.onSimpleChild(namespace, localPart, prefixedName, attributes, mappingScope, context, strValue);
            return;
        }
        try {
            childValue = SimpleDeserializer.convert(strValue, itemClass);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializer.onSimpleChild", "518", this);
            throw new SAXException(e);
        }
        this.setChildValue(childValue, this.curIndex);
        ++this.curIndex;
    }

    public void setValue(Object value2, Object hint) throws SAXException {
        if (hint instanceof Integer) {
            this.setChildValue(value2, (Integer)hint);
        } else {
            super.setValue(value2, hint);
        }
    }

    public void setChildValue(Object value2, int offset) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ArrayDeserializer::setChildValue(" + value2 + ", " + offset + ")");
        }
        ArrayList list = (ArrayList)this.value;
        if (this.mDimLength == null) {
            while (list.size() <= offset) {
                list.add(null);
            }
            list.set(offset, value2);
        } else {
            ArrayList mDimIndex = this.toMultiIndex(offset);
            for (int i = 0; i < this.mDimLength.size(); ++i) {
                int length = (Integer)this.mDimLength.get(i);
                int index = (Integer)mDimIndex.get(i);
                while (list.size() < length) {
                    list.add(null);
                }
                if (i < this.mDimLength.size() - 1) {
                    if (list.get(index) == null) {
                        list.set(index, new ArrayList());
                    }
                    list = (ArrayList)list.get(index);
                    continue;
                }
                list.set(index, value2);
            }
        }
    }

    public void valueComplete() throws SAXException {
        if (this.componentsReady()) {
            try {
                if (this.arrayClass != null) {
                    this.value = JavaUtils.convert(this.value, this.arrayClass);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        super.valueComplete();
    }

    private int convertToIndex(String text, String exceptKey) throws SAXException {
        StringTokenizer tokenizer = new StringTokenizer(text, "[],");
        int index = 0;
        try {
            if (this.mDimLength == null) {
                index = Integer.parseInt(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    throw new SAXException(Messages.getMessage(exceptKey, text));
                }
            } else {
                int dim = -1;
                ArrayList<Integer> work = new ArrayList<Integer>();
                while (tokenizer.hasMoreTokens()) {
                    if (++dim >= this.mDimLength.size()) {
                        throw new SAXException(Messages.getMessage(exceptKey, text));
                    }
                    int workIndex = Integer.parseInt(tokenizer.nextToken());
                    if (workIndex < 0 || workIndex >= (Integer)this.mDimLength.get(dim)) {
                        throw new SAXException(Messages.getMessage(exceptKey, text));
                    }
                    work.add(new Integer(workIndex));
                }
                index = this.toSingleIndex(work);
            }
        }
        catch (SAXException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializer.convertToIndex", "679", this);
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializer.convertToIndex", "682", this);
            throw new SAXException(Messages.getMessage(exceptKey, text));
        }
        return index;
    }

    private ArrayList toMultiIndex(int single) {
        if (this.mDimLength == null) {
            return null;
        }
        if (this.mDimFactor == null) {
            this.mDimFactor = new ArrayList();
            for (int i = 0; i < this.mDimLength.size(); ++i) {
                int factor = 1;
                for (int j = i + 1; j < this.mDimLength.size(); ++j) {
                    factor *= ((Integer)this.mDimLength.get(j)).intValue();
                }
                this.mDimFactor.add(new Integer(factor));
            }
        }
        ArrayList<Integer> rc = new ArrayList<Integer>();
        for (int i = 0; i < this.mDimLength.size(); ++i) {
            int factor = (Integer)this.mDimFactor.get(i);
            rc.add(new Integer(single / factor));
            single %= factor;
        }
        return rc;
    }

    private int toSingleIndex(ArrayList indexArray) {
        if (this.mDimLength == null || indexArray == null) {
            return -1;
        }
        if (this.mDimFactor == null) {
            this.mDimFactor = new ArrayList();
            for (int i = 0; i < this.mDimLength.size(); ++i) {
                int factor = 1;
                for (int j = i + 1; j < this.mDimLength.size(); ++j) {
                    factor *= ((Integer)this.mDimLength.get(j)).intValue();
                }
                this.mDimFactor.add(new Integer(factor));
            }
        }
        int single = 0;
        for (int i = 0; i < indexArray.size(); ++i) {
            single += (Integer)this.mDimFactor.get(i) * (Integer)indexArray.get(i);
        }
        return single;
    }

    public boolean recycle() {
        boolean rc = super.recycle();
        if (rc) {
            this.arrayType = null;
            this.curIndex = 0;
            this.defaultItemType = null;
            this.length = 0;
            this.arrayClass = null;
            this.mDimLength = null;
            this.mDimFactor = null;
        }
        return rc;
    }

    public class ArrayListExtension
    extends ArrayList
    implements JavaUtils.ConvertCache {
        private HashMap table;
        private Class arrayClass;

        ArrayListExtension(Class arrayClass) {
            this.table = null;
            this.arrayClass = null;
            this.arrayClass = arrayClass;
            if (arrayClass == null || arrayClass.isInterface() || Modifier.isAbstract(arrayClass.getModifiers())) {
                arrayClass = null;
            }
        }

        ArrayListExtension(Class arrayClass, int length) {
            super(length);
            this.table = null;
            this.arrayClass = null;
            this.arrayClass = arrayClass;
            if (arrayClass == null || arrayClass.isInterface() || Modifier.isAbstract(arrayClass.getModifiers())) {
                arrayClass = null;
            }
        }

        public void setConvertedValue(Class cls, Object value2) {
            if (this.table == null) {
                this.table = new HashMap();
            }
            this.table.put(cls, value2);
        }

        public Object getConvertedValue(Class cls) {
            if (this.table == null) {
                return null;
            }
            return this.table.get(cls);
        }

        public Class getDestClass() {
            return this.arrayClass;
        }
    }
}

