/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.encoding.DefaultSOAP12TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMappingBase;
import com.ibm.ws.webservices.engine.encoding.TypeMappingDelegate;
import com.ibm.ws.webservices.engine.encoding.TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.xml.rpc.encoding.TypeMapping;

public class TypeMappingRegistryImpl
implements TypeMappingRegistry {
    private Hashtable mapTM = new Hashtable();
    private TypeMappingDelegate defaultDelTM = (TypeMappingDelegate)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            if (Constants.URI_DEFAULT_SOAP_ENC.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                return new TypeMappingDelegate(DefaultTypeMappingImpl.getSingleton());
            }
            return new TypeMappingDelegate(DefaultSOAP12TypeMappingImpl.getSingleton());
        }
    });

    public TypeMapping register(String namespaceURI, TypeMapping mapping) {
        if (mapping == null || !(mapping instanceof TypeMappingBase)) {
            throw new IllegalArgumentException(Messages.getMessage("badTypeMapping"));
        }
        if (namespaceURI == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullNamespaceURI"));
        }
        TypeMappingDelegate del = (TypeMappingDelegate)this.mapTM.get(namespaceURI);
        if (del == null) {
            del = new TypeMappingDelegate((TypeMappingBase)mapping);
            this.mapTM.put(namespaceURI, del);
        } else {
            del.setDelegate((TypeMappingBase)mapping);
        }
        return null;
    }

    public void registerDefault(TypeMapping mapping) {
        if (mapping == null || !(mapping instanceof TypeMappingBase)) {
            throw new IllegalArgumentException(Messages.getMessage("badTypeMapping"));
        }
        if (this.defaultDelTM.getDelegate() instanceof TypeMappingDelegate) {
            throw new IllegalArgumentException(Messages.getMessage("defaultTypeMappingSet"));
        }
        this.defaultDelTM.setDelegate((TypeMappingBase)mapping);
    }

    public TypeMapping getTypeMapping(String namespaceURI) {
        TypeMappingBase del = null;
        if (namespaceURI != null) {
            del = (TypeMappingBase)this.mapTM.get(namespaceURI);
        }
        TypeMappingBase tm = null;
        if (del != null) {
            tm = del.getDelegate();
        }
        if (tm == null) {
            tm = (TypeMappingBase)this.getDefaultTypeMapping();
        }
        return tm;
    }

    public TypeMapping unregisterTypeMapping(String namespaceURI) {
        TypeMappingBase del = null;
        if (namespaceURI != null) {
            del = (TypeMappingBase)this.mapTM.get(namespaceURI);
        }
        TypeMappingBase tm = null;
        if (del != null) {
            tm = del.getDelegate();
            del.setDelegate(null);
        }
        return tm;
    }

    public boolean removeTypeMapping(TypeMapping mapping) {
        String[] ns = this.getRegisteredEncodingStyleURIs();
        boolean rc = false;
        for (int i = 0; i < ns.length; ++i) {
            if (this.getTypeMapping(ns[i]) != mapping) continue;
            rc = true;
            this.unregisterTypeMapping(ns[i]);
        }
        return rc;
    }

    public TypeMapping createTypeMapping() {
        return new TypeMappingImpl(this.defaultDelTM);
    }

    public String[] getRegisteredEncodingStyleURIs() {
        Set s = this.mapTM.keySet();
        if (s != null) {
            String[] rc = new String[s.size()];
            int i = 0;
            Iterator it = s.iterator();
            while (it.hasNext()) {
                rc[i++] = (String)it.next();
            }
            return rc;
        }
        return null;
    }

    public void clear() {
        this.mapTM.clear();
    }

    public TypeMapping getDefaultTypeMapping() {
        TypeMappingBase defaultTM;
        for (defaultTM = this.defaultDelTM; defaultTM != null && defaultTM instanceof TypeMappingDelegate; defaultTM = ((TypeMappingBase)defaultTM).getDelegate()) {
        }
        return defaultTM;
    }
}

