/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.dispatchers;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.dispatchers.Processor;
import com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.lang.reflect.InvocationTargetException;

public abstract class BasicDispatcher
extends BasicHandler {
    private static final String D_OPTION_PROCESSOR = "processor";

    public static final void setProcessor(Configurable port2, Processor processor) {
        port2.setOption(D_OPTION_PROCESSOR, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Processor getProcessor(Configurable port2) {
        Processor p;
        Configurable configurable = port2;
        synchronized (configurable) {
            p = (Processor)port2.getOption(D_OPTION_PROCESSOR);
            if (p == null) {
                p = SoapRPCProcessor.getProcessor();
                BasicDispatcher.setProcessor(port2, p);
            }
        }
        return p;
    }

    protected void processMessage(MessageContext msgContext, Object targetService) throws Exception, WebServicesFault {
        SOAPPort port2 = msgContext.getPort();
        Processor processor = BasicDispatcher.getProcessor(msgContext.getPort());
        if (processor == null) {
            throw new WebServicesFault(Messages.getMessage("NoProcessor00", port2.getName()));
        }
        processor.processMessage(msgContext, this, targetService);
    }

    protected void resolveOperation(MessageContext msgContext) throws Exception, WebServicesFault {
        SOAPPort port2 = msgContext.getPort();
        Processor processor = BasicDispatcher.getProcessor(msgContext.getPort());
        if (processor == null) {
            throw new WebServicesFault(Messages.getMessage("NoProcessor00", port2.getName()));
        }
        processor.resolveOperation(msgContext);
    }

    public abstract void bindPortToDispatcher(SOAPPort var1) throws WebServicesFault;

    public abstract void invoke(MessageContext var1) throws WebServicesFault;

    public abstract Object invokeOperation(OperationDesc var1, Object var2, Object[] var3, MessageContext var4) throws WebServicesFault, InvocationTargetException;
}

