/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentsImpl;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDBeanMapping;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDispatcher;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDGen;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfoChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDNonFatalException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDOperation;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTargetedChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMapping;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMappingContainer;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistryImpl;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler;
import com.ibm.ws.webservices.engine.handlers.soap.ClientSOAPPort;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.handlers.soap.ServerSOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.LockableHashtable;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.tools.WSDLQuery;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDPort
extends WSDDTargetedChain
implements WSDDTypeMappingContainer {
    private static Log log = LogFactory.getLog(WSDDPort.class.getName());
    private TypeMappingRegistry _tmr = null;
    private List _typeMappings = new Vector();
    private List _operations = new Vector();
    private final PortDesc _portDesc = new PortDesc();
    private Vector _wsddGens = new Vector();
    private LockableHashtable _objects = null;
    private Style _style = Style.DEFAULT;
    private Use _use = Use.DEFAULT;

    public WSDDPort(int mode) {
        super(mode);
        this._portDesc.setName(this.getName());
    }

    public WSDDPort(int modeClientServer, Element e) throws WSDDException {
        super(modeClientServer, e);
        Element hcEl;
        String dispatcherStr;
        Element urlElem;
        String attachmentStr;
        String useStr;
        this._portDesc.setName(this.getName());
        String styleStr = e.getAttribute("style");
        if (styleStr != null && !styleStr.equals("")) {
            this.setStyle(Style.getStyle(styleStr, Style.DEFAULT));
            this.setDispatcherQName(this.getStyle().getDispatcher());
        }
        if ((useStr = e.getAttribute("use")) != null && !useStr.equals("")) {
            this.setUse(Use.getUse(useStr, Use.DEFAULT));
        } else if (this.getStyle() != Style.RPC) {
            this.setUse(Use.LITERAL);
        }
        String streamStr = e.getAttribute("streaming");
        if (streamStr != null && !streamStr.equals("")) {
            this.setStreaming(!streamStr.equals("off"));
        }
        if ((attachmentStr = e.getAttribute("attachment")) != null && !attachmentStr.equals("")) {
            this.setSendType(AttachmentsImpl.getSendType(attachmentStr));
        }
        Element[] operationElements = this.getChildElements(e, "operation");
        for (int i = 0; i < operationElements.length; ++i) {
            this.addOperation(new WSDDOperation(operationElements[i], this._portDesc));
        }
        Element[] typeMappingElements = this.getChildElements(e, "typeMapping");
        for (int i = 0; i < typeMappingElements.length; ++i) {
            this._addTypeMapping(new WSDDTypeMapping(typeMappingElements[i]));
        }
        Element[] beanMappingElements = this.getChildElements(e, "beanMapping");
        for (int i = 0; i < beanMappingElements.length; ++i) {
            this._addTypeMapping(new WSDDBeanMapping(beanMappingElements[i]));
        }
        Vector<String> nameSpaces = new Vector<String>();
        Element[] namespaceElements = this.getChildElements(e, "namespace");
        for (int i = 0; i < namespaceElements.length; ++i) {
            String ns = XMLUtils.getChildCharacterData(namespaceElements[i]);
            nameSpaces.add(ns);
        }
        this.setNamespaceMappings(nameSpaces);
        Element wsdlElem = this.getChildElement(e, "wsdlFile");
        if (wsdlElem != null) {
            String fileName = XMLUtils.getChildCharacterData(wsdlElem);
            this.setWSDLFile(fileName);
        }
        if ((urlElem = this.getChildElement(e, "endpointURL")) != null) {
            String endpointURL = XMLUtils.getChildCharacterData(urlElem);
            this.setEndpointURL(endpointURL);
        }
        if ((dispatcherStr = e.getAttribute("dispatcher")) != null && !dispatcherStr.equals("")) {
            this.setDispatcherQName(XMLUtils.getQNameFromString(dispatcherStr, e));
        }
        if ((hcEl = this.getChildElement(e, "handlerInfoChain")) != null) {
            this.setHandlerInfoChain(new WSDDJAXRPCHandlerInfoChain(modeClientServer == 1, hcEl));
        }
        this._initTMR();
        this.validateDescriptors();
        Element[] wsddGenElements = this.getChildElements(e, "Gen");
        for (int i = 0; i < wsddGenElements.length; ++i) {
            WSDDGen mapping = new WSDDGen(wsddGenElements[i]);
            this._wsddGens.add(mapping);
        }
    }

    public void setQName(QName qname) {
        super.setQName(qname);
        if (this._portDesc != null) {
            this._portDesc.setName(this.getName());
        }
    }

    protected QName getElementName() {
        return QNAME_PORT;
    }

    public void _initTMR() throws WSDDException {
        int j;
        this.expand();
        if (this._tmr == null) {
            this._tmr = new TypeMappingRegistryImpl();
            for (int i = 0; i < this._typeMappings.size(); ++i) {
                this.deployTypeMapping((WSDDTypeMapping)this._typeMappings.get(i));
            }
        }
        String[] uses = Use.getUses();
        String[] encodingStyles = new String[uses.length];
        for (j = 0; j < encodingStyles.length; ++j) {
            encodingStyles[j] = Use.getUse(uses[j]).getEncoding();
        }
        for (j = 0; j < encodingStyles.length; ++j) {
            String encodingStyle = encodingStyles[j];
            TypeMapping tm = (TypeMapping)this._tmr.getTypeMapping(encodingStyle);
            TypeMapping df = (TypeMapping)this._tmr.getDefaultTypeMapping();
            if (tm != null && tm != df) continue;
            tm = (TypeMapping)this._tmr.createTypeMapping();
            tm.setSupportedEncodings(encodingStyles);
            this._tmr.register(encodingStyle, tm);
        }
    }

    public void validateDescriptors() throws WSDDException {
        if (this._tmr == null) {
            this._initTMR();
        }
        this._portDesc.setTypeMappingRegistry(this._tmr);
        this._portDesc.setTypeMapping(this.getTypeMapping(this.getUse().getEncoding()));
    }

    public void addTypeMapping(WSDDTypeMapping mapping) {
        this.expand();
        this._addTypeMapping(mapping);
    }

    public void _addTypeMapping(WSDDTypeMapping mapping) {
        this._typeMappings.add(mapping);
    }

    public void addOperation(WSDDOperation operation) {
        this._operations.add(operation);
        OperationDesc opDesc = operation.getOperationDesc();
        this.setStyle(opDesc.getStyle());
        this.setUse(opDesc.getUse());
        this._portDesc.addOperationDesc(opDesc);
    }

    public void loadPortDescByIntrospection() {
        this._portDesc.loadPortDescByIntrospection();
    }

    public QName getDispatcherQName() {
        return this.getPivotQName();
    }

    public void setDispatcherQName(QName dispatcherQName) {
        this.setPivotQName(dispatcherQName);
    }

    private Style getStyle() {
        return this._style;
    }

    private void setStyle(Style style) {
        this._style = style;
    }

    private Use getUse() {
        return this._use;
    }

    private void setUse(Use use) {
        this._use = use;
    }

    public boolean getStreaming() {
        return !this._portDesc.needsHighFidelityRecording();
    }

    public void setStreaming(boolean streaming) {
        this._portDesc.setHighFidelityRecording(!streaming);
    }

    public int getSendType() {
        return this._portDesc.getSendType();
    }

    public void setSendType(int sendType) {
        this._portDesc.setSendType(sendType);
    }

    public List getAllowedMethods() {
        return this._portDesc.getAllowedMethods();
    }

    public void setAllowedMethods(List allowedMethods) {
        this._portDesc.setAllowedMethods(allowedMethods);
    }

    public String getEndpointURL() {
        return this._portDesc.getEndpointURL();
    }

    public void setEndpointURL(String endpointURL) {
        this._portDesc.setEndpointURL(endpointURL);
    }

    public String getWSDLFile() {
        return this._portDesc.getWSDLFile();
    }

    public void setWSDLFile(String wsdlFile) {
        this._portDesc.setWSDLFile(wsdlFile);
    }

    public QName getWSDLPort() {
        return this._portDesc.getWSDLPort();
    }

    public void setWSDLPort(QName qname) {
        this._portDesc.setWSDLPort(qname);
    }

    public void setWSDLPort(String namespaceURI, String localPart) {
        this.setWSDLPort(QNameTable.createQName(namespaceURI, localPart));
    }

    public void setNamespaceMappings(List _namespaceMappings) {
        if (!_namespaceMappings.isEmpty()) {
            this._portDesc.setNamespaceMappings(_namespaceMappings);
        }
    }

    public List getNamespaceMappings() {
        return this._portDesc.getNamespaceMappings();
    }

    public void setImplClass(Class implClass) {
        this._portDesc.setImplClass(implClass);
    }

    public void addWSGen(WSDDGen mapping) {
        this._wsddGens.add(mapping);
    }

    private void expand() {
        for (int i = 0; i < this._wsddGens.size(); ++i) {
            WSDLQuery wsdlQuery = null;
            try {
                wsdlQuery = ((WSDDGen)this._wsddGens.get(i)).getWSDLQuery();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.axis.ext.deployment.wsdd.WSDDPort.expand", "117", this);
                log.warn(Messages.getMessage("internalError00"), e);
                throw new InternalException(e);
            }
            if (wsdlQuery == null) continue;
            String portName = this.getWSDLPort().getLocalPart();
            if (log.isDebugEnabled()) {
                log.debug("portName = " + portName);
            }
            Vector tms = wsdlQuery.getTypeMappings(portName);
            if (log.isDebugEnabled()) {
                log.debug("TypeMapping vector = " + tms);
            }
            if (tms != null) {
                for (int j = 0; j < tms.size(); ++j) {
                    this._addTypeMapping((WSDDTypeMapping)tms.get(j));
                }
            }
            Vector operations = wsdlQuery.getOperationDescs(portName);
            if (log.isDebugEnabled()) {
                log.debug("Operations vector = " + operations);
            }
            if (operations == null) continue;
            for (int j = 0; j < operations.size(); ++j) {
                this.addOperation(new WSDDOperation((OperationDesc)operations.get(j)));
            }
        }
        this._wsddGens = new Vector();
    }

    protected Handler makeNewInstance(EngineConfiguration registry) throws ConfigurationException {
        this.expand();
        if (this._cachedPort == null) {
            List globalHeaders;
            JAXRPCHandler.ActorHeaderBindings bindings;
            HandlerChain chain;
            SOAPPort soapPort;
            this._initTMR();
            Handler reqHandler = null;
            WSDDChain request = this.getRequestFlow();
            if (request != null) {
                reqHandler = request.getInstance(registry);
            }
            Handler respHandler = null;
            WSDDChain response = this.getResponseFlow();
            if (response != null) {
                respHandler = response.getInstance(registry);
            }
            if (this.getModeClientServer() == 2) {
                Handler dispatcherHandler = null;
                if (this.getDispatcherQName() != null) {
                    try {
                        dispatcherHandler = WSDDDispatcher.getInstance(this.getDispatcherQName(), this, registry);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort.makeNewInstance", "450", this);
                        throw WSDDException.makeWSDDException(e);
                    }
                    if (dispatcherHandler == null) {
                        throw new WSDDException(Messages.getMessage("couldntConstructProvider00"));
                    }
                }
                soapPort = new ServerSOAPPort(reqHandler, dispatcherHandler, respHandler);
            } else if (this.getModeClientServer() == 1) {
                soapPort = new ClientSOAPPort(reqHandler, respHandler);
            } else {
                throw new InternalException(Messages.getMessage("soapport.csmode.undefined"));
            }
            soapPort.setPortDesc(this._portDesc);
            if (this.getQName() != null) {
                soapPort.setName(this.getName());
            }
            soapPort.setOptions(this.getParametersTable());
            if (this.getUse() != Use.ENCODED) {
                soapPort.setOption("sendMultiRefs", Boolean.FALSE);
                soapPort.setOption("sendXsiTypes", Boolean.FALSE);
            }
            if ((chain = this.getHandlerChain()) != null) {
                soapPort.setHandlerChain(chain);
            }
            if ((bindings = this.getActorHeaderBinding()) != null) {
                soapPort.setActorHeaderBinding(bindings);
            }
            if (this.getHandlerInfoChain() != null && (globalHeaders = this.getHandlerInfoChain().getGlobalHeaders()) != null) {
                soapPort.setGlobalHeaders(globalHeaders);
            }
            try {
                soapPort.getInitializedPortDesc(MessageContext.getCurrentThreadsContext());
            }
            catch (WebServicesFault wsf) {
                FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort.makeNewInstance", "510", this);
                throw WSDDException.makeWSDDException(wsf);
            }
            this._cachedPort = soapPort;
        }
        if (this._objects != null) {
            Map options = this._cachedPort.getOptions();
            if (options != null) {
                options.putAll(this._objects);
            } else {
                this._cachedPort.setOptions(this._objects);
            }
        }
        return this._cachedPort;
    }

    public void writeParamsToContext(SerializationContext context) throws IOException {
        super.writeParamsToContext(context);
        if (this._objects == null) {
            return;
        }
        Set entries = this._objects.entrySet();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name2 = (String)entry.getKey();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "name", "name", "CDATA", name2);
            attrs.addAttribute("", "value", "value", "CDATA", entry.getValue().toString());
            if (this._objects.isKeyLocked(name2)) {
                attrs.addAttribute("", "locked", "locked", "CDATA", "true");
            }
            context.getSerializationWriter().simpleElement(QNAME_PARAM, attrs, null);
        }
    }

    public void deployTypeMapping(WSDDTypeMapping mapping) throws WSDDException {
        this.expand();
        if (!this._typeMappings.contains(mapping)) {
            this._addTypeMapping(mapping);
        }
        if (this._tmr == null) {
            this._tmr = new TypeMappingRegistryImpl();
        }
        try {
            int j;
            String[] encodingStyles;
            String encodingStyle = mapping.getEncodingStyle();
            if (encodingStyle == null || encodingStyle.equals("")) {
                encodingStyles = Use.getUses();
                for (j = 0; j < encodingStyles.length; ++j) {
                    encodingStyles[j] = Use.getUse(encodingStyles[j]).getEncoding();
                }
            } else {
                encodingStyles = new String[]{encodingStyle};
            }
            for (j = 0; j < encodingStyles.length; ++j) {
                encodingStyle = encodingStyles[j];
                TypeMapping tm = (TypeMapping)this._tmr.getTypeMapping(encodingStyle);
                TypeMapping df = (TypeMapping)this._tmr.getDefaultTypeMapping();
                if (tm == null || tm == df) {
                    tm = (TypeMapping)this._tmr.createTypeMapping();
                    tm.setSupportedEncodings(encodingStyles);
                    this._tmr.register(encodingStyle, tm);
                }
                this._portDesc.setTypeMappingRegistry(this._tmr);
                this._portDesc.setTypeMapping(tm);
                SerializerFactory ser = null;
                DeserializerFactory deser = null;
                if (mapping.getSerializerName() != null && !mapping.getSerializerName().equals("")) {
                    ser = BaseSerializerFactory.createFactory(mapping.getSerializer(), mapping.getLanguageSpecificType(), mapping.getQName(), mapping.getBinderName(), mapping.getComponentQName(), mapping.getComponentTypeQName());
                }
                if (mapping.getDeserializerName() != null && !mapping.getDeserializerName().equals("")) {
                    deser = BaseDeserializerFactory.createFactory(mapping.getDeserializer(), mapping.getLanguageSpecificType(), mapping.getQName(), mapping.getBinderName(), mapping.getComponentQName(), mapping.getComponentTypeQName());
                }
                tm.register(mapping.getLanguageSpecificType(), mapping.getQName(), ser, deser);
            }
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort.deployTypeMapping", "570", this);
            log.error(Messages.getMessage("unabletoDeployTypemapping00", mapping.getQName().toString()), e);
            throw WSDDNonFatalException.makeWSDDNonFatalException(e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort.deployTypeMapping", "574", this);
            throw WSDDException.makeWSDDException(e);
        }
    }

    public void writeToContext(SerializationContext context) throws IOException {
        int i;
        this.expand();
        AttributesImpl attrs = new AttributesImpl();
        QName name2 = this.getQName();
        if (name2 != null) {
            attrs.addAttribute("", "name", "name", "CDATA", context.getSerializationWriter().qName2String(name2));
        }
        if (this.getDispatcherQName() != null) {
            attrs.addAttribute("", "dispatcher", "dispatcher", "CDATA", context.getSerializationWriter().qName2String(this.getDispatcherQName()));
        }
        if (this.getStyle() != Style.DEFAULT) {
            attrs.addAttribute("", "style", "style", "CDATA", this.getStyle().getName());
        }
        if (this.getUse() != Use.DEFAULT) {
            attrs.addAttribute("", "use", "use", "CDATA", this.getUse().getName());
        }
        if (this.getStreaming()) {
            attrs.addAttribute("", "streaming", "streaming", "CDATA", "on");
        } else {
            attrs.addAttribute("", "streaming", "streaming", "CDATA", "off");
        }
        if (this.getSendType() != 1) {
            attrs.addAttribute("", "attachment", "attachment", "CDATA", AttachmentsImpl.getSendTypeString(this.getSendType()));
        }
        context.getSerializationWriter().startElement(WSDDConstants.QNAME_PORT, attrs);
        if (this.getWSDLFile() != null) {
            context.getSerializationWriter().simpleElement(QNAME_WSDLFILE, null, this.getWSDLFile());
        }
        for (i = 0; i < this._operations.size(); ++i) {
            WSDDOperation operation = (WSDDOperation)this._operations.get(i);
            operation.writeToContext(context);
        }
        this.writeFlowsToContext(context);
        this.writeParamsToContext(context);
        for (i = 0; i < this._typeMappings.size(); ++i) {
            ((WSDDTypeMapping)this._typeMappings.get(i)).writeToContext(context);
        }
        List nameSpaces = this.getNamespaceMappings();
        for (int i2 = 0; i2 < nameSpaces.size(); ++i2) {
            context.getSerializationWriter().simpleElement(QNAME_NAMESPACE, null, (String)nameSpaces.get(i2));
        }
        if (this.getEndpointURL() != null) {
            context.getSerializationWriter().simpleElement(QNAME_ENDPOINTURL, null, this.getEndpointURL());
        }
        if (this.getHandlerInfoChain() != null) {
            this.getHandlerInfoChain().writeToContext(context);
        }
        context.getSerializationWriter().endElement();
    }

    public List getTypeMappings() {
        return this._typeMappings;
    }

    public void setTypeMappings(Vector typeMappings) {
        this._typeMappings = typeMappings;
    }

    public TypeMapping getTypeMapping(String encodingStyle) {
        if (this._tmr == null) {
            return null;
        }
        return (TypeMapping)this._tmr.getTypeMapping(encodingStyle);
    }

    public void setObject(String name2, Object value2) {
        if (this._objects == null) {
            this._objects = new LockableHashtable();
        }
        this._objects.put(name2, value2);
    }

    public String getName() {
        return this.getQName() == null ? null : this.getQName().getLocalPart();
    }

    public QName getServiceQName() {
        return this._portDesc == null ? null : this._portDesc.getServiceQName();
    }

    public String toString() {
        return "WSDDPort: Mode=" + (this.getModeClientServer() == 1 ? "Client" : "Server") + ", Name=" + this.getName() + ", PortDesc=" + this._portDesc;
    }
}

