/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WSDDEngineConfiguration;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDBeanMapping;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDGlobalConfiguration;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDNonFatalException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTransport;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMapping;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMappingContainer;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistryImpl;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleException;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleObject;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleOwner;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleSetImpl;
import com.ibm.ws.webservices.engine.lifecycle._LifeCycleObject;
import com.ibm.ws.webservices.engine.lifecycle._LifeCycleSet;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;

public class WSDDDeployment
extends WSDDElement
implements WSDDTypeMappingContainer,
WSDDEngineConfiguration,
_LifeCycleObject {
    protected static Log log = LogFactory.getLog(WSDDDeployment.class.getName());
    private HashMap ports = new HashMap();
    private HashMap transports = new HashMap();
    private Vector typeMappings = new Vector();
    private WSDDGlobalConfiguration globalConfig = null;
    private HashMap namespaceToPorts = new HashMap();
    private boolean _containerManaged = false;
    private _LifeCycleSet _lifeCycleSet;
    TypeMappingRegistry tmr = new TypeMappingRegistryImpl();
    private boolean tmrDeployed = false;

    public WSDDDeployment() {
        this._lifeCycleSet = this.lifeCycleSetFactory(this);
    }

    public WSDDDeployment(int modeClientServer, Element e) throws WSDDException {
        super(e);
        WSDDTypeMapping mapping;
        int i;
        this._lifeCycleSet = this.lifeCycleSetFactory(this);
        Element[] elements = this.getChildElements(e, "transport");
        for (i = 0; i < elements.length; ++i) {
            this.deployTransport(new WSDDTransport(modeClientServer, elements[i]));
        }
        elements = this.getChildElements(e, "port");
        for (i = 0; i < elements.length; ++i) {
            try {
                this.deployPort(new WSDDPort(modeClientServer, elements[i]));
                continue;
            }
            catch (WSDDNonFatalException ex) {
                continue;
            }
            catch (WSDDException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment.WSDDDeployment", "187", this);
                throw ex;
            }
        }
        elements = this.getChildElements(e, "typeMapping");
        for (i = 0; i < elements.length; ++i) {
            try {
                mapping = new WSDDTypeMapping(elements[i]);
                this.deployTypeMapping(mapping);
                continue;
            }
            catch (WSDDNonFatalException ex) {
                continue;
            }
            catch (WSDDException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment.WSDDDeployment", "202", this);
                throw ex;
            }
        }
        elements = this.getChildElements(e, "beanMapping");
        for (i = 0; i < elements.length; ++i) {
            mapping = new WSDDBeanMapping(elements[i]);
            this.deployTypeMapping(mapping);
        }
        Element el = this.getChildElement(e, "globalConfiguration");
        if (el != null) {
            this.setGlobalConfiguration(new WSDDGlobalConfiguration(modeClientServer, el));
        }
    }

    protected _LifeCycleSet lifeCycleSetFactory(_LifeCycleObject container) {
        return new LifeCycleSetImpl(container);
    }

    public boolean isContainerManaged() {
        return this._containerManaged;
    }

    public void setContainerManaged(boolean containerManaged) {
        this._containerManaged = containerManaged;
    }

    public void deployTransport(WSDDTransport transport2) {
        this.undeployTransport(transport2.getQName());
        this.transports.put(transport2.getQName(), transport2);
        this.manageLifeCycleOf(transport2);
    }

    public void undeployTransport(QName qname) {
        WSDDTransport transport2 = (WSDDTransport)this.transports.get(qname);
        if (transport2 != null) {
            this.transports.remove(qname);
            if (this.releaseLifeCycleManagementOf(transport2) && transport2.isActive()) {
                transport2.destroy();
            }
        }
    }

    public void deployPort(WSDDPort wsddPort) {
        this.undeployPort(wsddPort.getQName());
        this.registerNamespaceForPort(wsddPort.getQName().getLocalPart(), wsddPort);
        List namespaces = wsddPort.getNamespaceMappings();
        for (int i = 0; i < namespaces.size(); ++i) {
            String namespace = (String)namespaces.get(i);
            this.registerNamespaceForPort(namespace, wsddPort);
        }
        this.ports.put(wsddPort.getQName(), wsddPort);
        this.manageLifeCycleOf(wsddPort);
    }

    public void undeployPort(QName qname) {
        WSDDPort wsddPort = (WSDDPort)this.ports.get(qname);
        if (wsddPort != null) {
            List namespaces = wsddPort.getNamespaceMappings();
            for (int i = 0; i < namespaces.size(); ++i) {
                String namespace = (String)namespaces.get(i);
                this.removeNamespaceMapping(namespace);
            }
            this.removeNamespaceMapping(wsddPort.getQName().getLocalPart());
            this.ports.remove(qname);
            if (this.releaseLifeCycleManagementOf(wsddPort) && wsddPort.isActive()) {
                wsddPort.destroy();
            }
        }
    }

    public void deployTypeMapping(WSDDTypeMapping typeMapping) throws WSDDException {
        if (!this.typeMappings.contains(typeMapping)) {
            this.typeMappings.add(typeMapping);
        }
        if (this.tmrDeployed) {
            this.deployMapping(typeMapping);
        }
    }

    protected QName getElementName() {
        return QNAME_DEPLOY;
    }

    public void deployToRegistry(WSDDDeployment target) throws ConfigurationException {
        WSDDGlobalConfiguration global2 = this.globalConfig;
        if (global2 != null) {
            target.setGlobalConfiguration(global2);
        }
        Iterator<Object> i = this.transports.values().iterator();
        while (i.hasNext()) {
            target.deployTransport((WSDDTransport)i.next());
        }
        i = this.ports.values().iterator();
        while (i.hasNext()) {
            target.deployPort((WSDDPort)i.next());
        }
        i = this.typeMappings.iterator();
        while (i.hasNext()) {
            target.deployTypeMapping((WSDDTypeMapping)i.next());
        }
    }

    private void deployMapping(WSDDTypeMapping mapping) throws WSDDException {
        try {
            String encodingStyle = mapping.getEncodingStyle();
            if (encodingStyle == null) {
                encodingStyle = Constants.URI_DEFAULT_SOAP_ENC;
            }
            TypeMapping tm = (TypeMapping)this.tmr.getTypeMapping(encodingStyle);
            TypeMapping df = (TypeMapping)this.tmr.getDefaultTypeMapping();
            if (tm == null || tm == df) {
                tm = (TypeMapping)this.tmr.createTypeMapping();
                tm.setSupportedEncodings(new String[]{encodingStyle});
                this.tmr.register(encodingStyle, tm);
            }
            SerializerFactory ser = null;
            DeserializerFactory deser = null;
            if (mapping.getSerializerName() != null && !mapping.getSerializerName().equals("")) {
                ser = BaseSerializerFactory.createFactory(mapping.getSerializer(), mapping.getLanguageSpecificType(), mapping.getQName(), mapping.getComponentQName(), mapping.getComponentTypeQName());
            }
            if (mapping.getDeserializerName() != null && !mapping.getDeserializerName().equals("")) {
                deser = BaseDeserializerFactory.createFactory(mapping.getDeserializer(), mapping.getLanguageSpecificType(), mapping.getQName(), mapping.getComponentQName(), mapping.getComponentTypeQName());
            }
            tm.register(mapping.getLanguageSpecificType(), mapping.getQName(), ser, deser);
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment.deployMapping", "399", this);
            log.error(Messages.getMessage("unabletoDeployTypemapping00", mapping.getQName().toString()), e);
            throw WSDDNonFatalException.makeWSDDNonFatalException(e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment.deployMapping", "403", this);
            throw WSDDException.makeWSDDException(e);
        }
    }

    public void writeToContext(SerializationContext context) throws IOException {
        context.getSerializationWriter().addMapping("", "http://websphere.ibm.com/webservices/wsdd/");
        context.getSerializationWriter().addMapping("java", "http://websphere.ibm.com/webservices/wsdd/dispatchers/java");
        context.getSerializationWriter().startElement(QNAME_DEPLOY, null);
        if (this.globalConfig != null) {
            this.globalConfig.writeToContext(context);
        }
        Iterator<Object> i = this.ports.values().iterator();
        while (i.hasNext()) {
            WSDDPort wsddPort = (WSDDPort)i.next();
            wsddPort.writeToContext(context);
        }
        i = this.transports.values().iterator();
        while (i.hasNext()) {
            WSDDTransport transport2 = (WSDDTransport)i.next();
            transport2.writeToContext(context);
        }
        i = this.typeMappings.iterator();
        while (i.hasNext()) {
            WSDDTypeMapping mapping = (WSDDTypeMapping)i.next();
            mapping.writeToContext(context);
        }
        context.getSerializationWriter().endElement();
    }

    public void setGlobalConfiguration(WSDDGlobalConfiguration globalCfg) {
        if (this.globalConfig != null && this.releaseLifeCycleManagementOf(this.globalConfig) && this.globalConfig.isActive()) {
            this.globalConfig.destroy();
        }
        this.globalConfig = globalCfg;
        if (this.globalConfig != null) {
            this.manageLifeCycleOf(this.globalConfig);
        }
    }

    public WSDDTypeMapping[] getTypeMappings() {
        WSDDTypeMapping[] t = new WSDDTypeMapping[this.typeMappings.size()];
        this.typeMappings.toArray(t);
        return t;
    }

    public WSDDPort[] getPorts() {
        WSDDPort[] portArray = new WSDDPort[this.ports.size()];
        this.ports.values().toArray(portArray);
        return portArray;
    }

    public WSDDPort getWSDDPort(QName qname) {
        return (WSDDPort)this.ports.get(qname);
    }

    public Handler getTransport(QName name2) throws ConfigurationException {
        WSDDTransport wt = (WSDDTransport)this.transports.get(name2);
        if (wt != null) {
            return wt.getInstance(this);
        }
        return null;
    }

    public SOAPPort getPort(QName name2) throws ConfigurationException {
        WSDDPort wsddPort = (WSDDPort)this.ports.get(name2);
        if (wsddPort != null) {
            return (SOAPPort)wsddPort.getInstance(this);
        }
        return null;
    }

    public SOAPPort getPortByNamespaceURI(String namespace) throws ConfigurationException {
        WSDDPort wsddPort = (WSDDPort)this.namespaceToPorts.get(namespace);
        if (wsddPort != null) {
            return (SOAPPort)wsddPort.getInstance(this);
        }
        return null;
    }

    public TypeMapping getTypeMapping(String encodingStyle) throws ConfigurationException {
        return (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(encodingStyle);
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        if (!this.tmrDeployed) {
            for (int i = 0; i < this.typeMappings.size(); ++i) {
                WSDDTypeMapping mapping = (WSDDTypeMapping)this.typeMappings.get(i);
                this.deployMapping(mapping);
            }
            this.tmrDeployed = true;
        }
        return this.tmr;
    }

    public SimpleTargetedChain getGlobalHandler() throws ConfigurationException {
        if (this.globalConfig != null) {
            return (SimpleTargetedChain)this.globalConfig.getInstance(this);
        }
        return null;
    }

    public Map getGlobalOptions() {
        return this.globalConfig == null ? null : this.globalConfig.getParametersTable();
    }

    public WSDDGlobalConfiguration getGlobalConfig() {
        return this.globalConfig;
    }

    public Iterator getDeployedPorts() throws ConfigurationException {
        ArrayList<PortDesc> portDescs = new ArrayList<PortDesc>();
        Iterator i = this.ports.values().iterator();
        while (i.hasNext()) {
            WSDDPort wsddPort = (WSDDPort)i.next();
            try {
                SOAPPort soapPort = (SOAPPort)wsddPort.makeNewInstance(this);
                portDescs.add(soapPort.getPortDesc());
            }
            catch (WSDDNonFatalException ex) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Ignoring non-fatal exception: ", ex);
            }
        }
        return portDescs.iterator();
    }

    private void registerNamespaceForPort(String namespace, WSDDPort wsddPort) {
        this.namespaceToPorts.put(namespace, wsddPort);
    }

    private void removeNamespaceMapping(String namespace) {
        this.namespaceToPorts.remove(namespace);
    }

    public void setOwner(LifeCycleOwner owner) throws LifeCycleException {
        this._lifeCycleSet.setOwner(owner);
    }

    public LifeCycleOwner getOwner() {
        return this._lifeCycleSet.getOwner();
    }

    public final void init() throws LifeCycleException {
        this._lifeCycleSet.init();
    }

    public void _init() throws LifeCycleException {
        this._lifeCycleSet._init();
    }

    public final void destroy() {
        this._lifeCycleSet.destroy();
    }

    public void _destroy() {
        this._lifeCycleSet._destroy();
    }

    public int getState() {
        return this._lifeCycleSet.getState();
    }

    public boolean isActive() {
        return this._lifeCycleSet.isActive();
    }

    public void verifyActive() throws LifeCycleException {
        this._lifeCycleSet.verifyActive();
    }

    public void verifyInactive() throws LifeCycleException {
        this._lifeCycleSet.verifyInactive();
    }

    protected boolean manageLifeCycleOf(LifeCycleObject object) {
        return this._lifeCycleSet.manageLifeCycleOf(object);
    }

    protected boolean releaseLifeCycleManagementOf(LifeCycleObject object) throws LifeCycleException {
        return this._lifeCycleSet.releaseLifeCycleManagementOf(object);
    }
}

