/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.configuration;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.EngineConfigurationFactory;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.FileEngineConfigurationProvider;
import com.ibm.ws.webservices.engine.configuration.WSDDEngineConfigurationFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import java.io.File;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;

public class WebAppWSDDEngineConfigurationFactory
extends WSDDEngineConfigurationFactory {
    protected static Log log = LogFactory.getLog(WebAppWSDDEngineConfigurationFactory.class.getName());
    private ServletContext ctx;

    public static EngineConfigurationFactory newFactory(Object param) {
        return param instanceof ServletContext ? new WebAppWSDDEngineConfigurationFactory((ServletContext)param) : null;
    }

    protected WebAppWSDDEngineConfigurationFactory(ServletContext ctx) {
        this.ctx = ctx;
    }

    public EngineConfiguration getServerEngineConfig() {
        return WebAppWSDDEngineConfigurationFactory.getServerEngineConfig(this.ctx);
    }

    private static EngineConfiguration getServerEngineConfig(ServletContext ctx) {
        String appWebInfPath = "/WEB-INF";
        FileEngineConfigurationProvider config = null;
        String realWebInfPath = ctx.getRealPath(appWebInfPath);
        if (realWebInfPath == null || !new File(realWebInfPath, "maelstrom-server-config.wsdd").exists()) {
            String name2 = appWebInfPath + "/" + "maelstrom-server-config.wsdd";
            InputStream is = ctx.getResourceAsStream(name2);
            if (is != null) {
                config = new FileEngineConfigurationProvider(2, is);
            }
            if (config == null) {
                log.error(Messages.getMessage("servletEngineWebInfError01", name2));
            }
        }
        if (config == null && realWebInfPath != null) {
            try {
                config = new FileEngineConfigurationProvider(2, realWebInfPath, "maelstrom-server-config.wsdd");
            }
            catch (ConfigurationException e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.configuration.WebAppWSDDEngineConfigurationFactory.getServerEngineConfig", "203");
                log.error(Messages.getMessage("servletEngineWebInfError00"), e);
            }
        }
        if (config == null) {
            log.warn(Messages.getMessage("servletEngineWebInfWarn00"));
            try {
                InputStream is = ClassUtils.getResourceAsStream(WebAppWSDDEngineConfigurationFactory.class, "maelstrom-server-config.wsdd");
                config = new FileEngineConfigurationProvider(2, is);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.configuration.WebAppWSDDEngineConfigurationFactory.getServerEngineConfig", "217");
                log.error(Messages.getMessage("servletEngineWebInfError02"), e);
            }
        }
        return config;
    }
}

