/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.configurable;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.configurable.Configured;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.LockableHashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class ConfigurableImpl
implements Configurable {
    protected static Log log = LogFactory.getLog(ConfigurableImpl.class.getName());
    protected LockableHashtable options;

    public final void setOptionsDefault(Configured dephault) {
        this.setOptionsDefault(dephault.getOptions());
    }

    public final void setOptionsDefault(Map dephault) {
        if (this.options == null) {
            this.initOptions();
        }
        this.options.setParent(dephault);
    }

    public final void setOption(String name2, Object value2) {
        this.setOption(name2, value2, false);
    }

    public final void setOption(String name2, Object value2, boolean lock) {
        if (this.options == null) {
            this.initOptions();
        }
        if (this.isOptionBoolean(name2)) {
            value2 = this.normalize(value2);
        }
        this.options.put(name2, value2, lock);
    }

    public final void removeOption(String name2) {
        if (this.options != null) {
            this.options.remove(name2);
        }
    }

    public final boolean setOptionDefault(String name2, Object value2) {
        return this.setOptionDefault(name2, value2, false);
    }

    public final boolean setOptionDefault(String name2, Object value2, boolean lock) {
        boolean val;
        boolean bl = val = (this.options == null || this.options.get(name2) == null) && value2 != null;
        if (val) {
            this.setOption(name2, value2, lock);
        }
        return val;
    }

    public final void setOptions(Map opts) {
        if (opts == null) {
            this.options = null;
        } else if (opts != this.options) {
            this.options = new LockableHashtable(opts);
            Set names = this.getOptionsBooleanNames();
            if (names != null) {
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    Object name2 = iter.next();
                    Object value2 = this.options.get(name2);
                    if (value2 == null) {
                        this.options.put(name2, Boolean.TRUE);
                        continue;
                    }
                    if (value2 instanceof Boolean) continue;
                    this.options.put(name2, this.normalize(value2));
                }
            }
        }
    }

    public final Object getOption(String name2) {
        return this.options == null ? null : this.options.get(name2);
    }

    public final Map getOptions() {
        return this.options;
    }

    public Set getOptionsBooleanNames() {
        return null;
    }

    private final boolean isOptionBoolean(String name2) {
        Set options = this.getOptionsBooleanNames();
        return options == null ? false : options.contains(name2);
    }

    protected final void initOptions() {
        this.options = new LockableHashtable();
        Set names = this.getOptionsBooleanNames();
        if (names != null) {
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                this.options.put(iter.next(), Boolean.TRUE);
            }
        }
    }

    private final Boolean normalize(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        return new Boolean(JavaUtils.isTrue(value2));
    }
}

