/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.components.net;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.SecureTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientProperties;
import java.util.Hashtable;

public class TransportClientPropertiesFactory {
    private static final TraceComponent _tc = Tr.register(DefaultHTTPSTransportClientProperties.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static Hashtable factories = new Hashtable();

    public static synchronized TransportClientProperties create(String protocol2) {
        TransportClientProperties theTCP;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "TransportClientPropertiesFactory::create(" + protocol2 + ")");
        }
        if ((theTCP = (TransportClientProperties)factories.get(protocol2)) == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Factory not set yet");
            }
            if (protocol2.equalsIgnoreCase("http")) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Getting TransportClientProperties");
                }
                theTCP = (TransportClientProperties)WebServicesProperties.newInstance(TransportClientProperties.class);
            } else if (protocol2.equalsIgnoreCase("https")) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Getting SecureTransportClientProperties");
                }
                theTCP = (SecureTransportClientProperties)WebServicesProperties.newInstance(SecureTransportClientProperties.class);
            }
            if (theTCP != null) {
                factories.put(protocol2, theTCP);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, ((Object)theTCP).toString());
                }
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Factory already set");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "TransportClientPropertiesFactory::create(" + protocol2 + ")");
        }
        return theTCP;
    }

    public static String print() {
        return factories.toString();
    }

    static {
        WebServicesProperties.setClassOverrideProperty(TransportClientProperties.class, "webservices.transportClientProperties");
        WebServicesProperties.setClassDefault(TransportClientProperties.class, "com.ibm.ws.webservices.engine.components.net.DefaultHTTPTransportClientProperties");
        WebServicesProperties.setClassOverrideProperty(SecureTransportClientProperties.class, "webservices.securetransportClientProperties");
        WebServicesProperties.setClassDefault(SecureTransportClientProperties.class, "com.ibm.ws.webservices.engine.components.net.DefaultHTTPSTransportClientProperties");
        WebServicesProperties.setClassDefault(TransportClientProperties.class, DefaultHTTPTransportClientProperties.class.getName());
        WebServicesProperties.setClassDefault(SecureTransportClientProperties.class, DefaultHTTPSTransportClientProperties.class.getName());
    }
}

