/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.components.image;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.components.image.ImageIO;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedAction;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class MerlinIO
extends Component
implements ImageIO {
    private Exception propagateException = null;
    Exception propagateLoadException = null;

    public void saveImage(final String mimeType, final Image image, final OutputStream os) throws Exception {
        this.propagateException = null;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MerlinIO.this.privilegedSaveImage(mimeType, image, os);
                return null;
            }
        });
        if (this.propagateException != null) {
            throw this.propagateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void privilegedSaveImage(String mimeType, Image image, OutputStream os) {
        try {
            Iterator<ImageWriter> iter = javax.imageio.ImageIO.getImageWritersByMIMEType(mimeType);
            ImageWriter writer = iter.hasNext() ? iter.next() : null;
            boolean originalUseCache = javax.imageio.ImageIO.getUseCache();
            javax.imageio.ImageIO.setUseCache(false);
            try {
                ImageOutputStream ios = javax.imageio.ImageIO.createImageOutputStream(os);
                writer.setOutput(ios);
                BufferedImage rendImage = null;
                if (image instanceof BufferedImage) {
                    rendImage = (BufferedImage)image;
                } else {
                    MediaTracker tracker = new MediaTracker(this);
                    tracker.addImage(image, 0);
                    tracker.waitForAll();
                    rendImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
                    Graphics2D g = rendImage.createGraphics();
                    g.drawImage(image, 0, 0, null);
                }
                writer.write(new IIOImage(rendImage, null, null));
                writer.dispose();
                Object var12_12 = null;
                if (!originalUseCache) return;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (!originalUseCache) throw throwable;
                javax.imageio.ImageIO.setUseCache(true);
                throw throwable;
            }
            javax.imageio.ImageIO.setUseCache(true);
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.components.image.MerlinIO.privilegedSaveImage", "153", this);
            this.propagateException = e;
        }
    }

    public Image loadImage(final InputStream in) throws Exception {
        this.propagateLoadException = null;
        Image image = (Image)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MerlinIO.this.privilegedLoadImage(in);
            }
        });
        if (this.propagateLoadException != null) {
            throw this.propagateLoadException;
        }
        return image;
    }

    private Image privilegedLoadImage(InputStream in) {
        try {
            return javax.imageio.ImageIO.read(in);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.components.image.MerlinIO.privilegedLoadImage", "187", this);
            this.propagateLoadException = e;
            return null;
        }
    }
}

