/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.Namespaces;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.commons.logging.Log;

public class ServiceFactory
extends javax.xml.rpc.ServiceFactory
implements ObjectFactory {
    public static final String SERVICE_CLASSNAME = "service classname";
    public static final String WSDL_LOCATION = "WSDL location";
    public static final String MAINTAIN_SESSION = "maintain session";
    public static final String SERVICE_NAMESPACE = "service namespace";
    public static final String SERVICE_LOCAL_PART = "service local part";
    protected static Log log = LogFactory.getLog(ServiceFactory.class.getName());
    private static final String PACKAGE_SEPERATOR = ".";

    public static Service getService(Map environment) {
        Service service = null;
        InitialContext context = null;
        EngineConfiguration configProvider = (EngineConfiguration)environment.get("engineConfig");
        if (configProvider == null) {
            configProvider = EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig();
        }
        try {
            context = new InitialContext();
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (context != null) {
            String name2 = (String)environment.get("jndiName");
            if (name2 == null) {
                name2 = "webServicesServiceName";
            }
            try {
                service = (Service)context.lookup(name2);
            }
            catch (NamingException e) {
                service = new Service(configProvider);
                try {
                    context.bind(name2, (Object)service);
                }
                catch (NamingException e1) {
                    FFDCFilter.processException(e1, "com.ibm.ws.webservices.engine.client.ServiceFactory.getService", "181");
                }
            }
        } else {
            service = new Service(configProvider);
        }
        return service;
    }

    public Object getObjectInstance(Object refObject, Name name2, Context nameCtx, Hashtable environment) throws Exception {
        Object instance = null;
        if (refObject instanceof Reference) {
            Reference ref = (Reference)refObject;
            RefAddr addr = ref.get(SERVICE_CLASSNAME);
            Object obj = null;
            if (addr != null && (obj = addr.getContent()) instanceof String) {
                instance = ClassUtils.forName((String)obj).newInstance();
            } else {
                addr = ref.get(WSDL_LOCATION);
                if (addr != null && (obj = addr.getContent()) instanceof String) {
                    URL wsdlLocation = new URL((String)obj);
                    addr = ref.get(SERVICE_NAMESPACE);
                    if (addr != null && (obj = addr.getContent()) instanceof String) {
                        String namespace = (String)obj;
                        addr = ref.get(SERVICE_LOCAL_PART);
                        if (addr != null && (obj = addr.getContent()) instanceof String) {
                            String localPart = (String)obj;
                            QName serviceName = QNameTable.createQName(namespace, localPart);
                            Class[] formalArgs = new Class[]{URL.class, QName.class};
                            Object[] actualArgs = new Object[]{wsdlLocation, serviceName};
                            Constructor ctor = Service.class.getDeclaredConstructor(formalArgs);
                            instance = ctor.newInstance(actualArgs);
                        }
                    }
                }
            }
            addr = ref.get(MAINTAIN_SESSION);
            if (addr != null && instance instanceof Service) {
                ((Service)instance).setMaintainSession(true);
            }
        }
        return instance;
    }

    public javax.xml.rpc.Service createService(URL wsdlDocumentLocation, QName serviceName) throws ServiceException {
        return new Service(wsdlDocumentLocation, serviceName);
    }

    public javax.xml.rpc.Service createService(QName serviceName) throws ServiceException {
        return new Service(serviceName);
    }

    public javax.xml.rpc.Service loadService(Class serviceInterface) throws ServiceException {
        return this.findGeneratedServiceLocator(serviceInterface.getName(), serviceInterface);
    }

    public javax.xml.rpc.Service loadService(URL wsdlDocumentLocation, Class serviceInterface, Properties properties) throws ServiceException {
        return this.findGeneratedServiceLocator(serviceInterface.getName(), serviceInterface);
    }

    public javax.xml.rpc.Service loadService(URL wsdlDocumentLocation, QName serviceName, Properties properties) throws ServiceException {
        Namespaces namespaces = this.getNs2PkgMapping(properties);
        String javaPackage = namespaces.getCreate(serviceName.getNamespaceURI());
        String serviceClass = javaPackage + PACKAGE_SEPERATOR + serviceName.getLocalPart();
        return this.findGeneratedServiceLocator(serviceClass, null);
    }

    private Namespaces getNs2PkgMapping(Properties properties) {
        Namespaces namespaces = new Namespaces(null, PACKAGE_SEPERATOR.charAt(0));
        if (properties != null) {
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String namespaceProperty = (String)keys.nextElement();
                String packageProperty = (String)properties.get(namespaceProperty);
                namespaces.put(namespaceProperty, packageProperty);
            }
        }
        return namespaces;
    }

    private Service findGeneratedServiceLocator(String serviceClassFQName, Class serviceInterface) throws ServiceException {
        String translatedMessage;
        String translatedMessage2;
        String generatedServiceLocator = serviceClassFQName + "Locator";
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        Class<?> serviceClass = null;
        Service service = null;
        try {
            serviceClass = classloader.loadClass(generatedServiceLocator);
        }
        catch (ClassNotFoundException ex) {
            translatedMessage2 = Messages.getMessage("noClassForService00", generatedServiceLocator);
            log.error(translatedMessage2, ex);
        }
        if (serviceInterface == null) {
            try {
                serviceInterface = classloader.loadClass(serviceClassFQName);
            }
            catch (ClassNotFoundException ex) {
                translatedMessage2 = Messages.getMessage("noClassForService00", serviceClassFQName);
                log.error(translatedMessage2, ex);
            }
        }
        if (serviceClass != null) {
            if (!javax.xml.rpc.Service.class.isAssignableFrom(serviceInterface)) {
                translatedMessage = Messages.getMessage("mustSubclassService", serviceInterface.getName());
                log.error(translatedMessage);
                throw new ServiceException(translatedMessage);
            }
            if (!serviceInterface.isAssignableFrom(serviceClass)) {
                translatedMessage = Messages.getMessage("mustSubclassServiceInterface", serviceInterface.getName(), serviceClass.getName());
                log.error(translatedMessage);
                throw new ServiceException(translatedMessage);
            }
            try {
                service = (Service)serviceClass.newInstance();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.client.ServiceFactory.findGeneratedServiceLocator", "421", this);
                translatedMessage2 = Messages.getMessage("cantInstantiateClass", serviceClass.getName());
                log.error(translatedMessage2, ex);
                throw new ServiceException(translatedMessage2, ex);
            }
            return service;
        }
        translatedMessage = Messages.getMessage("noClassForService00", generatedServiceLocator);
        log.error(translatedMessage);
        throw new ServiceException(translatedMessage);
    }
}

