/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.PivotHandlerWrapper;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.resources.Messages;
import org.apache.commons.logging.Log;

public class ClientEngine
extends WebServicesEngine {
    protected static Log log = LogFactory.getLog(ClientEngine.class.getName());

    public ClientEngine() {
        super(EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig());
    }

    public ClientEngine(EngineConfiguration config) {
        super(config == null ? EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig() : config);
    }

    public WebServicesEngine getClientEngine() {
        return this;
    }

    protected Handler createMessageFlow(MessageContext msgContext) throws WebServicesFault, ConfigurationException {
        Handler target;
        String transportName = msgContext.getTransportName();
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("transport01", "ServerEngine.invoke", transportName));
        }
        if ((target = this.getTransport(transportName)) == null) {
            throw new WebServicesFault(Messages.getMessage("noTransport00", transportName));
        }
        target = PivotHandlerWrapper.factory(this.getGlobalHandler(), target);
        return PivotHandlerWrapper.factory(msgContext.getPort(), target);
    }

    public boolean isServer() {
        return false;
    }
}

