/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.dispatchers.ejb;

import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.EJSLocalWrapper;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.util.DeploymentUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EnterpriseBean;

public class WSEJBWrapper
extends EJSLocalWrapper {
    private static final TraceComponent _tc = Tr.register(WSEJBWrapper.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final String D_OPERATION_OPTION_EJB_METHODIDX = "operation.ejbMethodIdx";
    public static final String D_MSGCONTEXT_OPTION_EJS = "context.ejs";
    private static final String noTtoWebServicesFault00 = "Mapping Exception to WebServicesFault: ";
    private static final String WSEJBWRAPPER_MESSAGEINDEX = "wsejbwrapper.messageIndex";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseBean preInvoke(MessageContext msgContext) throws Throwable {
        OperationDesc operation = msgContext.getOperation();
        if (operation == null) {
            Tr.error(_tc, "WSEJBWrapper::preInvoke did not find an OperationDesc!");
            throw WebServicesFault.makeFault(new Throwable("An OperationDesc was not found"));
        }
        int methodIdx = this.getMethodIdx(operation);
        msgContext.setProperty(WSEJBWRAPPER_MESSAGEINDEX, new Integer(methodIdx));
        EnterpriseBean beanRef = null;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "WSEJBWrapper::invoke : methodIdx for method " + operation.getName() + " == " + methodIdx + ".");
        }
        EJSDeployedSupport ejs = this.container.getEJSDeployedSupport((EJSWrapperBase)this);
        try {
            beanRef = this.container.preInvoke((EJSWrapperBase)this, methodIdx, ejs);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "WSEJBWrapper::setupEnvironment beanRef (" + beanRef.toString() + ")");
            }
            msgContext.setProperty(D_MSGCONTEXT_OPTION_EJS, ejs);
        }
        catch (Throwable e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.dispatchers.ejb.WSEJBWrapper.preInvoke", "105", (Object)this);
            ejs.setUncheckedException(e);
            try {
                this.container.postInvoke((EJSWrapperBase)this, methodIdx, ejs);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.container.putEJSDeployedSupport(ejs);
                throw throwable;
            }
            this.container.putEJSDeployedSupport(ejs);
            throw e;
        }
        return beanRef;
    }

    public void postInvoke(MessageContext msgContext) throws Throwable {
        OperationDesc operation = msgContext.getOperation();
        EJSDeployedSupport ejs = (EJSDeployedSupport)msgContext.getProperty(D_MSGCONTEXT_OPTION_EJS);
        if (ejs == null) {
            throw new WebServicesFault(nls.getFormattedMessage("ejbdispatcher.expected.ejs", null, null));
        }
        Integer value2 = (Integer)msgContext.getProperty(WSEJBWRAPPER_MESSAGEINDEX);
        if (value2 == null) {
            throw WebServicesFault.makeFault(new Throwable("methodIdx of OperationDesc not found"));
        }
        int methodIdx = value2;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Found methodIdx " + methodIdx);
        }
        try {
            try {
                this.container.postInvoke((EJSWrapperBase)this, methodIdx, ejs);
            }
            catch (Throwable exp) {
                FFDCFilter.processException(exp, "com.ibm.ws.webservices.dispatchers.ejb.WSEJBWrapper.postInvoke", "132", (Object)this);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, noTtoWebServicesFault00 + exp);
                }
                throw WebServicesFault.makeFault(exp);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.container.putEJSDeployedSupport(ejs);
            throw throwable;
        }
        this.container.putEJSDeployedSupport(ejs);
    }

    public void setEJSException(MessageContext msgContext, Throwable ex, boolean checked) {
        block5: {
            EJSDeployedSupport ejs = (EJSDeployedSupport)msgContext.getProperty(D_MSGCONTEXT_OPTION_EJS);
            if (ejs != null) {
                try {
                    if (checked) {
                        ejs.setCheckedException((Exception)ex);
                    } else {
                        ejs.setUncheckedException(ex);
                    }
                }
                catch (RemoteException rex) {
                    if (!_tc.isDebugEnabled()) break block5;
                    Tr.debug(_tc, "WSEJBWrapper::setUncheckedException received RemoteException " + rex.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMethodIdx(OperationDesc operation) throws RuntimeError {
        Integer methodIdx;
        OperationDesc operationDesc = operation;
        synchronized (operationDesc) {
            methodIdx = (Integer)operation.getOption(D_OPERATION_OPTION_EJB_METHODIDX);
            if (methodIdx == null) {
                methodIdx = new Integer(this.getMethodIdx(operation.getMethod()));
                operation.setOption(D_OPERATION_OPTION_EJB_METHODIDX, methodIdx);
            }
        }
        return methodIdx;
    }

    private int getMethodIdx(Method method) throws RuntimeError {
        Class wsSEIClass = this.bmd.webserviceEndpointInterfaceClass;
        Method[] allMethods = DeploymentUtil.getMethods(wsSEIClass);
        for (int i = 0; i < allMethods.length; ++i) {
            if (!this.isEquivalentMethod(allMethods[i], method)) continue;
            return i;
        }
        String msgKey = "wsejbwrapper.expected.method";
        Object[] params = new String[]{method.toString(), wsSEIClass.getName()};
        String message = nls.getFormattedMessage(msgKey, params, null);
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, message);
        }
        throw new RuntimeError(message);
    }

    private boolean isEquivalentMethod(Method a, Method b) {
        if (a != null && b != null && a.getName().equals(b.getName()) && a.getReturnType() != null && b.getReturnType() != null && a.getReturnType().equals(b.getReturnType())) {
            Class<?>[] paramsB;
            Class<?>[] paramsA = a.getParameterTypes();
            if (paramsA.length != (paramsB = b.getParameterTypes()).length) {
                return false;
            }
            for (int i = 0; i < paramsA.length; ++i) {
                if (paramsA[i].equals(paramsB[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

