/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.exception.WSDLPostProcessingException;
import com.ibm.ws.webservices.utils.PluginUtils;
import com.ibm.wsspi.webservices.WSDLPostProcessorPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensionRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLPostProcessorPluginMgr {
    private static final TraceComponent _tc = Tr.register(WSDLPostProcessorPluginMgr.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");
    private List<WSDLPostProcessorPlugin> implementationList = new ArrayList<WSDLPostProcessorPlugin>();
    private static WSDLPostProcessorPluginMgr instance = null;

    private WSDLPostProcessorPluginMgr() {
    }

    public static synchronized WSDLPostProcessorPluginMgr getInstance() {
        if (instance == null) {
            instance = new WSDLPostProcessorPluginMgr();
            instance.discoverWSDLPostProcessorPlugins();
        }
        return instance;
    }

    public void discoverWSDLPostProcessorPlugins() {
        PluginUtils.discoverExtensions(WSDLPostProcessorPlugin.class.getName(), "com.ibm.wsfp.main.ibmaxis2-wsdl-post-processor-plugin", this.implementationList);
        this.sortByWeight(this.implementationList);
    }

    public void runPostProcessWSDL(Definition definition, Map parameters) throws WSDLPostProcessingException {
        for (WSDLPostProcessorPlugin proc : this.implementationList) {
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Running WSDL post processor plugin: " + proc);
                }
                proc.postProcessWSDL(definition, parameters);
            }
            catch (WSDLPostProcessingException wppe) {
                FFDCFilter.processException((Throwable)wppe, "com.ibm.ws.webservices.deployment.WSDLPostProcessorPluginMgr.runPostProcessWSDL", "98", this);
                Object[] inserts = new Object[]{proc.getClass().getName(), wppe};
                Tr.error(_tc, "runWsdlPostProcPluginFail00", inserts);
                throw wppe;
            }
        }
    }

    public void runRegisterExtensions(ExtensionRegistry er) throws WSDLPostProcessingException {
        for (WSDLPostProcessorPlugin proc : this.implementationList) {
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Running WSDL post processor plugin: " + proc);
                }
                proc.registerExtensions(er);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.deployment.WSDLPostProcessorPluginMgr.runRegisterExtensions", "124", this);
                Object[] inserts = new Object[]{proc.getClass().getName(), e};
                Tr.error(_tc, "runWsdlPostProcPluginFail00", inserts);
                throw new WSDLPostProcessingException(e);
            }
        }
    }

    private void sortByWeight(List<WSDLPostProcessorPlugin> list) {
        if (list == null) {
            return;
        }
        WPPComparator comparator = new WPPComparator();
        Collections.sort(list, comparator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WPPComparator
    implements Comparator<WSDLPostProcessorPlugin> {
        WPPComparator() {
        }

        @Override
        public int compare(WSDLPostProcessorPlugin plugin1, WSDLPostProcessorPlugin plugin2) {
            if (plugin1.getWeight() < plugin2.getWeight()) {
                return -1;
            }
            if (plugin1.getWeight() > plugin2.getWeight()) {
                return 1;
            }
            return 0;
        }
    }
}

