/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.BindingChoices;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Vector;

public class ClientBindPortInfo
extends AppDeploymentTask {
    private static TraceComponent tc = Tr.register(BindingChoices.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    public static final String TaskName = "WebServicesClientBindPortInfo";
    static final long serialVersionUID = -5271271636065813895L;
    private static final int TOTAL_COLUMNS = 10;
    public static final int MODULE_COLUMN = 0;
    public static final int EJB_COLUMN = 1;
    public static final int SERVICE_COLUMN = 2;
    public static final int PORT_COLUMN = 3;
    public static final int TIMEOUT_COLUMN = 4;
    public static final int BASICAUTHID_COLUMN = 5;
    public static final int BASICAUTHPWD_COLUMN = 6;
    public static final int SSLCFG_COLUMN = 7;
    public static final int OVERRIDDENENDPOINT_COLUMN = 8;
    public static final int OVERRIDDBINDINGNAMESPACE_COLUMN = 9;

    public ClientBindPortInfo(AppDeploymentController flowController) {
        super(flowController);
        this.name = TaskName;
        this.colNames = new String[10];
        this.colNames[0] = "webservices.cfgbnd_Module_Name";
        this.colNames[1] = "webservices.cfgbnd_EJB";
        this.colNames[2] = "webservices.cfgbnd_Web_Service";
        this.colNames[3] = "webservices.cfgbnd_Port";
        this.colNames[4] = "webservices.cfgbnd_Timeout";
        this.colNames[5] = "webservices.cfgbnd_BasicAuth_ID";
        this.colNames[6] = "webservices.cfgbnd_BasicAuth_Password";
        this.colNames[7] = "webservices.cfgbnd_SSL_Config";
        this.colNames[8] = "webservices.cfgbnd_Overridden_Endpoint";
        this.colNames[9] = "webservices.cfgbnd_Overridden_BindingNamespace";
        this.mutables = new boolean[10];
        this.mutables[0] = false;
        this.mutables[1] = false;
        this.mutables[2] = false;
        this.mutables[3] = false;
        this.mutables[4] = true;
        this.mutables[5] = true;
        this.mutables[6] = true;
        this.mutables[7] = true;
        this.mutables[8] = true;
        this.mutables[9] = true;
        this.requiredColumns = new boolean[10];
        this.requiredColumns[0] = true;
        this.requiredColumns[1] = true;
        this.requiredColumns[2] = true;
        this.requiredColumns[3] = true;
        this.requiredColumns[4] = false;
        this.requiredColumns[5] = false;
        this.requiredColumns[6] = false;
        this.requiredColumns[7] = false;
        this.requiredColumns[8] = false;
        this.requiredColumns[9] = false;
    }

    public String[] validate() {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        Vector<String> errorMessages = new Vector<String>();
        this.taskValidateErrorMessages = null;
        for (i = 1; this.taskData != null && i < this.taskData.length; ++i) {
            String overridden_endpoint;
            String timeout = this.taskData[i][4];
            if (timeout != null && !timeout.equals("") && !ClientBindPortInfo.isGoodTimeout(timeout)) {
                Object[] fillins = new Object[]{timeout, this.taskData[i][0]};
                String error = MessageFormat.format(util.getMessage((AppDeploymentTask)this, (String)"WSWS0056E"), fillins);
                errorMessages.addElement(error);
            }
            if ((overridden_endpoint = this.taskData[i][8]) != null && !overridden_endpoint.equals("") && !overridden_endpoint.equals(" ")) {
                if (ClientBindPortInfo.isGoodEndpoint(overridden_endpoint)) continue;
                Object[] fillins = new Object[]{overridden_endpoint, this.taskData[i][0]};
                String error = MessageFormat.format(util.getMessage((AppDeploymentTask)this, (String)"WSWS0057E"), fillins);
                errorMessages.addElement(error);
                continue;
            }
            String overridden_bindingNamespace = this.taskData[i][9];
            if (overridden_bindingNamespace == null || overridden_bindingNamespace.equals("") || overridden_bindingNamespace.equals(" ")) continue;
            Object[] fillins = new Object[]{overridden_bindingNamespace, this.taskData[i][0]};
            String error = MessageFormat.format(util.getMessage((AppDeploymentTask)this, (String)"WSWS0059E"), fillins);
            errorMessages.addElement(error);
        }
        this.buildErrorMessages(errorMessages);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WebServicesClientBindPortInfo validate taskValidateErrorMessages");
            if (this.taskValidateErrorMessages != null && this.taskValidateErrorMessages.length > 0) {
                for (i = 0; i < this.taskValidateErrorMessages.length; ++i) {
                    Tr.exit(tc, "errors[" + i + "]=" + this.taskValidateErrorMessages[i]);
                }
            }
        }
        return this.taskValidateErrorMessages;
    }

    public static boolean isGoodTimeout(String timeout) {
        boolean return_value = true;
        try {
            int intTimeout = Integer.parseInt(timeout, 10);
            if (intTimeout < 0) {
                return_value = false;
            }
        }
        catch (NumberFormatException numEx) {
            return_value = false;
        }
        return return_value;
    }

    public static boolean isGoodEndpoint(String endpoint) {
        boolean return_value = true;
        try {
            URL url = new URL(endpoint);
        }
        catch (MalformedURLException malformedEx) {
            return_value = false;
        }
        return return_value;
    }
}

