/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.metadata.ServerPortMetaData;
import com.ibm.ws.webservices.utils.ServiceRefPartialInfo;
import com.ibm.ws.webservices.utils.ServiceRefPartialInfoBuilder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JAXRPCServiceRefInfoBuilder
implements ServiceRefPartialInfoBuilder {
    private static final TraceComponent tc = Tr.register(JAXRPCServiceRefInfoBuilder.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static final boolean entryEnabled = tc.isEntryEnabled();
    private static final boolean debugEnabled = tc.isDebugEnabled();
    private Map portMap;

    JAXRPCServiceRefInfoBuilder(Map portMap) {
        this.portMap = portMap;
    }

    public Map buildInfo() throws Exception {
        if (entryEnabled) {
            Tr.entry(tc, "buildInfo");
        }
        HashMap<String, ServiceRefPartialInfo> partialInfoMap = new HashMap<String, ServiceRefPartialInfo>();
        if (this.portMap != null && !this.portMap.isEmpty()) {
            if (debugEnabled) {
                Tr.debug(tc, "Building ServiceRefPartialInfo from JAX-RPC ports");
            }
            Iterator keySetIter = this.portMap.keySet().iterator();
            while (keySetIter.hasNext()) {
                String key = (String)keySetIter.next();
                ServerPortMetaData spmd = (ServerPortMetaData)this.portMap.get(key);
                ServiceRefPartialInfo info = new ServiceRefPartialInfo();
                info.setKey(key);
                info.setWsdlLocation(spmd.getWsddPort().getWSDLFile());
                info.setPortQName(spmd.getWsddPort().getWSDLPort());
                if (debugEnabled) {
                    Tr.debug(tc, "Built ServiceRefPartialInfo from JAX-RPC port component: " + info.toString());
                }
                partialInfoMap.put(info.getKey(), info);
            }
        } else if (debugEnabled) {
            Tr.debug(tc, "No deployed ports found to build ServiceRefPartialInfo");
        }
        if (entryEnabled) {
            Tr.exit(tc, "buildInfo");
        }
        return partialInfoMap;
    }
}

