/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.collaborators;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaData;
import com.ibm.ws.webcontainer.webapp.WebAppImpl;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppCollaboratorConfig;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppInitializationCollaborator;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.management.EndpointManagerMBeanImpl;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ClientServiceMetaData;
import com.ibm.ws.webservices.metadata.ServerModuleMetaData;
import com.ibm.ws.webservices.metadata.ServerPortMetaData;
import com.ibm.ws.webservices.metadata.WASWebServicesServerMetaDataImpl;
import com.ibm.ws.wsaddressing.urimap.PortURIManager;
import com.ibm.ws.wsaddressing.urimap.WSADeployUtils;
import java.util.Iterator;
import java.util.Map;

public class WebCollaborator
implements WebAppInitializationCollaborator {
    private static String WS_SERVLET_CLASS = "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet";
    private static TraceComponent _tc = Tr.register(WebCollaborator.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    WASWebServicesServerMetaDataImpl metaData;

    public WebCollaborator(WASWebServicesServerMetaDataImpl md) {
        this.metaData = md;
    }

    public void starting(WebAppCollaboratorConfig collabData) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "starting");
        }
        WebAppImpl webApp = (WebAppImpl)collabData.getWebApp();
        WebModuleMetaData webModuleMetaData = collabData.getWebModuleMetaData();
        ClientEntityMetaData cemd = this.metaData.getModuleClientEntityMetaData((ModuleMetaData)webModuleMetaData);
        if (cemd != null) {
            try {
                cemd.bindServiceRefs(ClientServiceMetaData.getJavaColonCompEnvContext(webApp.getJavaColonContext()));
            }
            catch (Exception ne) {
                FFDCFilter.processException((Throwable)ne, "com.ibm.ws.webservices.collaborators.WebCollaborator.starting", "83", this);
                Tr.error(_tc, "internal.error", ne);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "starting");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started(WebAppCollaboratorConfig collabData) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "started");
        }
        try {
            WebModuleMetaData webModuleMetaData = collabData.getWebModuleMetaData();
            ServerModuleMetaData moduleSemd = this.metaData.getServerModuleMetaData((ModuleMetaData)webModuleMetaData);
            if (moduleSemd != null) {
                EndpointManagerMBeanImpl mbean;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "adding Servlet entry for WebApp " + webModuleMetaData.getName());
                }
                WebAppImpl webApp = (WebAppImpl)collabData.getWebApp();
                if (moduleSemd.getRouterModuleName() != null) {
                    moduleSemd.bindRouterURLPatterns(webApp.getConfiguration());
                }
                if ((mbean = (EndpointManagerMBeanImpl)moduleSemd.getEndpointManagerMbean()) != null) {
                    mbean.startAll();
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Endpoint Manager MBean not set on module metadata.");
                }
                Map portComponents = moduleSemd.getPorts();
                Iterator i = portComponents.values().iterator();
                while (i.hasNext()) {
                    ServerPortMetaData portComponent = (ServerPortMetaData)i.next();
                    String originalUrl = portComponent.getURLPattern();
                    if (originalUrl == null) continue;
                    if (portComponent.isURLGenerated()) {
                        webApp.addDynamicServlet(portComponent.getServletName(), WS_SERVLET_CLASS, originalUrl, null);
                    }
                    String urlForExtWSDL = "";
                    String urlForWSDL = "";
                    if (originalUrl.startsWith("/")) {
                        urlForWSDL = originalUrl + "/wsdl/*";
                        urlForExtWSDL = originalUrl + "/extwsdl/*";
                    } else {
                        urlForWSDL = "/" + originalUrl + "/wsdl/*";
                        urlForExtWSDL = "/" + originalUrl + "/extwsdl/*";
                    }
                    webApp.addDynamicServlet(portComponent.getServletName(), WS_SERVLET_CLASS, urlForWSDL, null);
                    webApp.addDynamicServlet(portComponent.getServletName(), WS_SERVLET_CLASS, urlForExtWSDL, null);
                }
                if (this.metaData.getWSDLModuleData((ModuleMetaData)webModuleMetaData) == null) {
                    Map moduleDataMap = DeployUtils.loadModuleData(moduleSemd.getApplicationName(), moduleSemd.getBinaryURL());
                    this.metaData.setWSDLModuleData((ModuleMetaData)webModuleMetaData, moduleDataMap);
                    Map wsamoduleDataMap = WSADeployUtils.loadModuleData(moduleSemd.getApplicationName(), moduleSemd.getBinaryURL());
                    PortURIManager.addApplicationPortMappings(webApp, wsamoduleDataMap);
                }
                moduleSemd.collaboratorStarted();
            }
        }
        catch (Exception se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.collaborators.WebCollaborator.started", "180", this);
            Tr.error(_tc, "internal.error", se);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "started");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopping(WebAppCollaboratorConfig collabData) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stopping");
        }
        try {
            WebModuleMetaData webModuleMetaData = collabData.getWebModuleMetaData();
            ServerModuleMetaData moduleSemd = this.metaData.getServerModuleMetaData((ModuleMetaData)webModuleMetaData);
            if (moduleSemd != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "removing Servlet entry for WebApp " + webModuleMetaData.getName());
                }
                WebAppImpl webApp = (WebAppImpl)collabData.getWebApp();
                Map portComponents = moduleSemd.getPorts();
                Iterator i = portComponents.values().iterator();
                while (i.hasNext()) {
                    ServerPortMetaData portComponent = (ServerPortMetaData)i.next();
                    String originalUrl = portComponent.getURLPattern();
                    if (!portComponent.isURLGenerated()) continue;
                    webApp.removeDynamicServlet(portComponent.getServletName());
                }
            }
        }
        catch (Exception se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.collaborators.WebCollaborator.stopping", "180", this);
            Tr.error(_tc, "internal.error", se);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "stopping");
            }
        }
    }

    public void stopped(WebAppCollaboratorConfig collabData) {
        WebModuleMetaData webModuleMetaData = collabData.getWebModuleMetaData();
        ServerModuleMetaData moduleSemd = this.metaData.getServerModuleMetaData((ModuleMetaData)webModuleMetaData);
        if (moduleSemd != null) {
            EndpointManagerMBeanImpl mbean = (EndpointManagerMBeanImpl)moduleSemd.getEndpointManagerMbean();
            if (mbean != null) {
                mbean.stopAll();
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Endpoint Manager MBean not set on module metadata.");
            }
            moduleSemd.collaboratorStopped();
        }
    }
}

