/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.WebServicesException;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ClientModuleMetaData;
import com.ibm.ws.webservices.metadata.ClientServiceMetaData;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.wsdl.Definition;

public class ServiceRefClientFactory
implements ObjectFactory {
    private static TraceComponent _tc = Tr.register(ServiceRefClientFactory.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static String SET_WSDDPORT_METHOD_PREFIX = "set";
    private static String SET_WSDDPORT_METHOD_SUFFIX = "WSDDPortName";
    private static String UNSPECIFIED_PORT_NAME = null;

    private static String getClassLocator(String className) {
        return className + "Locator";
    }

    public Object getObjectInstance(Object refObj, Name name2, Context nameCtx, Hashtable env) throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Enter getObjectInstance(refObj=" + JavaUtils.getObjectIdentity(refObj) + ", Name=" + name2 + ", Context=" + nameCtx + ", env);");
        }
        javax.xml.rpc.Service srv = null;
        if (refObj instanceof Reference) {
            Reference ref = (Reference)refObj;
            String cr = ref.getClassName();
            if (cr.equals(ClientServiceMetaData.class.getName())) {
                ClientEntityMetaData clientEntityMetaData = WebServicesServiceHome.getWebServicesService().getClientEntityMetaData();
                if (clientEntityMetaData == null) {
                    String msg = "ClientEntityMetaData is not available";
                    Tr.error(_tc, "internal.error", msg);
                    throw new WebServicesException(msg);
                }
                ClientServiceMetaData clientServiceMetaData = clientEntityMetaData.getClientServiceMetaData(ref);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "clientEntityMetaData.getClientServiceMetaData(ref) == " + clientServiceMetaData);
                }
                if (clientServiceMetaData.getServiceInterface().equals(javax.xml.rpc.Service.class.getName())) {
                    Definition doc = clientServiceMetaData.getWsdlDoc();
                    if (doc == null) {
                        srv = new Service();
                        ((Service)srv).setEngine(clientEntityMetaData.getEngine());
                    } else {
                        Map namespace2PackageMapping = clientServiceMetaData.getNamespaceToPackageMapping();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Service QName on java:comp lookup is " + clientServiceMetaData.getQName());
                            Tr.debug(_tc, "Service WsdlDoc is " + doc);
                            Tr.debug(_tc, "refNamespace2PackageMapping is " + namespace2PackageMapping);
                        }
                        srv = new Service(clientEntityMetaData.getEngine(), doc, clientServiceMetaData.getQName(), namespace2PackageMapping);
                    }
                } else {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> srvcl = null;
                    try {
                        srvcl = cl.loadClass(ServiceRefClientFactory.getClassLocator(clientServiceMetaData.getServiceInterface()));
                    }
                    catch (ClassNotFoundException ex) {
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.client.ServiceRefClientFactory.getObjectInstance", "132", this);
                        Tr.error(_tc, "internal.error", ex);
                        throw ex;
                    }
                    if (!javax.xml.rpc.Service.class.isAssignableFrom(srvcl)) {
                        Tr.error(_tc, "internal.error", "Specified service " + srvcl + " is not assignable from javax.xml.rpc.Service");
                        throw new Exception("Specified service does not inherit from javax.xml.rpc.Service");
                    }
                    srv = (javax.xml.rpc.Service)srvcl.newInstance();
                    if (srv instanceof Service) {
                        ((Service)srv).setEngine(clientEntityMetaData.getEngine());
                    }
                    Method[] locatorMethods = srvcl.getMethods();
                    String[] wsdlPorts = this.getWsdlPortsFromReferencable(clientServiceMetaData);
                    for (int wsdlPortIndex = 0; wsdlPortIndex < wsdlPorts.length; ++wsdlPortIndex) {
                        Object[] params;
                        String methodName;
                        int i;
                        Method setWSDDPortNameMethod = null;
                        String expectedMethodName = null;
                        if (wsdlPorts[wsdlPortIndex] == UNSPECIFIED_PORT_NAME) {
                            expectedMethodName = SET_WSDDPORT_METHOD_PREFIX + "<PortName>" + SET_WSDDPORT_METHOD_SUFFIX;
                            if (wsdlPortIndex != 0) {
                                Tr.error(_tc, "internal.error", "ServiceRefClientFactory: Empty PortName in WSDL Port Names Array");
                            }
                            for (i = 0; i < locatorMethods.length; ++i) {
                                methodName = locatorMethods[i].getName();
                                if (!methodName.startsWith(SET_WSDDPORT_METHOD_PREFIX) || !methodName.endsWith(SET_WSDDPORT_METHOD_SUFFIX)) continue;
                                setWSDDPortNameMethod = locatorMethods[i];
                                break;
                            }
                        } else {
                            expectedMethodName = SET_WSDDPORT_METHOD_PREFIX + wsdlPorts[wsdlPortIndex] + SET_WSDDPORT_METHOD_SUFFIX;
                            for (i = 0; i < locatorMethods.length; ++i) {
                                methodName = locatorMethods[i].getName();
                                if (!methodName.equals(expectedMethodName)) continue;
                                setWSDDPortNameMethod = locatorMethods[i];
                                break;
                            }
                        }
                        String portName = ClientModuleMetaData.clientConfigurationPortName(clientServiceMetaData.getName(), wsdlPorts[wsdlPortIndex]);
                        if (setWSDDPortNameMethod != null) {
                            params = new Object[]{portName};
                            setWSDDPortNameMethod.invoke((Object)srv, params);
                            if (!_tc.isDebugEnabled()) continue;
                            Tr.debug(_tc, "ServiceLocator " + srvcl + " WSDDPort name set to " + portName);
                            continue;
                        }
                        params = new Object[]{srvcl, expectedMethodName, clientServiceMetaData.getName(), portName};
                        Tr.warning(_tc, "warning.ServiceNameSetter.notfound", params);
                    }
                }
                ((Service)srv).setServiceRefName(clientServiceMetaData.getName());
                ((Service)srv).setWSDLFileName(clientServiceMetaData.getWsdlFileName());
                ((Service)srv).setPortTypeToPortMapping(clientServiceMetaData.getDefaultPortMapping());
                ((Service)srv).setSEIToPortTypeMapping(clientServiceMetaData.getSeiToPortTypeMapping());
                ((Service)srv).setOverriddingEndpointURIs(clientServiceMetaData.getOverriddingEndpointURIs());
            } else {
                Object[] params = new Object[]{cr, ClientServiceMetaData.class.getName()};
                Tr.warning(_tc, "warning.client.reference.wrong.type", params);
            }
        } else {
            Tr.warning(_tc, "warning.client.reference.not.found");
        }
        return srv;
    }

    private String[] getWsdlPortsFromReferencable(ClientServiceMetaData serviceMetaData) {
        String[] refWsdlPorts = serviceMetaData.getWsdlPortNames();
        if (refWsdlPorts == null) {
            refWsdlPorts = new String[]{UNSPECIFIED_PORT_NAME};
        }
        return refWsdlPorts;
    }
}

