/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.util.ObjectPool;

public class Buffer {
    private static ObjectPool pool = new ObjectPool(Buffer.class.getName(), 256){

        protected Object createObject() {
            return new Buffer();
        }
    };
    public static int SIZE = 8192;
    protected Buffer next;
    protected byte[] buf = new byte[SIZE];
    protected int offset;
    protected int length;

    private Buffer() {
    }

    public static Buffer allocate() {
        Buffer next = (Buffer)pool.remove();
        next.clear();
        return next;
    }

    public void clear() {
        this.next = null;
        this.offset = 0;
        this.length = 0;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int write(byte[] buf, int offset, int length) {
        if (SIZE - this.length < length) {
            length = SIZE - this.length;
        }
        System.arraycopy(buf, offset, this.buf, this.length, length);
        this.length += length;
        return length;
    }

    public int getAvailable() {
        return this.buf.length - this.length;
    }

    public Buffer getNext() {
        return this.next;
    }

    public void setNext(Buffer next) {
        this.next = next;
    }

    public static void free(Buffer buf) {
        buf.next = null;
        pool.add(buf);
    }

    public static void freeAll(Buffer buf) {
        while (buf != null) {
            Buffer next = buf.next;
            Buffer.free(buf);
            buf = next;
        }
    }
}

