/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.ssl.JSSEProviderFactory;
import java.util.List;
import java.util.Properties;

public class TrustManagerData {
    private static final TraceComponent tc = Tr.register(TrustManagerData.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    String tmName;
    String tmProvider;
    String tmAlgorithm;
    String tmCustomClass;
    Properties tmCustomProps;
    String tmScope;

    public TrustManagerData(String name2, String provider, String algorithm, String customClass, Properties customAttributes, String scope) {
        this.tmName = name2;
        this.tmProvider = provider;
        this.tmAlgorithm = algorithm;
        this.tmCustomClass = customClass;
        this.tmCustomProps = customAttributes;
        this.tmScope = scope;
    }

    public Properties convertListToProperties(List customAttributes) {
        if (customAttributes != null) {
            Properties props = new Properties();
            for (Property prop : customAttributes) {
                if (prop == null) continue;
                props.setProperty(prop.getName(), prop.getValue());
            }
            return props;
        }
        return null;
    }

    public String getName() {
        return this.tmName;
    }

    public void setName(String s) {
        this.tmName = s;
    }

    public String getProvider() {
        return this.tmProvider;
    }

    public void setProvider(String s) {
        this.tmProvider = s;
    }

    public String getAlgorithm() {
        return this.tmAlgorithm;
    }

    public void setAlgorithm(String s) {
        this.tmAlgorithm = s;
    }

    public String getTrustManagerClass() {
        return this.tmCustomClass;
    }

    public void setTrustManagerClass(String s) {
        this.tmCustomClass = s;
    }

    public Properties getAdditionalTrustManagerAttrs() {
        return this.tmCustomProps;
    }

    public void setAdditionalTrustManagerAttrs(List attributes) {
        this.tmCustomProps = this.convertListToProperties(attributes);
    }

    public String getManagementScope() {
        return this.tmScope;
    }

    public void setManagementScope(String scope) {
        this.tmScope = scope;
    }

    public String getTrustManagerString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustManagerString");
        }
        if (this.tmCustomClass != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTrustManagerString -> " + this.tmCustomClass);
            }
            return this.tmCustomClass;
        }
        if (this.tmAlgorithm != null && this.tmProvider != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTrustManagerString -> " + this.tmAlgorithm + "|" + this.tmProvider);
            }
            return this.tmAlgorithm + "|" + this.tmProvider;
        }
        if (this.tmAlgorithm != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTrustManagerString -> " + this.tmAlgorithm);
            }
            return this.tmAlgorithm;
        }
        String trustManager = JSSEProviderFactory.getTrustManagerFactoryAlgorithm();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustManagerString (default) -> " + trustManager);
        }
        return trustManager;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TrustManagerData: name=");
        sb.append(this.tmName);
        sb.append(", algorithm=");
        sb.append(this.tmAlgorithm);
        sb.append(", provider=");
        sb.append(this.tmProvider);
        sb.append(", customClass=");
        sb.append(this.tmCustomClass);
        sb.append(", scope=");
        sb.append(this.tmScope);
        return sb.toString();
    }
}

