/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.KeyFileFormatKind;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.config.CertificateManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.core.WSPKCSInKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStoreList;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class KeyStoreManager {
    private static final TraceComponent tc = Tr.register(KeyStoreManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static KeyStoreManager thisClass = null;
    private HashMap keyStoreMap = new HashMap();
    private HashMap acceleratorMap = new HashMap();
    private static HashMap expandMap = new HashMap();
    private static String host;
    private static WSPKCSInKeyStoreList pkcsStoreList;

    private KeyStoreManager() {
    }

    public static KeyStoreManager getInstance() {
        if (thisClass == null) {
            KeyStoreManager.getHostName();
            thisClass = new KeyStoreManager();
        }
        return thisClass;
    }

    public void loadKeyStores(com.ibm.websphere.models.config.security.Security security2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadKeyStores");
        }
        this.clearKeyStoreMap();
        EList keyStoreList = security2.getKeyStores();
        for (int i = 0; i < keyStoreList.size(); ++i) {
            com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)keyStoreList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading KeyStore name " + keyStore.getName() + ".");
            }
            this.loadWCCMKeyStore(keyStore);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadKeyStores");
        }
    }

    public void loadWCCMKeyStore(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadWCCMKeyStore");
        }
        String scopeString = null;
        if (keyStore.getManagementScope() != null) {
            scopeString = keyStore.getManagementScope().getScopeName();
        }
        if (scopeString != null && !ManagementScopeManager.getInstance().currentScopeContained(scopeString)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyStore is not in the current scope.");
            }
            return;
        }
        String alias = keyStore.getName();
        WSKeyStore wsks_key = new WSKeyStore(keyStore);
        if (alias != null && wsks_key != null) {
            this.addKeyStoreIfNotDuplicate(alias, wsks_key);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadWCCMKeyStore (keystore)");
        }
    }

    public WSKeyStore[] loadOldWCCMKeyStores(String alias, String sslType, SecureSocketLayer ssl2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadOldWCCMKeyStore");
        }
        String keyStoreClientAlias = null;
        String keyStoreServerAlias = null;
        String keyStoreName = null;
        String keyStorePassword = null;
        String keyStoreFormat = null;
        String keyStoreProvider = null;
        String trustStoreName = null;
        String trustStorePassword = null;
        String trustStoreFormat = null;
        String trustStoreProvider = null;
        String tokenEnabled = null;
        String tokenLibrary = null;
        String tokenPassword = null;
        String tokenSlot = null;
        String tokenType = null;
        if (ssl2 != null && sslType != null && sslType.equals("SSSL")) {
            if (ssl2 != null && ssl2.isSetEnableCryptoHardwareSupport() && ssl2.isEnableCryptoHardwareSupport()) {
                keyStoreFormat = "JCE4758KS";
                keyStoreName = ssl2.getKeyFileName();
                if (keyStoreName != null) {
                    keyStoreName = "safkeyringhw:///" + keyStoreName;
                }
                if ((keyStorePassword = ssl2.getKeyFilePassword()) == null) {
                    keyStorePassword = "password";
                }
                tokenEnabled = "true";
            } else {
                keyStoreFormat = "JCERACFKS";
                keyStoreName = ssl2.getKeyFileName();
                if (keyStoreName != null) {
                    keyStoreName = "safkeyring:///" + keyStoreName;
                }
                if ((keyStorePassword = ssl2.getKeyFilePassword()) == null) {
                    keyStorePassword = "password";
                }
                tokenEnabled = "false";
            }
        } else {
            if (ssl2 != null && ssl2.isSetEnableCryptoHardwareSupport() && ssl2.isEnableCryptoHardwareSupport()) {
                tokenEnabled = "true";
                CryptoHardwareToken orbcrypto = ssl2.getCryptoHardware();
                tokenType = orbcrypto.getTokenType();
                tokenLibrary = orbcrypto.getLibraryFile();
                tokenPassword = orbcrypto.getPassword();
            } else {
                tokenEnabled = "false";
            }
            if (ssl2 == null && System.getProperty("javax.net.ssl.keyStoreProvider") != null) {
                keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider");
            }
            if (ssl2 != null && ssl2.getKeyFileName() != null && !ssl2.getKeyFileName().equals("")) {
                keyStoreName = this.expand(ssl2.getKeyFileName());
            } else if (ssl2 == null && System.getProperty("javax.net.ssl.keyStore") != null) {
                keyStoreName = System.getProperty("javax.net.ssl.keyStore");
            }
            if (ssl2 != null && ssl2.getKeyFilePassword() != null && !ssl2.getKeyFilePassword().equals("")) {
                keyStorePassword = ssl2.getKeyFilePassword();
            } else if (ssl2 == null && System.getProperty("javax.net.ssl.keyStorePassword") != null && (keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword")) != null) {
                keyStorePassword = SSLConfig.decodePassword(keyStorePassword);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Decoded keyStorePassword from system prop.");
                }
                System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
            }
            if (ssl2 != null && ssl2.getKeyFileFormat() != null && !ssl2.getKeyFileFormat().equals("")) {
                keyStoreFormat = KeyStoreManager.getKeyStoreType(ssl2.getKeyFileFormat());
            } else if (ssl2 == null && System.getProperty("javax.net.ssl.keyStoreType") != null) {
                keyStoreFormat = System.getProperty("javax.net.ssl.keyStoreType");
            }
            if (ssl2 == null && System.getProperty("javax.net.ssl.keyStoreProvider") != null) {
                keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider");
            }
            if (ssl2 != null && ssl2.getTrustFileName() != null && !ssl2.getTrustFileName().equals("")) {
                trustStoreName = this.expand(ssl2.getTrustFileName());
            } else if (ssl2 == null && System.getProperty("javax.net.ssl.trustStore") != null) {
                trustStoreName = System.getProperty("javax.net.ssl.trustStore");
            }
            if (ssl2 != null && ssl2.getTrustFilePassword() != null && !ssl2.getTrustFilePassword().equals("")) {
                trustStorePassword = ssl2.getTrustFilePassword();
            } else if (ssl2 == null && System.getProperty("javax.net.ssl.trustStorePassword") != null && (trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword")) != null) {
                trustStorePassword = SSLConfig.decodePassword(trustStorePassword);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Decoded trustStorePassword from system prop.");
                }
                System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
            }
            if (ssl2 != null && ssl2.getTrustFileFormat() != null && !ssl2.getTrustFileFormat().equals("")) {
                trustStoreFormat = KeyStoreManager.getKeyStoreType(ssl2.getTrustFileFormat());
            } else if (ssl2 == null && System.getProperty("javax.net.ssl.trustStoreType") != null) {
                trustStoreFormat = System.getProperty("javax.net.ssl.trustStoreType");
            }
            if (ssl2 == null && System.getProperty("javax.net.ssl.trustStoreProvider") != null) {
                trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
            }
        }
        if (ssl2 != null) {
            for (int j = 0; j < ssl2.getProperties().size(); ++j) {
                Property sslproperty = (Property)ssl2.getProperties().get(j);
                if (sslproperty == null) continue;
                if (sslproperty.getName().equals("com.ibm.ssl.tokenSlot")) {
                    tokenSlot = sslproperty.getValue();
                    continue;
                }
                if (sslproperty.getName().equals("com.ibm.ssl.keyStoreClientAlias")) {
                    keyStoreClientAlias = sslproperty.getValue();
                    continue;
                }
                if (!sslproperty.getName().equals("com.ibm.ssl.keyStoreServerAlias")) continue;
                keyStoreServerAlias = sslproperty.getValue();
            }
        }
        WSKeyStore wsks_key = null;
        WSKeyStore wsks_trust = null;
        if (tokenLibrary != null || keyStoreName != null) {
            wsks_key = new WSKeyStore();
            if (tokenEnabled != null) {
                wsks_key.setProperty("com.ibm.ssl.tokenEnabled", tokenEnabled);
            }
            wsks_key.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
            if (keyStoreClientAlias != null) {
                wsks_key.setProperty("com.ibm.ssl.keyStoreClientAlias", keyStoreClientAlias);
            }
            if (keyStoreServerAlias != null) {
                wsks_key.setProperty("com.ibm.ssl.keyStoreServerAlias", keyStoreServerAlias);
            }
            if (ssl2 != null && sslType != null && sslType.equals("SSSL")) {
                wsks_key.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
                if (keyStoreName != null) {
                    wsks_key.setProperty("com.ibm.ssl.keyStore", keyStoreName);
                }
                if (keyStorePassword != null) {
                    wsks_key.setProperty("com.ibm.ssl.keyStorePassword", keyStorePassword);
                }
                if (keyStoreFormat != null) {
                    wsks_key.setProperty("com.ibm.ssl.keyStoreType", keyStoreFormat);
                    if (!(keyStoreFormat.equals("JKS") || keyStoreFormat.equals("JCEKS") || keyStoreFormat.equals("PKCS12"))) {
                        wsks_key.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                    } else {
                        wsks_key.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
                    }
                }
                wsks_key.setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
                wsks_key.setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
                wsks_key.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
                wsks_key.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "false");
                wsks_key.setProperty("com.ibm.ssl.keyStoreUseForAcceleration", "false");
            } else if (tokenEnabled.equals("true")) {
                if (tokenLibrary != null) {
                    wsks_key.setProperty("com.ibm.ssl.tokenLibraryFile", tokenLibrary);
                    wsks_key.setProperty("com.ibm.ssl.keyStore", tokenLibrary);
                }
                if (tokenPassword != null) {
                    wsks_key.setProperty("com.ibm.ssl.tokenPassword", tokenPassword);
                    wsks_key.setProperty("com.ibm.ssl.keyStorePassword", tokenPassword);
                }
                if (tokenType != null) {
                    wsks_key.setProperty("com.ibm.ssl.tokenType", tokenType);
                    wsks_key.setProperty("com.ibm.ssl.keyStoreType", tokenType);
                }
                if (tokenSlot != null) {
                    wsks_key.setProperty("com.ibm.ssl.tokenSlot", tokenSlot);
                    wsks_key.setProperty("com.ibm.ssl.keyStoreSlot", tokenSlot);
                }
                wsks_key.setProperty("com.ibm.ssl.keyStoreProvider", "IBMPKCS11Impl");
                wsks_key.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                wsks_key.setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
                wsks_key.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "true");
                wsks_key.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "false");
                wsks_key.setProperty("com.ibm.ssl.keyStoreUseForAcceleration", "true");
            } else {
                if (keyStoreName != null) {
                    wsks_key.setProperty("com.ibm.ssl.keyStore", keyStoreName);
                }
                if (keyStorePassword != null) {
                    wsks_key.setProperty("com.ibm.ssl.keyStorePassword", keyStorePassword);
                }
                if (keyStoreFormat != null) {
                    wsks_key.setProperty("com.ibm.ssl.keyStoreType", keyStoreFormat);
                    if (!(keyStoreFormat.equals("JKS") || keyStoreFormat.equals("JCEKS") || keyStoreFormat.equals("PKCS12"))) {
                        wsks_key.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                    } else {
                        wsks_key.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
                    }
                }
                if (keyStoreFormat != null && keyStoreFormat.equals("JCE4758KS")) {
                    wsks_key.setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
                } else {
                    wsks_key.setProperty("com.ibm.ssl.keyStoreReadOnly", "false");
                }
                wsks_key.setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
                wsks_key.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
                wsks_key.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "true");
                wsks_key.setProperty("com.ibm.ssl.keyStoreUseForAcceleration", "false");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding KeyStore name: " + alias + "_key");
            }
            wsks_key.setProperty("com.ibm.ssl.keyStoreName", alias + "_key");
            this.addKeyStoreIfNotDuplicate(alias + "_key", wsks_key);
        }
        if (trustStoreName != null) {
            wsks_trust = new WSKeyStore();
            wsks_trust.setProperty("com.ibm.ssl.tokenEnabled", "false");
            wsks_trust.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
            wsks_trust.setProperty("com.ibm.ssl.keyStore", trustStoreName);
            if (trustStorePassword != null) {
                wsks_trust.setProperty("com.ibm.ssl.keyStorePassword", trustStorePassword);
            }
            if (trustStoreFormat != null) {
                wsks_trust.setProperty("com.ibm.ssl.keyStoreType", trustStoreFormat);
                if (!(trustStoreFormat.equals("JKS") || trustStoreFormat.equals("JCEKS") || trustStoreFormat.equals("PKCS12"))) {
                    wsks_trust.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                } else {
                    wsks_trust.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
                }
            }
            if (trustStoreFormat != null && trustStoreFormat.equals("JCE4758KS")) {
                wsks_trust.setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
            } else {
                wsks_trust.setProperty("com.ibm.ssl.keyStoreReadOnly", "false");
            }
            wsks_trust.setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
            wsks_trust.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
            wsks_trust.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "true");
            wsks_trust.setProperty("com.ibm.ssl.keyStoreUseForAcceleration", "false");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding TrustStore name: " + alias + "_trust");
            }
            wsks_trust.setProperty("com.ibm.ssl.keyStoreName", alias + "_trust");
            this.addKeyStoreIfNotDuplicate(alias + "_trust", wsks_trust);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Total Number of KeyStores: " + this.keyStoreMap.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadOldWCCMKeyStore");
        }
        if (wsks_key != null && wsks_trust != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning key and trust.");
            }
            return new WSKeyStore[]{wsks_key, wsks_trust};
        }
        if (wsks_key != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Copying key to trust.");
            }
            wsks_trust = (WSKeyStore)wsks_key.clone();
            wsks_trust.setProperty("com.ibm.ssl.keyStoreName", alias + "_trust");
            this.addKeyStoreIfNotDuplicate(alias + "_trust", wsks_trust);
            return new WSKeyStore[]{wsks_key, wsks_trust};
        }
        if (wsks_trust != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Copying trust to key.");
            }
            wsks_key = (WSKeyStore)wsks_trust.clone();
            wsks_key.setProperty("com.ibm.ssl.keyStoreName", alias + "_key");
            this.addKeyStoreIfNotDuplicate(alias + "_key", wsks_key);
            return new WSKeyStore[]{wsks_key, wsks_trust};
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not returning any KeyStores from old WCCM config.");
        }
        return null;
    }

    public void loadKeyStores(SecurityConfigObject security2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadKeyStores");
        }
        this.clearKeyStoreMap();
        SecurityConfigObjectList keyStoreList = security2.getObjectList("keyStores");
        for (int i = 0; i < keyStoreList.size(); ++i) {
            SecurityConfigObject keyStore = keyStoreList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading KeyStore name " + keyStore.getString("name") + ".");
            }
            this.loadKeyStore(keyStore);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadKeyStores");
        }
    }

    public void loadKeyStore(SecurityConfigObject keyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadWCCMKeyStore");
        }
        String scopeString = null;
        SecurityConfigObject mgmtScope = keyStore.getObject("managementScope");
        if (mgmtScope != null) {
            scopeString = mgmtScope.getString("scopeName");
        }
        if (scopeString != null && !ManagementScopeManager.getInstance().currentScopeContained(scopeString)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyStore is not in the current scope.");
            }
            return;
        }
        String alias = keyStore.getString("name");
        WSKeyStore wsks_key = new WSKeyStore(keyStore);
        if (alias != null && wsks_key != null) {
            this.addKeyStoreIfNotDuplicate(alias, wsks_key);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadWCCMKeyStore (keystore)");
        }
    }

    public WSKeyStore[] loadOldWCCMKeyStores(String alias, String sslType, SecurityConfigObject ssl2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadOldWCCMKeyStores");
        }
        String keyStoreClientAlias = null;
        String keyStoreServerAlias = null;
        String keyStoreName = null;
        String keyStorePassword = null;
        String keyStoreFormat = null;
        String keyStoreProvider = null;
        String trustStoreName = null;
        String trustStorePassword = null;
        String trustStoreFormat = null;
        String trustStoreProvider = null;
        String tokenEnabled = null;
        String tokenLibrary = null;
        String tokenPassword = null;
        String tokenSlot = null;
        String tokenType = null;
        if (ssl2 != null && sslType != null && sslType.equals("SSSL")) {
            if (ssl2 != null && ssl2.isSet("enableCryptoHardwareSupport") && ssl2.getBoolean("enableCryptoHardwareSupport").booleanValue()) {
                keyStoreFormat = "JCE4758KS";
                keyStoreName = ssl2.getUnexpandedString("keyFileName");
                if (keyStoreName != null) {
                    keyStoreName = "safkeyringhw:///" + keyStoreName;
                }
                if ((keyStorePassword = ssl2.getUnexpandedString("keyFilePassword")) == null) {
                    keyStorePassword = "password";
                }
                tokenEnabled = "true";
            } else {
                keyStoreFormat = "JCERACFKS";
                keyStoreName = ssl2.getUnexpandedString("keyFileName");
                if (keyStoreName != null) {
                    keyStoreName = "safkeyring:///" + keyStoreName;
                }
                if ((keyStorePassword = ssl2.getUnexpandedString("keyFilePassword")) == null) {
                    keyStorePassword = "password";
                }
                tokenEnabled = "false";
            }
        } else {
            if (ssl2 != null && ssl2.isSet("enableCryptoHardwareSupport") && ssl2.getBoolean("enableCryptoHardwareSupport").booleanValue()) {
                tokenEnabled = "true";
                SecurityConfigObject orbcrypto = ssl2.getObject("cryptoHardware");
                tokenType = orbcrypto.getString("tokenType");
                tokenLibrary = orbcrypto.getUnexpandedString("libraryFile");
                tokenPassword = orbcrypto.getDecodedString("password");
            } else {
                tokenEnabled = "false";
            }
            if (ssl2 == null && System.getProperty("javax.net.ssl.keyStoreProvider") != null) {
                keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider");
            }
            if (ssl2 != null && ssl2.getUnexpandedString("keyFileName") != null && !ssl2.getUnexpandedString("keyFileName").equals("")) {
                keyStoreName = this.expand(ssl2.getUnexpandedString("keyFileName"));
            } else if (ssl2 == null && System.getProperty("javax.net.ssl.keyStore") != null) {
                keyStoreName = System.getProperty("javax.net.ssl.keyStore");
            }
            String password = null;
            if (ssl2 != null) {
                password = ssl2.getDecodedString("keyFilePassword");
            }
            if (password != null && !password.equals("")) {
                keyStorePassword = password;
            } else if (ssl2 == null && System.getProperty("javax.net.ssl.keyStorePassword") != null && (keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword")) != null) {
                keyStorePassword = SSLConfig.decodePassword(keyStorePassword);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Decoded keyStorePassword from system prop.");
                }
                System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
            }
            if (ssl2 != null && ssl2.getString("keyFileFormat", "JKS") != null && !ssl2.getString("keyFileFormat", "JKS").equals("")) {
                keyStoreFormat = ssl2.getString("keyFileFormat", "JKS");
            } else if (ssl2 == null && System.getProperty("javax.net.ssl.keyStoreType") != null) {
                keyStoreFormat = System.getProperty("javax.net.ssl.keyStoreType");
            }
            if (ssl2 == null && System.getProperty("javax.net.ssl.keyStoreProvider") != null) {
                keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider");
            }
            if (ssl2 != null && ssl2.getUnexpandedString("trustFileName") != null && !ssl2.getUnexpandedString("trustFileName").equals("")) {
                trustStoreName = this.expand(ssl2.getUnexpandedString("trustFileName"));
            } else if (ssl2 == null && System.getProperty("javax.net.ssl.trustStore") != null) {
                trustStoreName = System.getProperty("javax.net.ssl.trustStore");
            }
            password = null;
            if (ssl2 != null) {
                password = ssl2.getDecodedString("trustFilePassword");
            }
            if (password != null && !password.equals("")) {
                trustStorePassword = password;
            } else if (ssl2 == null && System.getProperty("javax.net.ssl.trustStorePassword") != null && (trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword")) != null) {
                trustStorePassword = SSLConfig.decodePassword(trustStorePassword);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Decoded trustStorePassword from system prop.");
                }
                System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
            }
            if (ssl2 != null && ssl2.getString("trustFileFormat", "JKS") != null && !ssl2.getString("trustFileFormat", "JKS").equals("")) {
                trustStoreFormat = ssl2.getString("trustFileFormat", "JKS");
            } else if (ssl2 == null && System.getProperty("javax.net.ssl.trustStoreType") != null) {
                trustStoreFormat = System.getProperty("javax.net.ssl.trustStoreType");
            }
            if (ssl2 == null && System.getProperty("javax.net.ssl.trustStoreProvider") != null) {
                trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
            }
        }
        if (ssl2 != null) {
            SecurityConfigObjectList sslProps = ssl2.getObjectList("properties");
            for (int j = 0; j < sslProps.size(); ++j) {
                SecurityConfigObject sslproperty = sslProps.get(j);
                if (sslproperty == null) continue;
                String name2 = sslproperty.getString("name");
                if (name2.equals("com.ibm.ssl.tokenSlot")) {
                    tokenSlot = sslproperty.getString("value");
                    continue;
                }
                if (name2.equals("com.ibm.ssl.keyStoreClientAlias")) {
                    keyStoreClientAlias = sslproperty.getString("value");
                    continue;
                }
                if (!name2.equals("com.ibm.ssl.keyStoreServerAlias")) continue;
                keyStoreServerAlias = sslproperty.getString("value");
            }
        }
        WSKeyStore wsks_key = null;
        WSKeyStore wsks_trust = null;
        if (tokenLibrary != null || keyStoreName != null) {
            wsks_key = new WSKeyStore();
            if (tokenEnabled != null) {
                wsks_key.setProperty("com.ibm.ssl.tokenEnabled", tokenEnabled);
            }
            wsks_key.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
            if (keyStoreClientAlias != null) {
                wsks_key.setProperty("com.ibm.ssl.keyStoreClientAlias", keyStoreClientAlias);
            }
            if (keyStoreServerAlias != null) {
                wsks_key.setProperty("com.ibm.ssl.keyStoreServerAlias", keyStoreServerAlias);
            }
            if (ssl2 != null && sslType != null && sslType.equals("SSSL")) {
                wsks_key.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
                if (keyStoreName != null) {
                    wsks_key.setProperty("com.ibm.ssl.keyStore", keyStoreName);
                }
                if (keyStorePassword != null) {
                    wsks_key.setProperty("com.ibm.ssl.keyStorePassword", keyStorePassword);
                }
                if (keyStoreFormat != null) {
                    wsks_key.setProperty("com.ibm.ssl.keyStoreType", keyStoreFormat);
                    if (!(keyStoreFormat.equals("JKS") || keyStoreFormat.equals("JCEKS") || keyStoreFormat.equals("PKCS12"))) {
                        wsks_key.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                    } else {
                        wsks_key.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
                    }
                }
                wsks_key.setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
                wsks_key.setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
                wsks_key.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
                wsks_key.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "false");
                wsks_key.setProperty("com.ibm.ssl.keyStoreUseForAcceleration", "false");
            } else if (tokenEnabled.equals("true")) {
                if (tokenLibrary != null) {
                    wsks_key.setProperty("com.ibm.ssl.tokenLibraryFile", tokenLibrary);
                    wsks_key.setProperty("com.ibm.ssl.keyStore", tokenLibrary);
                }
                if (tokenPassword != null) {
                    wsks_key.setProperty("com.ibm.ssl.tokenPassword", tokenPassword);
                    wsks_key.setProperty("com.ibm.ssl.keyStorePassword", tokenPassword);
                }
                if (tokenType != null) {
                    wsks_key.setProperty("com.ibm.ssl.tokenType", tokenType);
                    wsks_key.setProperty("com.ibm.ssl.keyStoreType", tokenType);
                }
                if (tokenSlot != null) {
                    wsks_key.setProperty("com.ibm.ssl.tokenSlot", tokenSlot);
                    wsks_key.setProperty("com.ibm.ssl.keyStoreSlot", tokenSlot);
                }
                wsks_key.setProperty("com.ibm.ssl.keyStoreProvider", "IBMPKCS11Impl");
                wsks_key.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                wsks_key.setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
                wsks_key.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "true");
                wsks_key.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "false");
                wsks_key.setProperty("com.ibm.ssl.keyStoreUseForAcceleration", "true");
            } else {
                if (keyStoreName != null) {
                    wsks_key.setProperty("com.ibm.ssl.keyStore", keyStoreName);
                }
                if (keyStorePassword != null) {
                    wsks_key.setProperty("com.ibm.ssl.keyStorePassword", keyStorePassword);
                }
                if (keyStoreFormat != null) {
                    wsks_key.setProperty("com.ibm.ssl.keyStoreType", keyStoreFormat);
                    if (!(keyStoreFormat.equals("JKS") || keyStoreFormat.equals("JCEKS") || keyStoreFormat.equals("PKCS12"))) {
                        wsks_key.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                    } else {
                        wsks_key.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
                    }
                }
                if (keyStoreFormat != null && keyStoreFormat.equals("JCE4758KS")) {
                    wsks_key.setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
                } else {
                    wsks_key.setProperty("com.ibm.ssl.keyStoreReadOnly", "false");
                }
                wsks_key.setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
                wsks_key.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
                wsks_key.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "true");
                wsks_key.setProperty("com.ibm.ssl.keyStoreUseForAcceleration", "false");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding KeyStore name: " + alias + "_key");
            }
            wsks_key.setProperty("com.ibm.ssl.keyStoreName", alias + "_key");
            this.addKeyStoreIfNotDuplicate(alias + "_key", wsks_key);
        }
        if (trustStoreName != null) {
            wsks_trust = new WSKeyStore();
            wsks_trust.setProperty("com.ibm.ssl.tokenEnabled", "false");
            wsks_trust.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
            wsks_trust.setProperty("com.ibm.ssl.keyStore", trustStoreName);
            if (trustStorePassword != null) {
                wsks_trust.setProperty("com.ibm.ssl.keyStorePassword", trustStorePassword);
            }
            if (trustStoreFormat != null) {
                wsks_trust.setProperty("com.ibm.ssl.keyStoreType", trustStoreFormat);
                if (!(trustStoreFormat.equals("JKS") || trustStoreFormat.equals("JCEKS") || trustStoreFormat.equals("PKCS12"))) {
                    wsks_trust.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                } else {
                    wsks_trust.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
                }
            }
            if (trustStoreFormat != null && trustStoreFormat.equals("JCE4758KS")) {
                wsks_trust.setProperty("com.ibm.ssl.keyStoreReadOnly", "true");
            } else {
                wsks_trust.setProperty("com.ibm.ssl.keyStoreReadOnly", "false");
            }
            wsks_trust.setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
            wsks_trust.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
            wsks_trust.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "true");
            wsks_trust.setProperty("com.ibm.ssl.keyStoreUseForAcceleration", "false");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding TrustStore name: " + alias + "_trust");
            }
            wsks_trust.setProperty("com.ibm.ssl.keyStoreName", alias + "_trust");
            this.addKeyStoreIfNotDuplicate(alias + "_trust", wsks_trust);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Total Number of KeyStores: " + this.keyStoreMap.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadOldWCCMKeyStore");
        }
        if (wsks_key != null && wsks_trust != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning key and trust.");
            }
            return new WSKeyStore[]{wsks_key, wsks_trust};
        }
        if (wsks_key != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Copying key to trust.");
            }
            wsks_trust = (WSKeyStore)wsks_key.clone();
            wsks_trust.setProperty("com.ibm.ssl.keyStoreName", alias + "_trust");
            this.addKeyStoreIfNotDuplicate(alias + "_trust", wsks_trust);
            return new WSKeyStore[]{wsks_key, wsks_trust};
        }
        if (wsks_trust != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Copying trust to key.");
            }
            wsks_key = (WSKeyStore)wsks_trust.clone();
            wsks_key.setProperty("com.ibm.ssl.keyStoreName", alias + "_key");
            this.addKeyStoreIfNotDuplicate(alias + "_key", wsks_key);
            return new WSKeyStore[]{wsks_key, wsks_trust};
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not returning any KeyStores from old WCCM config.");
        }
        return null;
    }

    public boolean checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot(SSLConfig sslprops) {
        boolean tsExists;
        boolean ksExists;
        block63: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot");
            }
            ksExists = false;
            tsExists = false;
            String tokenEnabled = null;
            String tokenConfigFile = null;
            String fileBased = null;
            String keyStoreLocation = null;
            String password = null;
            String type = null;
            String provider = null;
            String readOnly = null;
            String scope = null;
            try {
                File tFile;
                FileExistsAction action;
                Boolean fileExists;
                String name2 = sslprops.getProperty("com.ibm.ssl.keyStoreName");
                WSKeyStore wsks = this.getKeyStore(name2);
                if (wsks == null) {
                    wsks = new WSKeyStore();
                    if (name2 != null) {
                        wsks.setProperty("com.ibm.ssl.keyStoreName", name2);
                    }
                    if ((fileBased = sslprops.getProperty("com.ibm.ssl.keyStoreFileBased")) != null) {
                        wsks.setProperty("com.ibm.ssl.keyStoreFileBased", fileBased);
                    }
                    if ((readOnly = sslprops.getProperty("com.ibm.ssl.keyStoreReadOnly")) != null) {
                        wsks.setProperty("com.ibm.ssl.keyStoreReadOnly", readOnly);
                    }
                    if ((keyStoreLocation = sslprops.getProperty("com.ibm.ssl.keyStore")) != null) {
                        wsks.setProperty("com.ibm.ssl.keyStore", keyStoreLocation);
                    }
                    if ((password = sslprops.getProperty("com.ibm.ssl.keyStorePassword")) != null) {
                        wsks.setProperty("com.ibm.ssl.keyStorePassword", password);
                    }
                    if ((tokenEnabled = sslprops.getProperty("com.ibm.ssl.tokenEnabled")) != null) {
                        wsks.setProperty("com.ibm.ssl.tokenEnabled", tokenEnabled);
                    }
                    if ((type = sslprops.getProperty("com.ibm.ssl.keyStoreType")) != null) {
                        wsks.setProperty("com.ibm.ssl.keyStoreType", type);
                        if (!(type.equals("JKS") || type.equals("JCEKS") || type.equals("PKCS12") || type.equals("CMSKS") || type.equals("IBMi5OSKeyStore"))) {
                            wsks.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                            fileBased = "false";
                        } else {
                            wsks.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
                            fileBased = "true";
                        }
                        if (type.equals("PKCS11") || type.equals("JCE4758KS")) {
                            wsks.setProperty("com.ibm.ssl.tokenEnabled", "true");
                        }
                        if ((readOnly = sslprops.getProperty("com.ibm.ssl.keyStoreReadOnly")) != null) {
                            wsks.setProperty("com.ibm.ssl.keyStoreReadOnly", readOnly);
                        }
                    }
                    if ((tokenConfigFile = sslprops.getProperty("com.ibm.ssl.tokenConfigFile")) != null) {
                        wsks.setProperty("com.ibm.ssl.tokenConfigFile", tokenConfigFile);
                    }
                    if ((provider = sslprops.getProperty("com.ibm.ssl.keyStoreProvider")) != null) {
                        if (provider.equals("IBMPKCS11Impl")) {
                            wsks.setProperty("com.ibm.ssl.tokenEnabled", "true");
                        }
                        wsks.setProperty("com.ibm.ssl.keyStoreProvider", provider);
                    }
                    if ((scope = sslprops.getProperty("com.ibm.ssl.keyStoreScope")) != null) {
                        wsks.setProperty("com.ibm.ssl.keyStoreScope", scope);
                    }
                    this.keyStoreMap.put(name2, wsks);
                }
                if (fileBased == null) {
                    fileBased = wsks.getProperty("com.ibm.ssl.keyStoreFileBased");
                }
                if (readOnly == null) {
                    readOnly = wsks.getProperty("com.ibm.ssl.keyStoreReadOnly");
                }
                if (keyStoreLocation == null) {
                    keyStoreLocation = wsks.getProperty("com.ibm.ssl.keyStore");
                }
                String keyStoreFile = null;
                Certificate signer = null;
                if (fileBased != null && fileBased.equals("true") && readOnly != null && readOnly.equals("false") && name2 != null && name2.endsWith("DefaultKeyStore")) {
                    try {
                        URL conversionURL = new URL(keyStoreLocation);
                        keyStoreFile = conversionURL.getFile();
                        while (keyStoreFile.startsWith("/")) {
                            keyStoreFile = keyStoreFile.substring(1);
                        }
                    }
                    catch (MalformedURLException e) {
                        keyStoreFile = keyStoreLocation;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "File path for OutputStream: " + keyStoreFile);
                    }
                    File kFile = null;
                    Boolean fileExists2 = Boolean.FALSE;
                    if (keyStoreFile != null) {
                        kFile = new File(keyStoreFile);
                        FileExistsAction action2 = new FileExistsAction(kFile);
                        fileExists2 = (Boolean)AccessController.doPrivileged(action2);
                    }
                    if (kFile != null && fileExists2.booleanValue()) {
                        ksExists = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot -> (keystore exists)");
                        }
                    } else if (kFile != null) {
                        String location = keyStoreFile;
                        if (password == null) {
                            password = wsks.getProperty("com.ibm.ssl.keyStorePassword");
                        }
                        if (type == null) {
                            type = wsks.getProperty("com.ibm.ssl.keyStoreType");
                        }
                        if (provider == null) {
                            provider = wsks.getProperty("com.ibm.ssl.keyStoreProvider");
                        }
                        if (scope == null) {
                            scope = wsks.getProperty("com.ibm.ssl.keyStoreScope");
                        }
                        Boolean fileBasedBoolean = Boolean.TRUE;
                        Boolean readOnlyBoolean = Boolean.FALSE;
                        Boolean initializeAtStartupBoolean = Boolean.TRUE;
                        KeyStoreInfo ksInfo = new KeyStoreInfo(name2, location, password, provider, type, fileBasedBoolean, null, scope, null, readOnlyBoolean, initializeAtStartupBoolean, Boolean.FALSE, null, new Integer(0), Boolean.FALSE, null, null);
                        String clientAlias = sslprops.getProperty("com.ibm.ssl.keyStoreClientAlias");
                        String defaultAlias = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqAlias", "default");
                        String alias = null;
                        alias = clientAlias != null ? clientAlias : (defaultAlias != null ? defaultAlias : "default");
                        String sizeString = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqKeySize", "1024");
                        String subjectDN = this.expand(SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqSubjectDN", "cn=${hostname},o=IBM,c=US"));
                        String daysString = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqDays", "5475");
                        int size = new Integer(sizeString);
                        int days = new Integer(daysString);
                        CertReqInfo certReq = new CertReqInfo(alias, size, subjectDN, days, ksInfo, null);
                        try {
                            signer = CertificateManager.getInstance().chainedCertificateCreate(certReq, "root", null);
                        }
                        catch (NoClassDefFoundError e) {
                            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.KeyStoreManager.checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot", "1339", this, new Object[]{e});
                            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.chained.create.error.CWPKI0043E", new Object[]{e.toString()}, "Error creating a chained certificate due to: " + e);
                            Tr.error(tc, msg);
                            throw e;
                        }
                    }
                }
                String trustStoreName = sslprops.getProperty("com.ibm.ssl.trustStoreName");
                WSKeyStore wsts = this.getKeyStore(trustStoreName);
                String trustStoreFileBased = null;
                String trustStoreLocation = null;
                String trustStorePassword = null;
                String trustStoreType = null;
                String trustStoreProvider = null;
                String trustStoreReadOnly = null;
                tokenEnabled = null;
                tokenConfigFile = null;
                if (wsts == null) {
                    wsts = new WSKeyStore();
                    if (trustStoreName != null) {
                        wsts.setProperty("com.ibm.ssl.keyStoreName", trustStoreName);
                    }
                    if ((trustStoreFileBased = sslprops.getProperty("com.ibm.ssl.trustStoreFileBased")) != null) {
                        wsts.setProperty("com.ibm.ssl.keyStoreFileBased", trustStoreFileBased);
                    }
                    if ((trustStoreLocation = sslprops.getProperty("com.ibm.ssl.trustStore")) != null) {
                        wsts.setProperty("com.ibm.ssl.keyStore", trustStoreLocation);
                    }
                    if ((trustStorePassword = sslprops.getProperty("com.ibm.ssl.trustStorePassword")) != null) {
                        wsts.setProperty("com.ibm.ssl.keyStorePassword", trustStorePassword);
                    }
                    if (tokenEnabled != null) {
                        wsts.setProperty("com.ibm.ssl.tokenEnabled", tokenEnabled);
                    }
                    if ((trustStoreType = sslprops.getProperty("com.ibm.ssl.trustStoreType")) != null) {
                        if (trustStoreType.equals("PKCS11") || trustStoreType.equals("JCE4758KS")) {
                            wsts.setProperty("com.ibm.ssl.tokenEnabled", "true");
                        }
                        if (trustStoreType.equals("JCERACFKS") || trustStoreType.equals("JCE4758KS")) {
                            wsts.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                            fileBased = "false";
                        }
                        wsts.setProperty("com.ibm.ssl.keyStoreType", trustStoreType);
                    }
                    if ((tokenConfigFile = sslprops.getProperty("com.ibm.ssl.tokenConfigFile")) != null) {
                        wsts.setProperty("com.ibm.ssl.tokenConfigFile", tokenConfigFile);
                    }
                    if ((trustStoreProvider = sslprops.getProperty("com.ibm.ssl.trustStoreProvider")) != null) {
                        wsts.setProperty("com.ibm.ssl.keyStoreProvider", trustStoreProvider);
                    }
                    if ((trustStoreReadOnly = sslprops.getProperty("com.ibm.ssl.trustStoreReadOnly")) != null) {
                        wsts.setProperty("com.ibm.ssl.keyStoreReadOnly", trustStoreReadOnly);
                    }
                    this.keyStoreMap.put(trustStoreName, wsts);
                }
                if (trustStoreFileBased == null) {
                    trustStoreFileBased = wsts.getProperty("com.ibm.ssl.keyStoreFileBased");
                }
                if (trustStoreLocation == null) {
                    trustStoreLocation = wsts.getProperty("com.ibm.ssl.keyStore");
                }
                String trustStoreFile = null;
                if (ksExists || trustStoreFileBased == null || !trustStoreFileBased.equals("true") || trustStoreName == null || !trustStoreName.endsWith("DefaultTrustStore")) break block63;
                try {
                    URL conversionURL = new URL(trustStoreLocation);
                    trustStoreFile = conversionURL.getFile();
                    while (trustStoreFile.startsWith("/")) {
                        trustStoreFile = trustStoreFile.substring(1);
                    }
                }
                catch (MalformedURLException e) {
                    trustStoreFile = trustStoreLocation;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "File path for OutputStream: " + trustStoreFile);
                }
                if ((fileExists = (Boolean)AccessController.doPrivileged(action = new FileExistsAction(tFile = new File(trustStoreFile)))).booleanValue()) {
                    tsExists = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot -> (truststore exists)");
                    }
                } else {
                    KeyStore keyStore = wsts.getKeyStore(false, false);
                    String signer_alias = "default_signer";
                    if (keyStore != null && signer != null) {
                        keyStore.setCertificateEntry(signer_alias, signer);
                        wsts.store();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Signer set in new truststore file.");
                        }
                    }
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.KeyStoreManager.checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot", "1476", this, new Object[]{e});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception creating client keystore and/or truststore.", new Object[]{e});
                }
                Tr.error(tc, "ssl.client.keystore.create.error.CWPKI0031E", new Object[]{e.getMessage()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfClientKeyStoreAndTrustStoreExistsAndCreateIfNot -> " + new Boolean(!ksExists && !tsExists).toString());
        }
        return !ksExists && !tsExists;
    }

    public Certificate checkIfKeyStoreExistsAndCreateIfNot(WSKeyStore ks, SSLConfig config) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfKeyStoreExistsAndCreateIfNot");
        }
        String fileBased = ks.getProperty("com.ibm.ssl.keyStoreFileBased");
        String location = ks.getProperty("com.ibm.ssl.keyStore");
        String profileRoot = KeyStoreManager.getConfigRoot();
        String expandedConfigRoot = null;
        expandedConfigRoot = profileRoot != null ? profileRoot : KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
        String keyStoreName = ks.getProperty("com.ibm.ssl.keyStoreName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Key store location: " + location);
        }
        if (keyStoreName != null && (keyStoreName.endsWith("DefaultKeyStore") || keyStoreName.endsWith("RSATokenKeyStore")) && fileBased != null && fileBased.equals("true")) {
            File keyStoreFile = new File(location);
            FileExistsAction action = new FileExistsAction(keyStoreFile);
            Boolean fileExists = (Boolean)AccessController.doPrivileged(action);
            if (fileExists.booleanValue()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot -> (exists)");
                }
                return null;
            }
            try {
                String name2 = ks.getProperty("com.ibm.ssl.keyStoreName");
                String password = ks.getProperty("com.ibm.ssl.keyStorePassword");
                String type = ks.getProperty("com.ibm.ssl.keyStoreType");
                String provider = ks.getProperty("com.ibm.ssl.keyStoreProvider");
                String scope = ks.getProperty("com.ibm.ssl.keyStoreScope");
                String stash = ks.getProperty("com.ibm.ssl.keyStoreCreateCMSStash");
                Boolean stashBoolean = Boolean.TRUE;
                if (stash != null) {
                    stashBoolean = new Boolean(stash);
                }
                Boolean fileBasedBoolean = Boolean.TRUE;
                Boolean readOnlyBoolean = Boolean.FALSE;
                Boolean initializeAtStartupBoolean = Boolean.TRUE;
                KeyStoreInfo ksInfo = new KeyStoreInfo(name2, location, password, provider, type, fileBasedBoolean, null, scope, null, readOnlyBoolean, initializeAtStartupBoolean, stashBoolean, null, new Integer(0), Boolean.FALSE, null, null);
                if (keyStoreName.endsWith("RSATokenKeyStore")) {
                    ksInfo.setUsage("RSATokenKeys");
                } else {
                    ksInfo.setUsage("SSLKeys");
                }
                String clientAlias = config.getProperty("com.ibm.ssl.keyStoreClientAlias");
                String serverAlias = config.getProperty("com.ibm.ssl.keyStoreServerAlias");
                String defaultAlias = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqAlias", "default");
                String alias = null;
                alias = serverAlias != null ? serverAlias : (clientAlias != null ? clientAlias : (defaultAlias != null ? defaultAlias : "default"));
                String sizeString = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqKeySize", "1024");
                String subjectDN = this.expand(SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqSubjectDN", "cn=${hostname},o=IBM,c=US"));
                String daysString = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqDays", "5475");
                int size = new Integer(sizeString);
                int days = new Integer(daysString);
                CertReqInfo certReq = new CertReqInfo(alias, size, subjectDN, days, ksInfo, null);
                Certificate signer = CertificateManager.getInstance().chainedCertificateCreate(certReq, "root", null);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot");
                }
                return signer;
            }
            catch (Exception e) {
                if (e instanceof SSLException) {
                    throw (SSLException)e;
                }
                throw new SSLException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot (not filebased or in config root)");
        }
        return null;
    }

    public void checkIfTrustStoreExistsAndCreateIfNot(WSKeyStore ts, SSLConfig config, Certificate signer) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfTrustStoreExistsAndCreateIfNot");
        }
        String fileBased = ts.getProperty("com.ibm.ssl.keyStoreFileBased");
        String location = ts.getProperty("com.ibm.ssl.keyStore");
        String profileRoot = KeyStoreManager.getConfigRoot();
        String expandedConfigRoot = null;
        expandedConfigRoot = profileRoot != null ? profileRoot : KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
        String trustStoreName = ts.getProperty("com.ibm.ssl.keyStoreName");
        if (trustStoreName != null && (trustStoreName.endsWith("DefaultTrustStore") || trustStoreName.endsWith("RSATokenTrustStore")) && fileBased != null && fileBased.equals("true")) {
            File trustStoreFile = new File(location);
            FileExistsAction action = new FileExistsAction(trustStoreFile);
            Boolean fileExists = (Boolean)AccessController.doPrivileged(action);
            if (fileExists.booleanValue()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot -> (exists)");
                }
                return;
            }
            try {
                String name2 = ts.getProperty("com.ibm.ssl.keyStoreName");
                String password = ts.getProperty("com.ibm.ssl.keyStorePassword");
                String type = ts.getProperty("com.ibm.ssl.keyStoreType");
                String provider = ts.getProperty("com.ibm.ssl.keyStoreProvider");
                String scope = ts.getProperty("com.ibm.ssl.keyStoreScope");
                KeyStore keyStore = this.getKeyStore(name2, type, provider, location, password, scope, true, config);
                String signer_alias = "default_signer";
                if (keyStore != null && signer != null) {
                    keyStore.setCertificateEntry(signer_alias, signer);
                    FileOutputStream fos = new FileOutputStream(location);
                    keyStore.store(fos, password.toCharArray());
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot (signer set)");
                    }
                    return;
                }
            }
            catch (Exception e) {
                if (e instanceof SSLException) {
                    throw (SSLException)e;
                }
                throw new SSLException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot (not filebased or in config root)");
        }
    }

    public void addKeyStoreIfNotDuplicate(String keyStoreName, WSKeyStore ks) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addKeyStoreIfNotDuplicate", keyStoreName);
        }
        if (this.keyStoreMap.size() > 0) {
            for (Map.Entry current : this.keyStoreMap.entrySet()) {
                WSKeyStore mapks = (WSKeyStore)current.getValue();
                if (!mapks.equals(ks)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found a matching KeyStore, adding reference to existing.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding keystore lookup as: " + keyStoreName);
                }
                this.keyStoreMap.put(keyStoreName, mapks);
                String accelerator = mapks.getProperty("com.ibm.ssl.keyStoreUseForAcceleration");
                if (accelerator != null && accelerator.equals("true")) {
                    this.acceleratorMap.put(keyStoreName, mapks);
                }
                return;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding KeyStore to the Map: " + keyStoreName + ", values: " + ks);
        }
        if (SSLConfigManager.getInstance().validationEnabled()) {
            ks.provideExpirationWarnings(new Integer("60"), keyStoreName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding keystore lookup as: " + keyStoreName);
        }
        this.keyStoreMap.put(keyStoreName, ks);
        String accelerator = ks.getProperty("com.ibm.ssl.keyStoreUseForAcceleration");
        if (accelerator != null && accelerator.equals("true")) {
            this.acceleratorMap.put(keyStoreName, ks);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addKeyStoreIfNotDuplicate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchangeSigners(String configRootKeyStore, com.ibm.websphere.models.config.ipc.ssl.KeyStore keystore, String configRootTrustStore, com.ibm.websphere.models.config.ipc.ssl.KeyStore truststore) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exchangeSigners", new Object[]{keystore.getLocation(), truststore.getLocation()});
        }
        FileOutputStream fos = null;
        try {
            String name1 = keystore.getName();
            String location1 = this.fixupConfigRootForSignerExchange(configRootKeyStore, keystore.getLocation());
            String password1 = keystore.getPassword();
            String type1 = keystore.getType();
            String provider1 = keystore.getProvider();
            String scope1 = keystore.getManagementScope().getScopeName();
            KeyStore keyStore1 = this.getKeyStore(name1, type1, provider1, location1, password1, scope1, true, null);
            String name2 = truststore.getName();
            String location2 = this.fixupConfigRootForSignerExchange(configRootTrustStore, truststore.getLocation());
            String password2 = truststore.getPassword();
            String type2 = truststore.getType();
            String provider2 = truststore.getProvider();
            String scope2 = truststore.getManagementScope().getScopeName();
            boolean keystore2modified = false;
            KeyStore keyStore2 = this.getKeyStore(name2, type2, provider2, location2, password2, scope2, true, null);
            if (keyStore1 != null && keyStore2 != null) {
                Enumeration<String> alias1Enumeration = keyStore1.aliases();
                while (alias1Enumeration.hasMoreElements()) {
                    boolean exists;
                    String alias = alias1Enumeration.nextElement();
                    if (!keyStore1.isKeyEntry(alias)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key alias: " + alias);
                    }
                    Certificate[] signerChain = keyStore1.getCertificateChain(alias);
                    X509Certificate signer = (X509Certificate)signerChain[signerChain.length - 1];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Certificate DN: " + signer.getIssuerDN().getName());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Certificate S/N: " + signer.getSerialNumber());
                    }
                    if (!(exists = this.checkIfSignerAlreadyExistsInTrustStore(signer, keyStore2)) && !keyStore2.containsAlias(alias)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding alias \"" + alias + "\" from keystore \"" + location1 + "\" to keystore \"" + location2 + "\".");
                        }
                        keyStore2.setCertificateEntry(alias, signer);
                        keystore2modified = true;
                        continue;
                    }
                    if (exists) continue;
                    int num = 1;
                    String newAlias = null;
                    while (keyStore2.containsAlias(newAlias = alias + "_" + num++)) {
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + newAlias + "\" from keystore \"" + location1 + "\" to keystore \"" + location2 + "\".");
                    }
                    if (keyStore2.containsAlias(newAlias)) continue;
                    keyStore2.setCertificateEntry(newAlias, signer);
                    keystore2modified = true;
                }
                if (keystore2modified) {
                    if (type2 != null && (type2.equals("CMSKS") || type2.equals("IBMi5OSKeyStore"))) {
                        Class<?> cl1 = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                        Method theMethod1 = cl1.getMethod("storeCMSKeyStore", KeyStore.class, String.class, String.class, String.class, String.class);
                        theMethod1.invoke(cl1.newInstance(), keyStore2, location2, password2, type2, "true");
                    } else {
                        fos = new FileOutputStream(location2);
                        keyStore2.store(fos, password2.toCharArray());
                    }
                    this.clearJavaKeyStoresFromKeyStoreMap();
                }
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.KeyStoreManager.exchangeSigners", "1802", this, new Object[]{e});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception exchanging signers.", new Object[]{e});
            }
            Tr.error(tc, "ssl.signer.exchange.error.CWPKI0030E", new Object[]{e.getMessage()});
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exchangeSigners");
        }
    }

    public boolean checkIfSignerAlreadyExistsInTrustStore(X509Certificate signer, KeyStore trustStore) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkIfSignerAlreadyExistsInTrustStore");
            }
            try {
                String signerMD5Digest = this.generateDigest("MD5", signer);
                if (signerMD5Digest == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfSignerAlreadyExistsInTrustStore -> false (could not generate digest)");
                    }
                    return false;
                }
                Enumeration<String> aliases = trustStore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate cert;
                    String certMD5Digest;
                    String alias = aliases.nextElement();
                    if (!trustStore.containsAlias(alias) || !signerMD5Digest.equals(certMD5Digest = this.generateDigest("MD5", cert = (X509Certificate)trustStore.getCertificate(alias)))) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "checkIfSignerAlreadyExistsInTrustStore -> true (digest matches)");
                    }
                    return true;
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.KeyStoreManager.checkIfSignerAlreadyExistsInTrustStore", "1863", this, new Object[]{e});
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception checking if signer already exists.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfSignerAlreadyExistsInTrustStore -> false (no digest matches)");
        }
        return false;
    }

    private String fixupConfigRootForSignerExchange(String configRoot, String location) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupConfigRoot", new Object[]{configRoot, location});
        }
        String newPath = location;
        int index = location.indexOf("/cells/");
        if (index != -1) {
            String lastPart = location.substring(index);
            newPath = configRoot + lastPart;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupConfigRoot -> " + newPath);
        }
        return newPath;
    }

    public WSKeyStore getKeyStore(String keyStoreName, String keyStoreScopeName, Object sessionObject) {
        WSKeyStore wsks;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getKeyStore", new Object[]{keyStoreName, sessionObject});
            }
            wsks = null;
            try {
                Class<?> cl1 = Class.forName("com.ibm.ws.ssl.utils.ProfileKeystoreUtils");
                if (cl1 != null) {
                    Method theMethod1 = cl1.getMethod("getWSKeyStoreFromConfig", String.class, String.class, Object.class);
                    wsks = (WSKeyStore)theMethod1.invoke(null, keyStoreName, keyStoreScopeName, sessionObject);
                }
                if (wsks != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSKeyStore was successfully created.");
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.KeyStoreManager.getKeyStore", "1917", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Received the following exception while creating a keystore from the configuration.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStore");
        }
        return wsks;
    }

    public WSKeyStore getKeyStore(String keyStoreName) {
        WSKeyStore ks = (WSKeyStore)this.keyStoreMap.get(keyStoreName);
        if (ks != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning a keyStore for name: " + keyStoreName);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find a keyStore for name: " + keyStoreName);
            }
        }
        return ks;
    }

    public String[] getKeyStoreAliases() {
        return this.keyStoreMap.keySet().toArray(new String[0]);
    }

    public String[] getAcceleratorAliases() {
        return this.acceleratorMap.keySet().toArray(new String[0]);
    }

    public static String getKeyStoreType(KeyFileFormatKind type) {
        String keyFileFormat = null;
        if (type != null) {
            switch (type.getValue()) {
                case 2: {
                    keyFileFormat = "JCEKS";
                    break;
                }
                default: {
                    keyFileFormat = type.getName();
                }
            }
        }
        return keyFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getKeyStore(String name2, String type, String provider, String fileName, String password, String scope, boolean create, SSLConfig sslConfig) throws Exception {
        WSKeyStore keystore;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStore", new Object[]{name2, type, provider, fileName, scope, create, SSLConfigManager.mask(password)});
        }
        if (name2 != null && !create && (keystore = (WSKeyStore)this.keyStoreMap.get(name2)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKeyStore (from WSKeyStore)");
            }
            return keystore.getKeyStore(false, false);
        }
        KeyStore keyStore = null;
        FileOutputStream fos = null;
        InputStream inputStream = null;
        boolean not_finished = true;
        int retry_count = 0;
        boolean fileBased = true;
        ArrayList<Object> keyStoreTypes = new ArrayList();
        while (not_finished) {
            fileBased = !type.equals("JCERACFKS");
            if (!type.equals("CMSKS") && !type.equals("IBMi5OSKeyStore")) {
                keyStore = KeyStore.getInstance(type);
            }
            char[] passphrase = null;
            if (password != null) {
                passphrase = password.toCharArray();
            }
            try {
                Method theMethod1;
                Class<?> cl1;
                if (type != null && type.equals("PKCS11")) {
                    WSPKCSInKeyStore pKS;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating PKCS11 keystore.");
                    }
                    if ((pKS = pkcsStoreList.insert(type, fileName, password, false, provider, false)) == null) continue;
                    keyStore = pKS.getKS();
                    not_finished = false;
                    continue;
                }
                if (null == fileName) {
                    if (type != null && (type.equals("CMSKS") || type.equals("IBMi5OSKeyStore"))) {
                        Class<?> cl12 = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                        Method theMethod12 = cl12.getMethod("loadCMSKeyStore", File.class, String.class, String.class, String.class, String.class, String.class);
                        keyStore = (KeyStore)theMethod12.invoke(cl12.newInstance(), null, fileName, password, type, provider, "true");
                        not_finished = false;
                        continue;
                    }
                    keyStore.load(null, passphrase);
                    not_finished = false;
                    continue;
                }
                File f = new File(fileName);
                FileExistsAction action = new FileExistsAction(f);
                Boolean fileExists = (Boolean)AccessController.doPrivileged(action);
                if (!fileExists.booleanValue() && fileBased) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getKeyStore created new KeyStore: " + fileName);
                    }
                    if (type != null && (type.equals("CMSKS") || type.equals("IBMi5OSKeyStore"))) {
                        cl1 = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                        theMethod1 = cl1.getMethod("loadCMSKeyStore", File.class, String.class, String.class, String.class, String.class, String.class);
                        keyStore = (KeyStore)theMethod1.invoke(cl1.newInstance(), null, fileName, password, type, provider, "true");
                        not_finished = false;
                        continue;
                    }
                    keyStore.load(null, passphrase);
                    not_finished = false;
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getKeyStore created a new inputStream: " + fileName);
                }
                if (type != null && (type.equals("CMSKS") || type.equals("IBMi5OSKeyStore"))) {
                    cl1 = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                    theMethod1 = cl1.getMethod("loadCMSKeyStore", File.class, String.class, String.class, String.class, String.class, String.class);
                    keyStore = (KeyStore)theMethod1.invoke(cl1.newInstance(), f, fileName, password, type, provider, "true");
                    not_finished = false;
                    continue;
                }
                inputStream = this.getInputStream(fileName, create);
                keyStore.load(inputStream, passphrase);
                not_finished = false;
            }
            catch (IOException e) {
                if (e.getMessage().equalsIgnoreCase("Invalid keystore format") || e.getMessage().indexOf("DerInputStream.getLength()") != -1) {
                    if (retry_count == 0) {
                        String alias = "unknown";
                        if (sslConfig != null) {
                            alias = sslConfig.getProperty("com.ibm.ssl.alias");
                        }
                        Tr.warning(tc, "ssl.keystore.type.invalid.CWPKI0018W", new Object[]{type, alias});
                        keyStoreTypes = new ArrayList<String>(Security.getAlgorithms("KeyStore"));
                    }
                    if (retry_count >= keyStoreTypes.size()) {
                        throw e;
                    }
                    if (!(type = (String)keyStoreTypes.get(retry_count++)).equals("PKCS11") && !type.equals("IBMCMSKS")) continue;
                    type = (String)keyStoreTypes.get(retry_count++);
                    continue;
                }
                throw e;
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStore (from SSLConfig properties)");
        }
        return keyStore;
    }

    public InputStream getInputStream(String fileName, boolean create) throws MalformedURLException, IOException {
        try {
            GetKeyStoreInputStreamAction action = new GetKeyStoreInputStreamAction(fileName, create);
            return (InputStream)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.provider.AbstractJSSEProvider", "2173", this, new Object[]{ex});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", new Object[]{ex});
            }
            if (ex instanceof MalformedURLException) {
                throw (MalformedURLException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex.getMessage());
        }
    }

    public OutputStream getOutputStream(String fileName) throws MalformedURLException, IOException {
        try {
            GetKeyStoreOutputStreamAction action = new GetKeyStoreOutputStreamAction(fileName);
            return (OutputStream)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.KeyStoreManager.getOutputStream", "2247", this, new Object[]{ex});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", new Object[]{ex});
            }
            if (ex instanceof MalformedURLException) {
                throw (MalformedURLException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex.getMessage());
        }
    }

    public String generateDigest(String algorithmName, X509Certificate cert) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "generateDigest", new Object[]{algorithmName});
            }
            try {
                if (cert != null) {
                    DerOutputStream dos = new DerOutputStream();
                    dos.write(cert.getEncoded());
                    MessageDigest md = MessageDigest.getInstance(algorithmName);
                    md.update(dos.toByteArray());
                    byte[] ba = md.digest();
                    String hex = new HexDumpEncoder().encode(ba);
                    hex = hex.replaceAll("\\s", ":");
                    String[] hexDigits = hex.split(":");
                    if (hexDigits != null) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < hexDigits.length; ++i) {
                            if (hexDigits[i] == null || hexDigits[i].length() != 2) continue;
                            sb.append(hexDigits[i]);
                            sb.append(":");
                        }
                        sb.deleteCharAt(sb.length() - 1);
                        return sb.toString().toUpperCase();
                    }
                }
            }
            catch (NoClassDefFoundError e) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "generateDigest", new Object[]{e});
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.KeyStoreManager.generateDigest", "2394", this);
                if (!tc.isEntryEnabled()) break block8;
                Tr.exit(tc, "generateDigest", new Object[]{e});
            }
        }
        return null;
    }

    protected void clearKeyStoreMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearKeyStoreMap");
        }
        this.keyStoreMap.clear();
        this.acceleratorMap.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearKeyStoreMap");
        }
    }

    public void clearKSMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearKSMap");
        }
        this.keyStoreMap.clear();
        this.acceleratorMap.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearKSMap");
        }
    }

    protected void clearKeyStoreFromMap(String keyStoreName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearKeyStoreFromMap", new Object[]{keyStoreName});
        }
        this.keyStoreMap.remove(keyStoreName);
        this.acceleratorMap.remove(keyStoreName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearKeyStoreFromMap");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJavaKeyStoresFromKeyStoreMap() {
        HashMap hashMap = this.keyStoreMap;
        synchronized (hashMap) {
            for (Map.Entry entry : this.keyStoreMap.entrySet()) {
                WSKeyStore ws = (WSKeyStore)entry.getValue();
                if (ws == null) continue;
                ws.clearJavaKeyStore();
            }
        }
    }

    public String expand(String input) {
        String output;
        block39: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "expand");
            }
            String tempInput = input;
            output = null;
            String expand = null;
            output = (String)expandMap.get(tempInput);
            if (output != null && !output.equals("")) {
                output = output.replace('\\', '/');
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "expand -> " + output);
                }
                return output;
            }
            try {
                String userRoot;
                String lastPart;
                String firstPart;
                int index;
                if (SSLConfigManager.getInstance().isServerProcess()) {
                    if (input.indexOf("${CONFIG_ROOT}") != -1) {
                        expand = KeyStoreManager.getConfigRoot();
                        if (expand != null) {
                            expand = expand.replace('\\', '/');
                            output = input;
                            output = output.replaceAll("\\$\\{CONFIG_ROOT\\}", expand);
                        }
                        if (expand == null && (expand = KeyStoreManager.getUserInstallRoot()) != null) {
                            expand = expand + File.separator + "config";
                            expand = expand.replace('\\', '/');
                            output = input;
                            output = output.replaceAll("\\$\\{CONFIG_ROOT\\}", expand);
                        }
                    } else if (input.indexOf("${WORKSPACE_ROOT}") != -1) {
                        expand = (KeyStoreManager.getUserInstallRoot() != null ? KeyStoreManager.getUserInstallRoot() : System.getProperty("websphere.workspace.root")) + File.separator + "wstemp";
                        if (expand != null) {
                            expand = expand.replace('\\', '/');
                            output = input;
                            output = output.replaceAll("\\$\\{WORKSPACE_ROOT\\}", expand);
                        }
                    } else {
                        Class<?> SSLComponentImplClass = Class.forName("com.ibm.ws.ssl.core.SSLComponentImpl");
                        Method getStaticExpandMethod = SSLComponentImplClass.getMethod("expand", String.class);
                        output = (String)getStaticExpandMethod.invoke(null, tempInput);
                    }
                    tempInput = output;
                }
                if ((index = tempInput.indexOf("${user.root}")) != -1) {
                    firstPart = tempInput.substring(0, index);
                    lastPart = tempInput.substring(index + "${user.root}".length());
                    userRoot = SSLConfigManager.getInstance().getGlobalProperty("user.root");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "User install root: " + userRoot);
                    }
                    if (userRoot != null) {
                        output = firstPart != null && !firstPart.equals("") ? firstPart + userRoot + lastPart : userRoot + lastPart;
                        tempInput = output;
                    }
                }
                if ((index = tempInput.indexOf("${USER_INSTALL_ROOT}")) != -1) {
                    firstPart = tempInput.substring(0, index);
                    lastPart = tempInput.substring(index + "${USER_INSTALL_ROOT}".length());
                    userRoot = SSLConfigManager.getInstance().getGlobalProperty("user.root");
                    if (userRoot == null) {
                        userRoot = SSLConfigManager.getInstance().getGlobalProperty("user.install.root");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "User install root: " + userRoot);
                    }
                    if (userRoot != null) {
                        output = firstPart != null && !firstPart.equals("") ? firstPart + userRoot + lastPart : userRoot + lastPart;
                        tempInput = output;
                    }
                }
                if ((index = tempInput.indexOf("${hostname}")) != -1) {
                    firstPart = tempInput.substring(0, index);
                    lastPart = tempInput.substring(index + "${hostname}".length());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Hostname: " + host);
                    }
                    if (host != null) {
                        tempInput = output = firstPart + host + lastPart;
                    }
                }
                if ((index = tempInput.indexOf("${CONFIG_ROOT}")) != -1) {
                    firstPart = tempInput.substring(0, index);
                    lastPart = tempInput.substring(index + "${CONFIG_ROOT}".length());
                    userRoot = SSLConfigManager.getInstance().getGlobalProperty("was.repository.root");
                    if (userRoot == null && (userRoot = KeyStoreManager.getUserInstallRoot()) != null) {
                        userRoot = userRoot + File.separator + "config";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "User install root: " + userRoot);
                    }
                    if (userRoot != null) {
                        output = firstPart != null && !firstPart.equals("") ? firstPart + userRoot + lastPart : userRoot + lastPart;
                        tempInput = output;
                    }
                }
                if ((index = tempInput.indexOf("${WORKSPACE_ROOT}")) != -1) {
                    firstPart = tempInput.substring(0, index);
                    lastPart = tempInput.substring(index + "${WORKSPACE_ROOT}".length());
                    userRoot = null;
                    if (SSLConfigManager.getInstance().getGlobalProperty("websphere.workspace.root") != null) {
                        userRoot = SSLConfigManager.getInstance().getGlobalProperty("websphere.workspace.root");
                    } else if (userRoot == null && SSLConfigManager.getInstance().getGlobalProperty("user.root") != null) {
                        userRoot = SSLConfigManager.getInstance().getGlobalProperty("user.root") + File.separator + "wstemp";
                    } else if (userRoot == null) {
                        userRoot = KeyStoreManager.getUserInstallRoot() + File.separator + "wstemp";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "${WORKSPACE_ROOT} = " + userRoot);
                    }
                    if (userRoot != null) {
                        output = firstPart != null && !firstPart.equals("") ? firstPart + userRoot + lastPart : userRoot + lastPart;
                        tempInput = output;
                    }
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.KeyStoreManager.expand", "2636", this);
                if (!tc.isDebugEnabled()) break block39;
                Tr.debug(tc, "Expand exception: ", new Object[]{e});
            }
        }
        if (output != null) {
            output = output.replace('\\', '/');
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "expand -> " + output);
            }
            if (expandMap.size() > 50) {
                expandMap.clear();
                KeyStoreManager.getHostName();
            }
            expandMap.put(input, output);
            return output;
        }
        input = input.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expand -> (not expanded)");
        }
        return input;
    }

    public static String getHostName() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getHostName");
            }
            try {
                if (host == null && (host = InetAddress.getLocalHost().getCanonicalHostName()) != null) {
                    expandMap.put("cn=${hostname},o=IBM,c=US", "cn=" + host + ",o=IBM,c=US");
                    expandMap.put("${hostname}", host);
                }
            }
            catch (UnknownHostException e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception getting canonical hostname.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHostName -> " + host);
        }
        return host;
    }

    public Boolean createPluginKeyStore(String hostname, String webServerDirectoryURI) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPluginKeyStore", new Object[]{hostname, webServerDirectoryURI});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPluginKeyStore");
        }
        return Boolean.TRUE;
    }

    public static String expandHostNameVariable(String subjectDN, String nodeHostName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandHostNameVariable", new Object[]{subjectDN, nodeHostName});
        }
        String expandedSubjectDN = subjectDN;
        int index1 = subjectDN.indexOf("${hostname}");
        if (index1 != -1) {
            String firstPart = subjectDN.substring(0, index1);
            String lastPart = subjectDN.substring(index1 + "${hostname}".length());
            if (firstPart != null && !firstPart.equals("") && lastPart != null && !lastPart.equals("")) {
                expandedSubjectDN = firstPart + nodeHostName + lastPart;
            } else if (firstPart != null && !firstPart.equals("")) {
                expandedSubjectDN = firstPart + nodeHostName;
            } else if (lastPart != null && !lastPart.equals("")) {
                expandedSubjectDN = nodeHostName + lastPart;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandHostNameVariable -> " + expandedSubjectDN);
        }
        return expandedSubjectDN;
    }

    private static String fixupLocationWithRepositoryRoot(String repositoryRoot, String location) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupLocationWithRepositoryRoot", new Object[]{repositoryRoot, location});
        }
        int index = location.indexOf("/cells/");
        String newPath = location;
        if (index != -1) {
            String lastPart = location.substring(index);
            newPath = repositoryRoot + lastPart;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupLocationWithRepositoryRoot -> " + newPath);
        }
        return newPath;
    }

    public boolean isHWKeyStore(String keyStoreName) {
        String isToken = "false";
        WSKeyStore wsks = (WSKeyStore)this.keyStoreMap.get(keyStoreName);
        if (wsks != null) {
            isToken = wsks.getProperty("com.ibm.ssl.tokenEnabled");
        }
        return "true".equalsIgnoreCase(isToken);
    }

    public Provider getHWCryptoProviderInstance(String keyStoreName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHWCryptoProviderInstance");
        }
        WSPKCSInKeyStore pKS = null;
        Provider p = null;
        WSKeyStore wsks = (WSKeyStore)this.keyStoreMap.get(keyStoreName);
        boolean pureAcceleration = false;
        if (wsks != null) {
            String keyStoreFile = wsks.getProperty("com.ibm.ssl.keyStore");
            String keyStorePassword = wsks.getProperty("com.ibm.ssl.keyStorePassword");
            String keyStoreType = wsks.getProperty("com.ibm.ssl.keyStoreType");
            String keyStoreProvider = wsks.getProperty("com.ibm.ssl.keyStoreProvider");
            String useForAcceleration = wsks.getProperty("com.ibm.ssl.keyStoreUseForAcceleration");
            try {
                if (useForAcceleration != null && useForAcceleration.equals("true")) {
                    pureAcceleration = true;
                }
                pKS = pkcsStoreList.insert(keyStoreType, keyStoreFile, keyStorePassword, true, keyStoreProvider, pureAcceleration);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot get the HW crypto initialization status" + new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.KeyStoreManager.getHWCryptoProviderInstance", "2793", this);
                Tr.error(tc, "Cannot get the HW crypto initialization status", new Object[]{e.getMessage()});
            }
            if (pKS != null) {
                try {
                    p = pKS.getHWCryptoProviderInstance(keyStoreFile);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cannot get the HW crypto provider instance" + new Object[]{e});
                    }
                    Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.config.KeyStoreManager.getHWCryptoProviderInstance", "2805", this);
                    Tr.error(tc, "Cannot get the HW crypto provider instance", new Object[]{e.getMessage()});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHWCryptoProviderInstance");
        }
        return p;
    }

    public void returnHWCryptoProviderInstance(String keyStoreName, Provider hwProvider) {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "returnHWCryptoProviderInstance");
            }
            WSPKCSInKeyStore pKS = null;
            WSKeyStore wsks = (WSKeyStore)this.keyStoreMap.get(keyStoreName);
            if (wsks != null) {
                block8: {
                    String keyStoreFile = wsks.getProperty("com.ibm.ssl.keyStore");
                    try {
                        pKS = pkcsStoreList.getListElement(keyStoreFile);
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block8;
                        Tr.debug(tc, "Cannot get the HW crypto keystore list element" + new Object[]{keyStoreFile, e});
                    }
                }
                if (pKS != null) {
                    try {
                        pKS.returnHWCryptoProviderInstance(hwProvider);
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "Cannot return provider instance" + new Object[]{e});
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnHWCryptoProviderInstance");
        }
    }

    public static SecurityConfigObject getDefaultKeyStore(String defaultKeyStoreSuffix, String managementScope) {
        SecurityConfigObject keyStore;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDefaultKeyStore");
            }
            if (managementScope == null) {
                managementScope = ManagementScopeManager.getInstance().getNodeScopeName();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Selected default scope: " + managementScope);
            }
            String keyStoreName = KeyStoreManager.getDefaultKeyStoreName(defaultKeyStoreSuffix);
            keyStore = null;
            try {
                SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
                if (scm == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SecurityConfigManager is null.");
                    }
                    return null;
                }
                SecurityConfigObjectList keyStores = scm.getObjectList("security::keyStores");
                if (keyStores != null) {
                    for (int i = 0; i < keyStores.size(); ++i) {
                        keyStore = keyStores.get(i);
                        String name2 = keyStore.getString("name");
                        SecurityConfigObject myScope = keyStore.getObject("managementScope");
                        String scope = myScope.getString("scopeName");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking name and scope: " + name2 + ":" + scope);
                        }
                        if (keyStoreName != null && name2.equals(keyStoreName) && scope != null && scope.equals(managementScope)) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "getDefaultKeyStore", new Object[]{name2});
                            }
                            return keyStore;
                        }
                        keyStore = null;
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Unable to get the DefaultKeyStore " + keyStoreName, new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultKeyStore", new Object[]{keyStore});
        }
        return keyStore;
    }

    public static String getDefaultKeyStoreName(String defaultKeyStoreSuffix) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultKeyStoreName");
        }
        String processType = ManagementScopeManager.getInstance().getProcessType();
        String keyStoreName = null;
        if (processType.equals("client")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDefaultKeyStoreName", null);
            }
            return null;
        }
        keyStoreName = processType.equals("UnManagedProcess") || processType.equals("AdminAgent") || processType.equals("JobManager") ? "Node" + defaultKeyStoreSuffix : (defaultKeyStoreSuffix.equalsIgnoreCase("DefaultKeyStore") || defaultKeyStoreSuffix.equalsIgnoreCase("DefaultTrustStore") || defaultKeyStoreSuffix.equalsIgnoreCase("RSATokenKeyStore") || defaultKeyStoreSuffix.equalsIgnoreCase("RSATokenTrustStore") ? "Cell" + defaultKeyStoreSuffix : "Dmgr" + defaultKeyStoreSuffix);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultKeyStoreName", keyStoreName);
        }
        return keyStoreName;
    }

    public static SecurityConfigObject getKeyStore(String keyStoreName, String managementScope) {
        SecurityConfigObject keyStore;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getKeyStore");
            }
            if (managementScope == null) {
                String type = ManagementScopeManager.getInstance().getProcessType();
                managementScope = type.equals("DeploymentManager") ? ManagementScopeManager.getInstance().getCellScopeName() : ManagementScopeManager.getInstance().getNodeScopeName();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Selected default scope: " + managementScope);
            }
            keyStore = null;
            try {
                SecurityConfig secConfig = SecurityObjectLocator.getSecurityConfig();
                SecurityConfigObjectList keyStores = secConfig.getSCO().getObjectList("keyStores");
                if (keyStores != null) {
                    for (int i = 0; i < keyStores.size(); ++i) {
                        keyStore = keyStores.get(i);
                        String name2 = keyStore.getString("name");
                        SecurityConfigObject myScope = keyStore.getObject("managementScope");
                        String scope = myScope.getString("scopeName");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking name and scope: " + name2 + ":" + scope);
                        }
                        if (keyStoreName != null && name2.equals(keyStoreName) && scope != null && scope.equals(managementScope)) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "getDefaultKeyStore", new Object[]{name2});
                            }
                            return keyStore;
                        }
                        keyStore = null;
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Unable to get key store " + keyStoreName, new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStore", new Object[]{keyStore});
        }
        return keyStore;
    }

    public static String getUserInstallRoot() {
        return KeyStoreManager.stripLastSlash(SecurityObjectLocator.getAdminData().getUserInstallRootPath());
    }

    public static String getConfigRoot() {
        return KeyStoreManager.stripLastSlash(SecurityObjectLocator.getAdminData().getConfigRootPath());
    }

    public static String stripLastSlash(String inputString) {
        if (inputString != null && ((inputString = inputString.trim()).endsWith("/") || inputString.endsWith("\\"))) {
            return inputString.substring(0, inputString.length() - 1);
        }
        return inputString;
    }

    static {
        pkcsStoreList = new WSPKCSInKeyStoreList();
    }

    class FileExistsAction
    implements PrivilegedAction {
        private File file = null;

        public FileExistsAction(File input_file) {
            this.file = input_file;
        }

        public Object run() {
            try {
                return this.file.exists();
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
    }

    class GetKeyStoreOutputStreamAction
    implements PrivilegedExceptionAction {
        private String file = null;

        public GetKeyStoreOutputStreamAction(String fileName) {
            this.file = fileName;
        }

        public Object run() throws MalformedURLException, IOException {
            File kfile;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "GetKeyStoreOutputStreamAction.run", new Object[]{this.file});
            }
            OutputStream fos = null;
            if (this.file.startsWith("safkeyring://")) {
                URL ring = new URL(this.file);
                URLConnection ringConnect = ring.openConnection();
                fos = ringConnect.getOutputStream();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "GetKeyStoreOutputStreamAction.run (safkeyring)");
                }
                return fos;
            }
            try {
                URL conversionURL = new URL(this.file);
                this.file = conversionURL.getFile();
                while (this.file.startsWith("/")) {
                    this.file = this.file.substring(1);
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "File path for OutputStream: " + this.file);
            }
            if ((kfile = new File(this.file)).exists() && !kfile.canWrite()) {
                throw new IOException("Cannot write to KeyStore file: " + this.file);
            }
            fos = new FileOutputStream(kfile);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "GetKeyStoreOutputStreamAction.run");
            }
            return fos;
        }
    }

    class GetKeyStoreInputStreamAction
    implements PrivilegedExceptionAction {
        private String file = null;
        private boolean createStream = false;

        public GetKeyStoreInputStreamAction(String fileName, boolean create) {
            this.file = fileName;
            this.createStream = create;
        }

        public Object run() throws MalformedURLException, IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "GetKeyStoreInputStreamAction.run");
            }
            InputStream fis = null;
            URL urlFile = null;
            File kfile = new File(this.file);
            if (this.createStream && !kfile.exists()) {
                kfile.createNewFile();
                urlFile = kfile.toURL();
            } else {
                if (kfile.exists() && kfile.length() == 0L) {
                    throw new IOException("Keystore file exists, but is empty: " + this.file);
                }
                urlFile = !kfile.exists() ? new URL(this.file) : kfile.toURL();
            }
            fis = urlFile.openStream();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "GetKeyStoreInputStreamAction.run");
            }
            return fis;
        }
    }
}

