/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.ssl.JSSEProviderFactory;
import java.util.List;
import java.util.Properties;

public class KeyManagerData {
    private static final TraceComponent tc = Tr.register(KeyManagerData.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    String kmName;
    String kmProvider;
    String kmAlgorithm;
    String kmCustomClass;
    Properties kmCustomProps;
    String kmScope;

    public KeyManagerData(String name2, String provider, String algorithm, String customClass, Properties customAttributes, String scope) {
        this.kmName = name2;
        this.kmProvider = provider;
        this.kmAlgorithm = algorithm;
        this.kmCustomClass = customClass;
        this.kmCustomProps = customAttributes;
        this.kmScope = scope;
    }

    public Properties convertListToProperties(List customAttributes) {
        if (customAttributes != null) {
            Properties props = new Properties();
            for (Property prop : customAttributes) {
                if (prop == null) continue;
                props.setProperty(prop.getName(), prop.getValue());
            }
            return props;
        }
        return null;
    }

    public String getName() {
        return this.kmName;
    }

    public void setName(String s) {
        this.kmName = s;
    }

    public String getProvider() {
        return this.kmProvider;
    }

    public void setProvider(String s) {
        this.kmProvider = s;
    }

    public String getAlgorithm() {
        return this.kmAlgorithm;
    }

    public void setAlgorithm(String s) {
        this.kmAlgorithm = s;
    }

    public String getKeyManagerClass() {
        return this.kmCustomClass;
    }

    public void setKeyManagerClass(String s) {
        this.kmCustomClass = s;
    }

    public Properties getAdditionalKeyManagerAttrs() {
        return this.kmCustomProps;
    }

    public void setAdditionalKeyManagerAttrs(List attributes) {
        this.kmCustomProps = this.convertListToProperties(attributes);
    }

    public String getManagementScope() {
        return this.kmScope;
    }

    public void setManagementScope(String scope) {
        this.kmScope = scope;
    }

    public String getKeyManagerString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyManagerString");
        }
        if (this.kmCustomClass != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKeyManagerString -> " + this.kmCustomClass);
            }
            return this.kmCustomClass;
        }
        if (this.kmAlgorithm != null && this.kmProvider != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKeyManagerString -> " + this.kmAlgorithm + "|" + this.kmProvider);
            }
            return this.kmAlgorithm + "|" + this.kmProvider;
        }
        if (this.kmAlgorithm != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKeyManagerString -> " + this.kmAlgorithm);
            }
            return this.kmAlgorithm;
        }
        String keyManager = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyManagerString (default) -> " + keyManager);
        }
        return keyManager;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("KeyManagerData: name=");
        sb.append(this.kmName);
        sb.append(", algorithm=");
        sb.append(this.kmAlgorithm);
        sb.append(", provider=");
        sb.append(this.kmProvider);
        sb.append(", customClass=");
        sb.append(this.kmCustomClass);
        sb.append(", scope=");
        sb.append(this.kmScope);
        return sb.toString();
    }
}

