/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.cmskeystore.CMSLoadStoreParameterFactory;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.File;
import java.lang.reflect.Constructor;
import java.security.KeyStore;

public class CMSKeyStoreUtility {
    private static final TraceComponent tc = Tr.register(CMSKeyStoreUtility.class, "SSL", "com.ibm.ws.ssl.resources.ssl");

    public void storeCMSKeyStore(KeyStore ks, String SSLKeyFile, String SSLKeyPassword, String SSLKeyStoreType, String SSLKeyStoreStash) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "storeCMSKeyStore");
        }
        KeyStore.LoadStoreParameter loadParm = null;
        File sslKeyFile = new File(SSLKeyFile);
        if (PlatformHelperFactory.getPlatformHelper().isOS400() && System.getProperty("java.vm.name").equals("Classic VM")) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> permClass = null;
                permClass = cl != null ? cl.loadClass("com.ibm.i5os.keystore.i5OSLoadStoreParameter") : Class.forName("com.ibm.i5os.keystore.i5OSLoadStoreParameter");
                KeyStore.PasswordProtection protection = new KeyStore.PasswordProtection(SSLKeyPassword.toCharArray());
                Constructor<?> constructor = permClass.getConstructor(File.class, KeyStore.PasswordProtection.class);
                loadParm = (KeyStore.LoadStoreParameter)constructor.newInstance(sslKeyFile, protection);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not load iSeries LoadStoreParameter to store the CMS keystore.", new Object[]{e});
                }
                throw new SSLException(e.getMessage(), e);
            }
        } else if (SSLKeyStoreType.equals("CMSKS") && SSLKeyStoreStash != null && SSLKeyStoreStash.equals("true")) {
            loadParm = CMSLoadStoreParameterFactory.newCMSStoreParameter((File)sslKeyFile, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(SSLKeyPassword.toCharArray()), (boolean)true);
        } else if (SSLKeyStoreType.equals("CMSKS")) {
            loadParm = CMSLoadStoreParameterFactory.newCMSStoreParameter((File)sslKeyFile, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(SSLKeyPassword.toCharArray()), (boolean)false);
        }
        if (loadParm != null) {
            try {
                ks.store(loadParm);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not store the keystore.", new Object[]{e});
                }
                throw new SSLException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "storeCMSKeyStore");
        }
    }

    public KeyStore loadCMSKeyStore(File kFile, String keyStoreLocation, String SSLKeyPassword, String SSLKeyStoreType, String SSLKeyStoreProvider, String SSLKeyStoreStash) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCMSKeyStore");
        }
        KeyStore ks1 = null;
        try {
            KeyStore.LoadStoreParameter loadParm = null;
            if (PlatformHelperFactory.getPlatformHelper().isOS400() && System.getProperty("java.vm.name").equals("Classic VM")) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> permClass = null;
                permClass = cl != null ? cl.loadClass("com.ibm.i5os.keystore.i5OSLoadStoreParameter") : Class.forName("com.ibm.i5os.keystore.i5OSLoadStoreParameter");
                KeyStore.PasswordProtection protection = new KeyStore.PasswordProtection(SSLKeyPassword.toCharArray());
                Constructor<?> constructor = permClass.getConstructor(File.class, KeyStore.PasswordProtection.class);
                loadParm = (KeyStore.LoadStoreParameter)constructor.newInstance(kFile, protection);
            } else if (SSLKeyStoreType.equals("CMSKS") && SSLKeyStoreStash != null && SSLKeyStoreStash.equals("true")) {
                loadParm = CMSLoadStoreParameterFactory.newCMSLoadParameter((File)kFile, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(SSLKeyPassword.toCharArray()));
            } else if (SSLKeyStoreType.equals("CMSKS")) {
                loadParm = CMSLoadStoreParameterFactory.newCMSLoadParameter((File)kFile, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(SSLKeyPassword.toCharArray()));
            }
            if (loadParm != null) {
                JSSEProvider jsseProvider = JSSEProviderFactory.getInstance(SSLKeyStoreProvider);
                ks1 = jsseProvider.getKeyStoreInstance(SSLKeyStoreType, SSLKeyStoreProvider);
                ks1.load(loadParm);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception loading the CMS keystore.", new Object[]{e});
            }
            throw new SSLException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCMSKeyStore");
        }
        return ks1;
    }
}

