/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.channel.exception.ReadNeededInternalException;
import com.ibm.ws.ssl.channel.exception.SessionClosedException;
import com.ibm.ws.ssl.channel.impl.SSLBaseServiceContext;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SSLReadServiceContext
extends SSLBaseServiceContext
implements TCPReadRequestContext {
    protected static final TraceComponent tc = Tr.register(SSLReadServiceContext.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.impl.SSLReadServiceContext";
    protected TCPReadCompletedCallback callback = null;
    private boolean callerRequiredAllocation = false;
    private int jITAllocateSize = 0;
    protected WsByteBuffer netBuffer = null;
    private WsByteBuffer[] decryptedNetBuffers = null;
    private int[] decryptedNetLimitInfo = null;
    private int[] decryptedNetPosInfo = new int[1];
    private WsByteBuffer[] unconsumedDecData = null;
    private boolean decryptedNetBufferReleaseRequired = false;
    protected TCPReadRequestContext deviceReadContext;
    protected long bytesProduced = 0L;
    protected long bytesRequested = 0L;
    protected int netBufferMark = 0;
    private QueuedWork queuedWork = null;
    private SSLReadCompletedCallback readCallback = null;
    private ReadNeededInternalException readNeededInternalException = null;
    private SessionClosedException sessionClosedException = null;

    public SSLReadServiceContext(SSLConnectionLink connLink) {
        super(connLink);
        this.queuedWork = new QueuedWork();
        this.readCallback = new SSLReadCompletedCallback(this);
        this.readNeededInternalException = new ReadNeededInternalException("All available data read, but more needed, read again");
        this.sessionClosedException = new SessionClosedException("SSL engine is closed");
    }

    private void saveDecryptedPositions() {
        for (int i = 0; i < this.decryptedNetPosInfo.length; ++i) {
            this.decryptedNetPosInfo[i] = 0;
        }
        if (null != this.getBuffers()) {
            WsByteBuffer[] buffers = this.getBuffers();
            if (buffers.length > this.decryptedNetPosInfo.length) {
                this.decryptedNetPosInfo = new int[buffers.length];
            }
            for (int i = 0; i < buffers.length && null != buffers[i]; ++i) {
                this.decryptedNetPosInfo[i] = buffers[i].position();
            }
        }
    }

    public SSLReadServiceContext() {
    }

    public long read(long numBytes, int timeout) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "read, numbytes=" + numBytes + ", vc=" + this.getVCHash());
        }
        if (this.deviceReadContext == null) {
            this.deviceReadContext = this.getConnLink().getDeviceReadInterface();
        }
        if (timeout == -2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Requested to timeout former request.  Calling device side.");
            }
            this.deviceReadContext.read(numBytes, timeout);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "read");
            }
            return 0L;
        }
        this.decryptedNetBufferReleaseRequired = false;
        this.callerRequiredAllocation = false;
        IOException exceptionInRequest = this.checkRequest(numBytes, false);
        if (exceptionInRequest != null) {
            throw exceptionInRequest;
        }
        this.bytesRequested = numBytes;
        this.saveDecryptedPositions();
        this.bytesProduced = this.readUnconsumedDecData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Decrypted data left over from previous request: " + this.bytesProduced);
        }
        if (this.bytesRequested > this.bytesProduced || this.bytesRequested == 0L) {
            long devBytesRead = 0L;
            int loopCount = 0;
            long encryptedBytesAvailable = 0L;
            long bufferSize = 0L;
            if (this.bytesProduced > 0L) {
                SSLUtils.positionToLimit(this.decryptedNetBuffers);
                SSLUtils.limitToCapacity(this.decryptedNetBuffers);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adjusted left over decNetBuffers: " + SSLUtils.getBufferTraceInfo(this.decryptedNetBuffers));
                }
            }
            if (null != this.netBuffer) {
                encryptedBytesAvailable = this.netBuffer.remaining();
            }
            if (this.bytesRequested != 0L) {
                bufferSize = this.bytesRequested - this.bytesProduced;
            }
            this.getNetworkBuffer(bufferSize);
            while (this.bytesProduced < this.bytesRequested || this.bytesRequested == 0L) {
                if (encryptedBytesAvailable > 0L && ++loopCount == 1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No read needed.  Encrypted bytes already available: " + encryptedBytesAvailable);
                    }
                } else {
                    this.netBuffer.limit(this.netBuffer.capacity());
                    long deviceReadRequestSize = 0L;
                    if (this.bytesRequested != 0L && this.bytesRequested > this.bytesProduced) {
                        deviceReadRequestSize = this.bytesRequested - this.bytesProduced - encryptedBytesAvailable;
                        if (0L >= deviceReadRequestSize) {
                            deviceReadRequestSize = 1L;
                        }
                    } else {
                        deviceReadRequestSize = this.bytesRequested == 0L ? 0L : 1L;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "do sync read of : " + deviceReadRequestSize + " bytes into netBuffer..." + SSLUtils.getBufferTraceInfo(this.netBuffer));
                    }
                    try {
                        if (deviceReadRequestSize == 0L && (devBytesRead += this.deviceReadContext.read(deviceReadRequestSize, timeout)) == 0L) {
                            this.bytesProduced = 0L;
                            this.netBuffer.limit(this.netBuffer.position());
                            this.netBuffer.position(this.netBufferMark);
                            break;
                        }
                    }
                    catch (IOException e) {
                        this.netBuffer.limit(this.netBuffer.position());
                        this.netBuffer.position(this.netBufferMark);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Reset buffers after read error: vc=" + this.getVCHash() + ", netBuffer: " + SSLUtils.getBufferTraceInfo(this.netBuffer));
                        }
                        throw e;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "read bytes (total): " + devBytesRead);
                    }
                }
                this.netBuffer.limit(this.netBuffer.position());
                this.netBuffer.position(this.netBufferMark);
                Exception exception = this.decryptMessage(false, false);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, this.bytesProduced + " bytes produced of " + this.bytesRequested + " bytes requested");
                }
                encryptedBytesAvailable = this.netBuffer.remaining();
                if (exception == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Decryption succeeded.");
                    }
                    if (0L == this.bytesRequested) break;
                    if (this.bytesProduced >= this.bytesRequested) continue;
                    this.getNetworkBuffer(this.bytesRequested - this.bytesProduced);
                    continue;
                }
                if (exception instanceof ReadNeededInternalException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "More data needs to be read, loop to another read");
                    }
                    if (0L == this.bytesRequested) break;
                    this.getNetworkBuffer(this.bytesRequested - this.bytesProduced);
                    continue;
                }
                if (exception instanceof SessionClosedException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "SSL Session has been closed.");
                    }
                    throw new IOException("SSL connection was closed by peer");
                }
                FFDCFilter.processException((Throwable)exception, CLASS_NAME, "118", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Decryption unsuccessful, exception resulted: " + exception);
                }
                IOException exc = new IOException("Unable to decrypt message");
                exc.initCause(exception);
                throw exc;
            }
        }
        if (this.bytesProduced > 0L) {
            this.prepareDataForNextChannel();
            WsByteBuffer[] buffers = this.getBuffers();
            long count = 0L;
            for (int i = 0; i < buffers.length && count < this.bytesProduced; count += (long)(buffers[i].limit() - this.decryptedNetPosInfo[i]), ++i) {
            }
            this.bytesProduced = count;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "read: " + this.bytesProduced);
        }
        return this.bytesProduced;
    }

    public VirtualConnection read(long numBytes, TCPReadCompletedCallback userCallback, boolean forceQueue, int timeout) {
        return this.read(numBytes, userCallback, forceQueue, timeout, false);
    }

    protected VirtualConnection read(long numBytes, TCPReadCompletedCallback userCallback, boolean forceQueue, int timeout, boolean fromQueue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readAsynch, numBytes=" + numBytes + ", fromQueue=" + fromQueue + ", vc=" + this.getVCHash());
        }
        if (this.deviceReadContext == null) {
            this.deviceReadContext = this.getConnLink().getDeviceReadInterface();
        }
        if (timeout == -2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Requested to timeout former request.  Calling device side.");
            }
            this.readCallback.setCallBack(userCallback);
            this.deviceReadContext.read(numBytes, this.readCallback, forceQueue, timeout);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "readAsynch");
            }
            return this.getVC();
        }
        this.decryptedNetBufferReleaseRequired = false;
        this.callerRequiredAllocation = false;
        IOException exceptionInRequest = this.checkRequest(numBytes, true);
        if (exceptionInRequest != null) {
            this.handleAsyncError(forceQueue, exceptionInRequest, userCallback);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "readAsynch");
            }
            return null;
        }
        this.callback = userCallback;
        VirtualConnection vc = null;
        this.bytesRequested = numBytes;
        this.bytesProduced = this.readUnconsumedDecData();
        long bytesToRead = this.bytesRequested - this.bytesProduced;
        boolean requestSatisfied = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Data left over from previous request: " + this.bytesProduced);
        }
        if (this.bytesRequested > this.bytesProduced || this.bytesRequested == 0L) {
            WsByteBuffer deviceBuffer;
            if (this.deviceReadContext == null) {
                this.deviceReadContext = this.getConnLink().getDeviceReadInterface();
            }
            if (this.bytesProduced > 0L) {
                SSLUtils.positionToLimit(this.decryptedNetBuffers);
                SSLUtils.limitToCapacity(this.decryptedNetBuffers);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adjusted left over decNetBuffers: " + SSLUtils.getBufferTraceInfo(this.decryptedNetBuffers));
                }
            }
            if (null != (deviceBuffer = this.deviceReadContext.getBuffer()) && 0 != deviceBuffer.position() && 0 != deviceBuffer.remaining()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found data in existing network buffer, " + SSLUtils.getBufferTraceInfo(deviceBuffer));
                }
                this.netBuffer = deviceBuffer;
                vc = this.getConnLink().getVirtualConnection();
            } else {
                bytesToRead = this.bytesRequested == 0L ? 0L : this.bytesRequested - this.bytesProduced;
                this.getNetworkBuffer(bytesToRead);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "do async read of : " + bytesToRead + " bytes");
                }
                this.readCallback.setCallBack(userCallback);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling device side read with netBuffers, " + SSLUtils.getBufferTraceInfo(this.netBuffer));
                }
                if ((vc = this.deviceReadContext.read(bytesToRead, this.readCallback, forceQueue, timeout)) != null) {
                    this.netBuffer.limit(this.netBuffer.position());
                    this.netBuffer.position(this.netBufferMark);
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Left over data was enough to satisfy the request.");
            }
            vc = this.getConnLink().getVirtualConnection();
            requestSatisfied = true;
            this.prepareDataForNextChannel();
        }
        if (!requestSatisfied && vc != null) {
            boolean bCont;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Data is ready, no callback necessary.");
            }
            Exception exception = null;
            do {
                bCont = false;
                exception = this.decryptMessage(true, forceQueue);
                if (exception == null) {
                    this.prepareDataForNextChannel();
                    continue;
                }
                if (exception instanceof ReadNeededInternalException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "More data needs to be read. vc=" + this.getVCHash());
                    }
                    this.getNetworkBuffer(1L);
                    this.readCallback.setCallBack(userCallback);
                    vc = this.deviceReadContext.read(1L, this.readCallback, forceQueue, timeout);
                    if (vc == null) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Read done. No callback necessary, buffers " + SSLUtils.getBufferTraceInfo(this.netBuffer));
                    }
                    this.netBuffer.limit(this.netBuffer.position());
                    this.netBuffer.position(this.netBufferMark);
                    bCont = true;
                    continue;
                }
                if (exception instanceof SessionClosedException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "SSL Session has been closed.");
                    }
                    this.handleAsyncError(forceQueue, new IOException("SSL connection closed by peer"), userCallback);
                    vc = null;
                    continue;
                }
                FFDCFilter.processException((Throwable)exception, CLASS_NAME, "192", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception during unwrap, " + exception);
                }
                IOException ioe = new IOException("SSL decryption failed");
                ioe.initCause(exception);
                this.handleAsyncError(forceQueue, ioe, userCallback);
                vc = null;
            } while (bCont);
        }
        if (vc != null && (fromQueue || forceQueue)) {
            this.handleAsyncComplete(forceQueue, this.callback);
            vc = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readAsynch");
        }
        return vc;
    }

    private void handleAsyncComplete(boolean forceQueue, TCPReadCompletedCallback inCallback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleAsyncComplete");
        }
        if (forceQueue) {
            this.queuedWork.setCompleteParameters(this.getConnLink().getVirtualConnection(), this, inCallback);
            ChannelException errorCause = null;
            try {
                int executeRc = this.getConnLink().getThreadPool().execute(this.queuedWork, 2);
                if (executeRc != 0) {
                    errorCause = new ChannelException("threadpool at capacity, request rejected");
                }
            }
            catch (ChannelException ce) {
                errorCause = ce;
            }
            if (errorCause != null) {
                FFDCFilter.processException((Throwable)errorCause, CLASS_NAME, "471", this);
                inCallback.error(this.getConnLink().getVirtualConnection(), this, new IOException(errorCause.toString()));
            }
        } else {
            inCallback.complete(this.getConnLink().getVirtualConnection(), this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleAsyncComplete");
        }
    }

    private void handleAsyncError(boolean forceQueue, IOException exception, TCPReadCompletedCallback inCallback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleAsyncError");
        }
        if (forceQueue) {
            this.queuedWork.setErrorParameters(this.getConnLink().getVirtualConnection(), this, inCallback, exception);
            ChannelException errorCause = null;
            try {
                int executeRc = this.getConnLink().getThreadPool().execute(this.queuedWork, 2);
                if (executeRc != 0) {
                    errorCause = new ChannelException("threadpool at capacity, request rejected");
                }
            }
            catch (ChannelException ce) {
                errorCause = ce;
            }
            if (errorCause != null) {
                FFDCFilter.processException((Throwable)errorCause, CLASS_NAME, "503", this);
                inCallback.error(this.getConnLink().getVirtualConnection(), this, exception);
            }
        } else {
            inCallback.error(this.getConnLink().getVirtualConnection(), this, exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleAsyncError");
        }
    }

    private IOException checkRequest(long numBytes, boolean async) {
        WsByteBuffer[] callerBuffers;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRequest");
        }
        IOException exception = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "numBytes=" + numBytes + " jitsize=" + this.getJITAllocateSize() + " buffers=" + SSLUtils.getBufferTraceInfo(this.getBuffers()));
        }
        if ((callerBuffers = this.getBuffers()) == null || callerBuffers.length == 0) {
            if (this.getJITAllocateSize() <= 0 || (long)this.getJITAllocateSize() < numBytes) {
                exception = new IOException("No buffer(s) provided for reading data into.");
            }
        } else if (numBytes == 0L) {
            if (async) {
                exception = new IOException("Number of bytes requested, " + numBytes + " is less than minimum allowed (async).");
            }
        } else if (numBytes < 0L) {
            exception = new IOException("Number of bytes requested, " + numBytes + " is less than minimum allowed.");
        } else {
            int bytesAvail = SSLUtils.lengthOf(callerBuffers, 0);
            if ((long)bytesAvail < numBytes) {
                exception = new IOException("Number of bytes requested, " + numBytes + " exceeds space remaining in the buffers provided: " + bytesAvail);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRequest: " + exception);
        }
        return exception;
    }

    public long readUnconsumedDecData() {
        long totalBytesRead = 0L;
        if (this.unconsumedDecData != null) {
            if (this.getBuffer() == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caller needs buffer, unconsumed data: " + SSLUtils.getBufferTraceInfo(this.unconsumedDecData));
                }
                totalBytesRead = SSLUtils.lengthOf(this.unconsumedDecData, 0);
                this.cleanupDecBuffers();
                this.callerRequiredAllocation = true;
                this.decryptedNetBuffers = this.unconsumedDecData;
                this.unconsumedDecData = null;
                if (this.decryptedNetLimitInfo == null || this.decryptedNetLimitInfo.length != this.decryptedNetBuffers.length) {
                    this.decryptedNetLimitInfo = new int[this.decryptedNetBuffers.length];
                }
                SSLUtils.getBufferLimits(this.decryptedNetBuffers, this.decryptedNetLimitInfo);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caller provided buffers, unconsumed data: " + SSLUtils.getBufferTraceInfo(this.unconsumedDecData));
                }
                this.cleanupDecBuffers();
                this.decryptedNetBuffers = this.unconsumedDecData;
                totalBytesRead = this.copyDataToCallerBuffers();
                this.decryptedNetBuffers = null;
            }
        }
        return totalBytesRead;
    }

    protected void getNetworkBuffer(long requestedSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getNetworkBuffer: size=" + requestedSize);
        }
        this.netBufferMark = 0;
        int allocationSize = this.getConnLink().getPacketBufferSize();
        if ((long)allocationSize < requestedSize) {
            allocationSize = (int)requestedSize;
        }
        if (null == this.netBuffer) {
            this.netBuffer = SSLUtils.allocateByteBuffer(allocationSize, true);
        } else {
            int lim;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found existing netbuffer, " + SSLUtils.getBufferTraceInfo(this.netBuffer));
            }
            int cap = this.netBuffer.capacity();
            int pos = this.netBuffer.position();
            if (pos == (lim = this.netBuffer.limit())) {
                if (cap >= allocationSize) {
                    this.netBuffer.clear();
                } else {
                    this.netBuffer.release();
                    this.netBuffer = SSLUtils.allocateByteBuffer(allocationSize, true);
                }
            } else if (cap - pos < allocationSize) {
                WsByteBuffer buffer = SSLUtils.allocateByteBuffer(allocationSize, true);
                SSLUtils.copyBuffer(this.netBuffer, buffer, lim - pos);
                this.netBuffer.release();
                this.netBuffer = buffer;
            } else {
                this.netBufferMark = pos;
                this.netBuffer.position(lim);
                this.netBuffer.limit(cap);
            }
        }
        this.deviceReadContext.setBuffer(this.netBuffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "netBuffer: " + SSLUtils.getBufferTraceInfo(this.netBuffer));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNetworkBuffer");
        }
    }

    private void getDecryptedNetworkBuffers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDecryptedNetworkBuffers");
        }
        if (this.decryptedNetBuffers == null) {
            this.decryptedNetBuffers = this.getBuffers();
            if (this.decryptedNetBuffers == null) {
                this.callerRequiredAllocation = true;
                int allocationSize = this.getJITAllocateSize();
                int minSize = this.getConnLink().getAppBufferSize();
                if (allocationSize <= 0) {
                    allocationSize = minSize;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "allocating JIT buffer; size=" + allocationSize);
                }
                this.decryptedNetBuffers = SSLUtils.allocateByteBuffers(allocationSize, this.bytesRequested, this.getConfig().getDecryptBuffersDirect(), false);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Using buffers from getBuffers()");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Using buffers previously set");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDecryptedNetworkBuffers");
        }
    }

    private IOException expandDecryptedNetBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "expandDecryptedNetBuffer");
        }
        IOException exception = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "callerRequiredAlloc=" + this.callerRequiredAllocation + ", decNetReleaseReq=" + this.decryptedNetBufferReleaseRequired);
        }
        boolean expand = false;
        if (!this.getJITAllocateAction()) {
            if (this.decryptedNetBufferReleaseRequired) {
                expand = true;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Allocating substitute decNetworkBuffer");
                }
                this.decryptedNetBuffers = new WsByteBuffer[1];
                this.decryptedNetBuffers[0] = SSLUtils.allocateByteBuffer(this.getConnLink().getAppBufferSize(), this.getConfig().getDecryptBuffersDirect());
                this.decryptedNetBufferReleaseRequired = true;
            }
        } else {
            expand = true;
        }
        if (expand) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Expanding set of buffers by one.");
            }
            WsByteBuffer[] tempBuffers = this.decryptedNetBuffers;
            this.decryptedNetBuffers = new WsByteBuffer[tempBuffers.length + 1];
            for (int i = 0; i < tempBuffers.length; ++i) {
                this.decryptedNetBuffers[i] = tempBuffers[i];
            }
            this.decryptedNetBuffers[tempBuffers.length] = SSLUtils.allocateByteBuffer(this.getConnLink().getAppBufferSize(), this.getConfig().getDecryptBuffersDirect());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "decryptedNetBuffers changed to ..." + SSLUtils.getBufferTraceInfo(this.decryptedNetBuffers));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "expandDecryptedNetBuffer");
        }
        return exception;
    }

    private int copyDataToCallerBuffers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "copyDataToCallerBuffers");
        }
        WsByteBuffer[] src = this.decryptedNetBuffers;
        WsByteBuffer[] dst = this.getBuffers();
        WsByteBuffer dstBuffer = null;
        WsByteBuffer srcBuffer = null;
        int dstIndex = 0;
        int srcIndex = 0;
        int srcRemaining = 0;
        int dstRemaining = 0;
        int numBytesCopied = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Before copy:\r\n\tsrc: " + SSLUtils.getBufferTraceInfo(src) + "\r\n\tdst: " + SSLUtils.getBufferTraceInfo(dst));
        }
        while (srcIndex < src.length && dstIndex < dst.length) {
            srcBuffer = src[srcIndex];
            srcRemaining = srcBuffer.remaining();
            while (srcRemaining > 0 && dstIndex < dst.length) {
                dstBuffer = dst[dstIndex];
                dstRemaining = dstBuffer.remaining();
                if (srcRemaining <= dstRemaining) {
                    SSLUtils.copyBuffer(srcBuffer, dstBuffer, srcRemaining);
                    numBytesCopied += srcRemaining;
                    dstRemaining = dstBuffer.remaining();
                    if (dstRemaining != 0) break;
                    ++dstIndex;
                    break;
                }
                if (dstRemaining > 0) {
                    SSLUtils.copyBuffer(srcBuffer, dstBuffer, dstRemaining);
                    numBytesCopied += dstRemaining;
                    ++dstIndex;
                    srcRemaining = srcBuffer.remaining();
                    continue;
                }
                ++dstIndex;
            }
            ++srcIndex;
        }
        --srcIndex;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "After copy:\r\n\tsrc: " + SSLUtils.getBufferTraceInfo(src) + "\r\n\tdst: " + SSLUtils.getBufferTraceInfo(dst));
        }
        int remaining = SSLUtils.lengthOf(src, srcIndex);
        if (src == this.unconsumedDecData && null != srcBuffer && srcBuffer.hashCode() == this.unconsumedDecData[srcIndex].hashCode()) {
            if (0 < remaining) {
                WsByteBuffer temp = this.unconsumedDecData[srcIndex];
                this.unconsumedDecData[srcIndex] = this.unconsumedDecData[srcIndex].slice();
                temp.release();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Data left in unconsumedDecData: " + SSLUtils.getBufferTraceInfo(this.unconsumedDecData));
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Entire unconsumedDecData buffer drained.  Release and null out.");
                }
                WsByteBufferUtils.releaseBufferArray(this.unconsumedDecData);
                this.unconsumedDecData = null;
            }
        } else if (0 < remaining) {
            this.unconsumedDecData = SSLUtils.compressBuffers(this.decryptedNetBuffers, true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "unconsumedDecData: " + SSLUtils.getBufferTraceInfo(this.unconsumedDecData));
            }
        } else {
            this.cleanupDecBuffers();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "copyDataToCallerBuffers");
        }
        return numBytesCopied;
    }

    private void cleanupDecBuffers() {
        if (null != this.decryptedNetBuffers && (this.callerRequiredAllocation || this.decryptedNetBufferReleaseRequired)) {
            WsByteBufferUtils.releaseBufferArray(this.decryptedNetBuffers);
            this.decryptedNetBuffers = null;
        }
    }

    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "close, vc=" + this.getVCHash());
        }
        if (null != this.netBuffer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Releasing netBuffer during close " + SSLUtils.getBufferTraceInfo(this.netBuffer));
            }
            this.netBuffer.release();
            this.netBuffer = null;
        }
        this.cleanupDecBuffers();
        if (this.unconsumedDecData != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Releasing unconsumed decrypted buffers, " + SSLUtils.getBufferTraceInfo(this.unconsumedDecData));
            }
            WsByteBufferUtils.releaseBufferArray(this.unconsumedDecData);
            this.unconsumedDecData = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public void setJITAllocateSize(int numBytes) {
        this.jITAllocateSize = numBytes;
    }

    public boolean getJITAllocateAction() {
        return this.callerRequiredAllocation;
    }

    public int getJITAllocateSize() {
        return this.jITAllocateSize;
    }

    protected Exception decryptMessage(boolean async, boolean forceQueue) {
        Exception exception;
        block30: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "decryptMessage");
            }
            exception = null;
            SSLEngineResult result = null;
            SSLEngineResult.Status status = null;
            this.getDecryptedNetworkBuffers();
            try {
                while (true) {
                    int savedLimit = SSLUtils.adjustBufferForJSSE(this.netBuffer, this.getConnLink().getPacketBufferSize());
                    if (this.decryptedNetLimitInfo == null || this.decryptedNetLimitInfo.length != this.decryptedNetBuffers.length) {
                        this.decryptedNetLimitInfo = new int[this.decryptedNetBuffers.length];
                    }
                    SSLUtils.getBufferLimits(this.decryptedNetBuffers, this.decryptedNetLimitInfo);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "before unwrap:\r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(this.netBuffer) + "\r\n\tdecNetBuffers: " + SSLUtils.getBufferTraceInfo(this.decryptedNetBuffers));
                    }
                    if (0 < (result = this.getConnLink().getSSLEngine().unwrap(this.netBuffer.getWrappedByteBuffer(), SSLUtils.getWrappedByteBuffers(this.decryptedNetBuffers))).bytesProduced()) {
                        SSLUtils.flipBuffers(this.decryptedNetBuffers, result.bytesProduced());
                    }
                    status = result.getStatus();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "after unwrap:\r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(this.netBuffer) + "\r\n\tdecNetBuffers: " + SSLUtils.getBufferTraceInfo(this.decryptedNetBuffers) + "\r\n\tstatus=" + (Object)((Object)status) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced());
                    }
                    if (-1 != savedLimit) {
                        this.netBuffer.limit(savedLimit);
                    }
                    this.bytesProduced += (long)result.bytesProduced();
                    if (status == SSLEngineResult.Status.OK) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "OK result from the SSL engine, callerReqAlloc=" + this.getJITAllocateAction() + " decNetBuffRelReq=" + this.decryptedNetBufferReleaseRequired);
                        }
                        if (this.bytesRequested > this.bytesProduced) {
                            if (0 < result.bytesProduced()) {
                                SSLUtils.positionToLimit(this.decryptedNetBuffers);
                                SSLUtils.setBufferLimits(this.decryptedNetBuffers, this.decryptedNetLimitInfo);
                            }
                            if (this.netBuffer.remaining() != 0) continue;
                            exception = this.readNeededInternalException;
                        }
                    } else {
                        if (status != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
                        exception = this.expandDecryptedNetBuffer();
                        if (exception == null) {
                            continue;
                        }
                    }
                    break block30;
                    break;
                }
                if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    exception = this.readNeededInternalException;
                    break block30;
                }
                if (status == SSLEngineResult.Status.CLOSED) {
                    exception = this.sessionClosedException;
                    break block30;
                }
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK || result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP || result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    try {
                        result = this.doHandshake(async, forceQueue);
                    }
                    catch (IOException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Caught exception during SSL handshake, " + e);
                        }
                        exception = e;
                        break block30;
                    }
                    if (result != null) {
                        status = result.getStatus();
                        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                            exception = this.readNeededInternalException;
                        } else if (status == SSLEngineResult.Status.OK) {
                            this.prepareDataForNextChannel();
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Unhandled result from SSL engine: " + (Object)((Object)status));
                            }
                            exception = new SSLException("Unhandled result from SSL engine: " + (Object)((Object)status));
                        }
                    }
                    break block30;
                }
                exception = new SSLException("Unknown result from ssl engine not handled yet: " + (Object)((Object)status));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unknown result from ssl engine not handled yet: " + (Object)((Object)status));
                }
            }
            catch (SSLException ssle) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception during decryption, " + ssle);
                }
                exception = ssle;
                this.cleanupDecBuffers();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptMessage: " + exception);
        }
        return exception;
    }

    private SSLEngineResult doHandshake(boolean async, boolean forceQueue) throws IOException {
        SSLEngineResult sslResult;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "doHandshake");
        }
        int appSize = this.getConnLink().getAppBufferSize();
        int packetSize = this.getConnLink().getPacketBufferSize();
        WsByteBuffer localNetBuffer = SSLUtils.allocateByteBuffer(packetSize, true);
        WsByteBuffer decryptedNetBuffer = SSLUtils.allocateByteBuffer(appSize, false);
        WsByteBuffer encryptedAppBuffer = SSLUtils.allocateByteBuffer(packetSize, true);
        MyHandshakeCompletedCallback handshakeCallback = null;
        if (async) {
            handshakeCallback = new MyHandshakeCompletedCallback(this, this.callback, localNetBuffer, decryptedNetBuffer, encryptedAppBuffer);
        }
        try {
            sslResult = SSLUtils.handleHandshake(this.getConnLink(), localNetBuffer, decryptedNetBuffer, encryptedAppBuffer, null, handshakeCallback, false);
        }
        catch (IOException e) {
            localNetBuffer.release();
            localNetBuffer = null;
            decryptedNetBuffer.release();
            decryptedNetBuffer = null;
            encryptedAppBuffer.release();
            encryptedAppBuffer = null;
            throw e;
        }
        if (sslResult != null) {
            localNetBuffer.release();
            localNetBuffer = null;
            decryptedNetBuffer.release();
            decryptedNetBuffer = null;
            encryptedAppBuffer.release();
            encryptedAppBuffer = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "doHandshake");
        }
        return sslResult;
    }

    protected void prepareDataForNextChannel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareDataForNextChannel");
        }
        if (this.getJITAllocateAction()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Allocation was done here, adjust and hand off buffers, JIT=" + this.getJITAllocateSize());
            }
            int decryptedDataSize = SSLUtils.lengthOf(this.decryptedNetBuffers, 0);
            if (this.decryptedNetBuffers.length == 1) {
                if (decryptedDataSize <= this.getJITAllocateSize()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "single decNetBuffer is okay to pass to caller");
                    }
                    SSLUtils.positionToLimit(this.decryptedNetBuffers);
                    SSLUtils.setBufferLimits(this.decryptedNetBuffers, this.decryptedNetLimitInfo);
                    this.setBuffer(this.decryptedNetBuffers[0]);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "only one decNetBuffer, but too big (" + decryptedDataSize + ") for JIT.  Need to copy.");
                    }
                    this.setBuffer(SSLUtils.allocateByteBuffer(this.getJITAllocateSize(), false));
                    this.getBuffer().limit(this.getJITAllocateSize());
                    this.copyDataToCallerBuffers();
                }
            } else if (this.decryptedNetBuffers[0].remaining() == this.getJITAllocateSize()) {
                int i;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "multiple buffers, first of which matches the JIT size");
                }
                this.decryptedNetBuffers[0].position(this.decryptedNetBuffers[0].limit());
                this.setBuffer(this.decryptedNetBuffers[0]);
                if (null != this.unconsumedDecData && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Expected null unconsumed array, but isn't: " + SSLUtils.getBufferTraceInfo(this.unconsumedDecData));
                }
                int size = 0;
                for (i = 1; i < this.decryptedNetBuffers.length; ++i) {
                    if (0 == this.decryptedNetBuffers[i].remaining()) {
                        this.decryptedNetBuffers[i].release();
                        continue;
                    }
                    ++size;
                }
                if (0 < size) {
                    this.unconsumedDecData = new WsByteBuffer[size];
                    i = 1;
                    for (int x = 0; x < size; ++x) {
                        this.unconsumedDecData[x] = this.decryptedNetBuffers[i];
                        ++i;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "unconsumedDecData: " + SSLUtils.getBufferTraceInfo(this.unconsumedDecData));
                    }
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "multiple buffers, first does not match the JIT size.");
                }
                this.setBuffer(SSLUtils.allocateByteBuffer(this.getJITAllocateSize(), false));
                this.getBuffer().limit(this.getJITAllocateSize());
                for (int i = 0; i < this.decryptedNetBuffers.length; ++i) {
                    this.decryptedNetBuffers[i].position(0);
                }
                this.copyDataToCallerBuffers();
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Using channel provided buffers");
            }
            if (this.decryptedNetBufferReleaseRequired) {
                for (int i = 0; i < this.decryptedNetBuffers.length; ++i) {
                    if (null == this.decryptedNetBuffers[i]) continue;
                    this.decryptedNetBuffers[i].position(0);
                }
                this.copyDataToCallerBuffers();
            } else {
                SSLUtils.positionToLimit(this.decryptedNetBuffers);
                SSLUtils.setBufferLimits(this.decryptedNetBuffers, this.decryptedNetLimitInfo);
            }
        }
        this.decryptedNetBuffers = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Buffers being sent to next channel: " + SSLUtils.getBufferTraceInfo(this.getBuffers()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareDataForNextChannel");
        }
    }

    private class QueuedWork
    implements Runnable {
        private static final int READ = 0;
        private static final int ERROR = 1;
        private static final int COMPLETE = 2;
        private long numBytes = 0L;
        private TCPReadCompletedCallback userCallback = null;
        private int timeout = 0;
        private VirtualConnection vc = null;
        private TCPReadRequestContext tcpReadRequestContext = null;
        private IOException exception = null;
        private int action = 0;

        protected QueuedWork() {
        }

        public void setReadParameters(long _numBytes, TCPReadCompletedCallback _userCallback, int _timeout) {
            this.numBytes = _numBytes;
            this.userCallback = _userCallback;
            this.timeout = _timeout;
            this.action = 0;
        }

        public void setErrorParameters(VirtualConnection _vc, TCPReadRequestContext _tcpReadRequestContext, TCPReadCompletedCallback _userCallback, IOException _exception) {
            this.vc = _vc;
            this.tcpReadRequestContext = _tcpReadRequestContext;
            this.userCallback = _userCallback;
            this.exception = _exception;
            this.action = 1;
        }

        public void setCompleteParameters(VirtualConnection _vc, TCPReadRequestContext _tcpReadRequestContext, TCPReadCompletedCallback _userCallback) {
            this.vc = _vc;
            this.tcpReadRequestContext = _tcpReadRequestContext;
            this.userCallback = _userCallback;
            this.action = 2;
        }

        public void run() {
            if (this.action == 0) {
                SSLReadServiceContext.this.read(this.numBytes, this.userCallback, false, this.timeout, true);
            } else if (this.action == 1) {
                this.userCallback.error(this.vc, this.tcpReadRequestContext, this.exception);
            } else {
                this.userCallback.complete(this.vc, this.tcpReadRequestContext);
            }
        }
    }

    private class SSLReadCompletedCallback
    implements TCPReadCompletedCallback {
        private TCPReadCompletedCallback myCallback = null;
        private SSLReadServiceContext readContext = null;

        public SSLReadCompletedCallback(SSLReadServiceContext _readContext) {
            this.readContext = _readContext;
        }

        public void setCallBack(TCPReadCompletedCallback _myCallback) {
            this.myCallback = _myCallback;
        }

        public void complete(VirtualConnection vc, TCPReadRequestContext tcpRead) {
            Exception exception;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "complete, vc=" + SSLReadServiceContext.this.getVCHash());
            }
            SSLReadServiceContext.this.netBuffer = tcpRead.getBuffer();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "just after async read, but before flip\r\n\t" + SSLUtils.getBufferTraceInfo(SSLReadServiceContext.this.netBuffer));
            }
            SSLReadServiceContext.this.netBuffer.limit(SSLReadServiceContext.this.netBuffer.position());
            SSLReadServiceContext.this.netBuffer.position(SSLReadServiceContext.this.netBufferMark);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Read bytes: " + SSLReadServiceContext.this.netBuffer.remaining());
            }
            if ((exception = SSLReadServiceContext.this.decryptMessage(true, false)) == null) {
                if (SSLReadServiceContext.this.bytesRequested > SSLReadServiceContext.this.bytesProduced) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Some data decrypted, more data required, do a read. vc=" + SSLReadServiceContext.this.getVCHash());
                    }
                    tcpRead.read(1L, this, true, 0);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "data decrypted: bytesRequested=" + SSLReadServiceContext.this.bytesRequested + " bytesProduced=" + SSLReadServiceContext.this.bytesProduced);
                    }
                    SSLReadServiceContext.this.prepareDataForNextChannel();
                    this.myCallback.complete(vc, this.readContext);
                }
            } else if (exception instanceof ReadNeededInternalException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No data was decrypted, more data required, do a read. vc=" + SSLReadServiceContext.this.getVCHash());
                }
                SSLReadServiceContext.this.getNetworkBuffer(1L);
                tcpRead.setBuffer(SSLReadServiceContext.this.netBuffer);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling device side read with netBuffer, " + SSLUtils.getBufferTraceInfo(SSLReadServiceContext.this.netBuffer));
                }
                tcpRead.read(1L, this, true, 0);
            } else if (exception instanceof SessionClosedException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSL Session has been closed.");
                }
                SSLReadServiceContext.this.callback.error(vc, this.readContext, new IOException("SSL connection was closed by peer"));
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception during unwrap, " + exception);
                }
                FFDCFilter.processException((Throwable)exception, SSLReadServiceContext.CLASS_NAME, "798", this);
                SSLReadServiceContext.this.callback.error(vc, this.readContext, new IOException("SSL decryption failed: " + exception.getMessage()));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "complete");
            }
        }

        public void error(VirtualConnection vc, TCPReadRequestContext tcpRead, IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "error, vc=" + SSLReadServiceContext.this.getVCHash());
            }
            if (null == SSLReadServiceContext.this.netBuffer) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected callback, unable to proceed");
                }
                return;
            }
            SSLReadServiceContext.this.netBuffer.limit(SSLReadServiceContext.this.netBuffer.position());
            SSLReadServiceContext.this.netBuffer.position(SSLReadServiceContext.this.netBufferMark);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reset buffers after read error: netBuffer:" + SSLUtils.getBufferTraceInfo(SSLReadServiceContext.this.netBuffer));
            }
            SSLReadServiceContext.this.callback.error(vc, this.readContext, ioe);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "error");
            }
        }
    }

    public class MyHandshakeCompletedCallback
    implements SSLHandshakeCompletedCallback {
        private TCPReadRequestContext readContext;
        private TCPReadCompletedCallback hsReadCallback;
        private WsByteBuffer hsNetBuffer;
        private WsByteBuffer decryptedNetBuffer;
        private WsByteBuffer encryptedAppBuffer;

        public MyHandshakeCompletedCallback(TCPReadRequestContext _readContext, TCPReadCompletedCallback _readCallback, WsByteBuffer _netBuffer, WsByteBuffer _decryptedNetBuffer, WsByteBuffer _encryptedAppBuffer) {
            this.readContext = _readContext;
            this.hsReadCallback = _readCallback;
            this.hsNetBuffer = _netBuffer;
            this.decryptedNetBuffer = _decryptedNetBuffer;
            this.encryptedAppBuffer = _encryptedAppBuffer;
        }

        public void complete(SSLEngineResult sslResult) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "handshake complete");
            }
            this.hsNetBuffer.release();
            this.hsNetBuffer = null;
            this.decryptedNetBuffer.release();
            this.decryptedNetBuffer = null;
            this.encryptedAppBuffer.release();
            this.encryptedAppBuffer = null;
            SSLEngineResult.Status sslStatus = sslResult.getStatus();
            if (sslResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                SSLReadServiceContext.this.read(1L, this.hsReadCallback, true, 0);
            } else if (sslStatus == SSLEngineResult.Status.OK) {
                SSLReadServiceContext.this.prepareDataForNextChannel();
                SSLReadServiceContext.this.callback.complete(SSLReadServiceContext.this.getConnLink().getVirtualConnection(), this.readContext);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unhandled result from SSL engine: " + (Object)((Object)sslStatus));
                }
                IOException exception = new IOException("Unhandled result from SSL engine: " + (Object)((Object)sslStatus));
                FFDCFilter.processException((Throwable)exception, SSLReadServiceContext.CLASS_NAME, "750", this);
                SSLReadServiceContext.this.callback.error(SSLReadServiceContext.this.getConnLink().getVirtualConnection(), this.readContext, exception);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handshake complete");
            }
        }

        public void error(IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "handshake error");
            }
            this.hsNetBuffer.release();
            this.hsNetBuffer = null;
            this.decryptedNetBuffer.release();
            this.decryptedNetBuffer = null;
            this.encryptedAppBuffer.release();
            this.encryptedAppBuffer = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during encryption, " + ioe);
            }
            FFDCFilter.processException((Throwable)ioe, SSLReadServiceContext.CLASS_NAME, "762", this);
            SSLReadServiceContext.this.callback.error(SSLReadServiceContext.this.getConnLink().getVirtualConnection(), this.readContext, ioe);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handshake error");
            }
        }
    }
}

