/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.security.SSLType;
import com.ibm.ws.channel.commands.CFCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class ListSSLRepertoiresCommand
extends CFCommand {
    public ListSSLRepertoiresCommand(CommandMetadata metadata) {
        super(metadata);
    }

    public ListSSLRepertoiresCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws CommandValidationException {
        block5: {
            super.validate();
            ObjectName targetON = (ObjectName)this.getTargetObject();
            boolean checkResult = false;
            try {
                checkResult = this.checkType(targetON, new String[]{"SSLInboundChannel", "SSLOutboundChannel"}, false);
            }
            catch (Exception exp) {
                checkResult = false;
            }
            finally {
                if (checkResult) break block5;
                throw new InvalidParameterValueException(this.getName(), "target", targetON);
            }
        }
    }

    public void execute() {
        CommandResultImpl result = new CommandResultImpl();
        try {
            this.validate();
            result.setResult(this.getRepertoires((ObjectName)this.getTargetObject()));
        }
        catch (Exception exp) {
            result.setException(exp);
        }
        this.setCommandResult(result);
    }

    protected List getRepertoires(ObjectName sslChannelON) throws ConfigServiceException, ConnectorException, AttributeNotFoundException {
        ArrayList<ObjectName> jsseRepertoires = new ArrayList<ObjectName>();
        Properties location = ConfigServiceHelper.getObjectLocation(sslChannelON);
        StringBuffer contextURI = new StringBuffer();
        contextURI.append("cells/");
        contextURI.append(location.getProperty("cell"));
        ConfigService service = this.getConfigService();
        Session session = this.getConfigSession();
        ConfigDataId security2 = new ConfigDataId(contextURI.toString(), "security.xml");
        ObjectName securityON = ConfigServiceHelper.createObjectName(security2);
        List repertoires = (List)service.getAttribute(session, securityON, "repertoire");
        for (AttributeList repertoire : repertoires) {
            String type = (String)ConfigServiceHelper.getAttributeValue(repertoire, "type");
            if (!type.equals(SSLType.JSSE_LITERAL.toString())) continue;
            jsseRepertoires.add(ConfigServiceHelper.createObjectName(repertoire));
        }
        return jsseRepertoires;
    }
}

