/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.soap.container.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.soap.container.SoapContainerRouter;
import com.ibm.ws.soap.container.SoapContainerService;
import com.ibm.ws.webservices.WebServicesSystemService;
import com.ibm.wsspi.soapcontainer.SOAPRequest;
import com.ibm.wsspi.soapcontainer.SOAPResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class SOAPContainerChannelComponentImpl
extends ComponentImpl
implements SoapContainerService {
    private static final TraceComponent _tc = Tr.register(SOAPContainerChannelComponentImpl.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    Hashtable metaDataTable = new Hashtable();
    Hashtable engineTable = new Hashtable();
    SoapContainerRouter router = null;
    ThreadLocal threadLocalSysappName = new ThreadLocal();
    WebServicesSystemService wsSysSvc = null;
    boolean loadedConfig = false;
    Object configLoading = new Object();

    public void cacheMetaData(String key, Object metaData) {
        this.metaDataTable.put(key, metaData);
    }

    public Object getMetaData(String key) {
        return this.metaDataTable.get(key);
    }

    public Object getMetaData() {
        String key = (String)this.threadLocalSysappName.get();
        return this.metaDataTable.get(key);
    }

    public void cacheEngine(Object engine2) {
        String key = (String)this.threadLocalSysappName.get();
        this.engineTable.put(key, engine2);
    }

    public Object getEngine() {
        String key = (String)this.threadLocalSysappName.get();
        return this.engineTable.get(key);
    }

    public void registerRouter(SoapContainerRouter router) {
        this.router = router;
    }

    public Enumeration getRegisteredURLs() {
        return this.metaDataTable.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(SOAPRequest req, SOAPResponse res) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "handleRequest");
        }
        if (!this.loadedConfig) {
            Object object = this.configLoading;
            synchronized (object) {
                if (!this.loadedConfig) {
                    this.wsSysSvc.loadConfiguration();
                    this.loadedConfig = true;
                }
            }
        }
        if (this.router != null) {
            String requestURI = req.getRequestURI();
            String pathInfo = req.getRequestPathInfo();
            String sysAppName = pathInfo.substring(1, pathInfo.indexOf("/", 1));
            Object metaData = this.metaDataTable.get(sysAppName);
            Object engine2 = this.engineTable.get(sysAppName);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Invoking system application...\nRequest URI:              " + req.getRequestURI() + "\n" + "Request PathInfo:         " + pathInfo + "\n" + "System Application Name:  " + sysAppName + "\n" + "Metadata for application: " + metaData + "\n" + "Engine for application:   " + engine2 + "\n");
            }
            if (metaData != null) {
                try {
                    this.threadLocalSysappName.set(sysAppName);
                    this.router.doPost(req, res, metaData);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.soap.container.component.SOAPContainerChannelComponentImpl.handleRequest", "151", this);
                    Tr.error(_tc, "internal.error", e);
                    SOAPContainerChannelComponentImpl.errorResponse(res, pathInfo, sysAppName);
                }
                finally {
                    this.threadLocalSysappName.set(null);
                }
            } else {
                Object[] params = new Object[]{pathInfo, sysAppName};
                Tr.error(_tc, "no.system.application", params);
                SOAPContainerChannelComponentImpl.errorResponse(res, pathInfo, sysAppName);
            }
        } else {
            Object[] params = new Object[]{req.getRequestURI()};
            Tr.error(_tc, "no.system.router", params);
            SOAPContainerChannelComponentImpl.errorResponse(res, req.getRequestURI(), null);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "handleRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void errorResponse(SOAPResponse response, String url, String sysappName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "errorResponse");
        }
        try {
            response.setStatusCode(404);
            response.setContentType("text/html");
            OutputStream os = response.getOutputStream();
            if (os != null) {
                StringBuffer buf = new StringBuffer();
                buf.append("<h2>ERROR</h2>\n");
                buf.append("<p>URL recieved [" + url + "]\n");
                if (sysappName == null) {
                    buf.append("<p>No servlet engine router defined</p>\n");
                } else {
                    buf.append("<p>No registration or metadata for system endpoint application " + sysappName + "\n");
                }
                os.write(buf.toString().getBytes());
                os.close();
            }
            response.finishResponse();
        }
        catch (IOException e) {
            FFDCFilter.processException(e, "com.ibm.ws.soap.container.component.SOAPContainerChannelComponentImpl.errorResponse", "215");
            Tr.error(_tc, "internal.error", e);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "errorResponse");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object config) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initialize");
        }
        try {
            if (AdminServiceFactory.getAdminService().getProcessType().equals("DeploymentManager")) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Disabling component in DMGR process.");
                }
                throw new ComponentDisabledException();
            }
            this.addService(SoapContainerService.class, this);
            Tr.info(_tc, "soapcontainer.service");
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "initialize");
            }
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start");
        }
        this.wsSysSvc = (WebServicesSystemService)this.getService(WebServicesSystemService.class);
        if (this.wsSysSvc == null) {
            Tr.error(_tc, "internal.error", this.getClass().getName() + ": Could not get service for WebServicesSystemService.class");
            throw new RuntimeError("Cannot find WebServicesSystemService!");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "start");
        }
    }

    public void stop() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stop");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stop");
        }
    }
}

