/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.orbssl;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ffdc.Manager;
import com.ibm.ws.ssl.JSSEProviderFactory;

public final class SSLCiphers {
    public static final int CONFIDENTIALITY = 1;
    public static final int INTEGRITY = 2;
    public static final int AUTHENTICITY = 3;
    public static final int HIGH = 4;
    public static final int MEDIUM = 5;
    public static final int LOW = 6;
    public static final String[] HIGH_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_RC4_128_SHA"};
    public static final String[] HIGH_CIPHER_SUITES_FIPS = new String[]{"SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA"};
    public static final String[] MEDIUM_CIPHER_SUITES = new String[]{"SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
    public static final String[] MEDIUM_CIPHER_SUITES_FIPS = new String[0];
    public static final String[] LOW_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "SSL_DH_anon_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};
    public static final String[] LOW_CIPHER_SUITES_FIPS = new String[0];
    public static final String[] LOW_CIPHER_SUITES_CLIENT = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA"};
    public static final String[] LOW_CIPHER_SUITES_CLIENT_FIPS = new String[0];

    public static String[] getCipherSuites(int qop, boolean isClient, String provider) throws IllegalArgumentException {
        String[] result;
        block6: {
            result = null;
            try {
                if (qop == 1 || qop == 4) {
                    result = JSSEProviderFactory.isFipsEnabled() ? HIGH_CIPHER_SUITES_FIPS : HIGH_CIPHER_SUITES;
                    break block6;
                }
                if (qop == 2 || qop == 5) {
                    result = JSSEProviderFactory.isFipsEnabled() ? MEDIUM_CIPHER_SUITES_FIPS : MEDIUM_CIPHER_SUITES;
                    break block6;
                }
                if (qop == 2 || qop == 6) {
                    result = JSSEProviderFactory.isFipsEnabled() ? (isClient ? LOW_CIPHER_SUITES_CLIENT_FIPS : LOW_CIPHER_SUITES_FIPS) : (isClient ? LOW_CIPHER_SUITES_CLIENT : LOW_CIPHER_SUITES);
                    break block6;
                }
                IllegalArgumentException ex = new IllegalArgumentException("Illegal argument for Cipher qop - Client Socket is " + isClient);
                throw ex;
            }
            catch (IllegalArgumentException ex) {
                Manager.Ffdc.log(ex, SSLCiphers.class, "com.ibm.ws.security.orbssl.SSLCiphers.getCipherSuites", "260");
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.SSLCiphers", "SSLCiphers.getCipherSuites", (Exception)ex);
                }
                throw ex;
            }
        }
        return result;
    }

    public static String[] getCipherSuitesJoin(int qop1, int qop2, boolean isClient, String provider) throws IllegalArgumentException {
        String[] result;
        block23: {
            result = null;
            try {
                if (!(qop1 != 1 && qop1 != 4 || qop2 != 1 && qop2 != 4)) {
                    result = JSSEProviderFactory.isFipsEnabled() ? HIGH_CIPHER_SUITES_FIPS : HIGH_CIPHER_SUITES;
                    break block23;
                }
                if (!(qop1 != 2 && qop1 != 5 || qop2 != 2 && qop2 != 5)) {
                    result = JSSEProviderFactory.isFipsEnabled() ? MEDIUM_CIPHER_SUITES_FIPS : MEDIUM_CIPHER_SUITES;
                    break block23;
                }
                if (!(qop1 != 2 && qop1 != 6 || qop2 != 2 && qop2 != 6)) {
                    result = JSSEProviderFactory.isFipsEnabled() ? (isClient ? LOW_CIPHER_SUITES_CLIENT_FIPS : LOW_CIPHER_SUITES_FIPS) : (isClient ? LOW_CIPHER_SUITES_CLIENT : LOW_CIPHER_SUITES);
                    break block23;
                }
                if (!(qop1 != 1 && qop1 != 4 || qop2 != 2 && qop2 != 5)) {
                    if (JSSEProviderFactory.isFipsEnabled()) {
                        String[] result1 = new String[HIGH_CIPHER_SUITES_FIPS.length + MEDIUM_CIPHER_SUITES_FIPS.length];
                        System.arraycopy(HIGH_CIPHER_SUITES_FIPS, 0, result1, 0, HIGH_CIPHER_SUITES_FIPS.length);
                        System.arraycopy(MEDIUM_CIPHER_SUITES_FIPS, 0, result1, HIGH_CIPHER_SUITES_FIPS.length, MEDIUM_CIPHER_SUITES_FIPS.length);
                        result = result1;
                    } else {
                        String[] result1 = new String[HIGH_CIPHER_SUITES.length + MEDIUM_CIPHER_SUITES.length];
                        System.arraycopy(HIGH_CIPHER_SUITES, 0, result1, 0, HIGH_CIPHER_SUITES.length);
                        System.arraycopy(MEDIUM_CIPHER_SUITES, 0, result1, HIGH_CIPHER_SUITES.length, MEDIUM_CIPHER_SUITES.length);
                        result = result1;
                    }
                    break block23;
                }
                if (!(qop1 != 1 && qop1 != 4 || qop2 != 2 && qop2 != 6)) {
                    if (JSSEProviderFactory.isFipsEnabled()) {
                        if (isClient) {
                            String[] result1 = new String[HIGH_CIPHER_SUITES_FIPS.length + MEDIUM_CIPHER_SUITES_FIPS.length + LOW_CIPHER_SUITES_CLIENT_FIPS.length];
                            System.arraycopy(HIGH_CIPHER_SUITES_FIPS, 0, result1, 0, HIGH_CIPHER_SUITES_FIPS.length);
                            System.arraycopy(MEDIUM_CIPHER_SUITES_FIPS, 0, result1, HIGH_CIPHER_SUITES_FIPS.length, MEDIUM_CIPHER_SUITES_FIPS.length);
                            System.arraycopy(LOW_CIPHER_SUITES_CLIENT_FIPS, 0, result1, HIGH_CIPHER_SUITES_FIPS.length + MEDIUM_CIPHER_SUITES_FIPS.length, LOW_CIPHER_SUITES_CLIENT_FIPS.length);
                            result = result1;
                        } else {
                            String[] result1 = new String[HIGH_CIPHER_SUITES_FIPS.length + MEDIUM_CIPHER_SUITES_FIPS.length + LOW_CIPHER_SUITES_FIPS.length];
                            System.arraycopy(HIGH_CIPHER_SUITES_FIPS, 0, result1, 0, HIGH_CIPHER_SUITES_FIPS.length);
                            System.arraycopy(MEDIUM_CIPHER_SUITES_FIPS, 0, result1, HIGH_CIPHER_SUITES_FIPS.length, MEDIUM_CIPHER_SUITES_FIPS.length);
                            System.arraycopy(LOW_CIPHER_SUITES_FIPS, 0, result1, HIGH_CIPHER_SUITES_FIPS.length + MEDIUM_CIPHER_SUITES_FIPS.length, LOW_CIPHER_SUITES_FIPS.length);
                            result = result1;
                        }
                    } else if (isClient) {
                        String[] result1 = new String[HIGH_CIPHER_SUITES.length + MEDIUM_CIPHER_SUITES.length + LOW_CIPHER_SUITES_CLIENT.length];
                        System.arraycopy(HIGH_CIPHER_SUITES, 0, result1, 0, HIGH_CIPHER_SUITES.length);
                        System.arraycopy(MEDIUM_CIPHER_SUITES, 0, result1, HIGH_CIPHER_SUITES.length, MEDIUM_CIPHER_SUITES.length);
                        System.arraycopy(LOW_CIPHER_SUITES_CLIENT, 0, result1, HIGH_CIPHER_SUITES.length + MEDIUM_CIPHER_SUITES.length, LOW_CIPHER_SUITES_CLIENT.length);
                        result = result1;
                    } else {
                        String[] result1 = new String[HIGH_CIPHER_SUITES.length + MEDIUM_CIPHER_SUITES.length + LOW_CIPHER_SUITES.length];
                        System.arraycopy(HIGH_CIPHER_SUITES, 0, result1, 0, HIGH_CIPHER_SUITES.length);
                        System.arraycopy(MEDIUM_CIPHER_SUITES, 0, result1, HIGH_CIPHER_SUITES.length, MEDIUM_CIPHER_SUITES.length);
                        System.arraycopy(LOW_CIPHER_SUITES, 0, result1, HIGH_CIPHER_SUITES.length + MEDIUM_CIPHER_SUITES.length, LOW_CIPHER_SUITES.length);
                        result = result1;
                    }
                    break block23;
                }
                if (!(qop1 != 2 && qop1 != 5 || qop2 != 2 && qop2 != 6)) {
                    if (JSSEProviderFactory.isFipsEnabled()) {
                        if (isClient) {
                            String[] result1 = new String[MEDIUM_CIPHER_SUITES_FIPS.length + LOW_CIPHER_SUITES_CLIENT_FIPS.length];
                            System.arraycopy(MEDIUM_CIPHER_SUITES_FIPS, 0, result1, 0, MEDIUM_CIPHER_SUITES_FIPS.length);
                            System.arraycopy(LOW_CIPHER_SUITES_CLIENT_FIPS, 0, result1, MEDIUM_CIPHER_SUITES_FIPS.length, LOW_CIPHER_SUITES_CLIENT_FIPS.length);
                            result = result1;
                        } else {
                            String[] result1 = new String[MEDIUM_CIPHER_SUITES_FIPS.length + LOW_CIPHER_SUITES_FIPS.length];
                            System.arraycopy(MEDIUM_CIPHER_SUITES_FIPS, 0, result1, 0, MEDIUM_CIPHER_SUITES_FIPS.length);
                            System.arraycopy(LOW_CIPHER_SUITES_FIPS, 0, result1, MEDIUM_CIPHER_SUITES_FIPS.length, LOW_CIPHER_SUITES_FIPS.length);
                            result = result1;
                        }
                    } else if (isClient) {
                        String[] result1 = new String[MEDIUM_CIPHER_SUITES.length + LOW_CIPHER_SUITES_CLIENT.length];
                        System.arraycopy(MEDIUM_CIPHER_SUITES, 0, result1, 0, MEDIUM_CIPHER_SUITES.length);
                        System.arraycopy(LOW_CIPHER_SUITES_CLIENT, 0, result1, MEDIUM_CIPHER_SUITES.length, LOW_CIPHER_SUITES_CLIENT.length);
                        result = result1;
                    } else {
                        String[] result1 = new String[MEDIUM_CIPHER_SUITES.length + LOW_CIPHER_SUITES.length];
                        System.arraycopy(MEDIUM_CIPHER_SUITES, 0, result1, 0, MEDIUM_CIPHER_SUITES.length);
                        System.arraycopy(LOW_CIPHER_SUITES, 0, result1, MEDIUM_CIPHER_SUITES.length, LOW_CIPHER_SUITES.length);
                        result = result1;
                    }
                    break block23;
                }
                IllegalArgumentException ex = new IllegalArgumentException("Illegal argument for Cipher qop - Client Socket is " + isClient);
                throw ex;
            }
            catch (IllegalArgumentException ex) {
                Manager.Ffdc.log(ex, SSLCiphers.class, "com.ibm.ws.security.orbssl.SSLCiphers.getCipherSuitesJoin", "381");
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.SSLCiphers", "SSLCiphers.getCipherSuitesJoin", (Exception)ex);
                }
                throw ex;
            }
        }
        return result;
    }

    public static String[] coalesceCipherSpecs(String[] cipherSpec, String[] allowedCipherSpecs) {
        String[] tempSuites = new String[allowedCipherSpecs.length];
        int count = 0;
        for (int i = 0; i < cipherSpec.length; ++i) {
            boolean candidateIsAllowed = false;
            for (int j = 0; j < allowedCipherSpecs.length; ++j) {
                if (!cipherSpec[i].equals(allowedCipherSpecs[j])) continue;
                candidateIsAllowed = true;
                break;
            }
            if (!candidateIsAllowed) continue;
            tempSuites[count++] = cipherSpec[i];
        }
        String[] resultSuites = new String[count];
        System.arraycopy(tempSuites, 0, resultSuites, 0, count);
        return resultSuites;
    }
}

