/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.audit.AuditService;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class SecurityContext {
    private static final TraceComponent tc = Tr.register(SecurityContext.class, null, "com.ibm.ejs.resources.security");
    private static boolean isbServerProcess = false;
    private static final WebSphereRuntimePermission perm = new WebSphereRuntimePermission("SecurityContext");

    public static ContextManager getContextManager() {
        return ContextManagerFactory.getInstance();
    }

    protected static void setIsServerProcess() throws WSSecurityException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting server process = true");
        }
        isbServerProcess = true;
    }

    protected static void enable(AuditService auditService) throws WSSecurityException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Calling ContextManager.initialize()");
        }
        ContextManagerFactory.getInstance().initialize(auditService);
    }

    public static boolean isServerProcess() {
        return isbServerProcess;
    }

    public static void initialize() throws WSSecurityException {
    }

    public static void destroy() throws WSSecurityException {
        ContextManagerFactory.getInstance().clearCallerContext();
    }

    public static boolean isSecurityEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityEnabled");
        }
        boolean isEnabled = ContextManagerFactory.getInstance().isCellSecurityEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecurityEnabled", isEnabled);
        }
        return isEnabled;
    }

    public static String getUser() {
        String ret;
        block4: {
            if (!SecurityContext.isServerProcess()) {
                return null;
            }
            ret = null;
            try {
                WSCredential[] credential = ContextManagerFactory.getInstance().getCallerCredentials();
                if (credential != null && credential.length != 0 && credential[0] != null && !credential[0].isUnauthenticated()) {
                    ret = credential[0].getAccessId();
                }
            }
            catch (GeneralSecurityException e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error in getAccessId() from caller credential", e);
            }
        }
        return ret;
    }

    public static String getOwnName() {
        String ret;
        block4: {
            if (!SecurityContext.isServerProcess()) {
                return null;
            }
            ret = null;
            try {
                WSCredential credential = ContextManagerFactory.getInstance().getServerCredential();
                if (credential != null && !credential.isUnauthenticated()) {
                    ret = credential.getSecurityName();
                }
            }
            catch (GeneralSecurityException e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error in getSecurityName() from server credential", e);
            }
        }
        return SecurityContext.unqualifySecurityName(ret);
    }

    public static String getName() {
        if (!SecurityContext.isServerProcess()) {
            return null;
        }
        String qualifiedSecurityName = SecurityContext.getCallerNameWeb();
        return SecurityContext.unqualifySecurityName(qualifiedSecurityName);
    }

    public static String getCallerName() {
        String ret;
        block4: {
            if (!SecurityContext.isServerProcess()) {
                return null;
            }
            ret = null;
            try {
                WSCredential[] credential = ContextManagerFactory.getInstance().getCallerCredentials();
                if (credential != null && credential.length != 0 && credential[0] != null) {
                    ret = credential[0].getRealmSecurityName();
                }
            }
            catch (GeneralSecurityException e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error in getRealmSecurityName() from caller credential", e);
            }
        }
        return ret;
    }

    public static String getCallerNameWeb() {
        String ret;
        block4: {
            if (!SecurityContext.isServerProcess()) {
                return null;
            }
            ret = null;
            try {
                WSCredential[] credential = ContextManagerFactory.getInstance().getCallerCredentials();
                if (credential != null && credential.length != 0 && credential[0] != null && !credential[0].isUnauthenticated()) {
                    ret = credential[0].getRealmSecurityName();
                }
            }
            catch (GeneralSecurityException e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error in getRealmSecurityName() from caller credential", e);
            }
        }
        return ret;
    }

    public static String unqualifySecurityName(String qualifiedSecurityName) {
        String securityName = null;
        if (qualifiedSecurityName != null) {
            int idx = qualifiedSecurityName.indexOf("/");
            securityName = qualifiedSecurityName.substring(idx + 1);
        }
        return securityName;
    }

    public static Object runAsSystem(PrivilegedExceptionAction action) throws PrivilegedActionException {
        if (!SecurityContext.isServerProcess()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This is not a server process, so returning null.");
            }
            try {
                return action.run();
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        return ContextManagerFactory.getInstance().runAsSystem(action);
    }

    public static Object runAsSystemOrSpecified(PrivilegedExceptionAction action) throws PrivilegedActionException {
        if (!SecurityContext.isServerProcess()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This is not a server process, so running the action without setting the credential.");
            }
            try {
                return action.run();
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        return ContextManagerFactory.getInstance().runAsSystemOrSpecified(action);
    }

    public static Object runAsReceivedClient(PrivilegedExceptionAction action) throws PrivilegedActionException {
        if (!SecurityContext.isServerProcess()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This is not a server process, so running the action without setting the credential.");
            }
            try {
                return action.run();
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        return ContextManagerFactory.getInstance().runAsReceivedClient(action);
    }

    public static Object runAsClient(PrivilegedExceptionAction action) throws PrivilegedActionException {
        if (!SecurityContext.isServerProcess()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This is not a server process, so running the action without setting the credential.");
            }
            try {
                return action.run();
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        return ContextManagerFactory.getInstance().runAsClient(action);
    }
}

