/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.config.AdminData;
import com.ibm.ws.security.config.AuditConfig;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.DynamicTAIConfig;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigObjectFactory;
import com.ibm.ws.security.config.SecurityConfigResource;
import com.ibm.ws.security.config.SecurityThreadLocal;
import com.ibm.ws.security.config.naming.NamingAuthzConfig;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Stack;

public class SecurityObjectLocator {
    public static final String ADMIN = "admin";
    public static final String DOMAIN = "domain";
    private static TraceComponent tc = Tr.register(SecurityObjectLocator.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private static HashMap<String, Object> cache = new HashMap();
    private static boolean isSingleDomain = false;
    private static SecurityConfigResource adminContext = new SecurityConfigResource("", "Admin");
    private static SecurityConfigResource appContext = new SecurityConfigResource("", "Application");
    private static SecurityConfig adminSecurityConfig = null;
    private static SecurityConfig applicationSecurityConfig = null;
    private static SecurityConfig noinheritApplicationSecurityConfig = null;
    private static Object adminContextManager = null;
    private static Object applicationContextManager = null;
    private static SecurityConfigManager _scmInstance = null;
    private static SecurityConfigObjectFactory _scoFactory = null;
    private static InheritableThreadLocal _threadLocal = new InheritableThreadLocal(){

        protected synchronized Object initialValue() {
            Stack<SecurityConfigResource> stack = new Stack<SecurityConfigResource>();
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "initialValue()", stack);
            }
            return new SecurityThreadLocal(stack);
        }

        protected Object childValue(Object parentValue) {
            Stack<SecurityConfigResource> childStack = new Stack<SecurityConfigResource>();
            Stack<SecurityConfigResource> parentStack = ((SecurityThreadLocal)parentValue).getStack();
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.entry(tc, "childValue()", parentStack);
            }
            if (parentStack != null && !parentStack.isEmpty()) {
                childStack.push(parentStack.peek());
            }
            SecurityThreadLocal value2 = new SecurityThreadLocal(childStack);
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "childValue()", childStack);
            }
            return value2;
        }
    };

    public static void setSecurityConfigHelperFactory(SecurityConfigObjectFactory scHelperFactory) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "setSecurityConfigHelperFactory() ", _scoFactory != null ? _scoFactory.toString() : "null");
        }
        _scoFactory = scHelperFactory;
    }

    public static void setSecurityConfigManager(SecurityConfigManager scm) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "setSecurityConfigManager() ", _scmInstance != null ? _scmInstance.toString() : "null");
        }
        _scmInstance = scm;
    }

    public static boolean pushAdminContext() {
        return ((SecurityThreadLocal)_threadLocal.get()).pushResource(adminContext);
    }

    public static boolean pushAdminContext(String appName) {
        return ((SecurityThreadLocal)_threadLocal.get()).pushResource(appName, "Admin");
    }

    public static boolean pushAppContext(String appName) {
        if (appName == null || appName.length() == 0) {
            return ((SecurityThreadLocal)_threadLocal.get()).pushResource(appContext);
        }
        return ((SecurityThreadLocal)_threadLocal.get()).pushResource(appName, "Application");
    }

    public static boolean pushDomainContext(String name2, String type) {
        return SecurityObjectLocator.pushContext(name2, type);
    }

    public static boolean pushContext(String name2, String type) {
        return ((SecurityThreadLocal)_threadLocal.get()).pushResource(name2, type);
    }

    public static boolean pushDomainContext(SecurityConfigResource res) {
        return SecurityObjectLocator.pushContext(res);
    }

    public static boolean pushContext(SecurityConfigResource res) {
        return ((SecurityThreadLocal)_threadLocal.get()).pushResource(res);
    }

    public static SecurityConfigResource popDomainContext() {
        return SecurityObjectLocator.popContext();
    }

    public static SecurityConfigResource popContext() {
        return ((SecurityThreadLocal)_threadLocal.get()).popResource();
    }

    public static SecurityConfigResource peekDomainContext() {
        return SecurityObjectLocator.peekContext();
    }

    public static SecurityConfigResource peekContext() {
        return ((SecurityThreadLocal)_threadLocal.get()).peekResource();
    }

    public static SecurityThreadLocal getThreadLocal() {
        return (SecurityThreadLocal)_threadLocal.get();
    }

    private static String generateCacheKey(String keyPrefix) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "generateCacheKey() prefix=" + keyPrefix);
        }
        SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
        if (isSingleDomain) {
            return keyPrefix;
        }
        return keyPrefix + scm.getDomainId();
    }

    private static Object checkCache(String cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCache() cacheKey=" + cacheKey);
        }
        Object cachedObj = cache.get(cacheKey);
        return cachedObj;
    }

    private static void cacheObject(String cacheKey, Object instance) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheObject() cacheKey=" + cacheKey + " instance:", instance);
        }
        cache.put(cacheKey, instance);
    }

    private static void releaseObject(String cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseObject() cacheKey=" + cacheKey);
        }
        cache.remove(cacheKey);
    }

    private static synchronized void do_getSecurityConfigObjectFactory() {
        if (_scoFactory == null) {
            try {
                Class<?> cl1 = Class.forName("com.ibm.ws.security.config.SecurityConfigObjectFactoryImpl");
                Method theMethod1 = cl1.getMethod("getInstance", null);
                _scoFactory = (SecurityConfigObjectFactory)theMethod1.invoke((Object)null, (Object[])null);
            }
            catch (Exception e) {
                Tr.warning(tc, "Could not obtain SecurityConfigObjectFactory on the client side.", new Object[]{e});
            }
        }
    }

    private static SecurityConfigObjectFactory getSecurityConfigObjectFactory() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityConfigObjectFactory() ", _scoFactory != null ? _scoFactory.toString() : "null");
        }
        if (_scoFactory == null) {
            SecurityObjectLocator.do_getSecurityConfigObjectFactory();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityConfigObjectFactory() ", _scoFactory != null ? _scoFactory.toString() : "null");
        }
        return _scoFactory;
    }

    public static SecurityConfigManager getSecurityConfigManager() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityConfigManager() ", _scmInstance != null ? _scmInstance.toString() : "null");
        }
        if (_scmInstance == null) {
            if (SecurityObjectLocator.getSecurityConfigObjectFactory() != null) {
                _scmInstance = SecurityObjectLocator.getSecurityConfigObjectFactory().getSecurityConfigManager();
            }
            if (!RasHelper.isServer()) {
                isSingleDomain = true;
            } else if (_scmInstance != null) {
                boolean bl = isSingleDomain = !_scmInstance.isAdminAgent() && !_scmInstance.isMultiDomainDefined();
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "isSingleDomain=", isSingleDomain);
                }
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityConfigManager() ", _scmInstance != null ? _scmInstance.toString() : "null");
        }
        return _scmInstance;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String[] computeSecurityConfigCacheKey(String _scope, SecurityConfigResource res) {
        String cacheKey = null;
        String scmScope = null;
        String[] ret = null;
        if (_scope == null) {
            SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
            String domainId = null;
            domainId = res != null ? scm.getDomainId(res) : scm.getDomainId();
            if (domainId.equalsIgnoreCase(ADMIN)) {
                cacheKey = "SecurityConfig_admin";
                scmScope = "security";
            } else {
                cacheKey = "SecurityConfig_" + domainId;
                scmScope = "AppSecurity";
            }
        } else if (_scope.equalsIgnoreCase("security")) {
            cacheKey = "SecurityConfig_admin";
        } else {
            if (!_scope.equalsIgnoreCase("AppSecurity")) {
                Tr.error(tc, "computeSecurityConfigCacheKey() invalid scope " + _scope);
                return null;
            }
            SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
            String domainId = scm.getDomainId();
            if (domainId.equalsIgnoreCase(ADMIN)) {
                String domainName = scm.getDomainName();
                if (domainName == null) {
                    if (!SecurityConfigGlobals.enableVerbose) return null;
                    if (!tc.isEntryEnabled()) return null;
                    Tr.exit(tc, "computeSecurityConfigCacheKey() no domain exists, returning null");
                    return null;
                }
                cacheKey = "SecurityConfig_domain:" + domainName;
            } else {
                cacheKey = "SecurityConfig_" + domainId;
            }
        }
        if (scmScope == null) {
            ret = new String[]{cacheKey};
            return ret;
        }
        ret = new String[]{cacheKey, scmScope};
        return ret;
    }

    private static synchronized SecurityConfig do_getSecurityConfig(String cacheKey, String scmScope) {
        SecurityConfig cachedInstance = (SecurityConfig)SecurityObjectLocator.checkCache(cacheKey);
        if (cachedInstance == null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "getSecurityConfig() using cache key: " + cacheKey);
            }
            if ((cachedInstance = SecurityObjectLocator.getSecurityConfigObjectFactory().createSecurityConfig(scmScope, false, cacheKey)) != null) {
                cache.put(cacheKey, cachedInstance);
            } else {
                Exception e = new Exception("SecurityObjectLocator failed to create SecurityConfig helper");
                Manager.Ffdc.log(e, SecurityObjectLocator.class, "com.ibm.ws.security.config.SecurityObjectLocator", "275");
            }
        }
        return cachedInstance;
    }

    public static SecurityConfig getSecurityConfig() {
        return SecurityObjectLocator.getSecurityConfig(null);
    }

    public static SecurityConfig getSecurityConfig(String _scope) {
        SecurityConfig cachedInstance;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityConfig() " + _scope);
        }
        if (!RasHelper.isServer()) {
            Tr.info(tc, "Client code attempting to load security configuration");
        }
        if (isSingleDomain) {
            if (_scope == null || _scope.equalsIgnoreCase("Security")) {
                if (adminSecurityConfig == null) {
                    adminSecurityConfig = SecurityObjectLocator.do_getSecurityConfig(ADMIN, "security");
                }
                return adminSecurityConfig;
            }
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "computeSecurityConfigCacheKey() no domains defined and scope '" + _scope + "' requested, returning null");
            }
            return null;
        }
        SecurityConfigResource currentStackEntry = null;
        boolean setSomeConfig = false;
        boolean setAdminConfig = false;
        boolean setApplicationConfig = false;
        boolean setNoinheritApplicationConfig = false;
        if (_scope != null) {
            if (_scope.equalsIgnoreCase("security")) {
                if (adminSecurityConfig != null) {
                    if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSecurityConfig() returning adminSecurityConfig", adminSecurityConfig);
                    }
                    return adminSecurityConfig;
                }
                setAdminConfig = true;
                setSomeConfig = true;
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getSecurityConfig() adminSecurityConfig global null");
                }
            } else if (_scope.equalsIgnoreCase("AppSecurity")) {
                if (noinheritApplicationSecurityConfig != null) {
                    if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSecurityConfig() returning noinheritApplicationSecurityConfig", noinheritApplicationSecurityConfig);
                    }
                    return noinheritApplicationSecurityConfig;
                }
                setNoinheritApplicationConfig = true;
                setSomeConfig = true;
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getSecurityConfig() noinheritApplicationSecurityConfig global null");
                }
            }
        } else {
            SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
            if (!scm.isAdminAgent()) {
                currentStackEntry = SecurityObjectLocator.peekContext();
                if (currentStackEntry != null) {
                    SecurityConfig config = currentStackEntry.getSecurityConfig();
                    if (config != null) {
                        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                            Tr.exit(tc, "getSecurityConfig() returning config from current stack entry", config);
                        }
                        return config;
                    }
                    if (currentStackEntry.isAdmin()) {
                        if (adminSecurityConfig != null) {
                            currentStackEntry.setSecurityConfig(adminSecurityConfig);
                            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                                Tr.exit(tc, "getSecurityConfig() returning adminSecurityConfig and setting it in the current stack entry", adminSecurityConfig);
                            }
                            return adminSecurityConfig;
                        }
                        setAdminConfig = true;
                        setSomeConfig = true;
                        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                            Tr.debug(tc, "getSecurityConfig() admin stack entry with no config and adminSecurityConfig global null");
                        }
                    } else if (currentStackEntry.isApplication()) {
                        if (applicationSecurityConfig != null) {
                            currentStackEntry.setSecurityConfig(applicationSecurityConfig);
                            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                                Tr.exit(tc, "getSecurityConfig() returning applicationSecurityConfig and setting it in the current stack entry", applicationSecurityConfig);
                            }
                            return applicationSecurityConfig;
                        }
                        setApplicationConfig = true;
                        setSomeConfig = true;
                        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                            Tr.debug(tc, "getSecurityConfig() application stack entry with no config and applicationSecurityConfig global null");
                        }
                    } else if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getSecurityConfig() current stack entry (type: " + currentStackEntry.getType() + ") config ref is null, looking up SecurityConfig object");
                    }
                } else {
                    if (adminSecurityConfig != null) {
                        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                            Tr.exit(tc, "getSecurityConfig() returning admin config, null stack entry", adminSecurityConfig);
                        }
                        return adminSecurityConfig;
                    }
                    setAdminConfig = true;
                    setSomeConfig = true;
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getSecurityConfig() no stack entry and adminSecurityConfig global null");
                    }
                }
            }
        }
        String scmScope = _scope;
        String cacheKey = null;
        String[] ret = null;
        ret = SecurityObjectLocator.computeSecurityConfigCacheKey(_scope, currentStackEntry);
        if (ret == null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityConfig() <null>");
            }
            return null;
        }
        cacheKey = ret[0];
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "getSecurityConfig() using cache key: " + cacheKey);
        }
        if ((cachedInstance = (SecurityConfig)SecurityObjectLocator.checkCache(cacheKey)) == null) {
            if (ret.length == 2) {
                scmScope = ret[1];
            }
            cachedInstance = SecurityObjectLocator.do_getSecurityConfig(cacheKey, scmScope);
        }
        if (currentStackEntry != null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "getSecurityConfig() setting config in current stack entry");
            }
            currentStackEntry.setSecurityConfig(cachedInstance);
        }
        if (setSomeConfig) {
            if (setAdminConfig) {
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getSecurityConfig() setting adminSecurityConfig global");
                }
                adminSecurityConfig = cachedInstance;
            } else if (setApplicationConfig) {
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getSecurityConfig() setting applicationSecurityConfig global");
                }
                applicationSecurityConfig = cachedInstance;
            } else if (setNoinheritApplicationConfig) {
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getSecurityConfig() setting noinheritApplicationSecurityConfig global");
                }
                noinheritApplicationSecurityConfig = cachedInstance;
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityConfig() ", cachedInstance);
        }
        return cachedInstance;
    }

    public static void releaseSecurityConfig() {
        SecurityObjectLocator.releaseSecurityConfig(null);
    }

    public static void releaseSecurityConfig(String _scope) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseSecurityConfig() " + _scope);
        }
        String cacheKey = null;
        String[] ret = null;
        ret = SecurityObjectLocator.computeSecurityConfigCacheKey(_scope, null);
        if (ret == null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "releaseSecurityConfig()");
            }
            return;
        }
        cacheKey = ret[0];
        SecurityObjectLocator.releaseObject(cacheKey);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseSecurityConfig() " + _scope);
        }
    }

    private static synchronized AuditConfig do_getAuditConfig(String cacheKey) {
        AuditConfig cachedInstance = (AuditConfig)SecurityObjectLocator.checkCache(cacheKey);
        if (cachedInstance == null && (cachedInstance = SecurityObjectLocator.getSecurityConfigObjectFactory().createAuditConfig(cacheKey)) != null) {
            SecurityObjectLocator.cacheObject(cacheKey, cachedInstance);
        }
        return cachedInstance;
    }

    public static AuditConfig getAuditConfig() {
        AuditConfig cachedInstance;
        String cacheKey = "audit";
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuditConfig() context=audit");
        }
        if ((cachedInstance = (AuditConfig)SecurityObjectLocator.checkCache("audit")) == null) {
            cachedInstance = SecurityObjectLocator.do_getAuditConfig("audit");
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuditConfig() ", cachedInstance);
        }
        return cachedInstance;
    }

    private static synchronized CSIv2Config do_getCSIv2Config(String cacheKey, Object endPointMgr) {
        CSIv2Config cachedInstance = (CSIv2Config)SecurityObjectLocator.checkCache(cacheKey);
        if (cachedInstance == null && (cachedInstance = SecurityObjectLocator.getSecurityConfigObjectFactory().createCSIv2Config(cacheKey, endPointMgr)) != null) {
            SecurityObjectLocator.cacheObject(cacheKey, cachedInstance);
        }
        return cachedInstance;
    }

    public static CSIv2Config getCSIv2Config() {
        return SecurityObjectLocator.getCSIv2Config(null);
    }

    public static CSIv2Config getCSIv2Config(Object endPointMgr) {
        CSIv2Config cachedInstance;
        String cacheKey = SecurityObjectLocator.generateCacheKey("CSIv2Config_");
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCSIv2Config() context=" + cacheKey, endPointMgr);
        }
        if ((cachedInstance = (CSIv2Config)SecurityObjectLocator.checkCache(cacheKey)) == null) {
            cachedInstance = SecurityObjectLocator.do_getCSIv2Config(cacheKey, endPointMgr);
        } else {
            cachedInstance.updatePorts(endPointMgr);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCSIv2Config() ", cachedInstance);
        }
        return cachedInstance;
    }

    public static void releaseCSIv2Config() {
        String cacheKey = SecurityObjectLocator.generateCacheKey("CSIv2Config_");
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseCSIv2Config() " + cacheKey);
        }
        SecurityObjectLocator.releaseObject(cacheKey);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseCSIv2Config() " + cacheKey);
        }
    }

    private static synchronized AdminData do_getAdminData(String cacheKey) {
        AdminData cachedInstance = (AdminData)SecurityObjectLocator.checkCache(cacheKey);
        if (cachedInstance == null && (cachedInstance = SecurityObjectLocator.getSecurityConfigObjectFactory().createAdminData(cacheKey)) != null) {
            SecurityObjectLocator.cacheObject(cacheKey, cachedInstance);
        }
        return cachedInstance;
    }

    public static AdminData getAdminData(String scope) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminData(scope) " + scope);
        }
        String cacheKey = null;
        cacheKey = scope != null && scope.equalsIgnoreCase("security") ? (isSingleDomain ? "AdminData_" : "AdminData_admin") : SecurityObjectLocator.generateCacheKey("AdminData_");
        AdminData cachedInstance = (AdminData)SecurityObjectLocator.checkCache(cacheKey);
        if (cachedInstance == null) {
            cachedInstance = SecurityObjectLocator.do_getAdminData(cacheKey);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminData(scope) ", cachedInstance);
        }
        return cachedInstance;
    }

    public static AdminData getAdminData() {
        AdminData cachedInstance;
        String cacheKey = SecurityObjectLocator.generateCacheKey("AdminData_");
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminData() context=" + cacheKey);
        }
        if ((cachedInstance = (AdminData)SecurityObjectLocator.checkCache(cacheKey)) == null) {
            cachedInstance = SecurityObjectLocator.do_getAdminData(cacheKey);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminData() ", cachedInstance);
        }
        return cachedInstance;
    }

    public static void releaseAdminData() {
        String cacheKey = SecurityObjectLocator.generateCacheKey("AdminData_");
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseAdminData() " + cacheKey);
        }
        SecurityObjectLocator.releaseObject(cacheKey);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseAdminData() " + cacheKey);
        }
    }

    private static synchronized NamingAuthzConfig do_getNamingAuthzConfig(String cacheKey) {
        NamingAuthzConfig cachedInstance = (NamingAuthzConfig)SecurityObjectLocator.checkCache(cacheKey);
        if (cachedInstance == null && (cachedInstance = SecurityObjectLocator.getSecurityConfigObjectFactory().createNamingAuthzConfig(cacheKey)) != null) {
            SecurityObjectLocator.cacheObject(cacheKey, cachedInstance);
        }
        return cachedInstance;
    }

    public static NamingAuthzConfig getNamingAuthzConfig() {
        NamingAuthzConfig cachedInstance;
        String cacheKey = "NamingAuthzConfig";
        if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
            cacheKey = SecurityObjectLocator.generateCacheKey("NamingAuthzConfig_");
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamingAuthzConfig() context=" + cacheKey);
        }
        if ((cachedInstance = (NamingAuthzConfig)SecurityObjectLocator.checkCache(cacheKey)) == null) {
            cachedInstance = SecurityObjectLocator.do_getNamingAuthzConfig(cacheKey);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamingAuthzConfig() ", cachedInstance);
        }
        return cachedInstance;
    }

    public static void releaseNamingAuthzConfig() {
        String cacheKey = "NamingAuthzConfig";
        if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
            cacheKey = SecurityObjectLocator.generateCacheKey("NamingAuthzConfig_");
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseNamingAuthzConfig() " + cacheKey);
        }
        SecurityObjectLocator.releaseObject(cacheKey);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseNamingAuthzConfig() " + cacheKey);
        }
    }

    private static synchronized DynamicTAIConfig do_getDynamicTAIConfig(String cacheKey) {
        DynamicTAIConfig cachedInstance = (DynamicTAIConfig)SecurityObjectLocator.checkCache(cacheKey);
        if (cachedInstance == null && (cachedInstance = SecurityObjectLocator.getSecurityConfigObjectFactory().createDynamicTAIConfig()) != null) {
            SecurityObjectLocator.cacheObject(cacheKey, cachedInstance);
        }
        return cachedInstance;
    }

    public static DynamicTAIConfig getDynamicTAIConfig() {
        DynamicTAIConfig cachedInstance;
        String cacheKey = "DynamicTAIConfig";
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDynamicTAIConfig() context=DynamicTAIConfig");
        }
        if ((cachedInstance = (DynamicTAIConfig)SecurityObjectLocator.checkCache("DynamicTAIConfig")) == null) {
            cachedInstance = SecurityObjectLocator.do_getDynamicTAIConfig("DynamicTAIConfig");
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDynamicTAIConfig() ", cachedInstance);
        }
        return cachedInstance;
    }

    public static Object getRoleBasedConfigurator() {
        Object object = SecurityObjectLocator.getSecurityConfigObjectFactory().getRoleBasedConfigurator();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRoleBasecConfigurator() ", object);
        }
        return object;
    }

    public static void releaseRoleBasedConfigurator() {
        SecurityObjectLocator.getSecurityConfigObjectFactory().releaseRoleBasedConfigurator();
    }

    static SecurityConfig getAdminSecurityConfig() {
        return adminSecurityConfig;
    }

    public static Object getAdminContextManager() {
        return adminContextManager;
    }

    static void setAdminSecurityConfig(SecurityConfig config) {
        adminSecurityConfig = config;
    }

    public static void setAdminContextManager(Object contextManager) {
        adminContextManager = contextManager;
    }

    static SecurityConfig getApplicationSecurityConfig() {
        return applicationSecurityConfig;
    }

    public static Object getApplicationContextManager() {
        return applicationContextManager;
    }

    static void setApplicationSecurityConfig(SecurityConfig config) {
        applicationSecurityConfig = config;
    }

    public static void setApplicationContextManager(Object contextManager) {
        applicationContextManager = contextManager;
    }
}

