/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.auth.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import javax.security.auth.callback.CallbackHandler;

public final class SecurityCallbackHandlerAccessor {
    private static CallbackHandler callbackHandler;
    private static final WebSphereRuntimePermission perm;
    private static final TraceComponent tc;

    public static synchronized CallbackHandler getCallbackHandler() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallbackHandler()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCallbackHandler()");
        }
        return callbackHandler;
    }

    public static synchronized void setCallbackHandler(CallbackHandler newCallbackHandler) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCallbackHandler(newCallbackHandler)");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + perm.toString());
            }
            sm.checkPermission(perm);
        }
        callbackHandler = newCallbackHandler;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCallbackHandler(newCallbackHandler)");
        }
    }

    private SecurityCallbackHandlerAccessor() {
    }

    static {
        perm = new WebSphereRuntimePermission("setClientContainerCallback");
        tc = Tr.register(SecurityCallbackHandlerAccessor.class, null, "com.ibm.ejs.resources.security");
    }
}

