/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.metadata;

import com.ibm.ejs.csi.ResRefImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.GlobalTranConfigData;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.LocalTranConfigData;
import com.ibm.websphere.csi.ResRef;
import com.ibm.websphere.csi.ResRefList;
import com.ibm.ws.naming.java.javaNameSpace;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ContainerComponentMetaData;
import com.ibm.ws.runtime.metadata.CustomContainerComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.Context;

public class CustomContainerComponentMetaDataImpl
implements CustomContainerComponentMetaData {
    private static final TraceComponent tc = Tr.register(CustomContainerComponentMetaDataImpl.class, null, null);
    private static final String EOLN = System.getProperty("line.separator");
    private CustomContainerComponentMetaData.CustomResRefList _resRefList;
    private CustomContainerComponentMetaData.CustomLocalTranCfg _localTranConfigData;
    private CustomContainerComponentMetaData.CustomGlobalTranCfg _globalTranConfigData;
    private J2EEName _j2eeName;
    private javaNameSpace _javaNameSpace;
    private Context _javaNamespaceContext;
    private String _name;
    private ComponentMetaData _sourceMetaData = null;

    public CustomContainerComponentMetaDataImpl() {
        this._resRefList = new CustomResRefListImpl();
        this._localTranConfigData = new CustomLocalTranCfgImpl();
        this._globalTranConfigData = new CustomGlobalTranCfgImpl();
    }

    public CustomContainerComponentMetaDataImpl(ComponentMetaData cmd) {
        this._sourceMetaData = cmd;
        this._name = cmd.getName();
        this._j2eeName = cmd.getJ2EEName();
        if (cmd instanceof ContainerComponentMetaData) {
            ContainerComponentMetaData ccmd = (ContainerComponentMetaData)cmd;
            this._globalTranConfigData = new CustomGlobalTranCfgImpl(ccmd.getGlobalTranConfigData());
            this._localTranConfigData = new CustomLocalTranCfgImpl(ccmd.getLocalTranConfigData());
            this._resRefList = new CustomResRefListImpl(ccmd.getResourceRefList());
            this._javaNameSpace = ccmd.getJavaNameSpace();
            this._javaNamespaceContext = ccmd.getJavaNameSpaceContext();
        }
    }

    public ModuleMetaData getModuleMetaData() {
        return this._sourceMetaData.getModuleMetaData();
    }

    public J2EEName getJ2EEName() {
        return this._j2eeName;
    }

    public void setJ2EEName(J2EEName j2eeName) {
        this._j2eeName = j2eeName;
    }

    public Context getJavaNameSpaceContext() {
        return this._javaNamespaceContext;
    }

    public void setJavaNameSpaceContext(Context ctx) {
        this._javaNamespaceContext = ctx;
    }

    public javaNameSpace getJavaNameSpace() {
        return this._javaNameSpace;
    }

    public void setJavaNameSpace(javaNameSpace javaNameSpace2) {
        this._javaNameSpace = javaNameSpace2;
    }

    public String getName() {
        return this._name;
    }

    public void setMetaData(MetaDataSlot slot, Object metadata) {
        this._sourceMetaData.setMetaData(slot, metadata);
    }

    public Object getMetaData(MetaDataSlot slot) {
        return this._sourceMetaData.getMetaData(slot);
    }

    public void release() {
        this._sourceMetaData.release();
    }

    public LocalTranConfigData getLocalTran() {
        return this._localTranConfigData;
    }

    public LocalTranConfigData getLocalTranConfigData() {
        return this._localTranConfigData;
    }

    public CustomContainerComponentMetaData.CustomLocalTranCfg getCustomLocalTranConfigData() {
        return this._localTranConfigData;
    }

    public GlobalTranConfigData getGlobalTranConfigData() {
        return this._globalTranConfigData;
    }

    public CustomContainerComponentMetaData.CustomGlobalTranCfg getCustomGlobalTranConfigData() {
        return this._globalTranConfigData;
    }

    public ResRefList getResourceRefList() {
        return this._resRefList;
    }

    public CustomContainerComponentMetaData.CustomResRefList getCustomResourceRefList() {
        return this._resRefList;
    }

    public MetaData getSourceMetaData() {
        return this._sourceMetaData;
    }

    public String toString() {
        String separator = EOLN;
        StringBuffer sb = new StringBuffer();
        String sep = "                                 ";
        sb.append(separator + sep + "*** START CustomContainerComponentMetaData fields ***");
        sb.append(separator + sep + "name=" + this._name);
        sb.append(separator + sep + "j2eeName=" + this._j2eeName);
        sb.append(this._localTranConfigData);
        sb.append(this._globalTranConfigData);
        sb.append(this._resRefList);
        sb.append(separator + sep + "srcMetaData Type=" + (this._sourceMetaData == null ? null : this._sourceMetaData.getClass()));
        sb.append(separator + sep + "*** END CustomContainerComponentMetaData fields  ***");
        sb.append(separator + sep + "--- Source Meta-Data ---");
        sb.append(separator + (this._sourceMetaData == null ? "-none-" : this._sourceMetaData.toString()));
        return sb.toString();
    }

    public class CustomGlobalTranCfgImpl
    implements CustomContainerComponentMetaData.CustomGlobalTranCfg {
        private int transactionTimeout;
        private boolean sendWSAT;

        private CustomGlobalTranCfgImpl() {
            this.transactionTimeout = 0;
            this.sendWSAT = false;
        }

        private CustomGlobalTranCfgImpl(GlobalTranConfigData gtcfg) {
            this.transactionTimeout = gtcfg.getTransactionTimeout();
            this.sendWSAT = gtcfg.isSendWSAT();
        }

        public boolean isSendWSAT() {
            return this.sendWSAT;
        }

        public void setSendWSAT(boolean sendWSAT) {
            this.sendWSAT = sendWSAT;
        }

        public int getTransactionTimeout() {
            return this.transactionTimeout;
        }

        public void setTransactionTimeout(int transactionTimeout) {
            this.transactionTimeout = transactionTimeout;
        }

        public String toString() {
            String separator = EOLN;
            String sep = "                                 ";
            StringBuffer sb = new StringBuffer();
            sb.append(separator + sep + "      ****** CustomGlobalTranCfgImpl *******");
            sb.append(separator + sep + "transactionTimeout=" + this.transactionTimeout);
            sb.append(separator + sep + "isSendWSAT=" + this.sendWSAT);
            return sb.toString();
        }
    }

    public class CustomResRefListImpl
    implements CustomContainerComponentMetaData.CustomResRefList {
        private Vector _resRefVector;

        private CustomResRefListImpl() {
            this.setDefault();
        }

        private CustomResRefListImpl(ResRefList rrl) {
            if (rrl == null) {
                this.setDefault();
            } else {
                int numRefs = rrl.size();
                this._resRefVector = new Vector(numRefs);
                for (int i = 0; i < numRefs; ++i) {
                    ResRefImpl rr = new ResRefImpl(rrl.get(i));
                    this._resRefVector.add(i, rr);
                }
            }
        }

        private void setDefault() {
            this._resRefVector = new Vector();
        }

        public void addResRef(String description, String name2, String jndiName, String type, int resAuth, int resSharingScope, int resIsolationLevel) {
            this._resRefVector.add(new ResRefImpl(description, name2, jndiName, type, resAuth, resSharingScope, resIsolationLevel));
        }

        public ResRef findByName(String s) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "findByName", s);
            }
            Iterator resRefIterator = this._resRefVector.iterator();
            ResRef resRef = null;
            while (resRefIterator.hasNext() && !s.equals((resRef = (ResRef)resRefIterator.next()).getName())) {
                resRef = null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (resRef == null) {
                    Tr.debug(tc, "Resource with name '" + s + "' not found. Returning null.");
                } else {
                    Tr.debug(tc, "Returning " + ((ResRefImpl)resRef).toString());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "findByName");
            }
            return resRef;
        }

        public ResRef findByJNDIName(String s) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "findByJNDIName", s);
            }
            Iterator resRefIterator = this._resRefVector.iterator();
            ResRef resRef = null;
            while (resRefIterator.hasNext() && !s.equals((resRef = (ResRef)resRefIterator.next()).getJNDIName())) {
                resRef = null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (resRef == null) {
                    Tr.debug(tc, "Resource with JNDIName '" + s + "' not found. Returning null.");
                } else {
                    Tr.debug(tc, "Returning " + ((ResRefImpl)resRef).toString());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "findByJNDIName");
            }
            return resRef;
        }

        public void setLookupString(String s) {
        }

        public int size() {
            return this._resRefVector.size();
        }

        public ResRef get(int i) {
            return (ResRef)this._resRefVector.get(i);
        }

        public String toString() {
            String separator = EOLN;
            String sep = "                                 ";
            StringBuffer sb = new StringBuffer();
            int size = this._resRefVector.size();
            sb.append(separator + sep + "      ******* CustomResRefListImpl ******* ");
            sb.append(separator + sep + "ResRefList size=" + size);
            for (int i = 0; i < size; ++i) {
                sb.append(((ResRefImpl)this._resRefVector.get(i)).toString());
            }
            return sb.toString();
        }
    }

    public class CustomLocalTranCfgImpl
    implements CustomContainerComponentMetaData.CustomLocalTranCfg {
        private int boundary;
        private int resolver;
        private int unresolvedAction;
        private boolean isShareable;

        private CustomLocalTranCfgImpl() {
            this.boundary = 0;
            this.resolver = 0;
            this.unresolvedAction = 0;
            this.isShareable = false;
        }

        private CustomLocalTranCfgImpl(LocalTranConfigData ltc) {
            this.boundary = ltc.getValueBoundary();
            this.resolver = ltc.getValueResolver();
            this.unresolvedAction = ltc.getValueUnresolvedAction();
            this.isShareable = ltc.isShareable();
        }

        public int getValueBoundary() {
            return this.boundary;
        }

        public int getValueResolver() {
            return this.resolver;
        }

        public int getValueUnresolvedAction() {
            return this.unresolvedAction;
        }

        public boolean isShareable() {
            return this.isShareable;
        }

        public void setValueBoundary(int i) {
            this.boundary = i;
        }

        public void setValueResolver(int i) {
            this.resolver = i;
        }

        public void setValueUnresolvedAction(int i) {
            this.unresolvedAction = i;
        }

        public String toString() {
            String separator = EOLN;
            String sep = "                                 ";
            StringBuffer sb = new StringBuffer();
            sb.append(separator + sep + "      ****** CustomLTCDataImpl *******");
            if (this.boundary == 1) {
                sb.append(separator + sep + "Boundary=ACTIVITY");
            } else if (this.boundary == 0) {
                sb.append(separator + sep + "Boundary=BEAN_METHOD");
            } else {
                sb.append(separator + sep + "Boundary=UNKNOWN");
            }
            if (this.resolver == 0) {
                sb.append(separator + sep + "Resolver=APPLICATION");
            } else if (this.resolver == 1) {
                sb.append(separator + sep + "Resolver=CONTAINER_AT_BOUNDARY");
            } else {
                sb.append(separator + sep + "Resolver=UNKNOWN");
            }
            if (this.unresolvedAction == 0) {
                sb.append(separator + sep + "UnResolvedAction=ROLLBACK");
            } else if (this.unresolvedAction == 1) {
                sb.append(separator + sep + "UnResolvedAction=COMMIT");
            } else {
                sb.append(separator + sep + "UnResolvedAction=UNKNOWN");
            }
            if (this.isShareable) {
                sb.append(separator + sep + "isShareable=TRUE");
            } else {
                sb.append(separator + sep + "isShareable=FALSE");
            }
            return sb.toString();
        }
    }
}

