/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.jms.JMSRegistrar;
import com.ibm.ejs.jms.JMSRegistrationFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.runtime.component.binder.J2CBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.cred.AuthDataCredential;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Properties;

public abstract class JMSBinder
extends J2CBinder {
    private static TraceComponent tc = Tr.register(JMSBinder.class, "ResourceBinders", "com.ibm.ejs.jms.messaging");
    private static Boolean baseServer = null;

    protected void addJMSServerProperties(Properties p, String nodeName) throws ResourceBindingException {
        if (nodeName == null) {
            throw new ResourceBindingException("No node name property set for resource");
        }
        EndPointMgr.NodeEndPoints node_ends = null;
        EndPointMgr.EndPointInfo direct = null;
        EndPointMgr.EndPointInfo queued = null;
        String jmsserverHost = null;
        Integer directPort = null;
        Integer queuedPort = null;
        try {
            EndPointMgr eman = WsServiceRegistry.getService(this, EndPointMgr.class);
            if (eman != null) {
                EndPointMgr.ServerEndPoints serverEndPoints;
                node_ends = eman.getNodeEndPoints(nodeName);
                if (node_ends != null && (serverEndPoints = node_ends.getServerEndPoints(JMSBinder.isBaseServer() ? "@" : "jmsserver")) != null) {
                    direct = serverEndPoints.getEndPointInfo("JMSSERVER_DIRECT_ADDRESS");
                    queued = serverEndPoints.getEndPointInfo("JMSSERVER_QUEUED_ADDRESS");
                }
                if (direct != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "JMSServer direct endpoint: " + direct.getHost() + ":" + direct.getPort());
                    }
                    jmsserverHost = direct.getHost();
                    directPort = new Integer(direct.getPort());
                }
                if (queued != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "JMSServer queued endpoint: " + queued.getHost() + ":" + queued.getPort());
                    }
                    if (jmsserverHost == null) {
                        jmsserverHost = queued.getHost();
                    }
                    queuedPort = new Integer(queued.getPort());
                }
            }
        }
        catch (Throwable e) {
            Tr.audit(tc, "Exception reading node endpoints", e);
        }
        if (jmsserverHost == null || jmsserverHost.equals("")) {
            jmsserverHost = "localhost";
        }
        if (queuedPort == null) {
            queuedPort = new Integer(5558);
        }
        if (directPort == null) {
            directPort = new Integer(5559);
        }
        this.setProperty(p, "NODH", jmsserverHost, true);
        this.setProperty(p, "QUEUEDPORT", queuedPort.toString(), true);
        this.setProperty(p, "DIRECTPORT", directPort.toString(), true);
    }

    public String getNamePrefix() {
        return "jms";
    }

    protected void checkRequiredProperty(String resourceName, String propertyName, Object property) throws ResourceBindingException {
        this.checkRequiredProperty(property, "Invalid Configuration! The JMS Resource: " + resourceName + " has a null " + propertyName + " property.");
    }

    protected void setAuthenticationProperties(ConfigObject factory, Properties properties) {
        String alias;
        block4: {
            alias = factory.getString("authDataAlias", "__null__");
            try {
                AuthDataCredential credential = WSDefaultPrincipalMapping.getAuthData((String)alias);
                if (credential != null) {
                    this.setProperty(properties, "UserName", credential.getUserName(), true);
                    this.setProperty(properties, "Password", credential.getPassword(), true);
                }
            }
            catch (Exception exc) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "Failed to get auth data for alias " + alias, exc);
            }
        }
        this.setProperty(properties, "OptionC_authDataAlias", alias, true);
        ConfigObject mapping = factory.getObject("mapping");
        if (mapping != null) {
            this.setProperty(properties, "mappingConfigAlias", mapping.getString("mappingConfigAlias", "__null__"), true);
            this.setProperty(properties, "authDataAlias", mapping.getString("authDataAlias", "__null__"), true);
        }
    }

    private static boolean isBaseServer() {
        if (baseServer == null) {
            AdminService adminService = AdminServiceFactory.getAdminService();
            String processType = adminService.getProcessType();
            baseServer = processType.equals("UnManagedProcess") ? Boolean.TRUE : Boolean.FALSE;
        }
        return baseServer;
    }

    protected boolean checkMapNameStyleCompatiability() {
        boolean compatible = false;
        JMSRegistrar jmsRegistrarInstance = JMSRegistrationFactory.getJMSRegistration();
        if (jmsRegistrarInstance != null) {
            compatible = jmsRegistrarInstance.checkCompatibleVersion("6.0.1.1");
        }
        return compatible;
    }
}

