/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.j2c.ConnectionFactoryRefBuilderFactory;
import com.ibm.ejs.j2c.ConnectorProperties;
import com.ibm.ejs.j2c.ConnectorProperty;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.J2CBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.cred.AuthDataCredential;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.security.auth.login.LoginException;

public class DataSourceBinder
extends J2CBinder {
    private static final TraceComponent tc = Tr.register(DataSourceBinder.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");

    public boolean isUsedFor(ConfigObject resource) {
        return resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jdbc.xmi", "DataSource");
    }

    public String getNamePrefix() {
        return "jdbc";
    }

    public Object getBindingObject(ConfigObject dataSource) throws ResourceBindingException {
        String xaRecoveryAuthAlias;
        Properties properties = new Properties();
        ConnectorProperties configProps = new ConnectorProperties();
        Properties dataSourceProperties = new Properties();
        ConfigObject jdbcDriver = dataSource.getParent();
        String dataSourceName = dataSource.getString("name", "__null__");
        String authDataAlias = dataSource.getString("authDataAlias", "__null__");
        String userName = null;
        String password = null;
        if (authDataAlias != null) {
            try {
                AuthDataCredential authDC = WSDefaultPrincipalMapping.getAuthData((String)authDataAlias);
                if (authDC != null) {
                    int status = authDC.getStatus();
                    if (status == 1) {
                        Object[] parms = new Object[]{"Data Source", dataSourceName, authDataAlias};
                        Tr.warning(tc, "MISSING_AUTH_DATA_ENTRY_J2CA0130", parms);
                    } else {
                        ConnectorProperty connProp = new ConnectorProperty("OptionC_authDataAlias", "java.lang.String", authDataAlias);
                        configProps.add((Object)connProp);
                    }
                    userName = authDC.getUserName();
                    password = authDC.getPassword();
                }
            }
            catch (LoginException le) {
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((xaRecoveryAuthAlias = dataSource.getString("xaRecoveryAuthAlias", "__null__")) != null) {
            ConnectorProperty connProp = new ConnectorProperty("XA_RECOVERY_AUTH_ALIAS", "java.lang.String", xaRecoveryAuthAlias);
            configProps.add((Object)connProp);
        }
        ConfigObject mapMod = dataSource.getObject("mapping");
        ConfigObject pool2 = dataSource.getObject("connectionPool");
        this.checkRequiredProperty(pool2, "Invalid Configuration! The DataSource: " + dataSourceName + " has a null ConnectionPool property.");
        ConfigObject ra = dataSource.getObject("relationalResourceAdapter");
        this.checkRequiredProperty(ra, "Invalid Configuration! The DataSource: " + dataSourceName + " has a null RelationalResourceAdapter property.");
        String resourceAdapterConfigId = ra.getID();
        if (!"builtin_rra".equals(resourceAdapterConfigId)) {
            Tr.error(tc, "UNEXPECTED_RA_FOR_DATASOURCE_J2CA0217", new Object[]{dataSourceName, resourceAdapterConfigId});
        }
        try {
            this.addDsPropertySet(dataSourceProperties, dataSource.getObject("propertySet"));
            this.setProperty(dataSourceProperties, "dataSourceClass", jdbcDriver.getString("implementationClassName", "__null__"), true);
            this.setProperty(dataSourceProperties, "dataStoreHelperClass", dataSource.getString("datasourceHelperClassname", "__null__"), true);
            this.setProperty(dataSourceProperties, "statementCacheSize", new Integer(dataSource.getInt("statementCacheSize", 10)), false);
            this.setProperty(dataSourceProperties, "dataSourceJndiName", dataSource.getString("jndiName", "__null__"), false);
            this.setProperty(dataSourceProperties, "classpath", this.stringListToPath(jdbcDriver.getUnexpandedStringList("classpath")), false);
            this.setProperty(dataSourceProperties, "nativepath", this.stringListToPath(jdbcDriver.getUnexpandedStringList("nativepath")), false);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.DataSourceBinder.getBindingObject", "112", this);
            Tr.service(tc, "Exception binding " + dataSourceName + ":", e);
            throw new ResourceBindingException(dataSource, e.toString());
        }
        this.addJ2CResourceAdapterProperties(properties, ra);
        ConfigObject c = ra.getObject("deploymentDescriptor");
        if (c == null) {
            throw new ResourceBindingException("No JCA Connector defined");
        }
        boolean isJCA15 = this.checkJCA15(c.getString("specVersion", "__null__"));
        if (isJCA15) {
            List connDefList = c.getObject("resourceAdapter").getObject("outboundResourceAdapter").getObjectList("connectionDefinitions");
            if (connDefList.size() != 1) {
                Tr.error(tc, "MULTIPLE_CONNECTION_DEFINITIONS_J2CA0287", dataSourceName);
            }
            if (connDefList.size() > 0) {
                this.addConnectionDefinitionProperties(properties, (ConfigObject)connDefList.get(0));
            }
        }
        String raKey = null;
        try {
            raKey = AdminServiceFactory.getAdminService().getMBeanFactory().getConfigId(ra);
        }
        catch (AdminException e) {
            // empty catch block
        }
        this.checkSetProperty(properties, "resourceAdapterJavaBeanKey", raKey);
        this.setProperty(properties, "ConnectionFactoryType", ConnectionFactoryRefBuilder.FACTORY_WSJdbcDataSource, false);
        this.setProperty(properties, "name", dataSourceName, false);
        this.setProperty(properties, "authMechanismPreference", dataSource.getString("authMechanismPreference", "BASIC_PASSWORD"), true);
        if (isJCA15) {
            this.setProperty(properties, "manageCachedHandles", new Boolean(dataSource.getBoolean("manageCachedHandles", false)), false);
            this.setProperty(properties, "logMissingTransactionContext", new Boolean(dataSource.getBoolean("logMissingTransactionContext", true)), false);
        }
        this.setProperty(properties, "diagnoseConnectionUsage", new Boolean(dataSource.getBoolean("diagnoseConnectionUsage", false)), false);
        if (mapMod != null) {
            this.setProperty(properties, "mappingConfigAlias", mapMod.getString("mappingConfigAlias", "__null__"), true);
            String optionAAlias = mapMod.getString("authDataAlias", "__null__");
            if (optionAAlias != null) {
                this.setProperty(properties, "authDataAlias", optionAAlias, false);
            }
        }
        this.addJ2EEHrefProperties(properties, dataSource);
        this.addConnectionPoolProperties(properties, pool2);
        this.addConnectorPropertySet(configProps, ra.getObject("propertySet"));
        ConnectionFactoryRefBuilder refBuilder = ConnectionFactoryRefBuilderFactory.create();
        return refBuilder.createConnectorReferenceableObject(properties, configProps, dataSourceProperties);
    }

    private void addDsPropertySet(Properties props, ConfigObject co) {
        List propertyList = co.getObjectList("resourceProperties");
        for (int i = 0; i < propertyList.size(); ++i) {
            ConfigObject property = (ConfigObject)propertyList.get(i);
            if (property == null) continue;
            String name2 = property.getUnexpandedString("name", "__null__");
            String value2 = null;
            boolean expand = true;
            if (name2.equals("CloudscapeOldDatabaseName") || name2.equals("CloudscapeOldClasspath") || name2.startsWith("MIGROLD_")) {
                expand = false;
            }
            if (expand) {
                name2 = property.getString("name", "__null__");
                value2 = property.getString("value", "__null__");
            } else {
                value2 = property.getUnexpandedString("value", "__null__");
            }
            if (name2 == null || value2 == null) continue;
            props.setProperty(name2, value2);
        }
    }

    private String stringListToPath(List stringList) {
        int n;
        String path = "";
        if (stringList != null && (n = stringList.size()) > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                String unexpandedString = (String)stringList.get(i);
                String expandedString = null;
                try {
                    expandedString = this.expandVariable(unexpandedString);
                }
                catch (IllegalArgumentException iae) {
                    expandedString = unexpandedString;
                    Tr.service(tc, "An exception occurred expanding path string" + expandedString + ": " + iae + "; see FFDC log, probe ID=485");
                    FFDCFilter.processException((Throwable)iae, "com.ibm.ws.runtime.component.binder.DataSourceBinder.stringListToPath", "485", this);
                }
                if (expandedString == null || expandedString.length() <= 0) continue;
                sb.append(expandedString);
                if (i >= n - 1 || sb.charAt(sb.length() - 1) == File.pathSeparatorChar) continue;
                sb.append(File.pathSeparatorChar);
            }
            path = sb.toString();
        }
        return path;
    }
}

