/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.TransportChannelLoader;
import com.ibm.wsspi.channel.framework.exception.ChannelInstalledUnallowed;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportChannelLoaderImpl
extends WsComponentImpl
implements TransportChannelLoader {
    private static final TraceComponent tc = Tr.register(TransportChannelLoaderImpl.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private List<File> fileList = null;
    private File defaultJarLocation = null;
    private boolean channelInstallAllowed = true;

    @Override
    public synchronized void installTransportChannelJar(String jarName) throws IOException, ChannelInstalledUnallowed {
        if (!this.channelInstallAllowed) {
            throw new ChannelInstalledUnallowed("Channel install not allowed at this point in the runtime startup.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding channel: " + jarName);
        }
        if (null == this.defaultJarLocation) {
            this.defaultJarLocation = new File(System.getProperty("was.install.root"), "installedChannels");
            if (!this.defaultJarLocation.exists() || !this.defaultJarLocation.isDirectory()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default channel directory is missing " + this.defaultJarLocation);
                }
                this.defaultJarLocation = null;
                throw new IOException("Cannot find default channel directory");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Using default directory");
        }
        this.addChannelJar(this.defaultJarLocation, jarName);
    }

    @Override
    public synchronized void installTransportChannelJar(String jarName, String directory) throws IOException, ChannelInstalledUnallowed {
        File dir;
        if (!this.channelInstallAllowed) {
            throw new ChannelInstalledUnallowed("Channel install not allowed at this point in the runtime startup.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding channel: " + jarName);
        }
        if (!(dir = new File(System.getProperty("was.install.root"), directory)).exists() || !dir.isDirectory()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, directory + " channel directory is missing " + dir);
            }
            dir = null;
            throw new IOException("Cannot find channel directory, " + directory);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Using directory " + directory);
        }
        this.addChannelJar(dir, jarName);
    }

    private void addChannelJar(File directory, String jarName) throws IOException {
        File jar = new File(this.defaultJarLocation, jarName);
        if (!jar.exists() || !jar.isFile()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Jar " + jarName + " to install is missing " + jar + " in directory " + directory);
            }
            this.defaultJarLocation = null;
            throw new IOException("Cannot find channel jar " + jarName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Jar " + jarName + " found");
        }
        if (this.fileList == null) {
            this.fileList = new ArrayList<File>(4);
        }
        this.fileList.add(jar);
    }

    @Override
    public void initialize(Object configuration) {
        try {
            WsServiceRegistry.addService(this, TransportChannelLoader.class);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".initialize", "138", this);
        }
    }

    public synchronized List<File> unloadChannelList() {
        this.channelInstallAllowed = false;
        List<File> ret = this.fileList;
        this.fileList = null;
        this.defaultJarLocation = null;
        return ret;
    }
}

