/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.jms.DurableSubscriptionManager;
import com.ibm.ejs.jms.DurableSubscriptionManagerFactory;
import com.ibm.ejs.jms.ServiceAccessor;
import com.ibm.ejs.jms.listener.MDBListenerManager;
import com.ibm.ejs.jms.listener.MDBListenerManagerFactory;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.MessageListenerManager;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;

public class MessageListenerImpl
extends ComponentImpl
implements MessageListenerManager,
DeployedObjectListener,
PropertyChangeListener {
    protected MDBListenerManager mdbListenerManager;
    protected DurableSubscriptionManager durableSubMgr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object config) throws ConfigurationWarning, ConfigurationError {
        ConfigObject mls = (ConfigObject)config;
        ThreadPool sessionThreadPool = null;
        ConfigObject mls_threadPool = mls.getObject("threadPool");
        if (mls_threadPool == null) {
            throw new ConfigurationError("MessageListenerService - no thread pool defined");
        }
        ThreadPoolMgr tpm = null;
        try {
            tpm = (ThreadPoolMgr)this.getService(ThreadPoolMgr.class);
            sessionThreadPool = tpm.getThreadPoolFromConfigObject("MessageListenerThreadPool", mls_threadPool);
        }
        finally {
            this.releaseService(tpm);
        }
        this.durableSubMgr = DurableSubscriptionManagerFactory.create();
        this.durableSubMgr.initialize(this.getInstalledApplications(), this.expandVariable("${WAS_TEMP_DIR}"));
        ServiceAccessor extendedMessagingService = null;
        Object extendedMessagingInstance = null;
        try {
            extendedMessagingService = (ServiceAccessor)this.getService(Class.forName("com.ibm.ws.ems.ExtendedMessagingService"));
            extendedMessagingInstance = extendedMessagingService.getInstance();
        }
        catch (Exception e) {
            extendedMessagingInstance = null;
        }
        finally {
            if (extendedMessagingService != null) {
                this.releaseService(extendedMessagingService);
            }
        }
        ConfigService configService = (ConfigService)this.getService(ConfigService.class);
        boolean dynamicConfigurationEnabled = false;
        List customProperties = mls.getObjectList("properties");
        if (customProperties != null) {
            for (int i = 0; i < customProperties.size(); ++i) {
                ConfigObject wccmProp = (ConfigObject)customProperties.get(i);
                if (!wccmProp.getString("name", "__null__").equalsIgnoreCase("DYNAMIC.CONFIGURATION.ENABLED")) continue;
                dynamicConfigurationEnabled = Boolean.valueOf(wccmProp.getString("value", "__null__"));
            }
        }
        this.mdbListenerManager = MDBListenerManagerFactory.createMDBListenerManager();
        this.mdbListenerManager.initialize((Object)configService, (Object)mls, extendedMessagingInstance, (Object)sessionThreadPool, (Object)this.durableSubMgr, this.expandVariable("${WAS_TEMP_DIR}"), dynamicConfigurationEnabled);
        if (dynamicConfigurationEnabled) {
            Admin admin = null;
            try {
                admin = (Admin)this.getService(Admin.class);
                admin.addConfigChangeListener((ConfigChangeListener)this.mdbListenerManager);
            }
            finally {
                if (admin != null) {
                    this.releaseService(admin);
                }
            }
        }
        this.getBeanContextServices().addService(MessageListenerManager.class, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeError, RuntimeWarning {
        this.mdbListenerManager.startManager();
        this.durableSubMgr.checkDurableSubscriptions();
        ApplicationMgr appMgr = null;
        try {
            appMgr = (ApplicationMgr)this.getService(ApplicationMgr.class);
            appMgr.addDeployedObjectListener(this);
            this.setupAppMgrListenerForServerStopping(appMgr);
        }
        finally {
            this.releaseService(appMgr);
        }
    }

    public void stateChanged(DeployedObjectEvent doe) throws RuntimeError, RuntimeWarning {
        ((DeployedObjectListener)this.mdbListenerManager).stateChanged(doe);
        ((DeployedObjectListener)this.durableSubMgr).stateChanged(doe);
    }

    public MDBListenerManager getMDBListenerManager() {
        return this.mdbListenerManager;
    }

    public DurableSubscriptionManager getDurableSubscriptionManager() {
        return this.durableSubMgr;
    }

    private List getInstalledApplications() throws ConfigurationError {
        ConfigService configService = null;
        Server server2 = null;
        Vector<String> installedApps = new Vector<String>();
        String serverName = null;
        try {
            configService = (ConfigService)this.getService(ConfigService.class);
            server2 = (Server)this.getService(Server.class);
            serverName = server2.getName();
            ConfigScope configScope = configService.getScope(3);
            List docObjects = configService.getDocumentObjects(configScope, "serverindex.xml");
            List list = ((ConfigObject)docObjects.get(0)).getObjectList("serverEntries");
            for (int i = 0; i < list.size(); ++i) {
                ConfigObject se = (ConfigObject)list.get(i);
                if (!se.getString("serverName", "__null__").equals(serverName)) continue;
                List apps = se.getStringList("deployedApplications");
                for (int j = 0; j < apps.size(); ++j) {
                    String appName = (String)apps.get(j);
                    int index = appName.indexOf("/");
                    if (index != -1) {
                        appName = appName.substring(0, index - 4);
                    }
                    installedApps.add(appName);
                }
            }
        }
        catch (Exception e) {
            try {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.MessageListenerImpl.getInstalledApplications", "144", this);
                throw new ConfigurationError("MessageListenerService - unable to read serverindex configuration");
            }
            catch (Throwable throwable) {
                this.releaseService(configService);
                this.releaseService(server2);
                throw throwable;
            }
        }
        this.releaseService(configService);
        this.releaseService(server2);
        return installedApps;
    }

    private void setupAppMgrListenerForServerStopping(ApplicationMgr appMgr) {
        appMgr.addPropertyChangeListener("state", this);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getNewValue().equals("STOPPING")) {
            this.mdbListenerManager.applicationManagerStopping();
        }
    }
}

