/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.bootstrap.StopWatch;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.exception.WsRuntimeFwException;
import com.ibm.ws.exception.WsRuntimeFwExceptionUtil;
import com.ibm.ws.runtime.component.AsynchronousInitializer;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.config.ConfigLocatorAdapter;
import com.ibm.ws.runtime.config.ContainerConfigFactory;
import com.ibm.ws.runtime.config.InternalConfigService;
import com.ibm.ws.runtime.provisioning.ComponentMetaDataMgr;
import com.ibm.ws.runtime.service.ComponentManager;
import com.ibm.ws.runtime.service.ServiceProvider;
import com.ibm.wsspi.runtime.component.WsComponent;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.component.WsContainer;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerHelper {
    private static final TraceComponent tc = Tr.register(ContainerHelper.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private WsComponentImpl requestor;
    private String containerComponentName;
    private static final int INITIALIZE = 0;
    private static final int START = 1;
    private static final int STOP = 2;
    private static final int DESTROY = 3;
    private Object rootConfig;
    private ConfigLocatorAdapter[] locators;

    public ContainerHelper(WsComponentImpl requestor) {
        this.requestor = requestor;
    }

    public void destroyComponents(List components, List<Object> applicationComponents) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry(tc, "destroyComponents");
        }
        List allComponents = this.sortAllComponentsOfContainer(components, applicationComponents);
        for (ContainerImpl.ComponentStartup componentStartup : allComponents) {
            this.destroyComponent(componentStartup);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit(tc, "destroyComponents");
        }
    }

    private void destroyComponent(ContainerImpl.ComponentStartup componentStartup) {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "destroying " + componentStartup.componentInstance + " with global order = " + componentStartup.globalOrder);
            }
            if (componentStartup.componentInstance instanceof WsComponent) {
                WsComponent component = (WsComponent)componentStartup.componentInstance;
                component.destroy();
            } else {
                this.invokeNonWsComponent(3, componentStartup.componentInstance, componentStartup);
            }
        }
        catch (Throwable t) {
            Manager.Ffdc.log(t, this, null, "350");
            Tr.error(tc, "WSVR0103E", new Object[]{componentStartup, t});
        }
    }

    private void invokeNonWsComponent(int operation, Object component, ContainerImpl.ComponentStartup metaData) throws RuntimeWarning {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry(tc, "invokeNonWsComponent", new Object[]{operation, component, metaData});
        }
        if (metaData == null) {
            throw new RuntimeWarning("metaData is null for component " + component.getClass().getName());
        }
        String methodName = null;
        String methodAttribute = null;
        switch (operation) {
            case 0: {
                methodAttribute = "init-method";
                methodName = metaData.initMethod;
                break;
            }
            case 1: {
                methodAttribute = "start-method";
                methodName = metaData.startMethod;
                break;
            }
            case 2: {
                methodAttribute = "stop-method";
                methodName = metaData.stopMethod;
                break;
            }
            case 3: {
                methodAttribute = "destroy-method";
                methodName = metaData.destroyMethod;
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid operation " + operation + " for component " + component.getClass().getName());
                }
                throw new RuntimeWarning("invalid operation: " + operation + " for component " + component.getClass().getName());
            }
        }
        if (methodName == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute " + methodAttribute + " not specified for component " + component.getClass().getName());
            }
            return;
        }
        Class<?> componentClass = component.getClass();
        Method method = null;
        try {
            method = componentClass.getMethod(methodName, null);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, null, "354");
            throw new RuntimeWarning("Exception invoking method " + methodName + " for component " + componentClass.getName(), e);
        }
        try {
            method.invoke(component, (Object[])null);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, null, "362");
            throw new RuntimeWarning(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit(tc, "invokeNonWsComponent");
        }
    }

    public void stopComponents(List components, List<Object> applicationComponents) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry(tc, "stopComponents");
        }
        List allComponents = this.sortAllComponentsOfContainer(components, applicationComponents);
        for (ContainerImpl.ComponentStartup componentStartup : allComponents) {
            this.stopComponent(componentStartup);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit(tc, "stopComponents");
        }
    }

    private void stopComponent(ContainerImpl.ComponentStartup componentStartup) {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "stopping " + componentStartup.componentInstance + " with global order = " + componentStartup.globalOrder);
            }
            if (componentStartup.componentInstance instanceof WsComponent) {
                WsComponent component = (WsComponent)componentStartup.componentInstance;
                component.stop();
            } else {
                this.invokeNonWsComponent(2, componentStartup.componentInstance, componentStartup);
            }
        }
        catch (Throwable t) {
            Manager.Ffdc.log(t, this, null, "412");
            Tr.error(tc, "WSVR0102E", new Object[]{componentStartup, t});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startComponents(List components, Map componentStartupData) throws RuntimeWarning, RuntimeError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "startComponents " + components.size(), this);
        }
        StopWatch sw = StopWatch.instance();
        try {
            sw.start("WsComponentImpl.startComponents() " + this.containerComponentName);
            RuntimeWarning warning = null;
            for (int i = 0; i < components.size(); ++i) {
                Object component = components.get(i);
                try {
                    ContainerImpl.ComponentStartup metaData = (ContainerImpl.ComponentStartup)componentStartupData.get(component);
                    sw.start("WsComponentImpl : start " + metaData.getShortName());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "starting " + i, component.getClass().getName());
                    }
                    this.manageRuntimeDependencies(component, metaData, false);
                    if (component instanceof WsComponent) {
                        WsComponent wsComponent = (WsComponent)component;
                        if (metaData != null && metaData.asyncStart && !metaData.inhibitAsynchronousBehavior) {
                            this.requestor.runAsynchronousInitializer(new AsynchComponentSupport(1, wsComponent));
                            continue;
                        }
                        wsComponent.start();
                        continue;
                    }
                    if (metaData != null && metaData.asyncStart && !metaData.inhibitAsynchronousBehavior) {
                        this.requestor.runAsynchronousInitializer(new AsynchComponentSupport(1, component, null, metaData));
                        continue;
                    }
                    this.invokeNonWsComponent(1, component, metaData);
                    continue;
                }
                catch (RuntimeWarning rw) {
                    warning = rw;
                    if (!WsRuntimeFwExceptionUtil.report(rw)) continue;
                    Tr.error(tc, "WSVR0501E", new Object[]{component, rw});
                    continue;
                }
                catch (RuntimeError re) {
                    throw re;
                }
                catch (Throwable t) {
                    Manager.Ffdc.log(t, this, null, "484");
                    Tr.error(tc, "WSVR0501E", new Object[]{component, t});
                    warning = new RuntimeWarning(t);
                    WsRuntimeFwExceptionUtil.setReported(warning, true);
                    continue;
                }
                finally {
                    sw.stop();
                }
            }
            if (warning != null) {
                throw warning;
            }
        }
        finally {
            sw.stop();
        }
    }

    private void manageRuntimeDependencies(Object component, ContainerImpl.ComponentStartup metaData, boolean initPhase) throws RuntimeWarning {
        if (metaData.injectDependencies) {
            this.injectDependencies(component, metaData, initPhase);
        }
        if (metaData.injectionDependants != null) {
            this.injectDependants(component, metaData, initPhase);
        }
    }

    private void injectDependencies(Object component, ContainerImpl.ComponentStartup metaData, boolean initPhase) throws RuntimeWarning {
        boolean debugging;
        boolean bl = debugging = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "injectDependencies", new Object[]{component, metaData});
        }
        if (metaData == null) {
            if (debugging) {
                Tr.debug(tc, "null metadata for component " + component.getClass().getName());
            }
            return;
        }
        List dependencies = metaData.dependencies;
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            Object dependentComponentClass = null;
            Dependency dependency = (Dependency)i.next();
            if (initPhase != dependency.afterInit) continue;
            String methodName = dependency.method;
            ContainerImpl.ComponentStartup dependencyComp = dependency.component;
            if (dependencyComp == null) {
                throw new RuntimeWarning("Cannot find metadata for dependency " + dependency.name + ",component=" + metaData.componentId);
            }
            if (methodName == null) {
                if (!debugging) continue;
                Tr.debug(tc, "An injection method not specified for dependency " + dependency.name + " for component " + metaData.componentId);
                continue;
            }
            Object dependentComponent = dependencyComp.componentInstance;
            if (dependentComponent == null) {
                if (dependency.mandatory) {
                    throw new RuntimeWarning("Mandatory dependency " + dependency.name + " not started, component=" + metaData.componentId);
                }
                if (debugging) {
                    Tr.debug(tc, "Optional dependency " + dependency.name + " not started, Tracking. Component=" + metaData.componentId);
                }
                if (dependencyComp.injectionDependants == null) {
                    dependencyComp.injectionDependants = new ArrayList(3);
                }
                dependencyComp.injectionDependants.add(dependency);
                continue;
            }
            this.inject(component, dependency, dependentComponent);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "injectDependencies");
        }
    }

    private void inject(Object component, Dependency dependency, Object service) throws RuntimeWarning {
        Class<?> paramClass;
        boolean debugging;
        block17: {
            boolean bl = debugging = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
            if (debugging) {
                Tr.debug(tc, "Injecting dependency " + dependency.name + " into component " + component.getClass().getName());
            }
            paramClass = null;
            String parmType = dependency.parmType;
            if (parmType == null) {
                if (dependency.type == 1) {
                    parmType = dependency.name;
                } else if (dependency.component.services.size() >= 1) {
                    ServiceMetaData serv = (ServiceMetaData)dependency.component.services.get(0);
                    parmType = serv.interfaceName;
                }
            }
            if (debugging) {
                Tr.debug(tc, "parmType: " + parmType);
            }
            try {
                if (parmType != null) {
                    paramClass = dependency.component.loadClass(parmType);
                }
            }
            catch (Exception ex) {
                if (!debugging) break block17;
                Tr.debug(tc, "Exception loading parmType: " + parmType);
            }
        }
        if (paramClass == null) {
            paramClass = service.getClass();
            if (debugging) {
                Tr.debug(tc, "default parmType to service class: " + paramClass.getName());
            }
        }
        Class<?> componentClass = component.getClass();
        String methodName = dependency.method;
        Method method = null;
        try {
            method = componentClass.getMethod(methodName, paramClass);
        }
        catch (Exception e) {
            throw new RuntimeWarning("Problem retrieving method " + methodName + " for class " + componentClass.getName(), e);
        }
        if (method == null) {
            throw new RuntimeWarning("Unable to get method " + methodName + " for component " + componentClass.getName());
        }
        try {
            method.invoke(component, service);
            if (debugging) {
                Tr.debug(tc, "Inject successful: " + dependency.name);
            }
        }
        catch (Exception e) {
            throw new RuntimeWarning("Problem invoking method " + methodName + " for class " + componentClass.getName(), e);
        }
    }

    private void injectDependants(Object component, ContainerImpl.ComponentStartup metaData, boolean initPhase) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "injectDependants");
        }
        boolean debugging = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        List dependants = metaData.injectionDependants;
        for (Dependency dependency : dependants) {
            if (initPhase != dependency.afterInit) continue;
            if (debugging) {
                Tr.debug(tc, "Lazy injecting dependency " + dependency.name + ",component=" + dependency.metaData.componentId);
            }
            this.inject(dependency.metaData.componentInstance, dependency, component);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "injectDependants");
        }
    }

    private String getComponentNameFromType(Object value2) {
        String type;
        try {
            type = value2 instanceof ConfigObject ? ((ConfigObject)value2).getTypeName() : (value2 instanceof EObject ? ((EObject)value2).eClass().getName() : value2.toString());
        }
        catch (Exception ex) {
            type = value2 instanceof ConfigObject ? ((ConfigObject)value2).getID() : value2.toString();
        }
        return type;
    }

    public void initializeComponents(List components, List loadedComponents, Map componentStartupData) throws ConfigurationWarning, ConfigurationError {
        this.initializeComponents(this.rootConfig, this.locators, components, loadedComponents, componentStartupData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeComponents(Object rootConfig, ConfigLocatorAdapter[] locators, List components, List loadedComponents, Map componentStartupData) throws ConfigurationWarning, ConfigurationError {
        boolean debugging;
        boolean bl = debugging = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (debugging) {
            Tr.debug(tc, "initializeComponents", this);
        }
        StopWatch sw = StopWatch.instance();
        ConfigurationWarning configurationWarning = null;
        if (rootConfig != null && this.rootConfig == null) {
            this.rootConfig = rootConfig;
        }
        if (locators != null && this.locators == null) {
            this.locators = locators;
        }
        try {
            if (this.containerComponentName == null) {
                this.containerComponentName = rootConfig != null ? this.getComponentNameFromType(rootConfig) : this.requestor.getClass().getName();
            }
            sw.start("WsContainer.initializeComponents() : " + this.containerComponentName);
            ComponentManager componentManager = null;
            HashMap loadedConfigs = new HashMap();
            try {
                componentManager = WsServiceRegistry.getService(this.requestor, ComponentManager.class);
            }
            catch (Exception e1) {
                Manager.Ffdc.log(e1, this, null, "650");
                throw new ConfigurationError("ComponentManager service not found", e1);
            }
            for (int i = 0; i < components.size(); ++i) {
                ContainerImpl.ComponentStartup componentData = (ContainerImpl.ComponentStartup)components.get(i);
                if (componentData.startupMode == 0) {
                    if (debugging) {
                        Tr.debug(tc, "processing Primordial ", componentData);
                    }
                    try {
                        for (ServiceMetaData service : componentData.services) {
                            Class serviceClass = componentData.loadClass(service.interfaceName);
                            Object instance = WsServiceRegistry.getService(this, serviceClass);
                            if (instance == null) {
                                Tr.error(tc, "WSVR0124E", new Object[]{service.interfaceName, componentData.componentId});
                                componentData.state = 6;
                                continue;
                            }
                            componentData.componentInstance = instance;
                        }
                        continue;
                    }
                    catch (Throwable th) {
                        componentData.state = 6;
                        throw new ConfigurationWarning(th);
                    }
                }
                if (ComponentMetaDataMgr.instance().isProvisioningEnabled() && componentData.state != 1) {
                    if (!debugging) continue;
                    Tr.debug(tc, "State =" + componentData.state + ", skip component: " + componentData);
                    continue;
                }
                try {
                    if (debugging) {
                        Tr.debug(tc, "processing", componentData);
                    }
                    if (componentData.clazz != null && componentData.type == null) {
                        this.initializeComponent(componentData.clazz, null, componentManager, loadedConfigs, loadedComponents, locators, componentData, componentStartupData);
                        continue;
                    }
                    Object configurationObject = null;
                    for (int j = 0; configurationObject == null && j < locators.length; ++j) {
                        configurationObject = locators[j].getConfig(rootConfig, componentData.type);
                        if (!debugging || configurationObject == null) continue;
                        Tr.debug(tc, "config object " + configurationObject + " found by locator " + locators[j]);
                    }
                    if (configurationObject != null) {
                        if (configurationObject instanceof List) {
                            List list = (List)configurationObject;
                            for (int j = 0; j < list.size(); ++j) {
                                Object value2 = list.get(j);
                                this.initializeComponent(null, value2, componentManager, loadedConfigs, loadedComponents, locators, componentData, componentStartupData);
                            }
                            continue;
                        }
                        Object value3 = configurationObject;
                        this.initializeComponent(componentData.type, value3, componentManager, loadedConfigs, loadedComponents, locators, componentData, componentStartupData);
                        continue;
                    }
                    if (debugging) {
                        Tr.debug(tc, "config object not found!");
                    }
                    if (!componentData.configurationDataRequired) {
                        this.initializeComponent(componentData.clazz, null, componentManager, loadedConfigs, loadedComponents, locators, componentData, componentStartupData);
                        continue;
                    }
                    componentData.state = 6;
                    continue;
                }
                catch (ConfigurationWarning e) {
                    configurationWarning = e;
                }
            }
        }
        finally {
            sw.stop();
        }
        if (configurationWarning != null) {
            Manager.Ffdc.log(configurationWarning, this, null, "789");
            throw configurationWarning;
        }
    }

    public ConfigLocatorAdapter[] createConfigLocatorAdapters(Object[] locators) {
        if (locators == null) {
            return null;
        }
        if (locators instanceof ConfigLocatorAdapter[]) {
            return (ConfigLocatorAdapter[])locators;
        }
        InternalConfigService configService = (InternalConfigService)this.getService(ConfigService.class);
        ConfigLocatorAdapter[] adapters = new ConfigLocatorAdapter[locators.length];
        for (int i = 0; i < locators.length; ++i) {
            adapters[i] = new ConfigLocatorAdapter(locators[i], configService);
        }
        return adapters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeComponent(String implementationClass, Object configurationObject, ComponentManager componentManager, Map loadedConfigs, List loadedComponents, ConfigLocatorAdapter[] locators, ContainerImpl.ComponentStartup metaData, Map componentStartupData) throws ConfigurationWarning, ConfigurationError {
        boolean debugging;
        boolean bl = debugging = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (debugging) {
            Tr.debug(tc, "initializeComponent", new Object[]{implementationClass, configurationObject});
        }
        StopWatch sw = StopWatch.instance();
        String label = implementationClass != null ? metaData.getShortName() : (metaData != null && metaData.type != null && metaData.type.indexOf(46) != -1 ? metaData.getShortName() : this.getComponentNameFromType(configurationObject));
        sw.start("WsComponent : init " + label);
        try {
            if (configurationObject == null) {
                configurationObject = implementationClass;
            } else {
                Object data = loadedConfigs.get(configurationObject);
                if (data != null) {
                    if (debugging) {
                        Tr.debug(tc, "component already loaded by component ", (ContainerImpl.ComponentStartup)data);
                    }
                    return;
                }
            }
            ComponentManager.Component cmcomponent = null;
            Object componentInstance = null;
            if (metaData != null && metaData.clazz != null) {
                try {
                    componentInstance = metaData.loadClass(metaData.clazz).newInstance();
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, null, "894");
                    throw new ConfigurationWarning(e);
                }
            } else {
                cmcomponent = componentManager.getComponent(configurationObject);
                if (cmcomponent != null) {
                    componentInstance = cmcomponent.create();
                }
            }
            if (metaData != null && metaData.inhibitAsynchronousBehavior && componentInstance instanceof WsComponentImpl) {
                ((WsComponentImpl)componentInstance).inhibitAsynchBehavior();
            }
            if (componentInstance == null) {
                if (debugging) {
                    Tr.debug(tc, "Null component - type is " + metaData.type);
                }
                return;
            }
            loadedConfigs.put(configurationObject, metaData);
            if (componentInstance instanceof WsComponent) {
                this.initWsComponent(componentInstance, implementationClass, configurationObject, cmcomponent, metaData, loadedComponents, locators, componentStartupData);
            } else if (componentInstance instanceof ServiceProvider) {
                ((ServiceProvider)componentInstance).initialize(((ComponentImpl)this.requestor).getBeanContextServices());
            } else {
                this.initNonWsComponent(componentInstance, implementationClass, metaData, loadedComponents, componentStartupData);
            }
        }
        finally {
            sw.stop();
        }
    }

    private void initWsComponent(Object componentInstance, String implementationClass, Object configurationObject, ComponentManager.Component cmcomponent, ContainerImpl.ComponentStartup metaData, List loadedComponents, ConfigLocatorAdapter[] locators, Map componentStartupData) throws ConfigurationWarning, ConfigurationError {
        boolean asynchrousAction;
        boolean debugging = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        ConfigurationWarning configurationWarning = null;
        WsComponent component = (WsComponent)componentInstance;
        componentStartupData.put(component, metaData);
        boolean bl = asynchrousAction = metaData != null && metaData.asyncInitialize && !metaData.inhibitAsynchronousBehavior;
        if (this.add(component)) {
            try {
                if (debugging) {
                    Tr.debug(tc, "initializing", component);
                }
                boolean isContainer = componentInstance instanceof ContainerImpl || componentInstance instanceof WsContainer;
                String configurationData = metaData.configurationData;
                if (configurationData == null && cmcomponent != null) {
                    configurationData = cmcomponent.getConfigurationDataType();
                }
                if (configurationData == null || configurationData.equals("emf")) {
                    if (configurationObject instanceof ConfigObject) {
                        InternalConfigService configService = (InternalConfigService)this.getService(ConfigService.class);
                        configurationObject = configService.getEObject((ConfigObject)configurationObject);
                    }
                    if (isContainer) {
                        configurationObject = ContainerConfigFactory.createContainerConfig(configurationObject, locators);
                    }
                } else if (configurationData.equals("rcs")) {
                    if (configurationObject instanceof EObject) {
                        InternalConfigService configService = (InternalConfigService)this.getService(ConfigService.class);
                        configurationObject = configService.getConfigObject((EObject)configurationObject);
                    }
                    if (isContainer) {
                        configurationObject = ContainerConfigFactory.createContainerConfig((ConfigObject)configurationObject, locators);
                    }
                } else {
                    throw new ConfigurationError("invalid component configuration data type: " + configurationData);
                }
                if (asynchrousAction) {
                    loadedComponents.add(component);
                    this.requestor.runAsynchronousInitializer(new AsynchComponentSupport(0, component, configurationObject, loadedComponents));
                    metaData.componentInstance = component;
                } else {
                    component.initialize(configurationObject);
                    metaData.componentInstance = component;
                    this.autoregister(component, metaData);
                }
                metaData.state = 3;
                this.manageRuntimeDependencies(component, metaData, true);
            }
            catch (ComponentDisabledException cde) {
                component = null;
            }
            catch (ConfigurationWarning cw) {
                if (debugging) {
                    Tr.debug(tc, "Component, " + component + " initialize exception", cw);
                }
                metaData.componentInstance = component;
                this.autoregister(component, metaData);
                metaData.state = 3;
                configurationWarning = cw;
                if (cw.getCause() instanceof ComponentDisabledException) {
                    component = null;
                    configurationWarning = new ConfigurationWarning(cw.getMessage(), cw);
                }
            }
            catch (ConfigurationError ce) {
                throw ce;
            }
            catch (Throwable t) {
                Manager.Ffdc.log(t, this, null, "1011");
                component = null;
                configurationWarning = new ConfigurationWarning("Exception caught when initializing component", t);
                Tr.error(tc, "WSVR0501E", new Object[]{implementationClass, t});
            }
            if (component != null) {
                if (!asynchrousAction) {
                    loadedComponents.add(component);
                }
            } else {
                if (debugging) {
                    Tr.debug(tc, "Component, " + componentInstance + " is disabled");
                }
                this.remove(componentInstance);
            }
            if (configurationWarning != null) {
                throw configurationWarning;
            }
        }
    }

    private void initNonWsComponent(Object componentInstance, String implementationClass, ContainerImpl.ComponentStartup metaData, List loadedComponents, Map componentStartupData) throws ConfigurationWarning, ConfigurationError {
        boolean asynchrousAction;
        boolean debugging;
        boolean bl = debugging = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (debugging) {
            Tr.debug(tc, "initializing nonWsComponent " + componentInstance.getClass().getName());
        }
        ConfigurationWarning configurationWarning = null;
        Object component = componentInstance;
        componentStartupData.put(component, metaData);
        boolean bl2 = asynchrousAction = metaData != null && metaData.asyncInitialize && !metaData.inhibitAsynchronousBehavior;
        if (this.add(component)) {
            if (debugging) {
                Tr.debug(tc, "initializing", component);
            }
            try {
                if (asynchrousAction) {
                    loadedComponents.add(component);
                    this.requestor.runAsynchronousInitializer(new AsynchComponentSupport(0, component, loadedComponents, metaData));
                    metaData.componentInstance = component;
                } else {
                    this.invokeNonWsComponent(0, component, metaData);
                    metaData.componentInstance = component;
                    this.autoregister(component, metaData);
                }
                metaData.state = 3;
                this.manageRuntimeDependencies(component, metaData, true);
            }
            catch (WsRuntimeFwException e) {
                configurationWarning = new ConfigurationWarning("Exception caught when initializing component", e);
                Manager.Ffdc.log(e, this, null, "1078");
                Tr.error(tc, "WSVR0501E", new Object[]{implementationClass, e});
                component = null;
            }
            if (component != null) {
                if (!asynchrousAction) {
                    loadedComponents.add(component);
                }
            } else {
                if (debugging) {
                    Tr.debug(tc, "Component, " + componentInstance + " is disabled");
                }
                this.remove(componentInstance);
            }
            if (configurationWarning != null) {
                throw configurationWarning;
            }
        }
    }

    private void autoregister(Object component, ContainerImpl.ComponentStartup metaData) throws ConfigurationWarning {
        for (ServiceMetaData service : metaData.services) {
            if (!service.autoregister) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Autoregistered component " + component.getClass().getName() + " with interface " + service.interfaceName);
            }
            try {
                Class intfClass = metaData.loadClass(service.interfaceName);
                WsServiceRegistry.addService(component, intfClass);
            }
            catch (Exception e) {
                throw new ConfigurationWarning("Error during autoregister of component " + component.getClass().getName() + " with interface " + service.interfaceName, new ComponentDisabledException(e));
            }
        }
    }

    private boolean add(Object o) {
        boolean result = false;
        if (this.requestor instanceof WsContainer) {
            result = ((WsContainer)this.requestor).add(o);
        } else if (this.requestor instanceof ContainerImpl) {
            result = ((ContainerImpl)this.requestor).add(o);
        } else {
            RuntimeError re = new RuntimeError("Invalid object type for add() - " + o);
            Manager.Ffdc.log(re, this, null, "1192");
        }
        return result;
    }

    private boolean remove(Object o) {
        boolean result = false;
        if (this.requestor instanceof WsContainer) {
            result = ((WsContainer)this.requestor).remove(o);
        } else if (this.requestor instanceof ContainerImpl) {
            result = ((ContainerImpl)this.requestor).remove(o);
        } else {
            RuntimeError re = new RuntimeError("Invalid object type for add() - " + o);
            Manager.Ffdc.log(re, this, null, "1209");
        }
        return result;
    }

    private Object getService(Class serviceClass) {
        try {
            return WsServiceRegistry.getService(this, serviceClass);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, null, "556");
            throw new IllegalStateException("Service for " + serviceClass + " not found", e);
        }
    }

    public void addActivatedComponents(List activatedComponents, List<Object> applicationComponents) {
        for (Object activatedComponent : activatedComponents) {
            if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                Tr.debug(tc, "   " + activatedComponent);
            }
            if (applicationComponents.contains(activatedComponent)) continue;
            applicationComponents.add(activatedComponent);
        }
    }

    private List sortAllComponentsOfContainer(List<Object> components, List<Object> applicationComponents) {
        int numberComponents = components.size() + applicationComponents.size();
        Tr.debug(tc, "Container has a total of " + numberComponents + " component(s)");
        ArrayList<ContainerImpl.ComponentStartup> allContainerComponents = new ArrayList<ContainerImpl.ComponentStartup>(numberComponents);
        try {
            Collection<List> allComponents = ComponentMetaDataMgr.instance().getExtensionPointToComponentsMap().values();
            for (List someComponents : allComponents) {
                for (ContainerImpl.ComponentStartup componentStartup : someComponents) {
                    if (!components.contains(componentStartup.componentInstance) && !applicationComponents.contains(componentStartup.componentInstance)) continue;
                    allContainerComponents.add(componentStartup);
                }
            }
            Collections.sort(allContainerComponents, new ReverseGlobalOrderComparator());
        }
        catch (ConfigurationError ce) {
            Manager.Ffdc.log(ce, this, null, "1407");
        }
        return allContainerComponents;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReverseGlobalOrderComparator
    implements Comparator<ContainerImpl.ComponentStartup> {
        ReverseGlobalOrderComparator() {
        }

        @Override
        public int compare(ContainerImpl.ComponentStartup cs1, ContainerImpl.ComponentStartup cs2) {
            return cs2.globalOrder - cs1.globalOrder;
        }
    }

    private static class AsynchComponentSupport
    implements AsynchronousInitializer {
        public static final int INIT_ = 0;
        public static final int START_ = 1;
        private static final int WS_COMPONENT = 0;
        private static final int NON_WS_COMPONENT = 1;
        final int operation;
        final Object component;
        final Object configurationData;
        final List componentsList;
        final ContainerImpl.ComponentStartup metaData;
        private int componentType;

        public AsynchComponentSupport(int operation, WsComponent component, Object configurationData, List componentsList) {
            this.operation = operation;
            this.component = component;
            this.configurationData = configurationData;
            this.componentsList = componentsList;
            this.metaData = null;
            this.componentType = 0;
        }

        public AsynchComponentSupport(int operation, Object component, List componentsList, ContainerImpl.ComponentStartup metaData) {
            this.operation = operation;
            this.component = component;
            this.metaData = metaData;
            this.componentsList = componentsList;
            this.configurationData = null;
            this.componentType = 1;
        }

        public AsynchComponentSupport(int operation, WsComponent component) {
            this.operation = operation;
            this.component = component;
            this.metaData = null;
            this.componentsList = null;
            this.configurationData = null;
            this.componentType = 0;
        }

        public void run() throws ConfigurationWarning, ConfigurationError, RuntimeWarning, RuntimeError {
            if (this.componentType == 0) {
                this.runWsComponent(this.component);
            } else {
                this.runNonWsComponent();
            }
        }

        private void runWsComponent(Object wsComponent) throws ConfigurationWarning, ConfigurationError, RuntimeWarning, RuntimeError {
            WsComponent component = (WsComponent)wsComponent;
            switch (this.operation) {
                case 0: {
                    try {
                        component.initialize(this.configurationData);
                        break;
                    }
                    catch (ComponentDisabledException e) {
                        this.componentsList.remove(component);
                        break;
                    }
                    catch (ConfigurationWarning cw) {
                        throw cw;
                    }
                }
                case 1: {
                    component.start();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported operation : " + this.operation);
                }
            }
        }

        private void runNonWsComponent() throws RuntimeWarning {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.entry(tc, "runNonWsComponent");
                Tr.debug(tc, "runNonWsComponent", new Object[]{this.operation, this.component});
            }
            String methodName = null;
            String methodAttribute = null;
            switch (this.operation) {
                case 0: {
                    methodAttribute = "init-method";
                    methodName = this.metaData.initMethod;
                    break;
                }
                case 1: {
                    methodAttribute = "start-method";
                    methodName = this.metaData.startMethod;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported operation : " + this.operation);
                }
            }
            if (methodName == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attribute " + methodAttribute + " not specified for component " + this.component.getClass().getName());
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "invoking method " + methodName + " for component " + this.component.getClass().getName());
            }
            Class<?> componentClass = this.component.getClass();
            Method method = null;
            try {
                method = componentClass.getMethod(methodName, null);
            }
            catch (Throwable t) {
                if (this.componentsList != null) {
                    this.componentsList.remove(this.component);
                }
                throw new RuntimeWarning(t);
            }
            try {
                method.invoke(this.component, (Object[])null);
            }
            catch (Throwable t) {
                if (this.componentsList != null) {
                    this.componentsList.remove(this.component);
                }
                throw new RuntimeWarning(t);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.exit(tc, "runNonWsComponent");
            }
        }
    }

    public static class ServiceMetaData {
        public String interfaceName = null;
        public boolean autoregister = false;
    }

    public static class Dependency {
        public static final int COMPONENT = 0;
        public static final int SERVICE = 1;
        public int type = 1;
        public String name = null;
        public boolean mandatory = true;
        public boolean attemptStart = false;
        public String method = null;
        public String parmType = null;
        public ContainerImpl.ComponentStartup component = null;
        public ContainerImpl.ComponentStartup metaData = null;
        public boolean afterInit = false;

        public Dependency(ContainerImpl.ComponentStartup metaData) {
            this.metaData = metaData;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Dependency " + (this.type == 1 ? "[service] " : "[component] "));
            sb.append(this.name + " mandatory=" + Boolean.toString(this.mandatory));
            sb.append(" attemptStart=" + Boolean.toString(this.attemptStart));
            if (this.method != null) {
                sb.append(" [" + this.method + "]");
            }
            if (this.parmType != null) {
                sb.append(" [" + this.parmType + "]");
            }
            if (this.method != null) {
                sb.append(" afterInit=" + Boolean.toString(this.afterInit) + "]");
            }
            return sb.toString();
        }
    }
}

