/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.ReaderPool;
import com.ibm.CORBA.transport.TransportConnectionBase;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionInformation;
import com.ibm.ws.orb.transport.ConnectionInterceptor;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.orbimpl.transport.ConnectionKey;
import com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class WSTCPTransportConnection
extends TransportConnectionBase {
    private static int jniReadTimeout = 0;
    private static boolean readTimeOutInitialized = false;
    private static boolean enableKeepAlive = false;
    private static boolean keepAliveInitialized = false;
    protected ConnectionData connectionData = null;
    protected ConnectionInterceptor connectionInterceptor = null;
    ConnectionInformation connectionInformation = null;

    public WSTCPTransportConnection(ConnectionTable table, Socket socket, ReaderPool readerPool, ORBForTransports orbForTransports, ConnectionData connectionData, ConnectionInterceptor connectionInterceptor, boolean calledFromSubclass) {
        super(table, socket, readerPool, orbForTransports);
        boolean bKeepAlive;
        String methodName = "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)";
        int timeout = WSTCPTransportConnection.getReadTimeout(readerPool, orbForTransports);
        if (timeout > 0) {
            try {
                socket.setSoTimeout(timeout);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)", "The read timeout for this connection has been set to " + timeout + " milliseconds.");
                }
            }
            catch (Exception ex) {
                ORBRas.orbTrcLogger.exception(8L, (Object)this, "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)", ex);
            }
        }
        if (bKeepAlive = WSTCPTransportConnection.getKeepAlive(orbForTransports)) {
            try {
                socket.setKeepAlive(bKeepAlive);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)", "Server-side KeepAlive for this connection has been set to " + bKeepAlive + " .");
                }
            }
            catch (Exception ex) {
                ORBRas.orbTrcLogger.exception(8L, (Object)this, "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)", ex);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)", "the socket for this connection is: " + socket);
        }
        this.connectionData = connectionData;
        this.connectionInterceptor = connectionInterceptor;
        this.connectionInformation = new ConnectionInformationImpl(connectionData, null, System.currentTimeMillis(), socket.getInetAddress().getHostName(), socket.getPort());
        if (!calledFromSubclass) {
            this.activateServer();
        }
    }

    public WSTCPTransportConnection(ORBForTransports orbForTransports, ConnectionTable table, ConnectionKey key, ORBConnection conn, ReaderPool readerPool, Profile profile, ConnectionData connectionData, ConnectionInterceptor connectionInterceptor) {
        super(orbForTransports, table, (com.ibm.CORBA.transport.ConnectionKey)key, conn, readerPool, profile);
        String methodName = "<init>(ORBForTransports, ConnectionTable, ConnectionKey, ORBConnection, ReaderPool, Profile, ConnectionData, ConnectionInterceptor";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(ORBForTransports, ConnectionTable, ConnectionKey, ORBConnection, ReaderPool, Profile, ConnectionData, ConnectionInterceptor", "the connection key for this connection is: " + key);
        }
        this.connectionData = connectionData;
        this.connectionInterceptor = connectionInterceptor;
        this.connectionInformation = new ConnectionInformationImpl(connectionData, null, System.currentTimeMillis(), null, -1);
    }

    public void removeConnection() {
        String methodName = "removeConnection)";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "removeConnection)", "");
        }
        this.connectionInterceptor.notifyBrokenConnection(this.connectionInformation);
        super.removeConnection();
    }

    public com.ibm.CORBA.transport.ConnectionKey createKey(String host, int port2) {
        String methodName = "createKey(host,port)";
        ConnectionKey returnKey = new ConnectionKey(host, port2);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createKey(host,port)", "for input parameters host=" + host + ", port=" + port2 + ", the returned ConnectionKey=" + returnKey);
        }
        return returnKey;
    }

    public Socket createSocket(String host, int port2) throws Exception {
        String methodName = "createSocket(host,port)";
        int connectTimeout = this.getConnectTimeout();
        Socket socket = null;
        if (connectTimeout == 0) {
            socket = new Socket(host, port2);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(host,port)", "for input parameters host=" + host + ", port=" + port2 + ", the returned socket=" + socket);
            }
        } else {
            InetSocketAddress server2 = new InetSocketAddress(host, port2);
            InetSocketAddress client2 = new InetSocketAddress(0);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(host,port)", "connecting client=" + client2 + " to server=" + server2 + ", timeout=" + connectTimeout + "ms");
            }
            socket = new Socket();
            socket.bind(client2);
            socket.connect(server2, connectTimeout);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(host,port)", "successfully connected client " + socket);
            }
        }
        return socket;
    }

    public Object getConnectionData() {
        return this.connectionInformation;
    }

    public Socket createSocket(InetSocketAddress server2, InetSocketAddress client2) throws Exception {
        String methodName = "createSocket(server,client)";
        int connectTimeout = this.getConnectTimeout();
        Socket socket = null;
        if (connectTimeout == 0) {
            boolean fEvaluated;
            String lHost = this.getORBForTransports().getProperty("com.ibm.CORBA.LocalHost");
            boolean uselHost = lHost != null;
            String BindAddr = this.getORBForTransports().getProperty("com.ibm.ws.orb.transport.useMultiHome");
            boolean useBindAddr = BindAddr != null && BindAddr.equalsIgnoreCase("false");
            String remoteHost = server2.getHostName();
            int remotePort = server2.getPort();
            boolean bl = fEvaluated = useBindAddr && uselHost;
            if (fEvaluated) {
                socket = new Socket(remoteHost, remotePort, InetAddress.getByName(lHost), 0);
                if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createServerSocket()", "Bind Client Socket To A Specific NIC card=" + fEvaluated + ", Remote Host=" + remoteHost + ", Remote Port=" + remotePort + ", LocalHost=" + lHost + ", java.net.InetAddress.getByName( LocalHost )=" + InetAddress.getByName(lHost) + ", the returned socket=" + socket);
                }
            } else {
                socket = new Socket(remoteHost, remotePort);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(server,client)", "for input parameters host=" + remoteHost + ", port=" + remotePort + ", the returned socket=" + socket);
                }
            }
        } else {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(server,client)", "connecting client=" + client2 + " to server=" + server2 + ", timeout=" + connectTimeout + "ms");
            }
            socket = new Socket();
            socket.bind(client2);
            socket.connect(server2, connectTimeout);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(server,client)", "successfully connected client " + socket);
            }
        }
        return socket;
    }

    private static synchronized int getReadTimeout(ReaderPool readerPool, ORBForTransports orb) {
        if (!readTimeOutInitialized && readerPool instanceof JNIReaderPoolImpl) {
            String prop = orb.getProperty("com.ibm.CORBA.JNIReadTimeout");
            try {
                jniReadTimeout = Integer.parseInt(prop);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, WSTCPTransportConnection.class.getName(), "getReadTimeOut", "com.ibm.CORBA.JNIReadTimeout = " + jniReadTimeout);
                }
            }
            catch (Exception ex) {
                ORBRas.orbTrcLogger.exception(8L, WSTCPTransportConnection.class.getName(), "getReadTimeOut", ex);
            }
            readTimeOutInitialized = true;
        }
        return jniReadTimeout;
    }

    private static synchronized boolean getKeepAlive(ORBForTransports orb) {
        if (!keepAliveInitialized) {
            String prop = orb.getProperty("com.ibm.CORBA.EnableServerKeepAlive");
            enableKeepAlive = Boolean.valueOf(prop);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, WSTCPTransportConnection.class.getName(), "getKeepAlive", "com.ibm.CORBA.EnableServerKeepAlive = " + enableKeepAlive);
            }
            keepAliveInitialized = true;
        }
        return enableKeepAlive;
    }
}

