/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.services.lsd;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ffdc.Manager;
import com.ibm.ws.orb.services.lsd.AdapterInfo;
import com.ibm.ws.orb.services.lsd.LocationService;
import com.ibm.ws.orb.services.lsd.ORB_Server;
import com.ibm.ws.orb.services.lsd.ORB_ServerHelper;
import com.ibm.ws.orb.services.lsd._LocationServiceImplBase;
import com.ibm.ws.orbimpl.services.lsd.IORPrototype;
import com.ibm.ws.orbimpl.services.lsd.UserKeyImpl;
import com.ibm.ws.util.WSThreadLocal;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InputStream;

public class LocationServiceImpl
extends _LocationServiceImplBase {
    private static final long serialVersionUID = -4662278121185409699L;
    private ORB orb;
    private IORPrototype lsdPrototype = null;
    private Hashtable servers = new Hashtable();
    private Hashtable adapters = new Hashtable();
    private String serverPath = null;
    private String serverFileName = "IBMLSDActiveServerList.asl";
    private boolean serversReactivated = false;
    private static Class ctxMgrClz = null;
    private static java.lang.Object ctxMgr = null;
    private static Boolean ctxMgrIsCellSecurityEnabled = null;
    private static int securityMinorCodeInvalidSecurityCredentials = 0;
    public static WSThreadLocal threadLocalAvoidLogs = new WSThreadLocal();

    public LocationServiceImpl(ORB factory) {
        this.orb = factory;
    }

    protected void init() {
        block5: {
            String methodName = "init()";
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "init()");
            }
            try {
                this.serverPath = this.orb.getProperty("com.ibm.ws.orb.services.lsd.StoreActiveServerList");
                String lsdPort = this.orb.getProperty("com.ibm.ws.orb.services.lsd.LSDListenerPort");
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "init()", "LSDListenerPort is " + lsdPort);
                }
                this.lsdPrototype = new IORPrototype(this.orb, Integer.parseInt(lsdPort));
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, (java.lang.Object)this, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.init", "141", new java.lang.Object[]{this});
                if (!ORBRas.isTrcLogging) break block5;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "init()", e);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "init()");
        }
    }

    public byte[] register_server(byte[] orb_uuid, ORB_Server orb_server) {
        String methodName = "register_server (byte[] orb_uuid, ORB_Server orb_server)";
        IOR ior = null;
        if (this.isCellSecurityEnabled()) {
            try {
                if (((Boolean)this.invokeCtxMgrMethod("callerSubjectIsServerIdentity")).equals(Boolean.FALSE)) {
                    throw new NO_PERMISSION("Caller subject not matching server identity", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
                }
            }
            catch (Exception e) {
                throw new NO_PERMISSION("Failed to verify caller subject", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
            }
        }
        this.reactivateServers();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "register_server (byte[] orb_uuid, ORB_Server orb_server)");
        }
        if (null != orb_uuid) {
            this.addServer(orb_uuid, orb_server);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "register_server (byte[] orb_uuid, ORB_Server orb_server)", "returned from addServer();", (java.lang.Object)this.registrationInfo());
            }
            ior = this.lsdPrototype.asIOR();
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "register_server (byte[] orb_uuid, ORB_Server orb_server)", "LSDPrototype IOR returned:\n" + ior.stringify());
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "register_server (byte[] orb_uuid, ORB_Server orb_server)");
        }
        return ior != null ? ior.stringify().getBytes() : null;
    }

    public void unregister_server(byte[] orb_uuid) {
        String methodName = "unregister_server(byte[] orb_uuid)";
        if (this.isCellSecurityEnabled()) {
            try {
                if (((Boolean)this.invokeCtxMgrMethod("callerSubjectIsServerIdentity")).equals(Boolean.FALSE)) {
                    throw new NO_PERMISSION("Caller subject not matching server identity", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
                }
            }
            catch (Exception e) {
                throw new NO_PERMISSION("Failed to verify caller subject", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
            }
        }
        this.reactivateServers();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "unregister_server(byte[] orb_uuid)");
        }
        this.removeServer(this.getKey(orb_uuid));
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "unregister_server(byte[] orb_uuid)", "returned from removeServer();", (java.lang.Object)this.registrationInfo());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "unregister_server(byte[] orb_uuid)");
        }
    }

    public boolean register_object_adapters(byte[] orb_uuid, AdapterInfo[] adapter_info_seq) {
        String methodName = "register_object_adapters (byte[] orb_uuid, AdapterInfo[] adapter_info_seq)";
        boolean result = false;
        if (this.isCellSecurityEnabled()) {
            try {
                if (((Boolean)this.invokeCtxMgrMethod("callerSubjectIsServerIdentity")).equals(Boolean.FALSE)) {
                    throw new NO_PERMISSION("Caller subject not matching server identity", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
                }
            }
            catch (Exception e) {
                throw new NO_PERMISSION("Failed to verify caller subject", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
            }
        }
        this.reactivateServers();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "register_object_adapters (byte[] orb_uuid, AdapterInfo[] adapter_info_seq)");
        }
        result = this.addAdapter(orb_uuid, adapter_info_seq);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "register_object_adapters (byte[] orb_uuid, AdapterInfo[] adapter_info_seq)", "returned from addAdapter();", (java.lang.Object)this.registrationInfo());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "register_object_adapters (byte[] orb_uuid, AdapterInfo[] adapter_info_seq)");
        }
        return result;
    }

    public void unregister_object_adapters(byte[] orb_uuid, byte[][] adapter_name_seq) {
        String methodName = "unregister_object_adapters (byte[] orb_uuid, byte[][] adapter_name_seq)";
        if (this.isCellSecurityEnabled()) {
            try {
                if (((Boolean)this.invokeCtxMgrMethod("callerSubjectIsServerIdentity")).equals(Boolean.FALSE)) {
                    throw new NO_PERMISSION("Caller subject not matching server identity", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
                }
            }
            catch (Exception e) {
                throw new NO_PERMISSION("Failed to verify caller subject", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
            }
        }
        this.reactivateServers();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "unregister_object_adapters (byte[] orb_uuid, byte[][] adapter_name_seq)");
        }
        Vector serverKey = this.getKey(orb_uuid);
        for (int i = 0; i < adapter_name_seq.length; ++i) {
            this.removeAdapter(serverKey, this.getKey(adapter_name_seq[i]));
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "unregister_object_adapters (byte[] orb_uuid, byte[][] adapter_name_seq)", "returned from removeAdapter();", (java.lang.Object)this.registrationInfo());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "unregister_object_adapters (byte[] orb_uuid, byte[][] adapter_name_seq)");
        }
    }

    public IOR getNextTarget(byte[] objectKey) {
        IORPrototype prototype;
        block8: {
            prototype = null;
            Vector adapterKey = null;
            Vector serverKey = null;
            String methodName = "getNextTarget(byte[] objectKey)";
            this.reactivateServers();
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "getNextTarget(byte[] objectKey)");
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "getNextTarget(byte[] objectKey)", "currently registered servers/adapters", (java.lang.Object)this.registrationInfo());
            }
            try {
                serverKey = this.getServerKey(objectKey);
                if (null != serverKey) {
                    adapterKey = this.getAdapterKey(objectKey);
                    prototype = this.getPrototype(serverKey, adapterKey);
                    if (null == prototype) {
                        this.activateAdapters(serverKey, adapterKey);
                        prototype = this.getPrototype(serverKey, adapterKey);
                        if (prototype == null) {
                            return null;
                        }
                    }
                    break block8;
                }
                return null;
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, (java.lang.Object)this, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.getNextTarget", "473", new java.lang.Object[]{this});
                if (!ORBRas.isTrcLogging) break block8;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "getNextTarget(byte[] objectKey)", e);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "getNextTarget(byte[] objectKey)");
        }
        return prototype.asIOR(objectKey, "");
    }

    public String registrationInfo() {
        StringBuffer returnValue;
        block5: {
            String methodName = "registrationInfo()";
            returnValue = new StringBuffer();
            returnValue.append("Server/Adapter registration info:");
            int s = 0;
            try {
                Vector server2 = null;
                Hashtable serverAdapters = null;
                IORPrototype prototype = null;
                Enumeration serverKeys = this.servers.keys();
                Enumeration adapterKeys = null;
                Vector adapter = null;
                while (serverKeys.hasMoreElements()) {
                    int a = 0;
                    server2 = (Vector)serverKeys.nextElement();
                    returnValue.append("\nServer " + ++s + " Uuid: '");
                    returnValue.append(new String(this.getNameFromKey(server2)) + "'");
                    serverAdapters = (Hashtable)this.adapters.get(server2);
                    if (null != serverAdapters) {
                        adapterKeys = serverAdapters.keys();
                        while (adapterKeys.hasMoreElements()) {
                            adapter = (Vector)adapterKeys.nextElement();
                            returnValue.append("\n\tAdapter " + ++a + ": '");
                            returnValue.append(new String(this.getNameFromKey(adapter)));
                            returnValue.append("' - '");
                            prototype = (IORPrototype)serverAdapters.get(adapter);
                            returnValue.append(prototype.asIOR().stringify() + "'");
                        }
                        continue;
                    }
                    returnValue.append("\n\tNo adapters registered");
                }
                returnValue.append("\nServers registered: " + s);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, (java.lang.Object)this, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.registrationInfo", "534", new java.lang.Object[]{this});
                if (!ORBRas.isTrcLogging) break block5;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "registrationInfo()", e);
            }
        }
        return returnValue.toString();
    }

    private boolean addServer(byte[] serverUuid, ORB_Server orbServer) {
        String methodName = "addServer(byte[] serverUuid, ORB_Server orbServer)";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "addServer(byte[] serverUuid, ORB_Server orbServer)");
        }
        Vector serverKey = this.getKey(serverUuid);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "addServer(byte[] serverUuid, ORB_Server orbServer)", "Adding registration for serverKey '" + new String(this.getNameFromKey(serverKey)) + "'");
        }
        this.removeServer(serverKey);
        this.servers.put(serverKey, orbServer);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "addServer(byte[] serverUuid, ORB_Server orbServer)", "Server registration added for serverKey '" + new String(this.getNameFromKey(serverKey)) + "'");
        }
        this.saveServers();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "addServer(byte[] serverUuid, ORB_Server orbServer)");
        }
        return true;
    }

    private void removeServer(Vector serverKey) {
        String methodName = "removeServer(Vector serverKey)";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "removeServer(Vector serverKey)");
        }
        ORB_Server orbServer = (ORB_Server)this.servers.remove(serverKey);
        this.adapters.remove(serverKey);
        if (null != orbServer) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "removeServer(Vector serverKey)", "Server registration removed for serverKey '" + new String(this.getNameFromKey(serverKey)) + "'");
            }
            this.saveServers();
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "removeServer(Vector serverKey)");
        }
    }

    private synchronized void saveServers() {
        block7: {
            String methodName = "saveServers()";
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "saveServers()");
            }
            try {
                if (null != this.serverPath) {
                    ORB_Server orbServer = null;
                    String fileName = this.serverPath + File.separator + this.serverFileName;
                    FileOutputStream file = new FileOutputStream(fileName);
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "saveServers()", "Exporting activie server list", (java.lang.Object)("ASL File: " + fileName + "\nNo. of active servers:" + this.servers.size()));
                    }
                    ObjectOutputStream outStream = new ObjectOutputStream(file);
                    CDROutputStream cdrOutStream = ORB.createCDROutputStream((ORB)this.orb);
                    cdrOutStream.write_long(this.servers.size());
                    Enumeration e = this.servers.elements();
                    while (e.hasMoreElements()) {
                        orbServer = (ORB_Server)e.nextElement();
                        IOR ior = this.orb.objectToIOR((Object)orbServer);
                        ior.write(cdrOutStream);
                    }
                    cdrOutStream.writeTo((OutputStream)outStream);
                    cdrOutStream.close();
                    outStream.close();
                    file.close();
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, (java.lang.Object)this, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.saveServers", "698", new java.lang.Object[]{this});
                if (!ORBRas.isTrcLogging) break block7;
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "saveServers()", "Failed to write active server list to file;");
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "saveServers()", e);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "saveServers()");
        }
    }

    private IOR[] readServers() {
        String methodName = "readServers()";
        IOR[] iors = new IOR[]{};
        int i = -1;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "readServers()");
        }
        if (null != this.serverPath) {
            try {
                String fileName = this.serverPath + File.separator + this.serverFileName;
                if (new File(fileName).exists()) {
                    FileInputStream file = new FileInputStream(fileName);
                    ObjectInputStream inStream = new ObjectInputStream(file);
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    while (inStream.available() > 0) {
                        int size = inStream.available();
                        byte[] data = new byte[size];
                        inStream.readFully(data, 0, size);
                        byteStream.write(data, 0, size);
                    }
                    CDRInputStream cdrInStream = ORB.createCDRInputStream((ORB)this.orb, (byte[])byteStream.toByteArray(), (int)byteStream.size());
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "readServers()", "Read into ByteArrayOutputStream", (java.lang.Object)("Read total bytes: " + byteStream.size()));
                    }
                    int serverSize = cdrInStream.read_long();
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "readServers()", "Loading active server list", (java.lang.Object)("ASL File: " + fileName + "\nReported no. of servers: " + serverSize));
                    }
                    IOR ior = null;
                    iors = new IOR[serverSize];
                    for (i = 0; i < serverSize; ++i) {
                        ior = ORB.createIOR((ORB)this.orb);
                        ior.read((InputStream)cdrInStream);
                        iors[i] = ior;
                    }
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "readServers()", "No. of servers successfully loaded: " + serverSize);
                    }
                    cdrInStream.close();
                    inStream.close();
                    file.close();
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, (java.lang.Object)this, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.readServers", "799", new java.lang.Object[]{this});
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "readServers()", "Failed to completely load active server list;");
                    ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "readServers()", e);
                    ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "readServers()", "No. of servers successfully loaded: " + i);
                }
                IOR[] goodIors = new IOR[i];
                for (int j = 0; j < i; ++j) {
                    goodIors[j] = iors[j];
                }
                iors = goodIors;
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "readServers()");
        }
        return iors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reactivateServers() {
        block15: {
            if (this.serversReactivated) {
                return;
            }
            String methodName = "reactivateServers()";
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "reactivateServers()");
            }
            try {
                this.serversReactivated = true;
                ORB_Server orbServer = null;
                IOR[] iors = this.readServers();
                for (int i = 0; i < iors.length; ++i) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "reactivateServers()", "Server " + (i + 1) + ": \n" + iors[i].stringify());
                    }
                    Object obj = this.orb.IORToObject(iors[i]);
                    orbServer = ORB_ServerHelper.narrow((Object)obj);
                    try {
                        boolean isAppServerAlive = false;
                        try {
                            threadLocalAvoidLogs.set("reactivateServers.ping()");
                            if (ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "reactivateServers()", "threadLocalAvoidLogs is now set to avoid ffdc logs/messages in WSSSLTransportConnection/WSSSLClientSocketFactoryImpl");
                            }
                            isAppServerAlive = orbServer.ping();
                        }
                        finally {
                            threadLocalAvoidLogs.set(null);
                            if (ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "reactivateServers()", "threadLocalAvoidLogs is now reset");
                            }
                        }
                        if (!isAppServerAlive) continue;
                        orbServer.reregistration_required((LocationService)this, this.lsdPrototype.asIOR().stringify().getBytes());
                        if (!ORBRas.isTrcLogging) continue;
                        ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "reactivateServers()", "Server " + (i + 1) + " still alive, told to reregister");
                        continue;
                    }
                    catch (Exception e) {
                        String host = iors[i].getProfile(0).getHost();
                        int port2 = iors[i].getProfile(0).getPort();
                        Manager.Ffdc.log(e, (java.lang.Object)this, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.reactivateServers", "906", new java.lang.Object[]{this, new java.lang.Object[]{"Failed to contact host/port=" + host + "/" + port2}});
                        if (!ORBRas.isTrcLogging) continue;
                        ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "reactivateServers()", e);
                    }
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, (java.lang.Object)this, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.reactivateServers", "918", new java.lang.Object[]{this});
                if (!ORBRas.isTrcLogging) break block15;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "reactivateServers()", e);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "reactivateServers()");
        }
    }

    private boolean addAdapter(byte[] orb_uuid, AdapterInfo[] adapterInfo) {
        Hashtable<Vector, IORPrototype> adapter = null;
        Vector serverKey = this.getKey(orb_uuid);
        Vector adapterKey = null;
        String methodName = "addAdapter(byte[] orb_uuid, AdapterInfo[] adapterInfo)";
        boolean result = false;
        IOR ior = null;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "addAdapter(byte[] orb_uuid, AdapterInfo[] adapterInfo)");
        }
        for (int i = 0; i < adapterInfo.length; ++i) {
            adapterKey = this.getKey(adapterInfo[i].adapter_name);
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "addAdapter(byte[] orb_uuid, AdapterInfo[] adapterInfo)", "Adding registration for serverKey/AdapterKey '" + new String(this.getNameFromKey(serverKey)) + "'/'" + new String(this.getNameFromKey(adapterKey)) + "'");
            this.removeAdapter(serverKey, adapterKey);
            adapter = (Hashtable<Vector, IORPrototype>)this.adapters.get(serverKey);
            if (adapter == null) {
                adapter = new Hashtable<Vector, IORPrototype>();
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "addAdapter(byte[] orb_uuid, AdapterInfo[] adapterInfo)", "IORPrototype:\n" + new String(adapterInfo[i].ior_prototype));
            }
            ior = ORB.createIOR((ORB)this.orb, (String)new String(adapterInfo[i].ior_prototype));
            adapter.put(adapterKey, new IORPrototype(this.orb, ior));
            this.adapters.put(serverKey, adapter);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "addAdapter(byte[] orb_uuid, AdapterInfo[] adapterInfo)", "Adapter registration added for serverKey/AdapterKey '" + new String(this.getNameFromKey(serverKey)) + "'/'" + new String(this.getNameFromKey(adapterKey)) + "'");
            }
            result = true;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "addAdapter(byte[] orb_uuid, AdapterInfo[] adapterInfo)");
        }
        return result;
    }

    private void removeAdapter(Vector serverKey, Vector adapterKey) {
        IORPrototype prototype;
        Hashtable server2;
        String methodName = "removeAdapter(Vector serverKey, Vector adapterKey)";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "removeAdapter(Vector serverKey, Vector adapterKey)");
        }
        if (null != (server2 = (Hashtable)this.adapters.get(serverKey)) && null != (prototype = (IORPrototype)server2.remove(adapterKey)) && ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "removeAdapter(Vector serverKey, Vector adapterKey)", "Adapter registration removed for serverKey/AdapterKey '" + new String(this.getNameFromKey(serverKey)) + "'/'" + new String(this.getNameFromKey(adapterKey)) + "'");
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "removeAdapter(Vector serverKey, Vector adapterKey)");
        }
    }

    private boolean activateAdapters(Vector serverKey, Vector adapterKey) {
        byte[] adapterName = this.getNameFromKey(adapterKey);
        ORB_Server server2 = (ORB_Server)this.servers.get(serverKey);
        if (null != server2 && server2.ping()) {
            return server2.activate_object_adapter(adapterName);
        }
        return false;
    }

    private Vector getKey(byte[] name2) {
        Vector<Byte> key = new Vector<Byte>(name2.length);
        for (int i = 0; i < name2.length; ++i) {
            key.addElement(new Byte(name2[i]));
        }
        return key;
    }

    private Vector getServerKey(byte[] objectKey) {
        ObjectKey objKey = new ObjectKey(objectKey);
        byte[] id = objKey.getServerUUID();
        if (null != id) {
            return this.getKey(id);
        }
        return null;
    }

    private Vector getAdapterKey(byte[] objectKey) {
        byte[] adapterName = new UserKeyImpl(objectKey).getAdapterName();
        if (null != adapterName) {
            return this.getKey(adapterName);
        }
        return null;
    }

    private IORPrototype getPrototype(Vector serverKey, Vector adapterKey) {
        String methodName = "getPrototype(Vector serverKey, Vector adapterKey)";
        IORPrototype prototype = null;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "getPrototype(Vector serverKey, Vector adapterKey)");
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "getPrototype(Vector serverKey, Vector adapterKey)", "ServerKey is " + (null != serverKey ? new String(this.getNameFromKey(serverKey)) : "") + " " + "AdapterKey is " + (null != adapterKey ? new String(this.getNameFromKey(adapterKey)) : ""));
        }
        Hashtable prototypes = (Hashtable)this.adapters.get(serverKey);
        if (null != adapterKey) {
            if (prototypes != null) {
                prototype = (IORPrototype)prototypes.get(adapterKey);
            } else if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "getPrototype(Vector serverKey, Vector adapterKey)", "Did not find any adapters");
            }
        } else if (null != prototypes) {
            Enumeration e;
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "getPrototype(Vector serverKey, Vector adapterKey)", "Found Adapters");
            }
            if ((e = prototypes.keys()).hasMoreElements()) {
                adapterKey = (Vector)e.nextElement();
                prototype = (IORPrototype)prototypes.get(adapterKey);
            }
        } else if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "getPrototype(Vector serverKey, Vector adapterKey)", "Did not find any adapters");
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "getPrototype(Vector serverKey, Vector adapterKey)", "ServerKey is " + (null != serverKey ? new String(this.getNameFromKey(serverKey)) : "") + " " + "AdapterKey is " + (null != adapterKey ? new String(this.getNameFromKey(adapterKey)) : ""));
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "getPrototype(Vector serverKey, Vector adapterKey)");
        }
        return prototype;
    }

    private byte[] getNameFromKey(Vector key) {
        if (null == key) {
            return new byte[0];
        }
        Byte[] nameArray = key.toArray(new Byte[0]);
        byte[] name2 = new byte[nameArray.length];
        for (int i = 0; i < nameArray.length; ++i) {
            name2[i] = nameArray[i];
        }
        return name2;
    }

    private boolean isCellSecurityEnabled() {
        block4: {
            if (ctxMgrIsCellSecurityEnabled != null) {
                return ctxMgrIsCellSecurityEnabled;
            }
            ctxMgrIsCellSecurityEnabled = false;
            try {
                if (ctxMgr == null) {
                    Class<?> ctxMgrFactoryClz = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
                    Method ctxMgrFactoryGetInstance = ctxMgrFactoryClz.getMethod("getInstance", null);
                    ctxMgr = ctxMgrFactoryGetInstance.invoke(null, null);
                    ctxMgrClz = Class.forName("com.ibm.ws.security.core.ContextManager");
                }
                Method isEnabled = ctxMgrClz.getMethod("isCellSecurityEnabled", null);
                ctxMgrIsCellSecurityEnabled = (Boolean)isEnabled.invoke(ctxMgr, null);
                Class<?> smc = Class.forName("com.ibm.ISecurityUtilityImpl.SecurityMinorCodes");
                Field mc = smc.getField("INVALID_SECURITY_CREDENTIALS");
                securityMinorCodeInvalidSecurityCredentials = mc.getInt(null);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, (java.lang.Object)this, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.isCellSecurityEnabled", "1242", new java.lang.Object[]{this});
                if (!ORBRas.isTrcLogging) break block4;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "isCellSecurityEnabled()", e);
            }
        }
        return ctxMgrIsCellSecurityEnabled;
    }

    private java.lang.Object invokeCtxMgrMethod(String invokeName) {
        java.lang.Object result;
        block7: {
            String methodName = "invokeCtxMgrMethod()";
            result = null;
            if (!this.isCellSecurityEnabled()) {
                return null;
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "invokeCtxMgrMethod()");
            }
            try {
                if (ctxMgr == null) {
                    Class<?> ctxMgrFactoryClz = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
                    Method ctxMgrFactoryGetInstance = ctxMgrFactoryClz.getMethod("getInstance", null);
                    ctxMgr = ctxMgrFactoryGetInstance.invoke(null, null);
                    ctxMgrClz = Class.forName("com.ibm.ws.security.core.ContextManager");
                }
                Method ctxMgrMethod = ctxMgrClz.getMethod(invokeName, null);
                result = ctxMgrMethod.invoke(ctxMgr, null);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "invokeCtxMgrMethod()", invokeName + "():", result);
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, (java.lang.Object)this, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.invokeCtxMgrMethod", "1293", new java.lang.Object[]{this});
                if (!ORBRas.isTrcLogging) break block7;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "invokeCtxMgrMethod()", e);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "invokeCtxMgrMethod()");
        }
        return result;
    }
}

