/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.services.lsd;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ffdc.Manager;

public class IORPrototype {
    private ORB orb;
    private IOR ior;
    private byte[] objectKey = null;
    private String typeId = null;

    public IORPrototype(ORB orb, int port2) {
        String methodName = "IORPrototype(ORB orb, int port)";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "IORPrototype(ORB orb, int port)");
        }
        this.orb = orb;
        int iorPort = port2;
        Profile profile = orb.getTransportProfile();
        String localHost = orb.getLocalHost();
        if (null == localHost) {
            localHost = profile.getHost();
        }
        if (0 == iorPort) {
            iorPort = profile.getPort();
        }
        this.ior = ORB.createIOR((ORB)orb, (String)"", (String)localHost, (int)iorPort, (byte[])new byte[0]);
        if (ORBRas.isTrcLogging) {
            Object[] parms = new String[]{localHost, Integer.toString(iorPort), this.ior.stringify()};
            ORBRas.orbTrcLogger.trace(16L, (Object)this, "IORPrototype(ORB orb, int port)", "Host, Port, and IORPrototype", parms);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (Object)this, "IORPrototype(ORB orb, int port)");
        }
    }

    public IORPrototype(ORB factory, IOR ior) {
        this.ior = ior;
        this.orb = factory;
    }

    public IOR asIOR() {
        if (null == this.objectKey && null == this.typeId) {
            return this.ior;
        }
        return this.asIOR(this.getObjectKey(), this.getTypeId());
    }

    public IOR asIOR(byte[] objectKey, String typeId) {
        IOR newIOR;
        block6: {
            newIOR = null;
            String methodName = "asIOR(byte[] objectKey, String typeId)";
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (Object)this, "asIOR(byte[] objectKey, String typeId)");
            }
            try {
                Profile prototypeProfile = this.ior.getProfile();
                newIOR = ORB.createIOR((ORB)this.orb, (String)typeId, (Profile)prototypeProfile, (byte[])objectKey);
            }
            catch (Throwable t) {
                Manager.Ffdc.log(t, this, "com.ibm.ws.orbimpl.services.lsd.IORPrototype.asIOR", "143", this);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4104L, (Object)this, "asIOR(byte[] objectKey, String typeId)", "Caught Throwable ", (Object)t);
                }
                if (!(t instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)t;
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (Object)this, "asIOR(byte[] objectKey, String typeId)", "ObjectKey length is " + Integer.toString(objectKey.length), (Object)("IOR is " + (null != newIOR ? newIOR.stringify() : "")));
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (Object)this, "asIOR(byte[] objectKey, String typeId)");
        }
        return newIOR;
    }

    public void setObjectKey(ObjectKey objectKey) {
        this.objectKey = objectKey.getObjectKey();
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public byte[] getObjectKey() {
        if (null == this.objectKey) {
            return new byte[0];
        }
        return this.objectKey;
    }

    public String getTypeId() {
        if (null == this.typeId) {
            return new String("");
        }
        return this.typeId;
    }
}

