/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orb.transport;

import com.ibm.CORBA.iiop.CodeSetComponentInfo;
import com.ibm.CORBA.iiop.GIOPConnectionProfile;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ws.orb.transport.BaseConnectionDataImpl;
import com.ibm.ws.orb.transport.ConnectionData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;

public class IIOPEndpointProfile
implements GIOPConnectionProfile {
    private static final String ME = IIOPEndpointProfile.class.getName();
    private static final Logger log = Logger.getLogger(ME, "com.ibm.ws.iiop.channel.resources.IIOPMsgs");
    protected ConnectionData connectionData = null;
    protected Profile ior_profile = null;
    protected String chainName = null;
    protected boolean bootstrapIOR = false;

    protected IIOPEndpointProfile() {
    }

    public IIOPEndpointProfile(IOR ior, String chain, String host, int port2) {
        BaseConnectionDataImpl cd = new BaseConnectionDataImpl();
        cd.setRemoteHost(host);
        cd.setRemotePort(port2);
        this.init(ior, chain, cd);
    }

    public IIOPEndpointProfile(IOR ior, String chain, ConnectionData cd) {
        this.init(ior, chain, cd);
    }

    protected void init(IOR ior, String chain, ConnectionData cd) {
        String methodName = "init";
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "init", new Object[]{"Remote type=" + (ior == null ? "null" : ior.getTypeId()), "Chain name=" + chain, "ConnData=" + cd});
        }
        String msg = null;
        int minor_code = 0;
        if (ior == null) {
            msg = "IIOPEndpointProfile can not be initialized with a null IOR.";
            minor_code = 1229066493;
        } else if (chain == null) {
            msg = "IIOPEndpointProfile can not be initialized with a null chain name";
            minor_code = 1229066494;
        } else if (cd == null || cd.getConnectionType() == 4L && cd.getAltConnectionData() == null) {
            msg = "IIOPEndpointProfile can not be initialized without connection data(cd=" + cd + ")";
            minor_code = 1229066497;
        } else if (cd.getConnectionType() != 4L) {
            if (cd.getRemoteHost() == null) {
                msg = "IIOPEndpointProfile can not be initialized without a specified target host name";
                minor_code = 1229066495;
            } else if (cd.getRemotePort() == 0) {
                msg = "IIOPEndpointProfile can not be initialized without a valid target port number";
                minor_code = 1229066496;
            }
        }
        if (msg != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, msg, new Object[]{ior, cd});
            }
            throw new COMM_FAILURE(msg, minor_code, CompletionStatus.COMPLETED_NO);
        }
        this.ior_profile = ior.getProfile();
        this.connectionData = cd;
        this.chainName = chain;
        boolean bl = this.bootstrapIOR = ior.getTypeId().equals("") && this.ior_profile.getTaggedComponents().length == 0;
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "init");
        }
    }

    public void setChainName(String name2) {
        this.chainName = name2;
    }

    public String getChainName() {
        return this.chainName;
    }

    public String getHost() {
        return this.connectionData.getRemoteHost();
    }

    public int getPort() {
        return this.connectionData.getRemotePort();
    }

    public byte getMajor() {
        return this.ior_profile.getMajor();
    }

    public byte getMinor() {
        return this.ior_profile.getMinor();
    }

    public CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.ior_profile.getCodeSetComponentInfo();
    }

    public int getPartnerVersion() {
        return this.ior_profile.getPartnerVersion();
    }

    public short getPartnerExtended() {
        return this.ior_profile.getPartnerExtended();
    }

    public ConnectionData getConnectionData() {
        return this.connectionData;
    }

    public boolean isBootstrapIOR() {
        return this.bootstrapIOR;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[@" + this.hashCode() + "," + this.chainName + "," + this.connectionData + (this.isBootstrapIOR() ? ",bootstrap IOR" : "") + "]";
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        IIOPEndpointProfile that = (IIOPEndpointProfile)o;
        String thatChain = that.chainName;
        String thisChain = this.chainName;
        if (thisChain == null && thatChain != null || thisChain != null && thatChain == null || thisChain != null && thatChain != null && !thisChain.equals(thatChain)) {
            return false;
        }
        if (this.bootstrapIOR != that.bootstrapIOR) {
            return false;
        }
        ConnectionData thisData = this.connectionData;
        ConnectionData thatData = that.connectionData;
        return !(thisData == null && thatData != null || thisData != null && thatData == null) && (thisData == null || thatData == null || thisData.equals(thatData));
    }
}

