/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orb;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ffdc.Manager;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.orb.GlobalORBExistsException;
import com.ibm.ws.security.util.AccessController;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;

public final class GlobalORBFactory {
    private static ORB orb = null;
    private static final Class thisClass = GlobalORBFactory.class;

    private GlobalORBFactory() {
    }

    public static synchronized ORB init(String[] args, Properties props) throws GlobalORBExistsException {
        if (orb != null) {
            throw new GlobalORBExistsException(orb);
        }
        orb = (ORB)ORB.init((String[])args, (Properties)GlobalORBFactory.readProperties(props));
        return orb;
    }

    public static synchronized ORB init(Applet applet, Properties props) {
        orb = (ORB)ORB.init((Applet)applet, (Properties)GlobalORBFactory.readProperties(props));
        return orb;
    }

    public static synchronized ORB globalORB() {
        return orb;
    }

    public static Properties readProperties(Properties props) {
        Properties wasProps = new Properties();
        try {
            String fname = "orb.properties";
            InputStream stream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Thread.currentThread().getContextClassLoader().getResourceAsStream("orb.properties");
                }
            });
            if (stream != null) {
                wasProps.load(stream);
                stream.close();
            }
        }
        catch (PrivilegedActionException ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.orb.GlobalORBFactory.readProperties", "155");
        }
        catch (IOException ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.orb.GlobalORBFactory.readProperties", "158");
        }
        if (WSLauncher.isZOS() || WSLauncher.isISeries()) {
            try {
                Properties sysProps = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperties();
                    }
                });
                sysProps.putAll((Map<?, ?>)wasProps);
            }
            catch (AccessControlException ex) {
                Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.orb.GlobalORBFactory.readProperties", "185");
            }
        }
        if (props != null) {
            wasProps.putAll((Map<?, ?>)props);
        }
        return wasProps;
    }
}

